#   Title: 	get_rule.sed
#   Author: 	Larry Paulson, Cambridge University Computer Laboratory
#   Copyright   1986  University of Cambridge
#  usage:  sed -n -f get_rule.sed input-file.ML > output-file.ML
#
#  sed script that produces a .ML file to bind all rules to ML identifiers
#  The input is the .ML file containing the definition of a theory.
#  It processes all lines from "new_theory" to end of file,
#  	expecting each rule name to appear on a line that begins
#           <spaces> ( " <identifier> "
#  The theory file should end with a definition of the function "rule_named".

#  A separate sed script is used to avoid confusing the shell;
#  	note that the quote mark ' appears in the command.
/new_theory/,$ s/^ *("\([a-zA-Z][a-zA-Z0-9'_]*\)".*$/val \1 = rule_named "\1";/p
