/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.util.StandardUtilities;

public abstract class BufferListSet
implements SearchFileSet {
    private String[] files;

    @Override
    public synchronized String getFirstFile(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files[0];
    }

    @Override
    public synchronized String getLastFile(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files[this.files.length - 1];
    }

    @Override
    public synchronized String getNextFile(View view, String path) {
        return this.getPrevOrNextFile(view, path, Direction.NEXT);
    }

    @Override
    public synchronized String getPrevFile(View view, String path) {
        return this.getPrevOrNextFile(view, path, Direction.PREV);
    }

    @Override
    public synchronized String[] getFiles(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files;
    }

    @Override
    public synchronized int getFileCount(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    @Override
    public String getCode() {
        return null;
    }

    public void invalidateCachedList() {
        this.files = null;
    }

    private String getPrevOrNextFile(View view, String path, Direction direction) {
        boolean ignoreCase;
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        if (path == null) {
            path = view.getBuffer().getSymlinkPath();
            VFS vfs = VFSManager.getVFSForPath(path);
            boolean ignoreCase2 = (vfs.getCapabilities() & 0x80) != 0;
            for (String file : this.files) {
                if (StandardUtilities.compareStrings(file, path, ignoreCase2) != 0) continue;
                return path;
            }
            if (direction == Direction.NEXT) {
                return this.getFirstFile(view);
            }
            return this.getLastFile(view);
        }
        VFS vfs = VFSManager.getVFSForPath(path);
        boolean bl = ignoreCase = (vfs.getCapabilities() & 0x80) != 0;
        if (direction == Direction.NEXT && StandardUtilities.compareStrings(this.files[this.files.length - 1], path, ignoreCase) == 0) {
            return null;
        }
        if (direction == Direction.PREV && StandardUtilities.compareStrings(this.files[0], path, ignoreCase) == 0) {
            return null;
        }
        for (int i = 0; i < this.files.length - 1; ++i) {
            if (StandardUtilities.compareStrings(this.files[i], path, ignoreCase) != 0) continue;
            if (direction == Direction.NEXT) {
                return this.files[i + 1];
            }
            if (i == 0) {
                return this.files[this.files.length - 1];
            }
            return this.files[i - 1];
        }
        return null;
    }

    protected abstract String[] _getFiles(Component var1);

    private static enum Direction {
        PREV,
        NEXT;

    }
}

