/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.ProgressObserver;

class PluginManagerProgress
extends JDialog
implements ProgressObserver {
    private Thread thread;
    private final JProgressBar progress;
    private final JButton stop;
    private final int count;
    private int done = 1;
    private int valueSoFar;
    private final Roster roster;

    PluginManagerProgress(PluginManager dialog, Roster roster) {
        super(dialog, jEdit.getProperty("plugin-manager.progress.title"), true);
        this.roster = roster;
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        this.count = roster.getOperationCount();
        int maximum = 0;
        for (int i = 0; i < this.count; ++i) {
            maximum += roster.getOperation(i).getMaximum();
        }
        this.progress.setMaximum(maximum);
        content.add("North", this.progress);
        this.stop = new JButton(jEdit.getProperty("plugin-manager.progress.stop"));
        this.stop.addActionListener(new ActionHandler());
        JPanel panel = new JPanel(new FlowLayout(1, 0, 0));
        panel.add(this.stop);
        content.add("Center", panel);
        this.addWindowListener(new WindowHandler());
        this.pack();
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }

    @Override
    public void setValue(final long value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginManagerProgress.this.progress.setValue(PluginManagerProgress.this.valueSoFar + (int)value);
            }
        });
    }

    @Override
    public void setMaximum(long value) {
    }

    @Override
    public void setStatus(String status) {
        SwingUtilities.invokeLater(() -> this.progress.setString(status));
    }

    public void done() {
        try {
            if (this.done == this.count) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PluginManagerProgress.this.dispose();
                    }
                });
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PluginManagerProgress.this.valueSoFar = PluginManagerProgress.this.valueSoFar + PluginManagerProgress.this.roster.getOperation(PluginManagerProgress.this.done - 1).getMaximum();
                        PluginManagerProgress.this.progress.setValue(PluginManagerProgress.this.valueSoFar);
                        PluginManagerProgress.this.done++;
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class RosterThread
    extends Thread {
        RosterThread() {
            super("Plugin manager thread");
        }

        @Override
        public void run() {
            PluginManagerProgress.this.roster.performOperationsInWorkThread(PluginManagerProgress.this);
        }
    }

    class WindowHandler
    extends WindowAdapter {
        boolean done;

        WindowHandler() {
        }

        @Override
        public void windowOpened(WindowEvent evt) {
            if (this.done) {
                return;
            }
            this.done = true;
            PluginManagerProgress.this.thread = new RosterThread();
            PluginManagerProgress.this.thread.start();
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            PluginManagerProgress.this.thread.stop();
            PluginManagerProgress.this.dispose();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == PluginManagerProgress.this.stop) {
                PluginManagerProgress.this.thread.stop();
                PluginManagerProgress.this.dispose();
            }
        }
    }
}

