/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.InvalidHighlightException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.BoyerMooreSearchMatcher;
import org.gjt.sp.jedit.search.PatternSearchMatcher;
import org.gjt.sp.jedit.search.SearchMatcher;

public class Highlight {
    public static final int PERMANENT_SCOPE = 0;
    public static final int SESSION_SCOPE = 1;
    public static final int BUFFER_SCOPE = 2;
    private String stringToHighlight;
    private boolean regexp;
    private boolean ignoreCase = true;
    private boolean valid;
    private SearchMatcher searchMatcher;
    private static final int HIGHLIGHT_VERSION = 1;
    private static Color defaultColor = jEdit.getColorProperty((String)"gatchan.highlight.defaultColor");
    private static final Color[] COLORS = new Color[]{new Color(153, 255, 204), new Color(102, 102, 255), new Color(255, 102, 102), new Color(255, 204, 102), new Color(204, 255, 102), new Color(255, 51, 153), new Color(255, 51, 0), new Color(102, 255, 0), new Color(153, 0, 153), new Color(153, 153, 0), new Color(0, 153, 102)};
    private static int colorIndex;
    private Color color;
    private boolean enabled = true;
    private int scope = 0;
    private JEditBuffer buffer;
    private long duration = Long.MAX_VALUE;
    private long lastSeen = System.currentTimeMillis();
    public static final String HIGHLIGHTS_BUFFER_PROPS = "highlights";

    public Highlight(String stringToHighlight, boolean regexp, boolean ignoreCase, int scope) {
        this.scope = scope;
        this.init(stringToHighlight, regexp, ignoreCase, Highlight.getNextColor());
    }

    public Highlight(String stringToHighlight, boolean regexp, boolean ignoreCase) {
        this(stringToHighlight, regexp, ignoreCase, 0);
    }

    public Highlight(String s) {
        this(s, false, true, 0);
    }

    public Highlight() {
    }

    public void init(String s, boolean regexp, boolean ignoreCase, Color color) {
        if (s.length() == 0) {
            this.valid = false;
            throw new IllegalArgumentException("The search string cannot be empty");
        }
        this.valid = true;
        if (regexp) {
            if (this.searchMatcher == null || !s.equals(this.stringToHighlight) || !this.regexp || ignoreCase != this.ignoreCase) {
                this.searchMatcher = new PatternSearchMatcher(s, ignoreCase);
            }
        } else if (this.searchMatcher == null || !s.equals(this.stringToHighlight) || this.regexp || ignoreCase != this.ignoreCase) {
            this.searchMatcher = new BoyerMooreSearchMatcher(s, ignoreCase);
        }
        this.stringToHighlight = s;
        this.regexp = regexp;
        this.ignoreCase = ignoreCase;
        this.color = color;
    }

    public String getStringToHighlight() {
        return this.stringToHighlight;
    }

    public boolean isRegexp() {
        return this.regexp;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public SearchMatcher getSearchMatcher() {
        return this.searchMatcher;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Highlight) {
            Highlight highlight = (Highlight)obj;
            return highlight.stringToHighlight.equals(this.stringToHighlight) && highlight.regexp == this.regexp && highlight.ignoreCase == this.ignoreCase;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static void setDefaultColor(Color defaultColor) {
        Highlight.defaultColor = defaultColor;
    }

    public static Color getNextColor() {
        if (defaultColor != null) {
            return defaultColor;
        }
        ++colorIndex;
        return COLORS[colorIndex %= COLORS.length];
    }

    public String serialize() {
        StringBuffer buff = new StringBuffer(this.stringToHighlight.length() + 20);
        buff.append(1).append(';');
        Highlight.serializeBoolean(buff, this.regexp);
        Highlight.serializeBoolean(buff, this.ignoreCase);
        Highlight.serializeBoolean(buff, this.enabled);
        buff.append(this.color.getRGB());
        buff.append(';');
        buff.append(this.stringToHighlight);
        return buff.toString();
    }

    private static void serializeBoolean(StringBuffer buff, boolean bool) {
        if (bool) {
            buff.append(1);
        } else {
            buff.append(0);
        }
    }

    public static Highlight unserialize(String s, boolean getStatus) throws InvalidHighlightException {
        try {
            int index = s.indexOf(59);
            boolean regexp = s.charAt(index + 1) == '1';
            boolean ignoreCase = s.charAt(index + 2) == '1';
            boolean enabled = !getStatus || s.charAt(index + 3) == '1';
            int i = s.indexOf(59, index + 4);
            Color color = Color.decode(s.substring(index + 4, i));
            String searchString = new String(s.substring(i + 1));
            Highlight highlight = new Highlight();
            highlight.setEnabled(enabled);
            highlight.init(searchString, regexp, ignoreCase, color);
            return highlight;
        }
        catch (Exception e) {
            throw new InvalidHighlightException(e);
        }
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public JEditBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(JEditBuffer buffer) {
        List<Highlight> highlights;
        if (this.buffer != null) {
            highlights = (ArrayList<Highlight>)this.buffer.getProperty((Object)HIGHLIGHTS_BUFFER_PROPS);
            highlights.remove(this);
            if (highlights.isEmpty()) {
                this.buffer.unsetProperty(HIGHLIGHTS_BUFFER_PROPS);
            }
        }
        this.buffer = buffer;
        if (buffer != null) {
            highlights = (List)buffer.getProperty((Object)HIGHLIGHTS_BUFFER_PROPS);
            if (highlights == null) {
                highlights = new ArrayList<Highlight>();
                buffer.setProperty(HIGHLIGHTS_BUFFER_PROPS, highlights);
            }
            highlights.add(this);
        }
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void updateLastSeen() {
        this.lastSeen = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.lastSeen > this.duration;
    }

    public void setStringToHighlight(String stringToHighlight) {
        this.init(stringToHighlight, this.regexp, this.ignoreCase, this.color);
    }

    public String toString() {
        return "Highlight{stringToHighlight='" + this.stringToHighlight + '\'' + ", regexp=" + this.regexp + ", ignoreCase=" + this.ignoreCase + ", valid=" + this.valid + ", searchMatcher=" + this.searchMatcher + ", color=" + this.color + ", enabled=" + this.enabled + ", scope=" + this.scope + ", buffer=" + this.buffer + ", duration=" + this.duration + ", lastSeen=" + this.lastSeen + '}';
    }
}

