/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.util.Stack;
import org.gjt.sp.jedit.options.PluginOptions;
import org.gjt.sp.jedit.pluginmgr.MirrorList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class MirrorListHandler
extends DefaultHandler {
    private String id;
    private final StringBuilder description = new StringBuilder();
    private final StringBuilder location = new StringBuilder();
    private final StringBuilder country = new StringBuilder();
    private final StringBuilder continent = new StringBuilder();
    private final MirrorList mirrors;
    private MirrorList.Mirror mirror;
    private final Stack<String> stateStack = new Stack();
    private final String path;

    MirrorListHandler(MirrorList mirrors, String path) {
        this.mirrors = mirrors;
        this.path = path;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return XMLUtilities.findEntity(systemId, "mirrors.dtd", PluginOptions.class);
    }

    @Override
    public void characters(char[] c, int off, int len) {
        String tag = this.peekElement();
        if ("DESCRIPTION".equals(tag)) {
            this.description.append(c, off, len);
        } else if ("LOCATION".equals(tag)) {
            this.location.append(c, off, len);
        } else if ("COUNTRY".equals(tag)) {
            this.country.append(c, off, len);
        } else if ("CONTINENT".equals(tag)) {
            this.continent.append(c, off, len);
        }
    }

    @Override
    public void startElement(String uri, String localName, String tag, Attributes attrs) {
        if ((tag = this.pushElement(tag)).equals("MIRROR")) {
            this.mirror = new MirrorList.Mirror();
            this.id = attrs.getValue("ID");
        }
    }

    @Override
    public void endElement(String uri, String localName, String tag) {
        this.popElement();
        if (tag.equals("MIRROR")) {
            this.mirror.id = this.id;
            this.mirror.description = this.description.toString();
            this.mirror.location = this.location.toString();
            this.mirror.country = this.country.toString();
            this.mirror.continent = this.continent.toString();
            this.mirrors.add(this.mirror);
            this.description.setLength(0);
            this.location.setLength(0);
            this.country.setLength(0);
            this.continent.setLength(0);
        }
    }

    @Override
    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }

    @Override
    public void endDocument() {
        this.mirrors.finished();
    }

    private String pushElement(String name) {
        name = name == null ? null : name.intern();
        this.stateStack.push(name);
        return name;
    }

    private String peekElement() {
        return this.stateStack.peek();
    }

    private void popElement() {
        this.stateStack.pop();
    }
}

