/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.JEditActionSet;
import org.gjt.sp.util.StandardUtilities;

public abstract class JEditActionContext<F extends JEditAbstractEditAction, E extends JEditActionSet<F>> {
    String[] actionNames;
    Hashtable<String, E> actionHash = new Hashtable();
    Hashtable<String, E> overriddenActions = new Hashtable();
    private final Vector<E> actionSets = new Vector();

    public abstract void invokeAction(EventObject var1, F var2);

    public void addActionSet(E actionSet) {
        String[] actions;
        this.actionNames = null;
        this.actionSets.addElement(actionSet);
        ((JEditActionSet)actionSet).context = this;
        for (String action : actions = ((JEditActionSet)actionSet).getActionNames()) {
            if (this.actionHash.containsKey(action)) {
                JEditActionSet oldAction = (JEditActionSet)this.actionHash.get(action);
                this.overriddenActions.put(action, oldAction);
            }
            this.actionHash.put(action, actionSet);
        }
    }

    public void removeActionSet(E actionSet) {
        String[] actions;
        this.actionNames = null;
        this.actionSets.removeElement(actionSet);
        ((JEditActionSet)actionSet).context = null;
        for (String action : actions = ((JEditActionSet)actionSet).getActionNames()) {
            this.actionHash.remove(action);
            if (!this.overriddenActions.containsKey(action)) continue;
            JEditActionSet oldAction = (JEditActionSet)this.overriddenActions.remove(action);
            this.actionHash.put(action, oldAction);
        }
    }

    public E[] getActionSets() {
        if (this.actionSets.isEmpty()) {
            return null;
        }
        Class<?> clazz = ((JEditActionSet)this.actionSets.get(0)).getClass();
        Object[] retVal = (JEditActionSet[])Array.newInstance(clazz, this.actionSets.size());
        this.actionSets.copyInto(retVal);
        return retVal;
    }

    public F getAction(String name) {
        JEditActionSet set = (JEditActionSet)this.actionHash.get(name);
        if (set == null) {
            return null;
        }
        return (F)set.getAction(name);
    }

    public E getActionSetForAction(String action) {
        return (E)((JEditActionSet)this.actionHash.get(action));
    }

    public String[] getActionNames() {
        if (this.actionNames == null) {
            LinkedList<String> vec = new LinkedList<String>();
            for (int i = 0; i < this.actionSets.size(); ++i) {
                ((JEditActionSet)this.actionSets.elementAt(i)).getActionNames(vec);
            }
            this.actionNames = vec.toArray(new String[vec.size()]);
            Arrays.sort(this.actionNames, new StandardUtilities.StringCompare(true));
        }
        return Arrays.copyOf(this.actionNames, this.actionNames.length);
    }
}

