/*
 * Decompiled with CFR 0.152.
 */
package common.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class AtomicOutputStream
extends OutputStream {
    private File target;
    private File temp;
    private OutputStream out;

    public AtomicOutputStream(String path) throws IOException {
        this(new File(path));
    }

    public AtomicOutputStream(File path) throws IOException {
        if (path.exists() && !path.canWrite()) {
            throw new IOException("Can't write to " + path.getAbsolutePath());
        }
        this.temp = File.createTempFile(path.getName(), ".tmp", path.getParentFile());
        this.out = new FileOutputStream(this.temp);
        this.target = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block7: {
            if (this.out == null) {
                return;
            }
            try {
                this.out.close();
                if (this.temp.renameTo(this.target)) break block7;
                if (this.target.exists()) {
                    File backup = File.createTempFile(this.target.getName(), ".backup", this.target.getParentFile());
                    backup.delete();
                    if (!this.target.renameTo(backup) || !this.temp.renameTo(this.target)) {
                        if (backup.exists() && !this.target.exists()) {
                            backup.renameTo(this.target);
                        }
                        throw new IOException("Can't rename temp file to " + this.target.getName());
                    }
                    backup.delete();
                    break block7;
                }
                throw new IOException("Can't rename temp file to " + this.target.getName());
            }
            finally {
                this.out = null;
                this.temp = null;
                this.target = null;
            }
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (this.out == null) {
            return;
        }
        try {
            this.out.close();
            this.temp.delete();
        }
        catch (IOException iOException) {
        }
        finally {
            this.out = null;
            this.temp = null;
            this.target = null;
        }
    }

    protected void finalize() {
        this.rollback();
    }
}

