/*
 * Decompiled with CFR 0.152.
 */
package common.gui.pathbuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.jEdit;

public class PathBuilder
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JTable pathElementTable;
    private PathElementTableModel pathElementModel;
    private JPanel btnPanel;
    private JButton addElement;
    private JButton removeElement;
    private JButton moveUp;
    private JButton moveDown;
    private boolean moveButtonsEnabled = true;
    private boolean multiSelectionEnabled = false;
    private Vector elements = new Vector();
    private String startDirectory;
    private int fileSelectionMode;
    private List<ActionListener> actionListeners = null;
    private FileFilter filter;
    private static final String PROPS_PREFIX = "common.gui.pathbuilder";
    private String addButtonText;
    private String removeButtonText;
    private String moveUpButtonText;
    private String moveDownButtonText;
    private String fileDialogTitle;
    private String fileDialogAction;

    public PathBuilder() {
        this("Classpath Elements");
    }

    public PathBuilder(String title) {
        super(new BorderLayout());
        this.pathElementModel = new PathElementTableModel(title);
        this.addButtonText = jEdit.getProperty((String)"common.gui.pathbuilder.addButtonText");
        this.removeButtonText = jEdit.getProperty((String)"common.gui.pathbuilder.removeButtonText");
        this.moveUpButtonText = jEdit.getProperty((String)"common.gui.pathbuilder.moveUpButtonText");
        this.moveDownButtonText = jEdit.getProperty((String)"common.gui.pathbuilder.moveDownButtonText");
        this.fileDialogTitle = jEdit.getProperty((String)"common.gui.pathbuilder.fileDialogTitle");
        this.fileDialogAction = jEdit.getProperty((String)"common.gui.pathbuilder.fileDialogAction");
        this.addElement = new JButton(this.addButtonText);
        this.addElement.addActionListener(this);
        this.removeElement = new JButton(this.removeButtonText);
        this.removeElement.addActionListener(this);
        this.moveUp = new JButton(this.moveUpButtonText);
        this.moveUp.addActionListener(this);
        this.moveDown = new JButton(this.moveDownButtonText);
        this.moveDown.addActionListener(this);
        this.btnPanel = new JPanel();
        this.btnPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.btnPanel.add(this.addElement);
        this.btnPanel.add(this.removeElement);
        this.btnPanel.add(this.moveUp);
        this.btnPanel.add(this.moveDown);
        this.add((Component)this.btnPanel, "South");
        this.removeElement.setEnabled(false);
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        this.pathElementTable = new JTable(this.pathElementModel);
        JScrollPane tableScroller = new JScrollPane(this.pathElementTable);
        this.add((Component)tableScroller, "Center");
        this.pathElementTable.getSelectionModel().addListSelectionListener(this);
        if (this.elements.size() > 0) {
            this.pathElementTable.setRowSelectionInterval(0, 0);
        }
        this.fileSelectionMode = 2;
    }

    public void setAddButtonText(String text) {
        this.addElement.setText(text);
    }

    public void setRemoveButtonText(String text) {
        this.removeElement.setText(text);
    }

    public void setMoveUpButtonText(String text) {
        this.moveUp.setText(text);
    }

    public void setMoveDownButtonText(String text) {
        this.moveDown.setText(text);
    }

    public void setFileSelectionMode(int fsm) {
        this.fileSelectionMode = fsm;
    }

    public void setFileFilter(FileFilter filter) {
        this.filter = filter;
    }

    public void setStartDirectory(String startDirectory) {
        this.startDirectory = startDirectory;
    }

    public void setFileDialogTitle(String fileDialogTitle) {
        this.fileDialogTitle = fileDialogTitle;
    }

    public void setFileDialogAction(String fileDialogAction) {
        this.fileDialogAction = fileDialogAction;
    }

    public void setPath(String path) {
        int size = this.elements.size();
        if (size > 0) {
            this.elements.clear();
            this.pathElementModel.fireTableRowsDeleted(0, size - 1);
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            this.elements.addElement(st.nextToken());
        }
        if (this.elements.size() > 0) {
            this.pathElementModel.fireTableRowsInserted(0, this.elements.size() - 1);
            this.pathElementTable.setRowSelectionInterval(0, 0);
        }
    }

    public void setPathArray(String[] path) {
        int size = this.elements.size();
        if (size > 0) {
            this.elements.clear();
            this.pathElementModel.fireTableRowsDeleted(0, size - 1);
        }
        for (int i = 0; i < path.length; ++i) {
            this.elements.addElement(path[i]);
        }
        if (this.elements.size() > 0) {
            this.pathElementModel.fireTableRowsInserted(0, this.elements.size() - 1);
            this.pathElementTable.setRowSelectionInterval(0, 0);
        }
    }

    public String getPath() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.elements.size(); ++i) {
            sb.append((String)this.elements.elementAt(i));
            if (i >= this.elements.size() - 1) continue;
            sb.append(File.pathSeparator);
        }
        return sb.toString();
    }

    public String[] getPathArray() {
        String[] pathArray = new String[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            pathArray[i] = (String)this.elements.elementAt(i);
        }
        return pathArray;
    }

    public String getStartDirectory() {
        return this.startDirectory;
    }

    public void setMoveButtonsEnabled(boolean enabled) {
        if (enabled && !this.moveButtonsEnabled) {
            this.moveButtonsEnabled = true;
            this.btnPanel.add(this.moveUp);
            this.btnPanel.add(this.moveDown);
        } else if (!enabled && this.moveButtonsEnabled) {
            this.moveButtonsEnabled = false;
            this.btnPanel.remove(this.moveDown);
            this.btnPanel.remove(this.moveUp);
        }
    }

    public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
        this.multiSelectionEnabled = multiSelectionEnabled;
    }

    public void actionPerformed(ActionEvent evt) {
        int row;
        Object source = evt.getSource();
        if (source.equals(this.addElement)) {
            JFileChooser chooser = this.startDirectory != null ? new JFileChooser(this.startDirectory) : new JFileChooser();
            chooser.setFileSelectionMode(this.fileSelectionMode);
            if (this.multiSelectionEnabled) {
                chooser.setMultiSelectionEnabled(true);
            }
            if (this.filter != null) {
                chooser.addChoosableFileFilter(this.filter);
            }
            chooser.setDialogTitle(this.fileDialogTitle);
            int returnVal = chooser.showDialog(null, this.fileDialogAction);
            if (returnVal == 0) {
                if (this.multiSelectionEnabled) {
                    File[] files = chooser.getSelectedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        this.pathElementModel.add(files[i].getPath());
                    }
                } else {
                    this.pathElementModel.add(chooser.getSelectedFile().getPath());
                }
                if (this.elements.size() == 1) {
                    this.pathElementTable.setRowSelectionInterval(0, 0);
                }
                this.startDirectory = chooser.getCurrentDirectory().getPath();
            }
        } else if (source.equals(this.removeElement)) {
            row = this.pathElementTable.getSelectedRow();
            if (row >= 0) {
                this.pathElementModel.remove(row);
            }
        } else if (source.equals(this.moveUp)) {
            row = this.pathElementTable.getSelectedRow();
            if (row >= 1) {
                this.pathElementModel.moveUp(row);
            }
        } else if (source.equals(this.moveDown) && (row = this.pathElementTable.getSelectedRow()) < this.elements.size() - 1) {
            this.pathElementModel.moveDown(row);
        }
        int tableSize = this.elements.size();
        if (tableSize < 1 && this.removeElement.isEnabled()) {
            this.removeElement.setEnabled(false);
        } else if (tableSize > 0 && !this.removeElement.isEnabled()) {
            this.removeElement.setEnabled(true);
        }
        this.valueChanged(null);
        if (this.actionListeners != null) {
            for (ActionListener actionListener : this.actionListeners) {
                actionListener.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    public void valueChanged(ListSelectionEvent evt) {
        int row = this.pathElementTable.getSelectedRow();
        int tableSize = this.elements.size();
        if (tableSize < 1 && this.removeElement.isEnabled()) {
            this.removeElement.setEnabled(false);
        } else if (tableSize > 0 && !this.removeElement.isEnabled()) {
            this.removeElement.setEnabled(true);
        }
        if (tableSize < 1) {
            this.moveUp.setEnabled(false);
            this.moveDown.setEnabled(false);
            return;
        }
        if (row < 1) {
            this.moveUp.setEnabled(false);
            if (tableSize > 1 && !this.moveDown.isEnabled()) {
                this.moveDown.setEnabled(true);
            }
        } else if (row == tableSize - 1) {
            this.moveDown.setEnabled(false);
            if (!this.moveUp.isEnabled()) {
                this.moveUp.setEnabled(true);
            }
        } else {
            this.moveUp.setEnabled(true);
            this.moveDown.setEnabled(true);
        }
    }

    public void addActionListener(ActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(listener);
    }

    class PathElementTableModel
    extends AbstractTableModel {
        private String title = "";

        public PathElementTableModel(String title) {
            this.title = title;
        }

        public int getRowCount() {
            return PathBuilder.this.elements.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int column) {
            return this.title;
        }

        public Object getValueAt(int row, int column) {
            return PathBuilder.this.elements.elementAt(row);
        }

        protected void add(String value) {
            int rows = PathBuilder.this.elements.size();
            PathBuilder.this.elements.addElement(value);
            this.fireTableRowsInserted(rows, rows);
        }

        protected void remove(int row) {
            PathBuilder.this.elements.removeElementAt(row);
            this.fireTableRowsDeleted(row, row);
            if (PathBuilder.this.elements.size() > 0) {
                if (PathBuilder.this.elements.size() > row) {
                    PathBuilder.this.pathElementTable.setRowSelectionInterval(row, row);
                } else {
                    row = PathBuilder.this.elements.size() - 1;
                    PathBuilder.this.pathElementTable.setRowSelectionInterval(row, row);
                }
            }
        }

        protected void moveUp(int row) {
            Object a = PathBuilder.this.elements.elementAt(row);
            Object b = PathBuilder.this.elements.elementAt(row - 1);
            PathBuilder.this.elements.setElementAt(a, row - 1);
            PathBuilder.this.elements.setElementAt(b, row);
            this.fireTableRowsUpdated(row - 1, row);
            PathBuilder.this.pathElementTable.setRowSelectionInterval(row - 1, row - 1);
        }

        protected void moveDown(int row) {
            Object a = PathBuilder.this.elements.elementAt(row);
            Object b = PathBuilder.this.elements.elementAt(row + 1);
            PathBuilder.this.elements.setElementAt(a, row + 1);
            PathBuilder.this.elements.setElementAt(b, row);
            this.fireTableRowsUpdated(row, row + 1);
            PathBuilder.this.pathElementTable.setRowSelectionInterval(row + 1, row + 1);
        }
    }
}

