/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import common.gui.FileTextField;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class EasyOptionPane
extends AbstractOptionPane {
    private boolean emptyToNull = true;
    private List cspec;
    private Properties pstore;
    private Map cinst;
    private Map rgroups;

    public EasyOptionPane(String name) {
        super(name);
    }

    public EasyOptionPane(String name, String components) {
        super(name);
        StringTokenizer st = new StringTokenizer(components);
        LinkedList<String> lst = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            if (next.length() <= 0) continue;
            lst.add(next);
        }
        this.setComponentSpec(lst);
    }

    public EasyOptionPane(String name, List components) {
        super(name);
        this.setComponentSpec(components);
    }

    public void _init() {
        if (this.cspec == null) {
            return;
        }
        this.cinst = new HashMap();
        for (String comp : this.cspec) {
            JComponent jcomp;
            StringTokenizer st = new StringTokenizer(comp, ",");
            if (st.countTokens() == 0) {
                Log.log((int)9, (Object)((Object)this), (Object)("Invalid config string (1): " + comp));
                continue;
            }
            String type = st.nextToken();
            if (st.countTokens() < 2 && !"sep".equals(type) && !"label".equals(type)) {
                Log.log((int)9, (Object)((Object)this), (Object)("Invalid config string (2): " + comp));
                continue;
            }
            String label = null;
            String tooltip = null;
            if (st.hasMoreTokens()) {
                label = st.nextToken();
                if ("null".equals(label)) {
                    label = null;
                } else if (!"sep".equals(type)) {
                    tooltip = jEdit.getProperty((String)(label + ".tooltip"), (String)null);
                    label = jEdit.getProperty((String)label, (String)label);
                }
            }
            String prop = null;
            String value = null;
            if (st.hasMoreTokens()) {
                prop = st.nextToken();
            }
            String config = null;
            if (st.hasMoreTokens()) {
                config = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                Log.log((int)7, (Object)((Object)this), (Object)("component string has unused data: " + comp));
            }
            if (prop != null) {
                value = this.getProperty(prop, null);
            }
            if ("checkbox".equals(type)) {
                jcomp = this.createCheckBox(label, value, config);
                label = null;
            } else if ("combo".equals(type)) {
                jcomp = this.createComboBox(value, config, false);
            } else if ("dir".equals(type)) {
                jcomp = this.createFileTextField(value, config, 1);
            } else if ("ecombo".equals(type)) {
                jcomp = this.createComboBox(value, config, true);
            } else if ("file".equals(type)) {
                jcomp = this.createFileTextField(value, config, 0);
            } else if ("filedir".equals(type)) {
                jcomp = this.createFileTextField(value, config, 2);
            } else {
                if ("label".equals(type)) {
                    jcomp = new JLabel(label);
                    this.addComponent(jcomp);
                    continue;
                }
                if ("radio".equals(type)) {
                    if (config == null) {
                        Log.log((int)7, (Object)((Object)this), (Object)("Radio button with no group: " + comp));
                        continue;
                    }
                    jcomp = this.createRadioButton(label, value, config);
                    label = null;
                    this.addComponent(jcomp);
                    this.cinst.put(prop, this.rgroups.get(config));
                    continue;
                }
                if ("sep".equals(type)) {
                    if (label != null) {
                        this.addSeparator(label);
                        continue;
                    }
                    this.addSeparator();
                    continue;
                }
                if ("text".equals(type)) {
                    jcomp = this.createTextField(value, config);
                } else if ("textarea".equals(type)) {
                    jcomp = this.createTextArea(value, config);
                } else {
                    Object ocomp = this.createComponent(type, label, value, config);
                    if (ocomp == null) {
                        Log.log((int)7, (Object)((Object)this), (Object)("Unknown type: " + type));
                        continue;
                    }
                    this.cinst.put(prop, ocomp);
                    continue;
                }
            }
            this.cinst.put(prop, jcomp);
            if (tooltip != null) {
                jcomp.setToolTipText(tooltip);
            }
            if (label != null) {
                this.addComponent(label, jcomp);
                continue;
            }
            this.addComponent(jcomp);
        }
    }

    public void _save() {
        if (this.cinst == null) {
            return;
        }
        for (String prop : this.cinst.keySet()) {
            Object comp = this.cinst.get(prop);
            this.setProperty(prop, this.parseComponent(comp, prop));
        }
    }

    public void setEmptyToNull(boolean flag) {
        this.emptyToNull = flag;
    }

    protected void setComponentSpec(List components) {
        this.cspec = components;
    }

    protected void setPropertyStore(Properties p) {
        this.pstore = p;
    }

    protected Object getComponent(String prop) {
        return this.cinst != null ? this.cinst.get(prop) : null;
    }

    protected String getProperty(String name, String dflt) {
        if (this.pstore == null) {
            return jEdit.getProperty((String)name, (String)dflt);
        }
        String ret = this.pstore.getProperty(name);
        return ret == null ? dflt : ret;
    }

    protected void setProperty(String name, String val) {
        if (val != null && val.length() == 0 && this.emptyToNull) {
            val = null;
        }
        if (this.pstore == null) {
            if (val != null) {
                jEdit.setProperty((String)name, (String)val);
            } else {
                jEdit.unsetProperty((String)name);
            }
        } else if (val != null) {
            this.pstore.setProperty(name, val);
        } else {
            this.pstore.remove(name);
        }
    }

    protected void removeProperty(String name) {
        if (this.pstore == null) {
            jEdit.unsetProperty((String)name);
        } else {
            this.pstore.remove(name);
        }
    }

    protected void cleanup() {
        if (this.cinst == null) {
            return;
        }
        for (String prop : this.cinst.keySet()) {
            this.removeProperty(prop);
        }
    }

    protected Object createComponent(String type, String label, String value, String config) {
        return null;
    }

    protected String parseComponent(Object comp, String name) {
        String ret = null;
        if (comp instanceof ButtonGroup) {
            AbstractButton abtn;
            Enumeration<AbstractButton> buttons = ((ButtonGroup)comp).getElements();
            int idx = 0;
            while (buttons.hasMoreElements() && !(abtn = buttons.nextElement()).isSelected()) {
                ++idx;
            }
            ret = String.valueOf(idx);
        } else if (comp instanceof FileTextField) {
            ret = ((FileTextField)comp).getTextField().getText();
        } else if (comp instanceof JCheckBox) {
            boolean val = ((JCheckBox)comp).isSelected();
            ret = String.valueOf(val);
        } else if (comp instanceof JComboBox) {
            ret = ((JComboBox)comp).getSelectedItem().toString();
        } else if (comp instanceof JTextComponent) {
            ret = ((JTextComponent)comp).getText();
        } else {
            Log.log((int)7, (Object)((Object)this), (Object)("Unhandled component type: " + comp.getClass().getName()));
        }
        return ret;
    }

    private JCheckBox createCheckBox(String label, String prop, String config) {
        JCheckBox ret = new JCheckBox(label);
        ret.setSelected("true".equalsIgnoreCase(prop));
        return ret;
    }

    private JComboBox createComboBox(String prop, String config, boolean editable) {
        JComboBox<String> ret = new JComboBox<String>();
        ret.setEditable(editable);
        boolean found = false;
        int idx = 0;
        if (config != null) {
            StringTokenizer vals = new StringTokenizer(config, ":");
            while (vals.hasMoreTokens()) {
                String next = vals.nextToken();
                ret.addItem(next);
                if (next.equals(prop)) {
                    found = true;
                    continue;
                }
                if (found || !vals.hasMoreTokens()) continue;
                ++idx;
            }
        }
        if (!found && prop != null) {
            ret.addItem(prop);
        }
        if (ret.getItemCount() > 0) {
            ret.setSelectedIndex(idx);
        }
        return ret;
    }

    private FileTextField createFileTextField(String prop, String config, int mode) {
        FileTextField ret = new FileTextField("true".equalsIgnoreCase(config));
        if (prop != null) {
            ret.getTextField().setText(prop);
        }
        ret.setFileSelectionMode(mode);
        return ret;
    }

    private JRadioButton createRadioButton(String label, String prop, String config) {
        JRadioButton ret = new JRadioButton(label);
        if (config != null) {
            ButtonGroup grp;
            if (this.rgroups == null) {
                this.rgroups = new HashMap();
            }
            if ((grp = (ButtonGroup)this.rgroups.get(config)) == null) {
                grp = new ButtonGroup();
                this.rgroups.put(config, grp);
            }
            grp.add(ret);
            int idx = 0;
            try {
                idx = Integer.parseInt(prop);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            ret.setSelected(idx == grp.getButtonCount());
        }
        return ret;
    }

    private JTextField createTextField(String prop, String config) {
        JTextField ret = new JTextField();
        if (prop != null) {
            ret.setText(prop);
        }
        return ret;
    }

    private JTextArea createTextArea(String prop, String config) {
        JTextArea ret = new JTextArea();
        if (prop != null) {
            ret.setText(prop);
        }
        if (config != null) {
            try {
                ret.setRows(Integer.parseInt(config));
            }
            catch (NumberFormatException nfe) {
                ret.setRows(5);
            }
        }
        return ret;
    }
}

