/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Build_JDK;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.No_Progress$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Progress;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class Build_JDK$ {
    public static Build_JDK$ MODULE$;
    private final List<Build_JDK.JDK_Platform> jdk_platforms;
    private final String settings;
    private final Isabelle_Tool isabelle_tool;

    static {
        new Build_JDK$();
    }

    public Build_JDK.Version detect_version(String s) {
        Build_JDK.Version version;
        String string;
        Regex Version_Dir_Entry = new StringOps(Predef$.MODULE$.augmentString("^jdk1\\.(\\d+)\\.0_(\\d+)(?:\\.jdk)?$")).r();
        Option option = Version_Dir_Entry.unapplySeq((CharSequence)(string = s));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String a = (String)((LinearSeqOptimized)option.get()).apply(0);
            String b = (String)((LinearSeqOptimized)option.get()).apply(1);
            version = new Build_JDK.Version(a + "u" + b, "1." + a + ".0_" + b);
        } else {
            version = (Build_JDK.Version)package$.MODULE$.error().apply((Object)("Cannot detect JDK version from " + package$.MODULE$.quote().apply((Object)s)));
        }
        return version;
    }

    public List<Build_JDK.JDK_Platform> jdk_platforms() {
        return this.jdk_platforms;
    }

    public String readme(Build_JDK.Version version) {
        return "This is JDK/JRE " + version.full() + " as required for Isabelle.\n\nSee http://www.oracle.com/technetwork/java/javase/downloads/index.html\nfor the original downloads, which are covered by the Oracle Binary\nCode License Agreement for Java SE.\n\nLinux, Windows, Mac OS X all work uniformly, depending on certain\nplatform-specific subdirectories.\n";
    }

    public String settings() {
        return this.settings;
    }

    public Tuple2<Build_JDK.Version, Build_JDK.JDK_Platform> extract_archive(Path dir, Path archive) {
        Tuple2 tuple2;
        try {
            String s;
            Path tmp_dir = dir.$plus(Path$.MODULE$.explode("tmp"));
            Isabelle_System$.MODULE$.mkdirs(tmp_dir);
            Isabelle_System$.MODULE$.gnutar("-C " + File$.MODULE$.bash_path(tmp_dir) + " -xzf " + File$.MODULE$.bash_path(archive), Isabelle_System$.MODULE$.gnutar$default$2(), Isabelle_System$.MODULE$.gnutar$default$3()).check();
            List<String> list = File$.MODULE$.read_dir(tmp_dir);
            Some some = List$.MODULE$.unapplySeq(list);
            String string = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 ? (s = (String)((LinearSeqOptimized)some.get()).apply(0)) : (String)package$.MODULE$.error().apply((Object)"Archive contains multiple directories");
            String dir_entry = string;
            Build_JDK.Version version = this.detect_version(dir_entry);
            Path jdk_dir = tmp_dir.$plus(Path$.MODULE$.explode(dir_entry));
            Build_JDK.JDK_Platform platform = (Build_JDK.JDK_Platform)this.jdk_platforms().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.detect(jdk_dir))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)package$.MODULE$.error().apply((Object)"Failed to detect JDK platform"));
            Path platform_dir = dir.$plus(Path$.MODULE$.explode(platform.name()));
            Object object = platform_dir.is_dir() ? package$.MODULE$.error().apply((Object)("Directory already exists: " + platform_dir)) : BoxedUnit.UNIT;
            File$.MODULE$.move(jdk_dir, platform_dir);
            tuple2 = new Tuple2((Object)version, (Object)platform);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<String> option = package$.MODULE$.ERROR().unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            String msg = (String)option.get();
            Tuple2 tuple22 = (Tuple2)package$.MODULE$.cat_error().apply((Object)msg, (Object)("The error(s) above occurred for " + archive));
            tuple2 = tuple22;
        }
        return tuple2;
    }

    public void build_jdk(List<Path> archives, Progress progress, Path target_dir) {
        Object object = Platform$.MODULE$.is_windows() ? package$.MODULE$.error().apply((Object)"Cannot build jdk on Windows") : BoxedUnit.UNIT;
        Isabelle_System$.MODULE$.with_tmp_dir("jdk", (Function1 & Serializable & scala.Serializable)dir -> {
            Build_JDK.Version version;
            progress.echo("Extracting ...");
            List extracted = (List)archives.map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.extract_archive((Path)dir, (Path)x$2), List$.MODULE$.canBuildFrom());
            List list = ((TraversableOnce)extracted.map((Function1 & Serializable & scala.Serializable)x$3 -> (Build_JDK.Version)x$3._1(), List$.MODULE$.canBuildFrom())).toSet().toList();
            Some some = List$.MODULE$.unapplySeq((Seq)list);
            Build_JDK.Version version2 = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 ? (version = (Build_JDK.Version)((LinearSeqOptimized)some.get()).apply(0)) : (Nil$.MODULE$.equals(list) ? (Build_JDK.Version)package$.MODULE$.error().apply((Object)"No archives") : (Build_JDK.Version)package$.MODULE$.error().apply((Object)("Archives contain multiple JDK versions: " + package$.MODULE$.commas_quote().apply(list.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.short(), List$.MODULE$.canBuildFrom())))));
            Build_JDK.Version version3 = version2;
            List missing_platforms = (List)MODULE$.jdk_platforms().filterNot((Function1 & Serializable & scala.Serializable)p1 -> BoxesRunTime.boxToBoolean((boolean)extracted.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Build_JDK$.$anonfun$build_jdk$6(p1, x0$1)))));
            Object object = missing_platforms.nonEmpty() ? package$.MODULE$.error().apply((Object)("Missing platforms: " + package$.MODULE$.commas_quote().apply(missing_platforms.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), List$.MODULE$.canBuildFrom())))) : BoxedUnit.UNIT;
            String jdk_name = "jdk-" + version3.short();
            Path jdk_path = Path$.MODULE$.explode(jdk_name);
            Path component_dir = dir.$plus(jdk_path);
            Isabelle_System$.MODULE$.mkdirs(component_dir.$plus(Path$.MODULE$.explode("etc")));
            File$.MODULE$.write(component_dir.$plus(Path$.MODULE$.explode("etc/settings")), (CharSequence)MODULE$.settings());
            File$.MODULE$.write(component_dir.$plus(Path$.MODULE$.explode("README")), (CharSequence)MODULE$.readme(version3));
            extracted.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Build_JDK$.$anonfun$build_jdk$8(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                Build_JDK$.$anonfun$build_jdk$9(component_dir, dir, x$6);
                return BoxedUnit.UNIT;
            });
            File x$11 = component_dir.file();
            boolean x$12 = true;
            Function1<File, Object> x$13 = File$.MODULE$.find_files$default$2();
            File$.MODULE$.find_files(x$11, x$13, x$12).foreach((Function1 & Serializable & scala.Serializable)file -> {
                Object object;
                java.nio.file.Path path = file.toPath();
                Set<PosixFilePermission> perms = Files.getPosixFilePermissions(path, new LinkOption[0]);
                perms.add(PosixFilePermission.OWNER_READ);
                perms.add(PosixFilePermission.GROUP_READ);
                perms.add(PosixFilePermission.OTHERS_READ);
                perms.add(PosixFilePermission.OWNER_WRITE);
                if (file.isDirectory()) {
                    perms.add(PosixFilePermission.OWNER_WRITE);
                    perms.add(PosixFilePermission.OWNER_EXECUTE);
                    perms.add(PosixFilePermission.GROUP_EXECUTE);
                    object = BoxesRunTime.boxToBoolean((boolean)perms.add(PosixFilePermission.OTHERS_EXECUTE));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return Files.setPosixFilePermissions(path, perms);
            });
            File$.MODULE$.find_files(component_dir.$plus(Path$.MODULE$.explode("x86_64-darwin")).file(), (Function1<File, Object>)(Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Build_JDK$.$anonfun$build_jdk$11(file)), File$.MODULE$.find_files$default$3()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.delete()));
            progress.echo("Sharing ...");
            List list2 = (List)MODULE$.jdk_platforms().map((Function1 & Serializable & scala.Serializable)platform -> component_dir.$plus(Path$.MODULE$.explode(platform.name())).file().toPath(), List$.MODULE$.canBuildFrom());
            if (!(list2 instanceof .colon.colon)) {
                throw new MatchError((Object)list2);
            }
            .colon.colon colon2 = (.colon.colon)list2;
            java.nio.file.Path main_dir = (java.nio.file.Path)colon2.head();
            List other_dirs = colon2.tl$access$1();
            Tuple2 tuple2 = new Tuple2((Object)main_dir, (Object)other_dirs);
            Tuple2 tuple22 = tuple2;
            java.nio.file.Path main_dir2 = (java.nio.file.Path)tuple22._1();
            List other_dirs2 = (List)tuple22._2();
            File$.MODULE$.find_files(main_dir2.toFile(), File$.MODULE$.find_files$default$2(), File$.MODULE$.find_files$default$3()).iterator().map((Function1 & Serializable & scala.Serializable)file1 -> {
                java.nio.file.Path path1 = file1.toPath();
                return new Tuple2(file1, (Object)path1);
            }).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                Build_JDK$.$anonfun$build_jdk$15(main_dir2, other_dirs2, x$9);
                return BoxedUnit.UNIT;
            });
            progress.echo("Archiving ...");
            return Isabelle_System$.MODULE$.gnutar("--owner=root --group=root -C " + File$.MODULE$.bash_path((Path)dir) + " -czf " + File$.MODULE$.bash_path(target_dir.$plus(jdk_path.ext("tar.gz"))) + " " + jdk_name, Isabelle_System$.MODULE$.gnutar$default$2(), Isabelle_System$.MODULE$.gnutar$default$3()).check();
        });
    }

    public Progress build_jdk$default$2() {
        return No_Progress$.MODULE$;
    }

    public Path build_jdk$default$3() {
        return Path$.MODULE$.current();
    }

    public Isabelle_Tool isabelle_tool() {
        return this.isabelle_tool;
    }

    public static final /* synthetic */ boolean $anonfun$build_jdk$6(Build_JDK.JDK_Platform p1$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Build_JDK.JDK_Platform p2 = (Build_JDK.JDK_Platform)tuple2._2();
        String string = p1$1.name();
        String string2 = p2.name();
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$build_jdk$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$build_jdk$9(Path component_dir$1, Path dir$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Build_JDK.JDK_Platform platform = (Build_JDK.JDK_Platform)tuple2._2();
        File$.MODULE$.move(dir$1.$plus(Path$.MODULE$.explode(platform.name())), component_dir$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$build_jdk$11(File file) {
        return file.getName().startsWith("._");
    }

    public static final /* synthetic */ void $anonfun$build_jdk$15(java.nio.file.Path main_dir$1, List other_dirs$1, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file1 = (File)tuple2._1();
        java.nio.file.Path path1 = (java.nio.file.Path)tuple2._2();
        other_dirs$1.iterator().foreach((Function1 & Serializable & scala.Serializable)dir2 -> {
            Object object;
            java.nio.file.Path path2 = dir2.resolve(main_dir$1.relativize(path1));
            File file2 = path2.toFile();
            if (!Files.isSymbolicLink(path2) && file2.isFile() && File$.MODULE$.eq_content(file1, file2)) {
                file2.delete();
                object = Files.createLink(path2, path1);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$isabelle_tool$1(List args) {
        ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
        Getopts getopts = Getopts$.MODULE$.apply("\nUsage: isabelle build_jdk [OPTIONS] ARCHIVES...\n\n  Options are:\n    -D DIR       target directory (default \".\")\n\n  Build jdk component from tar.gz archives, with original jdk installations\n  for Linux (x86, x86_64), Windows (x86, x86_64), Mac OS X (x86_64).\n", (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"D:"), (Function1 & Serializable & scala.Serializable)arg -> {
            target_dir.elem = Path$.MODULE$.explode(arg);
            return BoxedUnit.UNIT;
        })}));
        List<String> more_args = getopts.apply((List<String>)args);
        if (more_args.isEmpty()) {
            throw getopts.usage();
        }
        List archives = (List)more_args.map((Function1 & Serializable & scala.Serializable)x$10 -> Path$.MODULE$.explode((String)x$10), List$.MODULE$.canBuildFrom());
        Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2());
        MODULE$.build_jdk((List<Path>)archives, progress, (Path)target_dir.elem);
    }

    private Build_JDK$() {
        MODULE$ = this;
        this.jdk_platforms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Build_JDK.JDK_Platform[]{new Build_JDK.JDK_Platform("x86-linux", "bin/java", new StringOps(Predef$.MODULE$.augmentString(".*ELF 32-bit.*80386.*")).r()), new Build_JDK.JDK_Platform("x86_64-linux", "bin/java", new StringOps(Predef$.MODULE$.augmentString(".*ELF 64-bit.*x86[-_]64.*")).r()), new Build_JDK.JDK_Platform("x86-windows", "bin/java.exe", new StringOps(Predef$.MODULE$.augmentString(".*PE32 executable.*80386.*")).r()), new Build_JDK.JDK_Platform("x86_64-windows", "bin/java.exe", new StringOps(Predef$.MODULE$.augmentString(".*PE32\\+ executable.*x86[-_]64.*")).r()), new Build_JDK.JDK_Platform("x86_64-darwin", "Contents/Home/bin/java", new StringOps(Predef$.MODULE$.augmentString(".*Mach-O 64-bit.*x86[-_]64.*")).r())}));
        this.settings = "# -*- shell-script -*- :mode=shellscript:\n\ncase \"$ISABELLE_PLATFORM_FAMILY\" in\n  linux)\n    ISABELLE_JAVA_PLATFORM=\"${ISABELLE_PLATFORM64:-$ISABELLE_PLATFORM32}\"\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM\"\n    ;;\n  windows)\n    if [ ! -e \"$COMPONENT/x86_64-windows\" ]; then\n      ISABELLE_JAVA_PLATFORM=\"x86-windows\"\n    elif \"$COMPONENT/x86_64-windows/jre/bin/java\" -version > /dev/null 2> /dev/null; then\n      ISABELLE_JAVA_PLATFORM=\"x86_64-windows\"\n    else\n      ISABELLE_JAVA_PLATFORM=\"x86-windows\"\n    fi\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM\"\n    ;;\n  macos)\n    if [ -z \"$ISABELLE_PLATFORM64\" ]; then\n      echo \"### Java unavailable on 32bit Mac OS X\" >&2\n    else\n      ISABELLE_JAVA_PLATFORM=\"$ISABELLE_PLATFORM64\"\n      ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM/Contents/Home\"\n    fi\n    ;;\nesac\n";
        this.isabelle_tool = new Isabelle_Tool("build_jdk", "build Isabelle jdk component from original platform installations", (Function1<List<String>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)args -> {
            Build_JDK$.$anonfun$isabelle_tool$1(args);
            return BoxedUnit.UNIT;
        }, true);
    }
}

