/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Build_History$Multicore$;
import isabelle.Build_Log;
import isabelle.Build_Log$;
import isabelle.Build_Log$Log_File$;
import isabelle.Build_Log$Prop$;
import isabelle.Bytes;
import isabelle.Command_Line$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date;
import isabelle.Date$;
import isabelle.File$;
import isabelle.File_Progress;
import isabelle.File_Progress$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Markup$;
import isabelle.Mercurial;
import isabelle.Mercurial$;
import isabelle.No_Progress$;
import isabelle.Other_Isabelle;
import isabelle.Output$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.Properties$;
import isabelle.SQL;
import isabelle.SQLite$;
import isabelle.SSH;
import isabelle.Sessions;
import isabelle.Sessions$;
import isabelle.Value$Int$;
import isabelle.Value$Long$;
import isabelle.XZ$;
import isabelle.package$;
import java.io.Serializable;
import java.sql.SQLException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class Build_History$ {
    public static Build_History$ MODULE$;
    private final String engine;
    private final String log_prefix;
    private final String META_INFO_MARKER;
    private final String default_rev;
    private final Tuple2<Object, Object> default_multicore;
    private final int default_heap;
    private final String default_isabelle_identifier;

    static {
        new Build_History$();
    }

    public String engine() {
        return this.engine;
    }

    public String log_prefix() {
        return this.log_prefix;
    }

    public String META_INFO_MARKER() {
        return this.META_INFO_MARKER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String augment_settings(Other_Isabelle other_isabelle, int threads, boolean arch_64, int heap, Option<Object> max_heap, List<String> more_settings) {
        String string;
        String windows_32 = "x86-windows";
        String windows_64 = "x86_64-windows";
        String platform_32 = other_isabelle.apply("getenv -b ISABELLE_PLATFORM32", other_isabelle.apply$default$2(), other_isabelle.apply$default$3(), other_isabelle.apply$default$4()).check().out();
        String platform_64 = other_isabelle.apply("getenv -b ISABELLE_PLATFORM64", other_isabelle.apply$default$2(), other_isabelle.apply$default$3(), other_isabelle.apply$default$4()).check().out();
        String platform_family = other_isabelle.apply("getenv -b ISABELLE_PLATFORM_FAMILY", other_isabelle.apply$default$2(), other_isabelle.apply$default$3(), other_isabelle.apply$default$4()).check().out();
        Path polyml_home = Build_History$.liftedTree1$1(other_isabelle);
        if (Platform$.MODULE$.is_windows() && arch_64) {
            if (!Build_History$.check_dir$1(windows_64, polyml_home)) throw Build_History$.err$1(windows_64);
            string = windows_64;
        } else if (Platform$.MODULE$.is_windows() && !arch_64) {
            string = Build_History$.check_dir$1(windows_32, polyml_home) ? windows_32 : platform_32;
        } else {
            Tuple2 tuple2;
            Tuple2 tuple22 = tuple2 = arch_64 ? new Tuple2((Object)platform_64, (Object)("x86_64-" + platform_family)) : new Tuple2((Object)platform_32, (Object)("x86-" + platform_family));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String platform = (String)tuple2._1();
            String platform_name = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)platform, (Object)platform_name);
            Tuple2 tuple24 = tuple23;
            String platform2 = (String)tuple24._1();
            String platform_name2 = (String)tuple24._2();
            if (!Build_History$.check_dir$1(platform2, polyml_home)) throw Build_History$.err$1(platform_name2);
            string = platform2;
        }
        String ml_platform = string;
        String ml_options = "--minheap " + heap + (max_heap.isDefined() ? " --maxheap " + max_heap.get() : "") + " --gcthreads " + threads + (ml_platform.endsWith("-windows") ? " --codepage utf8" : "");
        Tuple2 tuple2 = new Tuple2((Object)ml_platform, (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ML_HOME=" + File$.MODULE$.bash_path(Build_History$.ml_home$1(ml_platform, polyml_home)), "ML_PLATFORM=" + package$.MODULE$.quote().apply((Object)ml_platform), "ML_OPTIONS=" + package$.MODULE$.quote().apply((Object)ml_options)})));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String ml_platform2 = (String)tuple2._1();
        List ml_settings = (List)tuple2._2();
        Tuple2 tuple25 = new Tuple2((Object)ml_platform2, (Object)ml_settings);
        Tuple2 tuple26 = tuple25;
        String ml_platform3 = (String)tuple26._1();
        List ml_settings2 = (List)tuple26._2();
        List thread_settings = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ISABELLE_JAVA_SYSTEM_OPTIONS=\"$ISABELLE_JAVA_SYSTEM_OPTIONS -Disabelle.threads=" + threads + "\"", "ISABELLE_BUILD_OPTIONS=\"threads=" + threads + "\""}));
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{ml_settings2, thread_settings}));
        List settings = (more_settings.isEmpty() ? Nil$.MODULE$ : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{more_settings}))).$colon$colon$colon(list);
        File$.MODULE$.append(other_isabelle.etc_settings(), (CharSequence)("\n" + package$.MODULE$.cat_lines().apply(settings.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)package$.MODULE$.terminate_lines().apply(x$4), List$.MODULE$.canBuildFrom()))));
        return ml_platform3;
    }

    private String default_rev() {
        return this.default_rev;
    }

    private Tuple2<Object, Object> default_multicore() {
        return this.default_multicore;
    }

    private int default_heap() {
        return this.default_heap;
    }

    private String default_isabelle_identifier() {
        return this.default_isabelle_identifier;
    }

    public List<Tuple2<Process_Result, Path>> build_history(Mercurial.Repository hg, Progress progress, String rev, String isabelle_identifier, String components_base, boolean fresh, boolean nonfree, boolean multicore_base, List<Tuple2<Object, Object>> multicore_list, boolean arch_64, int heap, Option<Object> max_heap, List<String> init_settings, List<String> more_settings, boolean verbose, List<String> build_tags, List<String> build_args) {
        Object object = File$.MODULE$.eq(Path$.MODULE$.explode("~~"), hg.root()) ? package$.MODULE$.error().apply((Object)("Repository coincides with ISABELLE_HOME=" + Path$.MODULE$.explode("~~").expand())) : BoxedUnit.UNIT;
        multicore_list.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Build_History$.$anonfun$build_history$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Build_History$.$anonfun$build_history$2(x$5))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int threads = tuple2._1$mcI$sp();
            Nothing$ nothing$ = (Nothing$)package$.MODULE$.error().apply((Object)("Bad threads value < 1: " + threads));
            return nothing$;
        });
        multicore_list.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Build_History$.$anonfun$build_history$4(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Build_History$.$anonfun$build_history$5(x$7))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            Tuple2 tuple2 = x$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int processes = tuple2._2$mcI$sp();
            Nothing$ nothing$ = (Nothing$)package$.MODULE$.error().apply((Object)("Bad processes value < 1: " + processes));
            return nothing$;
        });
        Object object2 = heap < 100 ? package$.MODULE$.error().apply((Object)("Bad heap value < 100: " + heap)) : BoxedUnit.UNIT;
        Object object3 = max_heap.isDefined() && BoxesRunTime.unboxToInt((Object)max_heap.get()) < heap ? package$.MODULE$.error().apply((Object)("Bad max_heap value < heap: " + max_heap.get())) : BoxedUnit.UNIT;
        String string = System.getenv("ISABELLE_SETTINGS_PRESENT");
        boolean bl = string == null ? true : "".equals(string);
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.error().apply((Object)"Cannot run build_history within existing Isabelle settings environment");
        }
        hg.update(rev, true, hg.update$default$3(), hg.update$default$4());
        String x$36 = rev;
        String x$37 = "-l1";
        String x$38 = hg.log$default$2();
        progress.echo_if(verbose, hg.log(x$36, x$38, x$37));
        String isabelle_version = hg.id(rev);
        Other_Isabelle other_isabelle = new Other_Isabelle(progress, hg.root(), isabelle_identifier);
        String build_host = Isabelle_System$.MODULE$.hostname();
        Date build_history_date = Date$.MODULE$.now(Date$.MODULE$.now$default$1());
        String build_group_id = build_host + ":" + build_history_date.time();
        BooleanRef first_build = BooleanRef.create((boolean)true);
        return (List)multicore_list.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)Build_History$.$anonfun$build_history$7(check$ifrefutable$3))).map((Function1 & Serializable & scala.Serializable)x$20 -> {
            Process_Result build_result;
            Path log_path;
            Path isabelle_output;
            Tuple2 tuple2 = x$20;
            if (tuple2 != null) {
                int threads = tuple2._1$mcI$sp();
                int processes = tuple2._2$mcI$sp();
                other_isabelle.init_settings(components_base, nonfree, init_settings);
                other_isabelle.resolve_components(verbose);
                String ml_platform = MODULE$.augment_settings(other_isabelle, threads, arch_64, heap, max_heap, more_settings);
                isabelle_output = Path$.MODULE$.explode(other_isabelle.apply("getenv -b ISABELLE_OUTPUT", other_isabelle.apply$default$2(), other_isabelle.apply$default$3(), other_isabelle.apply$default$4()).check().out());
                Path isabelle_output_log = isabelle_output.$plus(Path$.MODULE$.explode("log"));
                Path isabelle_base_log = isabelle_output.$plus(Path$.MODULE$.explode("../base_log"));
                if (first_build$1.elem) {
                    other_isabelle.resolve_components(verbose);
                    if (fresh) {
                        Isabelle_System$.MODULE$.rm_tree(other_isabelle.isabelle_home().$plus(Path$.MODULE$.explode("lib/classes")));
                    }
                    other_isabelle.bash("env PATH=\"" + File$.MODULE$.bash_path(Path$.MODULE$.explode("~~/lib/dummy_stty").expand()) + ":$PATH\" " + "bin/isabelle jedit -b", true, verbose, other_isabelle.bash$default$4()).check();
                    Isabelle_System$.MODULE$.rm_tree(isabelle_base_log);
                }
                Isabelle_System$.MODULE$.rm_tree(isabelle_output);
                Isabelle_System$.MODULE$.mkdirs(isabelle_output);
                List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{build_host, ml_platform, "M" + threads}));
                log_path = other_isabelle.isabelle_home_user().$plus(Build_Log$.MODULE$.log_subdir(build_history_date)).$plus(Build_Log$.MODULE$.log_filename(MODULE$.engine(), build_history_date, (List<String>)build_tags.$colon$colon$colon(list)));
                Isabelle_System$.MODULE$.mkdirs(log_path.dir());
                Path build_out = other_isabelle.isabelle_home_user().$plus(Path$.MODULE$.explode("log/build.out"));
                File_Progress build_out_progress = new File_Progress(build_out, File_Progress$.MODULE$.$lessinit$greater$default$2());
                build_out.file().delete();
                if (multicore_base && !first_build$1.elem && isabelle_base_log.is_dir()) {
                    Isabelle_System$.MODULE$.copy_dir(isabelle_base_log, isabelle_output_log);
                }
                Date build_start = Date$.MODULE$.now(Date$.MODULE$.now$default$1());
                List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-v", "-j" + processes}));
                List build_args1 = build_args.$colon$colon$colon(list2);
                build_result = new Other_Isabelle(build_out_progress, hg.root(), isabelle_identifier).apply("build " + Bash$.MODULE$.strings((List<String>)build_args1), true, true, false);
                Date build_end = Date$.MODULE$.now(Date$.MODULE$.now$default$1());
                Build_Log.Build_Info build_info = Build_Log$Log_File$.MODULE$.apply(log_path.base_name(), build_result.out_lines()).parse_build_info(true);
                Sessions.Store store = Sessions$.MODULE$.store(Sessions$.MODULE$.store$default$1());
                List<Tuple2<String, String>> list3 = Properties$.MODULE$.lines_nonempty(Build_Log$Prop$.MODULE$.build_tags().name(), build_tags);
                List<Tuple2<String, String>> list4 = Properties$.MODULE$.lines_nonempty(Build_Log$Prop$.MODULE$.build_args().name(), (List<String>)build_args1);
                List meta_info = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_group_id().name()), (Object)build_group_id), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_id().name()), (Object)(build_host + ":" + build_start.time())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_engine().name()), (Object)MODULE$.engine()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_host().name()), (Object)build_host), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_start().name()), (Object)Build_Log$.MODULE$.print_date(build_start)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_end().name()), (Object)Build_Log$.MODULE$.print_date(build_end)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.isabelle_version().name()), (Object)isabelle_version)})).$colon$colon$colon(list4).$colon$colon$colon(list3);
                build_out_progress.echo("Reading ML statistics ...");
                List ml_statistics = (List)build_info.finished_sessions().flatMap((Function1 & Serializable & scala.Serializable)session_name -> {
                    List<List<Tuple2<String, String>>> list;
                    Path database = isabelle_output.$plus(store.database((String)session_name));
                    Path log_gz = isabelle_output.$plus(store.log_gz((String)session_name));
                    if (database.is_file()) {
                        list = (List)package$.MODULE$.using(SQLite$.MODULE$.open_database(database), (Function1 & Serializable & scala.Serializable)db -> store.read_ml_statistics((SQL.Database)db, (String)session_name));
                    } else if (log_gz.is_file()) {
                        Build_Log.Log_File qual$1 = Build_Log$Log_File$.MODULE$.apply(log_gz);
                        boolean x$39 = true;
                        boolean x$40 = qual$1.parse_session_info$default$1();
                        boolean x$41 = qual$1.parse_session_info$default$3();
                        list = qual$1.parse_session_info(x$40, x$39, x$41).ml_statistics();
                    } else {
                        list = Nil$.MODULE$;
                    }
                    List<List<Tuple2<String, String>>> properties = list;
                    return (List)properties.map((Function1 & Serializable & scala.Serializable)props -> {
                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Build_Log$.MODULE$.SESSION_NAME()), session_name);
                        return props.$colon$colon((Object)tuple2);
                    }, List$.MODULE$.canBuildFrom());
                }, List$.MODULE$.canBuildFrom());
                build_out_progress.echo("Reading error messages ...");
                List session_errors = (List)build_info.failed_sessions().flatMap((Function1 & Serializable & scala.Serializable)session_name -> {
                    Nil$ nil$;
                    Path database = isabelle_output.$plus(store.database((String)session_name));
                    if (database.is_file()) {
                        try {
                            nil$ = (List)package$.MODULE$.using(SQLite$.MODULE$.open_database(database), (Function1 & Serializable & scala.Serializable)db -> store.read_errors((SQL.Database)db, (String)session_name));
                        }
                        catch (SQLException sQLException) {
                            nil$ = Nil$.MODULE$;
                        }
                    } else {
                        nil$ = Nil$.MODULE$;
                    }
                    Nil$ errors = nil$;
                    return (List)errors.map((Function1 & Serializable & scala.Serializable)msg -> List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Build_Log$.MODULE$.SESSION_NAME()), session_name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Markup$.MODULE$.CONTENT()), msg)})), List$.MODULE$.canBuildFrom());
                }, List$.MODULE$.canBuildFrom());
                build_out_progress.echo("Reading heap sizes ...");
                List heap_sizes = (List)build_info.finished_sessions().flatMap((Function1 & Serializable & scala.Serializable)session_name -> {
                    Path heap = isabelle_output.$plus(Path$.MODULE$.explode((String)session_name));
                    return heap.is_file() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)("Heap " + session_name + " (" + Value$Long$.MODULE$.apply(heap.file().length()) + " bytes)"))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }, List$.MODULE$.canBuildFrom());
                build_out_progress.echo("Writing log file " + log_path.ext("xz") + " ...");
                String string = Build_Log$Log_File$.MODULE$.print_props(MODULE$.META_INFO_MARKER(), (List<Tuple2<String, String>>)meta_info);
                List<String> list5 = build_result.out_lines();
                List list6 = (List)ml_statistics.map((Function1 & Serializable & scala.Serializable)x$14 -> Build_Log$Log_File$.MODULE$.print_props(Build_Log$.MODULE$.ML_STATISTICS_MARKER(), (List<Tuple2<String, String>>)x$14), List$.MODULE$.canBuildFrom());
                List list7 = (List)session_errors.map((Function1 & Serializable & scala.Serializable)x$15 -> Build_Log$Log_File$.MODULE$.print_props(Build_Log$.MODULE$.ERROR_MESSAGE_MARKER(), (List<Tuple2<String, String>>)x$15), List$.MODULE$.canBuildFrom());
                File$.MODULE$.write_xz(log_path.ext("xz"), (CharSequence)package$.MODULE$.terminate_lines().apply((Object)heap_sizes.$colon$colon$colon(list7).$colon$colon$colon(list6).$colon$colon$colon(list5).$colon$colon((Object)string)), XZ$.MODULE$.options(6));
                if (multicore_base && first_build$1.elem && isabelle_output_log.is_dir()) {
                    Isabelle_System$.MODULE$.copy_dir(isabelle_output_log, isabelle_base_log);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Isabelle_System$.MODULE$.rm_tree(isabelle_output);
            first_build$1.elem = false;
            Tuple2 tuple22 = new Tuple2((Object)build_result, (Object)log_path.ext("xz"));
            return tuple22;
        }, List$.MODULE$.canBuildFrom());
    }

    public Progress build_history$default$2() {
        return No_Progress$.MODULE$;
    }

    public String build_history$default$3() {
        return this.default_rev();
    }

    public String build_history$default$4() {
        return this.default_isabelle_identifier();
    }

    public String build_history$default$5() {
        return "";
    }

    public boolean build_history$default$6() {
        return false;
    }

    public boolean build_history$default$7() {
        return false;
    }

    public boolean build_history$default$8() {
        return false;
    }

    public List<Tuple2<Object, Object>> build_history$default$9() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.default_multicore()}));
    }

    public boolean build_history$default$10() {
        return false;
    }

    public int build_history$default$11() {
        return this.default_heap();
    }

    public Option<Object> build_history$default$12() {
        return None$.MODULE$;
    }

    public List<String> build_history$default$13() {
        return Nil$.MODULE$;
    }

    public List<String> build_history$default$14() {
        return Nil$.MODULE$;
    }

    public boolean build_history$default$15() {
        return false;
    }

    public List<String> build_history$default$16() {
        return Nil$.MODULE$;
    }

    public List<String> build_history$default$17() {
        return Nil$.MODULE$;
    }

    public void main(String[] args) {
        throw Command_Line$.MODULE$.tool0((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BooleanRef multicore_base = BooleanRef.create((boolean)false);
            ObjectRef components_base = ObjectRef.create((Object)"");
            ObjectRef heap = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef max_heap = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef multicore_list = ObjectRef.create((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{MODULE$.default_multicore()})));
            ObjectRef isabelle_identifier = ObjectRef.create((Object)MODULE$.default_isabelle_identifier());
            ObjectRef more_settings = ObjectRef.create((Object)Nil$.MODULE$);
            BooleanRef fresh = BooleanRef.create((boolean)false);
            ObjectRef init_settings = ObjectRef.create((Object)Nil$.MODULE$);
            BooleanRef arch_64 = BooleanRef.create((boolean)false);
            BooleanRef nonfree = BooleanRef.create((boolean)false);
            ObjectRef output_file = ObjectRef.create((Object)"");
            ObjectRef rev = ObjectRef.create((Object)MODULE$.default_rev());
            ObjectRef build_tags = ObjectRef.create((Object)List$.MODULE$.empty());
            BooleanRef verbose = BooleanRef.create((boolean)false);
            BooleanRef exit_code = BooleanRef.create((boolean)false);
            Getopts getopts = Getopts$.MODULE$.apply("\nUsage: isabelle build_history [OPTIONS] REPOSITORY [ARGS ...]\n\n  Options are:\n    -B           first multicore build serves as base for scheduling information\n    -C DIR       base directory for Isabelle components (default: $ISABELLE_HOME_USER/../contrib)\n    -H SIZE      minimal ML heap in MB (default: " + MODULE$.default_heap() + " for x86, " + MODULE$.default_heap() * 2 + " for x86_64)\n    -M MULTICORE multicore configurations (see below)\n    -N NAME      alternative ISABELLE_IDENTIFIER (default: " + MODULE$.default_isabelle_identifier() + ")\n    -U SIZE      maximal ML heap in MB (default: unbounded)\n    -e TEXT      additional text for generated etc/settings\n    -f           fresh build of Isabelle/Scala components (recommended)\n    -i TEXT      initial text for generated etc/settings\n    -m ARCH      processor architecture (32=x86, 64=x86_64, default: x86)\n    -n           include nonfree components\n    -o FILE      output file for log names (default: stdout)\n    -r REV       update to revision (default: " + MODULE$.default_rev() + ")\n    -t TAG       free-form build tag (multiple occurrences possible)\n    -v           verbose\n    -x           return overall exit code from build processes\n\n  Build Isabelle sessions from the history of another REPOSITORY clone,\n  passing ARGS directly to its isabelle build tool.\n\n  Each MULTICORE configuration consists of one or two numbers (default 1):\n  THREADS or THREADSxPROCESSES, e.g. -M 1,2,4 or -M 1x4,2x2,4.\n", (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"B"), (Function1 & Serializable & scala.Serializable)x$21 -> {
                multicore_base.elem = true;
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C:"), (Function1 & Serializable & scala.Serializable)arg -> {
                components_base.elem = arg;
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"H:"), (Function1 & Serializable & scala.Serializable)arg -> {
                heap.elem = new Some((Object)BoxesRunTime.boxToInteger((int)Value$Int$.MODULE$.parse(arg)));
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"M:"), (Function1 & Serializable & scala.Serializable)arg -> {
                multicore_list.elem = (List)((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)','), (Object)arg)).map((Function1 & Serializable & scala.Serializable)x$22 -> Build_History$Multicore$.MODULE$.parse((String)x$22), List$.MODULE$.canBuildFrom());
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"N:"), (Function1 & Serializable & scala.Serializable)arg -> {
                isabelle_identifier.elem = arg;
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"U:"), (Function1 & Serializable & scala.Serializable)arg -> {
                max_heap.elem = new Some((Object)BoxesRunTime.boxToInteger((int)Value$Int$.MODULE$.parse(arg)));
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e:"), (Function1 & Serializable & scala.Serializable)arg -> {
                Build_History$.$anonfun$main$9(more_settings, arg);
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f"), (Function1 & Serializable & scala.Serializable)x$24 -> {
                fresh.elem = true;
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"i:"), (Function1 & Serializable & scala.Serializable)arg -> {
                Build_History$.$anonfun$main$11(init_settings, arg);
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"m:"), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                Build_History$.$anonfun$main$12(arch_64, x0$1);
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Function1 & Serializable & scala.Serializable)x$26 -> {
                nonfree.elem = true;
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"o:"), (Function1 & Serializable & scala.Serializable)arg -> {
                output_file.elem = arg;
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r:"), (Function1 & Serializable & scala.Serializable)arg -> {
                rev.elem = arg;
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t:"), (Function1 & Serializable & scala.Serializable)arg -> {
                Build_History$.$anonfun$main$16(build_tags, arg);
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Function1 & Serializable & scala.Serializable)x$28 -> {
                verbose.elem = true;
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Function1 & Serializable & scala.Serializable)x$29 -> {
                exit_code.elem = true;
                return BoxedUnit.UNIT;
            })}));
            List<String> more_args = getopts.apply(args);
            List<String> list = more_args;
            if (!(list instanceof .colon.colon)) {
                throw getopts.usage();
            }
            .colon.colon colon2 = (.colon.colon)list;
            String root = (String)colon2.head();
            List build_args = colon2.tl$access$1();
            Tuple2 tuple2 = new Tuple2((Object)root, (Object)build_args);
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String root2 = (String)tuple22._1();
            List build_args2 = (List)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)root2, (Object)build_args2);
            Tuple2 tuple24 = tuple23;
            String root3 = (String)tuple24._1();
            List build_args3 = (List)tuple24._2();
            Mercurial.Repository hg = Mercurial$.MODULE$.repository(Path$.MODULE$.explode(root3), Mercurial$.MODULE$.repository$default$2());
            boolean x$42 = true;
            boolean x$43 = Console_Progress$.MODULE$.$lessinit$greater$default$1();
            Console_Progress progress = new Console_Progress(x$43, x$42);
            List<Tuple2<Process_Result, Path>> results = MODULE$.build_history(hg, progress, (String)rev.elem, (String)isabelle_identifier.elem, (String)components_base.elem, fresh.elem, nonfree.elem, multicore_base.elem, (List<Tuple2<Object, Object>>)((List)multicore_list.elem), arch_64.elem, BoxesRunTime.unboxToInt((Object)((Option)heap.elem).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> arch_64$2.elem ? MODULE$.default_heap() * 2 : MODULE$.default_heap())), (Option<Object>)((Option)max_heap.elem), (List<String>)((List)init_settings.elem), (List<String>)((List)more_settings.elem), verbose.elem, (List<String>)((List)build_tags.elem), (List<String>)build_args3);
            String string = (String)output_file.elem;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                results.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)Build_History$.$anonfun$main$20(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
                    Build_History$.$anonfun$main$21(x$31);
                    return BoxedUnit.UNIT;
                });
            } else {
                File$.MODULE$.write(Path$.MODULE$.explode((String)output_file.elem), (CharSequence)package$.MODULE$.cat_lines().apply(results.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)Build_History$.$anonfun$main$22(check$ifrefutable$5))).map((Function1 & Serializable & scala.Serializable)x$32 -> {
                    Tuple2 tuple2 = x$32;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Path log_path = (Path)tuple2._2();
                    String string = log_path.implode();
                    return string;
                }, List$.MODULE$.canBuildFrom())));
            }
            int n = 0;
            int rc = BoxesRunTime.unboxToInt((Object)results.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToInteger((int)Build_History$.$anonfun$main$24(BoxesRunTime.unboxToInt((Object)x0$2), x1$1))));
            if (rc != 0 && exit_code.elem) {
                throw scala.sys.package$.MODULE$.exit(rc);
            }
        });
    }

    public List<Tuple2<String, Bytes>> remote_build_history(SSH.Session ssh, Path isabelle_repos_self, Path isabelle_repos_other, String isabelle_repos_source, String isabelle_identifier, boolean self_update, boolean push_isabelle_home, Progress progress, String rev, String options, String args) {
        Object object;
        Path isabelle_admin = isabelle_repos_self.$plus(Path$.MODULE$.explode("Admin"));
        Mercurial.Repository isabelle_hg = Mercurial$.MODULE$.setup_repository(isabelle_repos_source, isabelle_repos_self, ssh);
        if (self_update) {
            String string;
            if (push_isabelle_home) {
                Mercurial.Repository isabelle_home_hg = Mercurial$.MODULE$.repository(Path$.MODULE$.explode("~~"), Mercurial$.MODULE$.repository$default$2());
                String self_rev = isabelle_home_hg.id(isabelle_home_hg.id$default$1());
                isabelle_home_hg.push(isabelle_hg.root_url(), self_rev, true, isabelle_home_hg.push$default$4());
                string = self_rev;
            } else {
                isabelle_hg.pull(isabelle_hg.pull$default$1(), isabelle_hg.pull$default$2(), isabelle_hg.pull$default$3());
                string = isabelle_hg.id(isabelle_hg.id$default$1());
            }
            String self_rev = string;
            isabelle_hg.update(self_rev, true, isabelle_hg.update$default$3(), isabelle_hg.update$default$4());
            ssh.execute(ssh.bash_path(isabelle_repos_self.$plus(Path$.MODULE$.explode("bin/isabelle"))) + " components -a", ssh.execute$default$2(), ssh.execute$default$3(), ssh.execute$default$4()).check();
            object = ssh.execute(ssh.bash_path(isabelle_admin.$plus(Path$.MODULE$.explode("build"))) + " jars_fresh", ssh.execute$default$2(), ssh.execute$default$3(), ssh.execute$default$4()).check();
        } else {
            object = BoxedUnit.UNIT;
        }
        if (Mercurial$.MODULE$.is_repository(isabelle_repos_other, ssh)) {
            ssh.rm_tree(isabelle_repos_other);
        }
        String x$44 = ssh.bash_path(isabelle_repos_self);
        Path x$45 = isabelle_repos_other;
        String x$46 = rev;
        SSH.Session x$47 = ssh;
        String x$48 = Mercurial$.MODULE$.clone_repository$default$4();
        Mercurial.Repository other_hg = Mercurial$.MODULE$.clone_repository(x$44, x$45, x$46, x$48, x$47);
        return (List)ssh.with_tmp_dir((Function1 & Serializable & scala.Serializable)tmp_dir -> {
            Path output_file = tmp_dir.$plus(Path$.MODULE$.explode("output"));
            String string = rev;
            String string2 = "";
            ssh.execute(Isabelle_System$.MODULE$.export_isabelle_identifier(isabelle_identifier) + ssh.bash_path(isabelle_admin.$plus(Path$.MODULE$.explode("build_history"))) + " -o " + ssh.bash_path(output_file) + (!(string != null ? !string.equals(string2) : string2 != null) ? "" : " -r " + Bash$.MODULE$.string(rev)) + " " + options + " " + ssh.bash_path(isabelle_repos_other) + " " + args, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$34 -> {
                progress.echo(x$34);
                return BoxedUnit.UNIT;
            }, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$35 -> {
                progress.echo(x$35);
                return BoxedUnit.UNIT;
            }, false).check();
            return (List)((List)package$.MODULE$.split_lines().apply((Object)ssh.read(output_file))).map((Function1 & Serializable & scala.Serializable)line -> {
                Path log = Path$.MODULE$.explode((String)line);
                Bytes bytes = ssh.read_bytes(log);
                ssh.rm(log);
                return new Tuple2((Object)log.base_name(), (Object)bytes);
            }, List$.MODULE$.canBuildFrom());
        });
    }

    public String remote_build_history$default$4() {
        return "http://isabelle.in.tum.de/repos/isabelle";
    }

    public String remote_build_history$default$5() {
        return "remote_build_history";
    }

    public boolean remote_build_history$default$6() {
        return false;
    }

    public boolean remote_build_history$default$7() {
        return false;
    }

    public Progress remote_build_history$default$8() {
        return No_Progress$.MODULE$;
    }

    public String remote_build_history$default$9() {
        return "";
    }

    public String remote_build_history$default$10() {
        return "";
    }

    public String remote_build_history$default$11() {
        return "";
    }

    private static final Path liftedTree1$1(Other_Isabelle other_isabelle$1) {
        Path path;
        try {
            path = Path$.MODULE$.explode(other_isabelle$1.apply("getenv -b ML_HOME", other_isabelle$1.apply$default$2(), other_isabelle$1.apply$default$3(), other_isabelle$1.apply$default$4()).check().out()).dir();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<String> option = package$.MODULE$.ERROR().unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            String msg = (String)option.get();
            Path path2 = (Path)package$.MODULE$.error().apply((Object)("Bad ML_HOME: " + msg));
            path = path2;
        }
        return path;
    }

    private static final Path ml_home$1(String platform, Path polyml_home$1) {
        return polyml_home$1.$plus(Path$.MODULE$.explode(platform));
    }

    private static final Nothing$ err$1(String platform) {
        return (Nothing$)package$.MODULE$.error().apply((Object)("Platform " + platform + " unavailable on this machine"));
    }

    private static final boolean check_dir$1(String platform, Path polyml_home$1) {
        String string = platform;
        String string2 = "";
        return (string == null ? string2 != null : !string.equals(string2)) && Build_History$.ml_home$1(platform, polyml_home$1).is_dir();
    }

    public static final /* synthetic */ boolean $anonfun$build_history$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$build_history$2(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int threads = tuple2._1$mcI$sp();
        boolean bl = threads < 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$build_history$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$build_history$5(Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int processes = tuple2._2$mcI$sp();
        boolean bl = processes < 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$build_history$7(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$main$9(ObjectRef more_settings$2, String arg) {
        List list = (List)more_settings$2.elem;
        more_settings$2.elem = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{arg})).$colon$colon$colon(list);
    }

    public static final /* synthetic */ void $anonfun$main$11(ObjectRef init_settings$2, String arg) {
        List list = (List)init_settings$2.elem;
        init_settings$2.elem = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{arg})).$colon$colon$colon(list);
    }

    public static final /* synthetic */ void $anonfun$main$12(BooleanRef arch_64$2, String x0$1) {
        String string = x0$1;
        boolean bl = "32".equals(string) ? true : "x86".equals(string);
        if (bl) {
            arch_64$2.elem = false;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl2 = "64".equals(string) ? true : "x86_64".equals(string);
            if (bl2) {
                arch_64$2.elem = true;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.error().apply((Object)("Bad processor architecture: " + package$.MODULE$.quote().apply((Object)string)));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$main$16(ObjectRef build_tags$2, String arg) {
        List list = (List)build_tags$2.elem;
        build_tags$2.elem = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{arg})).$colon$colon$colon(list);
    }

    public static final /* synthetic */ boolean $anonfun$main$20(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$main$21(Tuple2 x$31) {
        Tuple2 tuple2 = x$31;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path log_path = (Path)tuple2._2();
        Output$.MODULE$.writeln(log_path.implode(), true);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$main$22(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ int $anonfun$main$24(int x0$2, Tuple2 x1$1) {
        Tuple2 tuple2;
        int rc;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)x1$1);
                if (tuple22 == null) break block2;
                rc = tuple22._1$mcI$sp();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        Process_Result res = (Process_Result)tuple2._1();
        int n = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(rc), res.rc());
        return n;
    }

    private Build_History$() {
        MODULE$ = this;
        this.engine = "build_history";
        this.log_prefix = this.engine() + "_";
        this.META_INFO_MARKER = "\fmeta_info = ";
        this.default_rev = "tip";
        this.default_multicore = new Tuple2.mcII.sp(1, 1);
        this.default_heap = 1500;
        this.default_isabelle_identifier = "build_history";
    }
}

