/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.IntegerInputVerifier;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.SyntaxUtilities;

public class GutterOptionPane
extends AbstractOptionPane {
    private static final String GUTTER_ENABLED_PROPERTY = "view.gutter.enabled";
    private static final String SELECTION_AREA_ENABLED_PROPERTY = "view.gutter.selectionAreaEnabled";
    private static final String SELECTION_AREA_BGCOLOR_PROPERTY = "view.gutter.selectionAreaBgColor";
    private static final int DEFAULT_SELECTION_GUTTER_WIDTH = 12;
    private FontSelector gutterFont;
    private ColorWellButton gutterForeground;
    private ColorWellButton gutterBackground;
    private JTextField gutterHighlightInterval;
    private ColorWellButton gutterHighlightColor;
    private JCheckBox lineNumbersEnabled;
    private JCheckBox gutterCurrentLineHighlightEnabled;
    private ColorWellButton gutterCurrentLineHighlight;
    private JCheckBox gutterStructureHighlightEnabled;
    private ColorWellButton gutterStructureHighlight;
    private JCheckBox gutterMarkerHighlightEnabled;
    private ColorWellButton gutterMarkerHighlight;
    private ColorWellButton gutterFoldMarkers;
    private JComboBox<String> foldPainter;
    private ColorWellButton gutterFocusBorder;
    private ColorWellButton gutterNoFocusBorder;
    private String[] painters;
    private JCheckBox gutterEnabled;
    private JPanel gutterComponents;
    private JTextField minLineNumberDigits;
    private JCheckBox selectionAreaEnabled;
    private ColorWellButton selectionAreaBgColor;
    private JTextField selectionAreaWidth;

    public GutterOptionPane() {
        super("gutter");
    }

    @Override
    public void _init() {
        this.gutterEnabled = new JCheckBox(jEdit.getProperty("options.gutter.enabled"));
        this.gutterEnabled.setSelected(GutterOptionPane.isGutterEnabled());
        this.addComponent(this.gutterEnabled);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 2;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.ipadx = 0;
        cons.ipady = 0;
        cons.insets = new Insets(0, 0, 0, 0);
        this.gutterComponents = new JPanel(new GridBagLayout());
        this.gutterComponents.setBorder(BorderFactory.createTitledBorder(jEdit.getProperty("options.gutter.optionalComponents")));
        IntegerInputVerifier integerInputVerifier = new IntegerInputVerifier();
        this.lineNumbersEnabled = new JCheckBox(jEdit.getProperty("options.gutter.lineNumbers"));
        this.lineNumbersEnabled.setSelected(jEdit.getBooleanProperty("view.gutter.lineNumbers"));
        this.gutterComponents.add((Component)this.lineNumbersEnabled, cons);
        this.minLineNumberDigits = new JTextField(String.valueOf(GutterOptionPane.getMinLineNumberDigits()), 1);
        this.minLineNumberDigits.setInputVerifier(integerInputVerifier);
        JPanel minLineNumberDigitsPanel = new JPanel();
        minLineNumberDigitsPanel.add(new JLabel(jEdit.getProperty("options.gutter.minLineNumberDigits")));
        minLineNumberDigitsPanel.add(this.minLineNumberDigits);
        cons.gridy = 1;
        this.gutterComponents.add((Component)minLineNumberDigitsPanel, cons);
        this.selectionAreaEnabled = new JCheckBox(jEdit.getProperty("options.gutter.selectionAreaEnabled"));
        this.selectionAreaEnabled.setSelected(GutterOptionPane.isSelectionAreaEnabled());
        cons.gridy = 2;
        this.gutterComponents.add((Component)this.selectionAreaEnabled, cons);
        this.addComponent(this.gutterComponents);
        this.setGutterComponentsEnabledState();
        this.gutterEnabled.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GutterOptionPane.this.setGutterComponentsEnabledState();
            }
        });
        this.selectionAreaBgColor = new ColorWellButton(GutterOptionPane.getSelectionAreaBackground());
        this.addComponent(jEdit.getProperty("options.gutter.selectionAreaBgColor"), (Component)this.selectionAreaBgColor, 3);
        this.selectionAreaWidth = new JTextField(String.valueOf(GutterOptionPane.getSelectionAreaWidth()), 12);
        this.selectionAreaWidth.setInputVerifier(integerInputVerifier);
        this.addComponent(jEdit.getProperty("options.gutter.selectionAreaWidth"), (Component)this.selectionAreaWidth);
        this.gutterFont = new FontSelector(jEdit.getFontProperty("view.gutter.font", new Font("Monospaced", 0, 10)));
        this.addComponent(jEdit.getProperty("options.gutter.font"), (Component)this.gutterFont);
        this.gutterForeground = new ColorWellButton(jEdit.getColorProperty("view.gutter.fgColor"));
        this.addComponent(jEdit.getProperty("options.gutter.foreground"), (Component)this.gutterForeground, 3);
        this.gutterBackground = new ColorWellButton(jEdit.getColorProperty("view.gutter.bgColor"));
        this.addComponent(jEdit.getProperty("options.gutter.background"), (Component)this.gutterBackground, 3);
        this.gutterCurrentLineHighlightEnabled = new JCheckBox(jEdit.getProperty("options.gutter.currentLineHighlight"));
        this.gutterCurrentLineHighlightEnabled.setSelected(jEdit.getBooleanProperty("view.gutter.highlightCurrentLine"));
        this.gutterCurrentLineHighlight = new ColorWellButton(jEdit.getColorProperty("view.gutter.currentLineColor"));
        this.addComponent(this.gutterCurrentLineHighlightEnabled, (Component)this.gutterCurrentLineHighlight, 3);
        this.gutterHighlightInterval = new JTextField(jEdit.getProperty("view.gutter.highlightInterval"), 3);
        Box gutterHighlightBox = new Box(0);
        gutterHighlightBox.add(new JLabel(jEdit.getProperty("options.gutter.interval-1")));
        gutterHighlightBox.add(Box.createHorizontalStrut(3));
        gutterHighlightBox.add(this.gutterHighlightInterval);
        gutterHighlightBox.add(Box.createHorizontalStrut(3));
        gutterHighlightBox.add(new JLabel(jEdit.getProperty("options.gutter.interval-2")));
        gutterHighlightBox.add(Box.createHorizontalStrut(12));
        this.gutterHighlightColor = new ColorWellButton(jEdit.getColorProperty("view.gutter.highlightColor"));
        this.addComponent(gutterHighlightBox, (Component)this.gutterHighlightColor, 3);
        this.gutterStructureHighlightEnabled = new JCheckBox(jEdit.getProperty("options.gutter.structureHighlight"));
        this.gutterStructureHighlightEnabled.setSelected(jEdit.getBooleanProperty("view.gutter.structureHighlight"));
        this.gutterStructureHighlight = new ColorWellButton(jEdit.getColorProperty("view.gutter.structureHighlightColor"));
        this.addComponent(this.gutterStructureHighlightEnabled, (Component)this.gutterStructureHighlight, 3);
        this.gutterMarkerHighlightEnabled = new JCheckBox(jEdit.getProperty("options.gutter.markerHighlight"));
        this.gutterMarkerHighlightEnabled.setSelected(jEdit.getBooleanProperty("view.gutter.markerHighlight"));
        this.gutterMarkerHighlight = new ColorWellButton(jEdit.getColorProperty("view.gutter.markerColor"));
        this.addComponent(this.gutterMarkerHighlightEnabled, (Component)this.gutterMarkerHighlight, 3);
        this.gutterFoldMarkers = new ColorWellButton(jEdit.getColorProperty("view.gutter.foldColor"));
        this.addComponent(jEdit.getProperty("options.gutter.foldColor"), (Component)this.gutterFoldMarkers, 3);
        this.gutterFocusBorder = new ColorWellButton(jEdit.getColorProperty("view.gutter.focusBorderColor"));
        this.addComponent(jEdit.getProperty("options.gutter.focusBorderColor"), (Component)this.gutterFocusBorder, 3);
        this.gutterNoFocusBorder = new ColorWellButton(jEdit.getColorProperty("view.gutter.noFocusBorderColor"));
        this.addComponent(jEdit.getProperty("options.gutter.noFocusBorderColor"), (Component)this.gutterNoFocusBorder, 3);
        this.addFoldStyleChooser();
    }

    @Override
    public void _save() {
        jEdit.setBooleanProperty("view.gutter.lineNumbers", this.lineNumbersEnabled.isSelected());
        jEdit.setIntegerProperty("view.gutter.minDigitCount", Integer.valueOf(this.minLineNumberDigits.getText()));
        jEdit.setFontProperty("view.gutter.font", this.gutterFont.getFont());
        jEdit.setColorProperty("view.gutter.fgColor", this.gutterForeground.getSelectedColor());
        jEdit.setColorProperty("view.gutter.bgColor", this.gutterBackground.getSelectedColor());
        jEdit.setBooleanProperty("view.gutter.highlightCurrentLine", this.gutterCurrentLineHighlightEnabled.isSelected());
        jEdit.setColorProperty("view.gutter.currentLineColor", this.gutterCurrentLineHighlight.getSelectedColor());
        jEdit.setProperty("view.gutter.highlightInterval", this.gutterHighlightInterval.getText());
        jEdit.setColorProperty("view.gutter.highlightColor", this.gutterHighlightColor.getSelectedColor());
        jEdit.setBooleanProperty("view.gutter.structureHighlight", this.gutterStructureHighlightEnabled.isSelected());
        jEdit.setColorProperty("view.gutter.structureHighlightColor", this.gutterStructureHighlight.getSelectedColor());
        jEdit.setBooleanProperty("view.gutter.markerHighlight", this.gutterMarkerHighlightEnabled.isSelected());
        jEdit.setColorProperty("view.gutter.markerColor", this.gutterMarkerHighlight.getSelectedColor());
        jEdit.setColorProperty("view.gutter.foldColor", this.gutterFoldMarkers.getSelectedColor());
        jEdit.setProperty("foldPainter", this.painters[this.foldPainter.getSelectedIndex()]);
        jEdit.setColorProperty("view.gutter.focusBorderColor", this.gutterFocusBorder.getSelectedColor());
        jEdit.setColorProperty("view.gutter.noFocusBorderColor", this.gutterNoFocusBorder.getSelectedColor());
        jEdit.setBooleanProperty(GUTTER_ENABLED_PROPERTY, this.gutterEnabled.isSelected());
        jEdit.setBooleanProperty(SELECTION_AREA_ENABLED_PROPERTY, this.selectionAreaEnabled.isSelected());
        jEdit.setColorProperty(SELECTION_AREA_BGCOLOR_PROPERTY, this.selectionAreaBgColor.getSelectedColor());
        jEdit.setIntegerProperty("view.gutter.selectionAreaWidth", Integer.valueOf(this.selectionAreaWidth.getText()));
    }

    private void setGutterComponentsEnabledState() {
        GenericGUIUtilities.setEnabledRecursively(this.gutterComponents, this.gutterEnabled.isSelected());
    }

    private void addFoldStyleChooser() {
        this.painters = ServiceManager.getServiceNames("org.gjt.sp.jedit.textarea.FoldPainter");
        this.foldPainter = new JComboBox();
        String current = JEditTextArea.getFoldPainterName();
        int selected = 0;
        for (int i = 0; i < this.painters.length; ++i) {
            String painter = this.painters[i];
            this.foldPainter.addItem(jEdit.getProperty("options.gutter.foldStyleNames." + painter, painter));
            if (!painter.equals(current)) continue;
            selected = i;
        }
        this.foldPainter.setSelectedIndex(selected);
        this.addComponent((Component)new JLabel(jEdit.getProperty("options.gutter.foldStyle.label")), this.foldPainter);
    }

    public static boolean isGutterEnabled() {
        return jEdit.getBooleanProperty(GUTTER_ENABLED_PROPERTY);
    }

    public static int getMinLineNumberDigits() {
        int n = jEdit.getIntegerProperty("view.gutter.minDigitCount", 2);
        if (n < 0) {
            n = 2;
        }
        return n;
    }

    public static boolean isSelectionAreaEnabled() {
        return jEdit.getBooleanProperty(SELECTION_AREA_ENABLED_PROPERTY);
    }

    public static Color getSelectionAreaBackground() {
        String color = jEdit.getProperty(SELECTION_AREA_BGCOLOR_PROPERTY);
        if (color == null) {
            return jEdit.getColorProperty("view.gutter.bgColor");
        }
        return SyntaxUtilities.parseColor(color, Color.black);
    }

    public static int getSelectionAreaWidth() {
        int n = jEdit.getIntegerProperty("view.gutter.selectionAreaWidth", 12);
        if (n < 0) {
            n = 12;
        }
        return n;
    }
}

