/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class DropShadowBorder
extends AbstractBorder {
    private int _width = 3;
    private Color _color = Color.BLACK;

    public DropShadowBorder() {
        this(3);
    }

    public DropShadowBorder(int width) {
        this(width, Color.BLACK);
    }

    public DropShadowBorder(int width, Color color) {
        this._width = width;
        this._color = color;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, this._width + 1, this._width + 1);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 1;
        insets.left = 1;
        insets.bottom = this._width + 1;
        insets.right = this._width + 1;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int y2;
        int x2;
        int y1;
        int x1;
        int i;
        Color old_color = g.getColor();
        g.setColor(this._color);
        g.drawRect(x, y, width - this._width - 1, height - this._width - 1);
        for (i = 0; i <= this._width; ++i) {
            x1 = x + this._width;
            y1 = y + height - i;
            x2 = x + width;
            y2 = y1;
            g.drawLine(x1, y1, x2, y2);
            x1 = x + width - this._width + i;
            y1 = y + this._width;
            x2 = x1;
            y2 = y + height;
            g.drawLine(x1, y1, x2, y2);
        }
        if (c.getParent() != null) {
            g.setColor(c.getParent().getBackground());
            for (i = 0; i <= this._width; ++i) {
                x1 = x;
                y1 = y + height - i;
                x2 = x + this._width;
                y2 = y1;
                g.drawLine(x1, y1, x2, y2);
                x1 = x + width - this._width;
                y1 = y + i;
                x2 = x + width;
                y2 = y1;
                g.drawLine(x1, y1, x2, y2);
            }
            g.setColor(g.getColor().darker());
            for (i = 0; i < this._width; ++i) {
                x1 = x + i + 1;
                y1 = y + height - this._width + i;
                x2 = x + this._width;
                y2 = y1;
                g.drawLine(x1, y1, x2, y2);
                x1 = x + width - this._width;
                y1 = y + i + 1;
                x2 = x1 + i;
                y2 = y1;
                g.drawLine(x1, y1, x2, y2);
            }
        }
        g.setColor(old_color);
    }
}

