/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.AbbrevEditor;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;

public class AddAbbrevDialog
extends JDialog {
    private View view;
    private AbbrevEditor editor;
    private JButton global;
    private JButton modeSpecific;
    private JButton cancel;

    public AddAbbrevDialog(View view, String abbrev) {
        super(view, jEdit.getProperty("add-abbrev.title"), false);
        this.view = view;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        this.editor = new AbbrevEditor();
        this.editor.setAbbrev(abbrev);
        this.editor.setBorder(new EmptyBorder(6, 0, 12, 0));
        content.add("Center", this.editor);
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.global = new JButton(jEdit.getProperty("add-abbrev.global"));
        this.global.addActionListener(new ActionHandler());
        box.add(this.global);
        box.add(Box.createHorizontalStrut(6));
        this.modeSpecific = new JButton(jEdit.getProperty("add-abbrev.mode"));
        this.modeSpecific.addActionListener(new ActionHandler());
        box.add(this.modeSpecific);
        box.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        box.add(this.cancel);
        box.add(Box.createGlue());
        content.add("South", box);
        KeyHandler listener = new KeyHandler();
        this.addKeyListener(listener);
        this.editor.getBeforeCaretTextArea().addKeyListener(listener);
        this.editor.getAfterCaretTextArea().addKeyListener(listener);
        this.setDefaultCloseOperation(2);
        if (abbrev == null) {
            GenericGUIUtilities.requestFocus(this, this.editor.getAbbrevField());
        } else {
            GenericGUIUtilities.requestFocus(this, this.editor.getBeforeCaretTextArea());
        }
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 27) {
                AddAbbrevDialog.this.dispose();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == AddAbbrevDialog.this.global) {
                String _abbrev = AddAbbrevDialog.this.editor.getAbbrev();
                if (_abbrev == null || _abbrev.length() == 0) {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                    return;
                }
                Abbrevs.addGlobalAbbrev(_abbrev, AddAbbrevDialog.this.editor.getExpansion());
                Abbrevs.expandAbbrev(AddAbbrevDialog.this.view, false);
            } else if (source == AddAbbrevDialog.this.modeSpecific) {
                String _abbrev = AddAbbrevDialog.this.editor.getAbbrev();
                if (_abbrev == null || _abbrev.length() == 0) {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                    return;
                }
                Abbrevs.addModeAbbrev(AddAbbrevDialog.this.view.getBuffer().getMode().getName(), _abbrev, AddAbbrevDialog.this.editor.getExpansion());
                Abbrevs.expandAbbrev(AddAbbrevDialog.this.view, false);
            }
            AddAbbrevDialog.this.dispose();
        }
    }
}

