/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import ise.plugin.nav.AutoJump;
import ise.plugin.nav.GoToLineDialog;
import ise.plugin.nav.NavHistoryPopup;
import ise.plugin.nav.NavPosition;
import ise.plugin.nav.NavToolBar;
import ise.plugin.nav.Navigator;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferAdapter;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferChanging;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;

public class NavigatorPlugin
extends EBPlugin {
    public static final String NAME = "Navigator";
    public static final int VIEW_SCOPE = 1;
    public static final int EDITPANE_SCOPE = 2;
    public static final String showOnToolBarKey = "navigator.showOnToolbar";
    private static final HashMap<View, Navigator> viewNavigatorMap = new HashMap();
    private static final HashMap<EditPane, Navigator> editPaneNavigatorMap = new HashMap();
    private boolean autoJump = false;
    private BufferListener bufferListener = null;

    public static boolean showOnToolBars() {
        return jEdit.getBooleanProperty((String)showOnToolBarKey, (boolean)false);
    }

    public static boolean groupByFile() {
        return jEdit.getBooleanProperty((String)"navigator.groupByFile", (boolean)false);
    }

    public static void toggleGroupByFile() {
        jEdit.setBooleanProperty((String)"navigator.groupByFile", (!NavigatorPlugin.groupByFile() ? 1 : 0) != 0);
    }

    public static boolean groupByLine() {
        return jEdit.getBooleanProperty((String)"navigator.groupByLine", (boolean)false);
    }

    public static void toggleGroupByLine() {
        jEdit.setBooleanProperty((String)"navigator.groupByLine", (!NavigatorPlugin.groupByLine() ? 1 : 0) != 0);
    }

    public static boolean combineLists() {
        return jEdit.getBooleanProperty((String)"navigator.combineLists", (boolean)false);
    }

    public static void showButtons() {
        jEdit.setBooleanProperty((String)showOnToolBarKey, (boolean)true);
        NavigatorPlugin.setToolBars();
    }

    public static void hideButtons(View view) {
        jEdit.setBooleanProperty((String)showOnToolBarKey, (boolean)false);
        NavigatorPlugin.clearToolBars();
    }

    public static void setToolBars() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (NavigatorPlugin.showOnToolBars()) {
                    View[] views;
                    NavigatorPlugin.clearToolBars(true);
                    for (View view : views = jEdit.getViews()) {
                        Navigator nav;
                        if (view.getToolBar() == null || (nav = NavigatorPlugin.getNavigator(view)) == null) continue;
                        NavToolBar toolBar = new NavToolBar(nav);
                        view.getToolBar().add(toolBar);
                    }
                }
            }
        });
    }

    public void start() {
        Buffer[] openBuffers;
        for (View v : jEdit.getViews()) {
            NavigatorPlugin.createNavigator(v);
            NavigatorPlugin.createNavigators(v);
        }
        NavigatorPlugin.clearToolBars();
        NavigatorPlugin.setToolBars();
        if (this.bufferListener == null) {
            this.bufferListener = new BufferEditListener();
        }
        for (Buffer buffer : openBuffers = jEdit.getBuffers()) {
            buffer.removeBufferListener(this.bufferListener);
            buffer.addBufferListener(this.bufferListener);
        }
    }

    public void stop() {
        viewNavigatorMap.clear();
        editPaneNavigatorMap.clear();
        NavigatorPlugin.clearToolBars(true);
    }

    public static int getScope() {
        return jEdit.getIntegerProperty((String)"navigator.scope", (int)1);
    }

    public static void setScope(int scope) {
        switch (scope) {
            case 1: 
            case 2: {
                jEdit.setIntegerProperty((String)"navigator.scope", (int)scope);
            }
        }
    }

    public static void toggleScope() {
        String msg = null;
        int scope = jEdit.getIntegerProperty((String)"navigator.scope", (int)1);
        switch (scope) {
            case 1: {
                scope = 2;
                msg = jEdit.getProperty((String)"navigator.message.editPaneScope", (String)"Navigator switched to EditPane scope.");
                break;
            }
            case 2: {
                scope = 1;
                msg = jEdit.getProperty((String)"navigator.message.viewScope", (String)"Navigator switched to View scope.");
                break;
            }
            default: {
                return;
            }
        }
        jEdit.setIntegerProperty((String)"navigator.scope", (int)scope);
        if (msg != null) {
            for (View view : viewNavigatorMap.keySet()) {
                view.getStatus().setMessage(msg);
            }
        }
    }

    public static void clearToolBars() {
        NavigatorPlugin.clearToolBars(false);
    }

    public static void clearToolBars(boolean force) {
        if (force || !NavigatorPlugin.showOnToolBars()) {
            for (View view : jEdit.getViews()) {
                Container viewToolBar = view.getToolBar();
                if (viewToolBar == null) continue;
                for (Component comp : viewToolBar.getComponents()) {
                    if (!(comp instanceof NavToolBar)) continue;
                    viewToolBar.remove(comp);
                }
                viewToolBar.repaint();
            }
        }
    }

    public static void addNavigator(View view, Navigator navigator) {
        if (view == null) {
            return;
        }
        if (viewNavigatorMap.containsKey(view)) {
            return;
        }
        viewNavigatorMap.put(view, navigator);
    }

    public static void addNavigator(EditPane editPane, Navigator navigator) {
        if (editPane == null) {
            return;
        }
        if (editPaneNavigatorMap.containsKey(editPane)) {
            return;
        }
        editPaneNavigatorMap.put(editPane, navigator);
    }

    public static Navigator getNavigator(View view) {
        Navigator navigator = null;
        if (NavigatorPlugin.getScope() == 2) {
            navigator = editPaneNavigatorMap.get(view.getEditPane());
            if (navigator == null) {
                navigator = NavigatorPlugin.createNavigator(view.getEditPane());
            }
        } else {
            navigator = viewNavigatorMap.get(view);
            if (navigator == null) {
                navigator = NavigatorPlugin.createNavigator(view);
            }
        }
        return navigator;
    }

    public static Navigator createNavigator(View view) {
        if (view == null) {
            return null;
        }
        Navigator navigator = viewNavigatorMap.get(view);
        if (navigator == null) {
            navigator = new Navigator(view);
            viewNavigatorMap.put(view, navigator);
        }
        return navigator;
    }

    public static void createNavigators(View view) {
        EditPane[] editPanes;
        if (view == null) {
            return;
        }
        for (EditPane editPane : editPanes = view.getEditPanes()) {
            NavigatorPlugin.createNavigator(editPane);
        }
    }

    public static Navigator createNavigator(EditPane editPane) {
        if (editPane == null) {
            return null;
        }
        Navigator navigator = editPaneNavigatorMap.get(editPane);
        if (navigator == null) {
            navigator = new Navigator(editPane);
            editPaneNavigatorMap.put(editPane, navigator);
        }
        return navigator;
    }

    public static NavHistoryPopup backList(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            return navigator.backList();
        }
        return null;
    }

    public static void goBack(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.goBack();
        }
    }

    public static void goBackFile(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.goBackFile();
        }
    }

    public static NavHistoryPopup forwardList(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            return navigator.forwardList();
        }
        return null;
    }

    public static void goForward(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.goForward();
        }
    }

    public static void goForwardFile(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.goForwardFile();
        }
    }

    public static void pushPosition(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.pushPosition();
        }
    }

    public static void popPosition(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.popPosition();
        }
    }

    public static void gotoTopPosition(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.gotoTopPosition();
        }
    }

    public static void swapCaretAndTop(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.swapCaretAndTop();
        }
    }

    public static void gotoLine(View view) {
        GoToLineDialog dialog = new GoToLineDialog(view);
        NavPosition position = dialog.getLineNumber();
        if (position == null) {
            return;
        }
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.jump(position);
        }
    }

    public static void combinedList(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.combinedList();
        }
    }

    public static void clearHistory(View view) {
        Navigator navigator = NavigatorPlugin.getNavigator(view);
        if (navigator != null) {
            navigator.clearHistory();
        }
        for (EditPane editPane : view.getEditPanes()) {
            navigator = editPaneNavigatorMap.get(editPane);
            if (navigator == null) continue;
            navigator.clearHistory();
        }
        view.getStatus().setMessage(jEdit.getProperty((String)"navigator.message.Navigator_history_cleared.", (String)"Navigator history cleared."));
    }

    public void handleMessage(EBMessage message) {
        EditPane p;
        Navigator n;
        if (message == null) {
            return;
        }
        if (message instanceof BufferUpdate) {
            BufferUpdate bu = (BufferUpdate)message;
            if (bu.getWhat().equals(BufferUpdate.LOADED) && !this.autoJump) {
                if (bu.getView() != null && bu.getView().getEditPane() != null && (n = NavigatorPlugin.getNavigator(bu.getView())) != null) {
                    n.addToHistory();
                }
            } else if (BufferUpdate.CLOSED.equals(bu.getWhat())) {
                if (bu.getView() != null && bu.getView().getEditPane() != null && bu.getBuffer() != null && bu.getBuffer().isUntitled() && (n = NavigatorPlugin.getNavigator(bu.getView())) != null) {
                    n.removeAll(bu.getBuffer().getPath());
                }
            } else if (BufferUpdate.CREATED.equals(bu.getWhat())) {
                bu.getBuffer().addBufferListener(this.bufferListener);
            }
        }
        if (message instanceof BufferChanging) {
            Navigator n2;
            BufferChanging bc = (BufferChanging)message;
            if (bc.getBuffer() != null && bc.getBuffer().isLoaded() && (p = bc.getEditPane()) != null && (n2 = NavigatorPlugin.getNavigator(p.getView())) != null) {
                n2.addToHistory();
            }
        } else if (message instanceof PositionChanging) {
            Navigator n3;
            PositionChanging cc;
            if (!this.autoJump && (p = (cc = (PositionChanging)message).getEditPane()) != null && (n3 = NavigatorPlugin.getNavigator(p.getView())) != null) {
                n3.addToHistory();
            }
        } else if (message instanceof EditPaneUpdate) {
            EditPane editPane;
            EditPaneUpdate epu = (EditPaneUpdate)message;
            if (epu.getWhat() == EditPaneUpdate.CREATED) {
                editPane = epu.getEditPane();
                Navigator n4 = viewNavigatorMap.get(editPane.getView());
                if (n4 == null) {
                    NavigatorPlugin.createNavigator(editPane.getView());
                }
                NavigatorPlugin.createNavigator(editPane);
            } else if (epu.getWhat().equals(EditPaneUpdate.DESTROYED) && jEdit.getIntegerProperty((String)"navigator.scope") == 2) {
                editPane = epu.getEditPane();
                editPaneNavigatorMap.remove(editPane);
            }
        } else if (message instanceof ViewUpdate) {
            ViewUpdate vu = (ViewUpdate)message;
            View v = vu.getView();
            Object what = vu.getWhat();
            if (what.equals(ViewUpdate.CREATED)) {
                Navigator n5 = NavigatorPlugin.createNavigator(v);
                if (n5 != null) {
                    n5.addToHistory();
                }
                NavigatorPlugin.setToolBars();
            } else if (what.equals(ViewUpdate.CLOSED)) {
                viewNavigatorMap.remove(v);
            } else if (what.equals(ViewUpdate.FULL_SCREEN_TOGGLED)) {
                if (NavigatorPlugin.showOnToolBars()) {
                    NavigatorPlugin.setToolBars();
                } else {
                    NavigatorPlugin.clearToolBars();
                }
            }
        } else if (message instanceof PropertiesChanged) {
            if (NavigatorPlugin.showOnToolBars()) {
                NavigatorPlugin.setToolBars();
            } else {
                NavigatorPlugin.clearToolBars();
            }
            for (Navigator nav : viewNavigatorMap.values()) {
                nav.setMaxHistorySize(jEdit.getIntegerProperty((String)"navigator.maxStackSize", (int)512));
            }
            NavigatorPlugin.setScope(jEdit.getIntegerProperty((String)"navigator.scope", (int)1));
        } else if (message instanceof AutoJump) {
            AutoJump aj = (AutoJump)message;
            n = NavigatorPlugin.getNavigator(aj.getView());
            if (n != null) {
                n.addToHistory();
            }
            this.autoJump = aj.getWhat().equals(AutoJump.STARTED);
        }
    }

    class BufferEditListener
    extends BufferAdapter {
        BufferEditListener() {
        }

        public void contentInserted(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
            if (buffer == null) {
                return;
            }
            for (Navigator nav : viewNavigatorMap.values()) {
                nav.contentInserted((Buffer)buffer, startLine, offset, numLines, length);
            }
            for (Navigator nav : editPaneNavigatorMap.values()) {
                nav.contentInserted((Buffer)buffer, startLine, offset, numLines, length);
            }
        }

        public void contentRemoved(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
            if (buffer == null) {
                return;
            }
            for (Navigator nav : viewNavigatorMap.values()) {
                nav.contentRemoved((Buffer)buffer, startLine, offset, numLines, length);
            }
            for (Navigator nav : editPaneNavigatorMap.values()) {
                nav.contentRemoved((Buffer)buffer, startLine, offset, numLines, length);
            }
        }
    }
}

