/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.StandardUtilities;

public class IOUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFile(File source, File dest) {
        boolean ok;
        block5: {
            ok = false;
            if ((!dest.exists() || !dest.canWrite()) && (dest.exists() || !dest.getParentFile().canWrite())) break block5;
            FileOutputStream fos = null;
            FileInputStream fis = null;
            try {
                fos = new FileOutputStream(dest);
                fis = new FileInputStream(source);
                ok = IOUtilities.copyStream(32768, null, fis, fos, false);
            }
            catch (IOException ioe) {
                try {
                    Log.log(7, IOUtilities.class, "Error moving file: " + ioe + " : " + ioe.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(fos);
                    IOUtilities.closeQuietly(fis);
                    throw throwable;
                }
                IOUtilities.closeQuietly(fos);
                IOUtilities.closeQuietly(fis);
            }
            IOUtilities.closeQuietly(fos);
            IOUtilities.closeQuietly(fis);
            if (ok) {
                source.delete();
            }
        }
        return ok;
    }

    public static boolean copyStream(int bufferSize, @Nullable ProgressObserver progress, InputStream in, OutputStream out, boolean canStop) throws IOException {
        int n;
        byte[] buffer = new byte[bufferSize];
        long copied = 0L;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
            copied += (long)n;
            if (progress != null) {
                progress.setStatus(StandardUtilities.formatFileSize(copied));
                progress.setValue(copied);
            }
            if (!canStop || !Thread.interrupted()) continue;
            return false;
        }
        return true;
    }

    public static boolean copyStream(@Nullable ProgressObserver progress, InputStream in, OutputStream out, boolean canStop) throws IOException {
        return IOUtilities.copyStream(4096, progress, in, out, canStop);
    }

    public static long fileLength(File file) {
        File[] files;
        long length = 0L;
        if (file.isFile()) {
            length = file.length();
        } else if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                length += IOUtilities.fileLength(f);
            }
        }
        return length;
    }

    public static void closeQuietly(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                if (closeable instanceof Flushable) {
                    ((Flushable)((Object)closeable)).flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void closeQuietly(@Nullable ObjectInput in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void closeQuietly(@Nullable ObjectOutput out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private IOUtilities() {
    }
}

