/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GlobalOptions;
import org.gjt.sp.jedit.options.PluginOptions;
import org.gjt.sp.jedit.pluginmgr.InstallPanel;
import org.gjt.sp.jedit.pluginmgr.ManagePanel;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

public class PluginManager
extends JFrame {
    private static PluginManager instance;
    private JTabbedPane tabPane;
    private JButton done;
    private JButton mgrOptions;
    private JButton pluginOptions;
    private InstallPanel installer;
    private InstallPanel updater;
    private ManagePanel manager;
    private PluginList pluginList;
    private boolean queuedUpdate;
    private boolean downloadingPluginList;
    private final Frame parent;
    public static final String PROPERTY_PLUGINSET = "plugin-manager.pluginset.path";

    public static PluginManager getInstance() {
        return instance;
    }

    @Override
    public void dispose() {
        instance = null;
        EditBus.removeFromBus(this);
        EditBus.removeFromBus(this.installer);
        super.dispose();
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged message) {
        if (this.pluginList != null && this.shouldUpdatePluginList()) {
            this.pluginList = null;
            this.updatePluginList();
        }
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate msg) {
        if (!this.queuedUpdate) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginManager.this.queuedUpdate = false;
                    PluginManager.this.manager.update();
                }
            });
            this.queuedUpdate = true;
        }
    }

    public static void showPluginManager(Frame parent) {
        if (instance == null) {
            instance = new PluginManager(parent);
        }
        instance.toFront();
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    PluginList getPluginList() {
        return this.pluginList;
    }

    void pluginRemoved() {
        this.updater.updateModel();
        this.installer.updateModel();
    }

    private PluginManager(Frame parent) {
        super(jEdit.getProperty("plugin-manager.title"));
        this.parent = parent;
        this.init();
    }

    private void init() {
        EditBus.addToBus(this);
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        this.tabPane = new JTabbedPane();
        this.manager = new ManagePanel(this);
        this.tabPane.addTab(jEdit.getProperty("manage-plugins.title"), this.manager);
        this.updater = new InstallPanel(this, true);
        this.tabPane.addTab(jEdit.getProperty("update-plugins.title"), this.updater);
        this.installer = new InstallPanel(this, false);
        this.tabPane.addTab(jEdit.getProperty("install-plugins.title"), this.installer);
        EditBus.addToBus(this.installer);
        content.add("Center", this.tabPane);
        this.tabPane.addChangeListener(new ListUpdater());
        Box buttons = new Box(0);
        ActionHandler al = new ActionHandler();
        this.mgrOptions = new JButton(jEdit.getProperty("plugin-manager.mgr-options"));
        this.mgrOptions.addActionListener(al);
        this.pluginOptions = new JButton(jEdit.getProperty("plugin-manager.plugin-options"));
        this.pluginOptions.addActionListener(al);
        this.done = new JButton(jEdit.getProperty("plugin-manager.done"));
        this.done.addActionListener(al);
        buttons.add(Box.createGlue());
        buttons.add(this.mgrOptions);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(this.pluginOptions);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(this.done);
        buttons.add(Box.createGlue());
        this.getRootPane().setDefaultButton(this.done);
        content.add("South", buttons);
        this.setDefaultCloseOperation(2);
        this.setIconImage(GUIUtilities.getPluginIcon());
        this.pack();
        GUIUtilities.loadGeometry(this, this.parent, "plugin-manager");
        GUIUtilities.addSizeSaver(this, this.parent, "plugin-manager");
        this.setVisible(true);
    }

    private boolean shouldUpdatePluginList() {
        return (this.pluginList == null || !this.pluginList.getMirrorId().equals(jEdit.getProperty("plugin-manager.mirror.id"))) && !this.downloadingPluginList;
    }

    private void updatePluginList() {
        if (jEdit.getSettingsDirectory() == null && jEdit.getJEditHome() == null) {
            GUIUtilities.error(this, "no-settings", null);
            return;
        }
        if (!this.shouldUpdatePluginList()) {
            return;
        }
        this.installer.loading();
        this.updater.loading();
        ThreadUtilities.runInBackground(new Task(){

            @Override
            public void _run() {
                try {
                    PluginManager.this.downloadingPluginList = true;
                    this.setStatus(jEdit.getProperty("plugin-manager.list-download-connect"));
                    PluginManager.this.pluginList = new PluginList(this);
                }
                finally {
                    PluginManager.this.downloadingPluginList = false;
                }
                ThreadUtilities.runInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        PluginManager.this.pluginListUpdated();
                    }
                });
            }
        });
    }

    public void checkForObsoletePlugins() {
        if (this.pluginList == null || this.pluginList.plugins == null) {
            return;
        }
        for (PluginJAR jar : jEdit.getPluginJARs()) {
            EditPlugin eplugin = jar.getPlugin();
            if (eplugin == null) continue;
            String installedVersion = jEdit.getProperty("plugin." + eplugin.getClassName() + ".version");
            for (PluginList.Plugin plugin : this.pluginList.plugins) {
                if (!MiscUtilities.pathsEqual(plugin.jar, MiscUtilities.getFileName(jar.getPath()))) continue;
                PluginList.Branch lastBranch = null;
                String latestVersion = "0";
                for (PluginList.Branch branch : plugin.branches) {
                    if (StandardUtilities.compareStrings(branch.version, installedVersion, false) < 0 || StandardUtilities.compareStrings(branch.version, latestVersion, false) < 0) continue;
                    latestVersion = branch.version;
                    lastBranch = branch;
                }
                if (lastBranch == null) continue;
                if (lastBranch.obsolete) {
                    this.disablePlugin(jar, plugin.name);
                    continue;
                }
                for (PluginList.Dependency dep : lastBranch.deps) {
                    if (!dep.what.equals("jedit") || dep.to == null || StandardUtilities.compareStrings(jEdit.getBuild(), dep.to, false) <= 0) continue;
                    this.disablePlugin(jar, plugin.name);
                }
            }
        }
    }

    private void disablePlugin(PluginJAR jar, String name) {
        Log.log(9, this, "Plugin: " + name + " is not supported on this version of jEdit! ");
        if (!jEdit.getBooleanProperty("plugin-manager.disable-obsolete", true)) {
            return;
        }
        jEdit.removePluginJAR(jar, false);
        String jarName = MiscUtilities.getFileName(jar.getPath());
        jEdit.setBooleanProperty("plugin-blacklist." + jarName, true);
        jEdit.setBooleanProperty("plugin." + jarName + ".disabled", true);
        jEdit.propertiesChanged();
    }

    private void pluginListUpdated() {
        Component selected = this.tabPane.getSelectedComponent();
        if (selected == this.installer || selected == this.updater) {
            this.installer.updateModel();
            this.updater.updateModel();
        }
        this.checkForObsoletePlugins();
    }

    public void processKeyEvents(KeyEvent ke) {
        if (ke.getID() == 401 && ke.getKeyCode() == 27) {
            this.cancel();
            ke.consume();
        }
    }

    class ListUpdater
    implements ChangeListener {
        ListUpdater() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component selected = PluginManager.this.tabPane.getSelectedComponent();
            if (selected == PluginManager.this.installer || selected == PluginManager.this.updater) {
                PluginManager.this.updatePluginList();
            } else if (selected == PluginManager.this.manager) {
                PluginManager.this.manager.update();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == PluginManager.this.done) {
                PluginManager.this.ok();
            } else if (source == PluginManager.this.mgrOptions) {
                new GlobalOptions((Frame)PluginManager.this, "plugin-manager");
            } else if (source == PluginManager.this.pluginOptions) {
                new PluginOptions(PluginManager.this);
            }
        }
    }
}

