/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.bufferio.BufferIORequest;
import org.gjt.sp.jedit.io.EncodingDetector;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class AutoDetection {
    public static BufferedInputStream getMarkedStream(InputStream in) {
        int bufferSize = BufferIORequest.getByteIOBufferSize();
        BufferedInputStream markable = new BufferedInputStream(in, bufferSize);
        assert (markable.markSupported());
        markable.mark(bufferSize);
        return markable;
    }

    public static boolean isGzipped(InputStream sample) throws IOException {
        int magic1 = 31;
        int magic2 = 139;
        return sample.read() == magic1 && sample.read() == magic2;
    }

    public static List<EncodingDetector> getEncodingDetectors() {
        ArrayList<EncodingDetector> detectors = new ArrayList<EncodingDetector>();
        String propName = "encodingDetectors";
        String selectedDetectors = jEdit.getProperty(propName);
        if (selectedDetectors != null && selectedDetectors.length() > 0) {
            for (String name : selectedDetectors.split("\\s+")) {
                EncodingDetector service = AutoDetection.getEncodingDetectorService(name);
                if (service != null) {
                    detectors.add(service);
                    continue;
                }
                Log.log(9, AutoDetection.class, "getEncodingDetectors(): No EncodingDetector for the name \"" + name + "\"");
            }
        }
        return detectors;
    }

    public static String getDetectedEncoding(BufferedInputStream markedStream) throws IOException {
        List<EncodingDetector> detectors = AutoDetection.getEncodingDetectors();
        for (EncodingDetector detector : detectors) {
            markedStream.reset();
            String detected = detector.detectEncoding(new BufferedInputStream(markedStream));
            if (detected == null) continue;
            return detected;
        }
        return null;
    }

    private static EncodingDetector getEncodingDetectorService(String name) {
        String serviceClass = "org.gjt.sp.jedit.io.EncodingDetector";
        Object service = ServiceManager.getService(serviceClass, name);
        if (service != null && service instanceof EncodingDetector) {
            return (EncodingDetector)service;
        }
        return null;
    }

    public static class Result {
        private final BufferedInputStream markedStream;
        private final boolean gzipped;
        private final String encoding;

        public Result(InputStream in) throws IOException {
            BufferedInputStream marked = AutoDetection.getMarkedStream(in);
            this.gzipped = AutoDetection.isGzipped(marked);
            if (this.gzipped) {
                marked.reset();
                marked = AutoDetection.getMarkedStream(new GZIPInputStream(marked));
            }
            marked.reset();
            this.encoding = AutoDetection.getDetectedEncoding(marked);
            this.markedStream = marked;
        }

        public BufferedInputStream getRewindedStream() throws IOException {
            this.markedStream.reset();
            return this.markedStream;
        }

        public boolean streamIsGzipped() {
            return this.gzipped;
        }

        public String getDetectedEncoding() {
            return this.encoding;
        }
    }
}

