/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class TaskMonitor
extends JPanel
implements TaskListener {
    private final TaskTableModel model;
    private final JTable table;
    private final JLabel remainingCount;

    public TaskMonitor() {
        super(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.remainingCount = new JLabel();
        panel.add((Component)this.remainingCount, "North");
        this.model = new TaskTableModel();
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1 || e.getType() == -1) {
                    TaskMonitor.this.updateTasksCount();
                }
            }
        });
        this.table = new JTable(this.model);
        this.table.setRowHeight(GUIUtilities.defaultRowHeight());
        this.table.setDefaultRenderer(Object.class, new TaskCellRenderer());
        this.table.getTableHeader().setVisible(false);
        this.table.setDefaultEditor(Object.class, new TaskTableEditor());
        this.table.getColumnModel().getColumn(1).setMaxWidth(16);
        this.table.getColumnModel().getColumn(1).setMinWidth(16);
        JScrollPane scroll = new JScrollPane(this.table);
        panel.add(scroll);
        this.updateTasksCount();
        this.add(panel);
    }

    @Override
    public void addNotify() {
        TaskManager.instance.visit(new TaskManager.TaskVisitor(){

            @Override
            public void visit(Task task) {
                TaskMonitor.this.model.addTask(task);
            }
        });
        TaskManager.instance.addTaskListener(this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        TaskManager.instance.removeTaskListener(this);
        super.removeNotify();
        this.model.removeAll();
    }

    @Override
    public void waiting(Task task) {
        this.model.addTask(task);
    }

    @Override
    public void running(Task task) {
        this.repaint();
    }

    @Override
    public void done(Task task) {
        this.model.removeTask(task);
    }

    @Override
    public void statusUpdated(Task task) {
        this.repaint();
    }

    @Override
    public void maximumUpdated(Task task) {
        this.repaint();
    }

    @Override
    public void valueUpdated(Task task) {
        this.repaint();
    }

    private void updateTasksCount() {
        this.remainingCount.setText(jEdit.getProperty("taskmanager.remainingtasks.label", new Object[]{this.model.getRowCount()}));
    }

    private static class TaskTableModel
    extends AbstractTableModel {
        private final List<Task> tasks = new ArrayList<Task>();

        private TaskTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.tasks.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.tasks.get(rowIndex);
        }

        void addTask(final Task task) {
            ThreadUtilities.runInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    TaskTableModel.this.tasks.add(task);
                    TaskTableModel.this.fireTableRowsInserted(TaskTableModel.this.tasks.size() - 1, TaskTableModel.this.tasks.size() - 1);
                }
            });
        }

        void removeTask(final Task task) {
            ThreadUtilities.runInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    int index = TaskTableModel.this.tasks.indexOf(task);
                    if (index != -1) {
                        TaskTableModel.this.tasks.remove(index);
                        TaskTableModel.this.fireTableRowsDeleted(index, index);
                    }
                }
            });
        }

        public void removeAll() {
            this.tasks.clear();
            this.fireTableDataChanged();
        }
    }

    private class TaskTableEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JButton button = new JButton(GUIUtilities.loadIcon(jEdit.getProperty("close-buffer.icon")));
        private Task task;

        private TaskTableEditor() {
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TaskTableEditor.this.task.cancel();
                    TaskTableEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.task = (Task)value;
            return this.button;
        }
    }

    private static class TaskCellRenderer
    implements TableCellRenderer {
        private final JProgressBar progress = new JProgressBar();
        private final JButton button = new JButton(GUIUtilities.loadIcon(jEdit.getProperty("close-buffer.icon")));

        private TaskCellRenderer() {
            this.progress.setStringPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Task task = (Task)value;
            if (column == 0) {
                if (task.getMaximum() == 0L) {
                    this.progress.setIndeterminate(true);
                } else {
                    this.progress.setIndeterminate(false);
                    long max = task.getMaximum();
                    long val = task.getValue();
                    if (max > Integer.MAX_VALUE) {
                        max >>= 10;
                        val >>= 10;
                    }
                    this.progress.setMaximum((int)max);
                    this.progress.setValue((int)val);
                }
                this.progress.setToolTipText(task.getLabel());
                this.progress.setString(task.getStatus());
                return this.progress;
            }
            this.button.setEnabled(task.isCancellable());
            return this.button;
        }
    }
}

