/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class AddModeDialog
extends EnhancedDialog {
    private JTextField modeName;
    private JTextField modeFile;
    private JButton browse;
    private JTextField filenameGlob;
    private JTextField firstLineGlob;
    private final JButton ok;
    private final JButton cancel;
    private boolean canceled = false;

    public AddModeDialog(View view) {
        super(view, jEdit.getProperty("options.editing.addMode.dialog.title"), true);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        AbstractOptionPane mainContent = new AbstractOptionPane("addmode");
        this.modeName = new JTextField();
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.modeName"), (Component)this.modeName);
        JLabel label = new JLabel(jEdit.getProperty("options.editing.addMode.dialog.modeFile"));
        mainContent.addComponent(label);
        this.modeFile = new JTextField();
        this.browse = new JButton(jEdit.getProperty("options.editing.addMode.dialog.browse"));
        this.browse.addActionListener(new ActionHandler());
        mainContent.addComponent((Component)this.modeFile, (Component)this.browse);
        this.filenameGlob = new JTextField();
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.filenameGlob"), (Component)this.filenameGlob);
        this.firstLineGlob = new JTextField();
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.firstLineGlob"), (Component)this.firstLineGlob);
        this.getContentPane().add(mainContent);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public String getModeName() {
        return this.modeName.getText();
    }

    public String getModeFile() {
        return this.modeFile.getText();
    }

    public String getFilenameGlob() {
        return this.filenameGlob.getText();
    }

    public String getFirstLineGlob() {
        return this.firstLineGlob.getText();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void ok() {
        if (this.getModeName() == null) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), "Mode name may not be empty.");
            return;
        }
        if (this.getModeFile() == null) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), "Mode name may not be empty.");
            return;
        }
        if (this.getFilenameGlob() == null && this.getFirstLineGlob() == null) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), "Either file name glob or first line glob or both must be filled in.");
            return;
        }
        this.canceled = false;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.dispose();
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == AddModeDialog.this.browse) {
                boolean multiSelect;
                int type;
                String path;
                View view = (View)AddModeDialog.this.getParent();
                String[] filename = GUIUtilities.showVFSFileDialog(view, path = jEdit.getSettingsDirectory(), type = 0, multiSelect = false);
                if (filename.length > 0) {
                    AddModeDialog.this.modeFile.setText(filename[0]);
                } else {
                    AddModeDialog.this.modeFile.setText("");
                }
            } else if (source == AddModeDialog.this.ok) {
                AddModeDialog.this.ok();
            } else if (source == AddModeDialog.this.cancel) {
                AddModeDialog.this.cancel();
            }
        }
    }
}

