/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.BrowserListener;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSFileNameField;
import org.gjt.sp.jedit.bufferio.IoTask;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class VFSFileChooserDialog
extends EnhancedDialog {
    private VFSBrowser browser;
    private VFSFileNameField filenameField;
    private String filename;
    private JButton ok;
    private JButton cancel;
    private boolean isOK;
    private TaskListener ioTaskHandler;

    public VFSFileChooserDialog(View view, String path, int mode, boolean multipleSelection) {
        this(view, path, mode, multipleSelection, true);
    }

    public VFSFileChooserDialog(View view, String path, int mode, boolean multipleSelection, boolean autoshow) {
        super(view, VFSFileChooserDialog.getTitle(mode), true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this._init(view, path, mode, multipleSelection, autoshow);
    }

    public VFSFileChooserDialog(Dialog parent, View view, String path, int mode, boolean multipleSelection, boolean autoshow) {
        super(parent, VFSFileChooserDialog.getTitle(mode), true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this._init(view, path, mode, multipleSelection, autoshow);
    }

    public VFSFileChooserDialog(Frame parent, View view, String path, int mode, boolean multipleSelection, boolean autoshow) {
        super(parent, VFSFileChooserDialog.getTitle(mode), true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this._init(view, path, mode, multipleSelection, autoshow);
    }

    public VFSBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public void dispose() {
        GUIUtilities.saveGeometry(this, "vfs.browser.dialog");
        TaskManager.instance.removeTaskListener(this.ioTaskHandler);
        super.dispose();
    }

    @Override
    public void ok() {
        boolean choosingDir;
        VFSFile[] files = this.browser.getSelectedFiles();
        this.filename = this.filenameField.getText();
        boolean bl = choosingDir = this.browser.getMode() == 3;
        if (files.length != 0) {
            if (choosingDir) {
                this.isOK = true;
                this.dispose();
            } else {
                this.browser.filesActivated(0, false);
            }
            return;
        }
        if (choosingDir && (this.filename == null || this.filename.length() == 0)) {
            this.isOK = true;
            this.dispose();
            return;
        }
        if (this.filename == null || this.filename.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        String bufferDir = this.browser.getView().getBuffer().getDirectory();
        if (this.filename.equals("-")) {
            this.filename = bufferDir;
        } else if (this.filename.startsWith("-/") || this.filename.startsWith('-' + File.separator)) {
            this.filename = MiscUtilities.constructPath(bufferDir, this.filename.substring(2));
        }
        final int[] type = new int[]{-1};
        this.filename = MiscUtilities.expandVariables(this.filename);
        final String path = MiscUtilities.constructPath(this.browser.getDirectory(), this.filename);
        final VFS vfs = VFSManager.getVFSForPath(path);
        Object session = vfs.createVFSSession(path, this);
        if (session == null) {
            return;
        }
        ThreadUtilities.runInBackground(new GetFileTypeRequest(vfs, session, path, type));
        AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable(){

            @Override
            public void run() {
                switch (type[0]) {
                    case 0: {
                        if (VFSFileChooserDialog.this.browser.getMode() == 3 || vfs instanceof FileVFS && VFSFileChooserDialog.this.doFileExistsWarning(path)) break;
                        VFSFileChooserDialog.this.isOK = true;
                        if (VFSFileChooserDialog.this.browser.getMode() == 4) {
                            Hashtable<String, Object> props = new Hashtable<String, Object>();
                            if (((VFSFileChooserDialog)VFSFileChooserDialog.this).browser.currentEncoding != null) {
                                props.put("encoding", ((VFSFileChooserDialog)VFSFileChooserDialog.this).browser.currentEncoding);
                            }
                            jEdit.openFile(VFSFileChooserDialog.this.browser.getView(), VFSFileChooserDialog.this.browser.getDirectory(), path, false, props);
                        }
                        VFSFileChooserDialog.this.dispose();
                        break;
                    }
                    case 1: 
                    case 2: {
                        VFSFileChooserDialog.this.browser.setDirectory(path);
                    }
                }
            }
        });
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public String[] getSelectedFiles() {
        if (!this.isOK) {
            return null;
        }
        if (this.browser.getMode() == 3) {
            if (this.browser.getSelectedFiles().length > 0) {
                return this.getSelectedFiles(1, 2);
            }
            return new String[]{this.browser.getDirectory()};
        }
        if (this.filename != null && this.filename.length() != 0) {
            String path = this.browser.getDirectory();
            return new String[]{MiscUtilities.constructPath(path, this.filename)};
        }
        return this.getSelectedFiles(0, 0);
    }

    private static String getDefaultTitle() {
        return jEdit.getProperty("vfs.browser.title");
    }

    private static String getTitle(int mode) {
        switch (mode) {
            case 0: {
                return jEdit.getProperty("vfs.browser.title.open");
            }
            case 1: {
                return jEdit.getProperty("vfs.browser.title.save");
            }
            case 2: {
                return jEdit.getProperty("vfs.browser.title");
            }
            case 3: {
                return jEdit.getProperty("vfs.browser.title");
            }
            case 4: {
                return jEdit.getProperty("vfs.browser.title.dialog");
            }
        }
        return jEdit.getProperty("vfs.browser.title");
    }

    private void _init(View view, String path, int mode, boolean multipleSelection, boolean autoshow) {
        String name;
        JPanel content = new JPanel(new BorderLayout());
        this.setContentPane(content);
        if (mode == 3) {
            name = null;
        } else if (path == null || path.endsWith(File.separator) || path.endsWith("/")) {
            name = null;
        } else {
            VFS vfs = VFSManager.getVFSForPath(path);
            name = vfs.getFileName(path);
            path = vfs.getParentOfPath(path);
            if ((vfs.getCapabilities() & 4) == 0) {
                path = null;
            }
        }
        this.browser = new VFSBrowser(view, path, mode, multipleSelection, null);
        this.browser.addBrowserListener(new BrowserHandler());
        content.add("Center", this.browser);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.filenameField = new VFSFileNameField(this.browser, null);
        this.filenameField.setText(name);
        this.filenameField.selectAll();
        this.filenameField.setName("filename");
        this.browser.setDefaultFocusComponent(this.filenameField);
        Box box = new Box(1);
        box.add(Box.createGlue());
        box.add(this.filenameField);
        box.add(Box.createGlue());
        JLabel label = new JLabel(jEdit.getProperty("vfs.browser.dialog.filename"));
        label.setDisplayedMnemonic(jEdit.getProperty("vfs.browser.dialog.filename.mnemonic").charAt(0));
        label.setLabelFor(this.filenameField);
        panel.add(label);
        panel.add(Box.createHorizontalStrut(12));
        panel.add(box);
        panel.add(Box.createHorizontalStrut(12));
        this.ok = new JButton();
        this.ok.setName("ok");
        this.getRootPane().setDefaultButton(this.ok);
        switch (mode) {
            case 0: 
            case 4: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.open"));
                break;
            }
            case 3: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                Dimension dim = this.ok.getPreferredSize();
                this.ok.setPreferredSize(dim);
                break;
            }
            case 1: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.save"));
            }
        }
        this.ok.addActionListener(new ActionHandler());
        panel.add(this.ok);
        panel.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.setName("cancel");
        this.cancel.addActionListener(new ActionHandler());
        panel.add(this.cancel);
        content.add("South", panel);
        this.ioTaskHandler = new IoTaskHandler();
        TaskManager.instance.addTaskListener(this.ioTaskHandler);
        this.pack();
        GUIUtilities.loadGeometry(this, "vfs.browser.dialog");
        GUIUtilities.requestFocus(this, this.filenameField);
        if (autoshow) {
            this.setVisible(true);
        }
    }

    private boolean doFileExistsWarning(String filename) {
        Object[] args;
        int result;
        return this.browser.getMode() == 1 && new File(filename).exists() && (result = GUIUtilities.confirm(this.browser, "fileexists", args = new String[]{MiscUtilities.getFileName(filename)}, 0, 2)) != 0;
    }

    private String[] getSelectedFiles(int type1, int type2) {
        VFSFile[] selectedFiles;
        ArrayList<String> l = new ArrayList<String>();
        for (VFSFile file : selectedFiles = this.browser.getSelectedFiles()) {
            if (file.getType() != type1 && file.getType() != type2) continue;
            l.add(file.getPath());
        }
        return l.toArray(new String[l.size()]);
    }

    private class GetFileTypeRequest
    extends IoTask {
        VFS vfs;
        Object session;
        String path;
        int[] type;

        GetFileTypeRequest(VFS vfs, Object session, String path, int[] type) {
            this.vfs = vfs;
            this.session = session;
            this.path = path;
            this.type = type;
        }

        @Override
        public void _run() {
            try {
                VFSFile entry = this.vfs._getFile(this.session, this.path, VFSFileChooserDialog.this.browser);
                this.type[0] = entry == null ? 0 : entry.getType();
            }
            catch (IOException e) {
                VFSManager.error(e, this.path, VFSFileChooserDialog.this.browser);
            }
            finally {
                try {
                    this.vfs._endVFSSession(this.session, VFSFileChooserDialog.this.browser);
                }
                catch (IOException e) {
                    VFSManager.error(e, this.path, VFSFileChooserDialog.this.browser);
                }
            }
        }
    }

    private class IoTaskHandler
    implements TaskListener {
        private final Runnable cursorStatus = new Runnable(){

            @Override
            public void run() {
                int requestCount = TaskManager.instance.countIoTasks();
                if (requestCount == 0) {
                    VFSFileChooserDialog.this.getContentPane().setCursor(Cursor.getDefaultCursor());
                } else if (requestCount >= 1) {
                    VFSFileChooserDialog.this.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };

        private IoTaskHandler() {
        }

        @Override
        public void waiting(Task task) {
            SwingUtilities.invokeLater(this.cursorStatus);
        }

        @Override
        public void running(Task task) {
            SwingUtilities.invokeLater(this.cursorStatus);
        }

        @Override
        public void done(Task task) {
            SwingUtilities.invokeLater(this.cursorStatus);
        }

        @Override
        public void statusUpdated(Task task) {
        }

        @Override
        public void maximumUpdated(Task task) {
        }

        @Override
        public void valueUpdated(Task task) {
            SwingUtilities.invokeLater(this.cursorStatus);
        }
    }

    private class BrowserHandler
    implements BrowserListener {
        private BrowserHandler() {
        }

        @Override
        public void filesSelected(VFSBrowser browser, VFSFile[] files) {
            boolean choosingDir;
            boolean bl = choosingDir = browser.getMode() == 3;
            if (files.length == 0) {
                if (choosingDir) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                }
            } else if (files.length == 1) {
                VFSFile file;
                if (choosingDir) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                }
                if ((file = files[0]).getType() == 0) {
                    String path = file.getPath();
                    String directory = browser.getDirectory();
                    String parent = MiscUtilities.getParentOfPath(path);
                    if (MiscUtilities.pathsEqual(parent, directory)) {
                        path = file.getName();
                    }
                    VFSFileChooserDialog.this.filenameField.setText(path);
                    VFSFileChooserDialog.this.filenameField.selectAll();
                }
            } else {
                if (choosingDir) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                }
                VFSFileChooserDialog.this.filenameField.setText(null);
            }
        }

        @Override
        public void filesActivated(VFSBrowser browser, VFSFile[] files) {
            VFSFileChooserDialog.this.filenameField.selectAll();
            if (files.length == 0) {
                VFSFileChooserDialog.this.ok();
                return;
            }
            int i = 0;
            int n = files.length;
            if (i < n) {
                if (files[i].getType() == 0) {
                    String path = files[i].getPath();
                    VFS vfs = VFSManager.getVFSForPath(path);
                    if (browser.getMode() == 1 && vfs instanceof FileVFS && VFSFileChooserDialog.this.doFileExistsWarning(path)) {
                        return;
                    }
                    VFSFileChooserDialog.this.isOK = true;
                    VFSFileChooserDialog.this.filenameField.setText(null);
                    if (browser.getMode() != 3) {
                        VFSFileChooserDialog.this.dispose();
                    }
                    return;
                }
                return;
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == VFSFileChooserDialog.this.ok) {
                VFSFileChooserDialog.this.ok();
            } else if (evt.getSource() == VFSFileChooserDialog.this.cancel) {
                VFSFileChooserDialog.this.cancel();
            }
        }
    }
}

