/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.io.IOException;
import org.gjt.sp.jedit.browser.AbstractBrowserTask;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class MkDirBrowserTask
extends AbstractBrowserTask {
    MkDirBrowserTask(VFSBrowser browser, Object session, VFS vfs, String path, Runnable awtRunnable) {
        super(browser, session, vfs, path, awtRunnable);
    }

    @Override
    public void _run() {
        Object[] args = new String[]{this.path};
        try {
            this.setCancellable(true);
            this.setStatus(jEdit.getProperty("vfs.status.mkdir", args));
            this.path = this.vfs._canonPath(this.session, this.path, this.browser);
            if (!this.vfs._mkdir(this.session, this.path, this.browser)) {
                VFSManager.error(this.browser, this.path, "ioerror.mkdir-error", null);
            }
        }
        catch (IOException io) {
            this.setCancellable(false);
            Log.log(9, this, io);
            args[0] = io.toString();
            VFSManager.error(this.browser, this.path, "ioerror", args);
        }
        finally {
            try {
                this.vfs._endVFSSession(this.session, this.browser);
            }
            catch (IOException io) {
                this.setCancellable(false);
                Log.log(9, this, io);
                args[0] = io.toString();
                VFSManager.error(this.browser, this.path, "ioerror", args);
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[type=MKDIR" + ",vfs=" + this.vfs + ",path=" + this.path + ']';
    }
}

