/*
 * Decompiled with CFR 0.152.
 */
package macosx;

import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import macosx.OSXAdapter;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.AboutDialog;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;
import org.jedit.options.CombinedOptions;

public class MacOSXPlugin
extends EBPlugin {
    private static final Pattern ctrlPat = Pattern.compile("\\bctrl\\b");
    private boolean fullScreenFailed = false;

    public void start() {
        if (this.osok()) {
            Runnable setup = new Runnable(){

                @Override
                public void run() {
                    try {
                        MacOSXPlugin listener = MacOSXPlugin.this;
                        Class<?> theClass = ((Object)((Object)listener)).getClass();
                        OSXAdapter.setQuitHandler((Object)listener, theClass.getDeclaredMethod("handleQuit", null));
                        OSXAdapter.setAboutHandler((Object)listener, theClass.getDeclaredMethod("handleAbout", null));
                        OSXAdapter.setPreferencesHandler((Object)listener, theClass.getDeclaredMethod("handlePreferences", null));
                        OSXAdapter.setFileHandler((Object)listener, theClass.getDeclaredMethod("handleOpenFile", String.class));
                        OSXAdapter.setReOpenApplicationHandler((Object)listener, theClass.getDeclaredMethod("handleReOpenApplication", null));
                        String lf = jEdit.getProperty((String)"lookAndFeel");
                        if (lf != null && lf.length() != 0 && !UIManager.getLookAndFeel().isNativeLookAndFeel()) {
                            Log.log((int)1, (Object)this, (Object)"Fixing keybindingds on current LNF");
                            UIDefaults uid = UIManager.getLookAndFeelDefaults();
                            MacOSXPlugin.fixMacKeyBindings(uid);
                        }
                    }
                    catch (Exception e) {
                        Log.log((int)9, (Object)this, (Object)"Error while loading the OSXAdapter:", (Throwable)e);
                    }
                }
            };
            ThreadUtilities.runInDispatchThread((Runnable)setup);
            Debug.ALT_KEY_PRESSED_DISABLED = jEdit.getBooleanProperty((String)"plugin.MacOSXPlugin.disableOption");
            boolean toSwap = MacOSXPlugin.isCtrlAltSwapped();
            if (toSwap) {
                MacOSXPlugin.setCtrlAltSwapped(true);
            }
        }
    }

    public void stop() {
    }

    public boolean handleQuit() {
        jEdit.exit((View)jEdit.getActiveView(), (boolean)true);
        return false;
    }

    public void handlePreferences() {
        new CombinedOptions((Frame)jEdit.getActiveView());
    }

    public void handleAbout() {
        new AboutDialog(jEdit.getActiveView());
    }

    public void handleOpenFile(String filepath) {
        File file = new File(filepath);
        if (file.exists()) {
            if (file.isDirectory()) {
                return;
            }
            if (jEdit.isStartupDone()) {
                View view = jEdit.getActiveView();
                if (view == null) {
                    view = PerspectiveManager.loadPerspective((jEdit.getBooleanProperty((String)"restore") && jEdit.getBooleanProperty((String)"restore.cli") ? 1 : 0) != 0);
                }
                if (jEdit.openFile((View)view, (String)file.getPath()) == null) {
                    Log.log((int)9, (Object)((Object)this), (Object)("Unable to open file: " + filepath));
                }
            } else {
                jEdit.openFileAfterStartup((String)file.getPath());
            }
        } else {
            Log.log((int)9, (Object)((Object)this), (Object)("Cannot open non-existing file: " + filepath));
        }
    }

    public void handleReOpenApplication() {
        if (jEdit.getActiveView() != null) {
            jEdit.getActiveView().requestFocus();
        } else {
            PerspectiveManager.loadPerspective((boolean)jEdit.getBooleanProperty((String)"restore"));
        }
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof BufferUpdate) {
            View[] views;
            BufferUpdate msg = (BufferUpdate)message;
            Buffer buffer = msg.getBuffer();
            for (View view : views = jEdit.getViews()) {
                if (view.getBuffer() != buffer) continue;
                this.refreshProxyIcon(view);
            }
        } else if (message instanceof ViewUpdate) {
            ViewUpdate msg = (ViewUpdate)message;
            this.refreshProxyIcon(msg.getView());
            if (msg.getWhat() == ViewUpdate.CREATED) {
                this.enableFullScreenMode(msg.getView());
            }
        } else if (message instanceof EditPaneUpdate) {
            EditPaneUpdate msg = (EditPaneUpdate)message;
            this.refreshProxyIcon(msg.getEditPane().getView());
        }
    }

    public void refreshProxyIcon(View view) {
        if (view == null) {
            return;
        }
        Buffer buffer = view.getBuffer();
        if (buffer == null) {
            view.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            view.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
            view.getRootPane().putClientProperty("Window.documentFile", null);
            return;
        }
        if (buffer.isDirty()) {
            view.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
            view.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        } else {
            view.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            view.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
        }
        if (buffer.isNewFile()) {
            view.getRootPane().putClientProperty("Window.documentFile", null);
        } else {
            view.getRootPane().putClientProperty("Window.documentFile", new File(buffer.getPath()));
        }
    }

    public static void fixMacKeyBindings(UIDefaults uiDefaults) {
        Object[] keys;
        for (Object key : keys = uiDefaults.keySet().toArray()) {
            InputMap map;
            KeyStroke[] keyStrokes;
            Object value = uiDefaults.get(key);
            if (!(value instanceof InputMap) || (keyStrokes = (map = (InputMap)value).keys()) == null) continue;
            for (KeyStroke keyStroke : keyStrokes) {
                String keyString = keyStroke.toString();
                if (keyString.indexOf("ctrl ") < 0) continue;
                Object action = map.get(keyStroke);
                keyString = ctrlPat.matcher(keyString).replaceAll("meta");
                map.remove(keyStroke);
                keyStroke = KeyStroke.getKeyStroke(keyString);
                map.put(keyStroke, action);
            }
        }
    }

    public static boolean isCtrlAltSwapped() {
        return jEdit.getBooleanProperty((String)"plugin.MacOSXPlugin.ctrlAltSwapped");
    }

    public static void setCtrlAltSwapped(boolean isSwapped) {
        boolean wasSwapped = MacOSXPlugin.isCtrlAltSwapped();
        jEdit.setBooleanProperty((String)"plugin.MacOSXPlugin.ctrlAltSwapped", (boolean)isSwapped);
        if (isSwapped) {
            KeyEventTranslator.setModifierMapping((int)2, (int)4, (int)8, (int)1);
        } else if (wasSwapped) {
            KeyEventTranslator.setModifierMapping((int)4, (int)2, (int)8, (int)1);
        }
    }

    public static void setDisableOption(boolean state) {
        Debug.ALT_KEY_PRESSED_DISABLED = state;
        jEdit.setBooleanProperty((String)"plugin.MacOSXPlugin.disableOption", (boolean)state);
    }

    public static boolean getDisableOption() {
        return jEdit.getBooleanProperty((String)"plugin.MacOSXPlugin.disableOption");
    }

    public void enableFullScreenMode(View view) {
        if (this.fullScreenFailed) {
            return;
        }
        try {
            Class<?> Util = Class.forName("com.apple.eawt.FullScreenUtilities");
            Class[] arguments = new Class[]{Window.class, Boolean.TYPE};
            Method setWindowCanFullScreen = Util.getMethod("setWindowCanFullScreen", arguments);
            setWindowCanFullScreen.invoke(Util, view, true);
        }
        catch (Exception e) {
            Log.log((int)1, (Object)((Object)this), (Object)("Unable to enable OS X native full screen mode: " + e));
            this.fullScreenFailed = true;
        }
    }

    private boolean osok() {
        if (!OperatingSystem.isMacOS()) {
            Log.log((int)9, (Object)((Object)this), (Object)jEdit.getProperty((String)"MacOSXPlugin.dialog.osname.message"));
            return false;
        }
        return true;
    }
}

