/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;

public class Chunk
extends Token {
    public SyntaxStyle style;
    public float width;
    private static final char[] EMPTY_TEXT = new char[0];
    private static boolean fontSubstEnabled;
    private static boolean fontSubstSystemFontsEnabled;
    private static Font[] preferredFonts;
    private static Font[] fontSubstList;
    private static int glyphCacheCapacity;
    private static SoftReference<GlyphCache> glyphCache;
    private Color background;
    public String str;
    private GlyphVector[] glyphs;

    public static float paintChunkList(Chunk chunks, Graphics2D gfx, float x, float y, boolean glyphVector) {
        Rectangle clipRect = gfx.getClipBounds();
        float _x = 0.0f;
        while (chunks != null) {
            if (x + _x + chunks.width > (float)clipRect.x && x + _x < (float)(clipRect.x + clipRect.width)) {
                if (Debug.CHUNK_PAINT_DEBUG) {
                    gfx.draw(new Rectangle2D.Float(x + _x, y - 10.0f, chunks.width, 10.0f));
                }
                if (chunks.isAccessible() && chunks.glyphs != null) {
                    gfx.setFont(chunks.style.getFont());
                    gfx.setColor(chunks.style.getForegroundColor());
                    if (glyphVector) {
                        chunks.drawGlyphs(gfx, x + _x, y);
                    } else if (chunks.str != null) {
                        gfx.drawString(chunks.str, (int)(x + _x), (int)y);
                    }
                }
            }
            _x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return _x;
    }

    public static float paintChunkBackgrounds(Chunk chunks, Graphics2D gfx, float x, float y, int lineHeight) {
        Rectangle clipRect = gfx.getClipBounds();
        float _x = 0.0f;
        FontMetrics forBackground = gfx.getFontMetrics();
        int ascent = forBackground.getAscent();
        int height = lineHeight;
        while (chunks != null) {
            Color bgColor;
            if (x + _x + chunks.width > (float)clipRect.x && x + _x < (float)(clipRect.x + clipRect.width) && chunks.isAccessible() && (bgColor = chunks.background) != null) {
                gfx.setColor(bgColor);
                gfx.fill(new Rectangle2D.Float(x + _x, y - (float)ascent, _x + chunks.width - _x, height));
            }
            _x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return _x;
    }

    public static float offsetToX(Chunk chunks, int offset) {
        if (chunks != null && offset < chunks.offset) {
            throw new ArrayIndexOutOfBoundsException(offset + " < " + chunks.offset);
        }
        float x = 0.0f;
        while (chunks != null) {
            if (chunks.isAccessible() && offset < chunks.offset + chunks.length) {
                return x + chunks.offsetToX(offset - chunks.offset);
            }
            x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return x;
    }

    public static int xToOffset(Chunk chunks, float x, boolean round) {
        float _x = 0.0f;
        while (chunks != null) {
            if (chunks.isAccessible() && x < _x + chunks.width) {
                return chunks.xToOffset(x - _x, round);
            }
            _x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return -1;
    }

    public static void propertiesChanged(IPropertyManager props) {
        fontSubstList = null;
        if (props == null) {
            fontSubstEnabled = false;
            fontSubstSystemFontsEnabled = true;
            preferredFonts = null;
        } else {
            fontSubstEnabled = Boolean.parseBoolean(props.getProperty("view.enableFontSubst"));
            fontSubstSystemFontsEnabled = Boolean.parseBoolean(props.getProperty("view.enableFontSubstSystemFonts"));
        }
        ArrayList<Font> userFonts = new ArrayList<Font>();
        int i = 0;
        if (props != null) {
            String family;
            while ((family = props.getProperty("view.fontSubstList." + i)) != null) {
                Font f = new Font(family, 0, 12);
                if (!"dialog".equalsIgnoreCase(f.getFamily()) || "dialog".equalsIgnoreCase(family)) {
                    userFonts.add(f);
                }
                ++i;
            }
        }
        preferredFonts = userFonts.toArray(new Font[userFonts.size()]);
        glyphCache = null;
    }

    Chunk(float width, int offset, ParserRuleSet rules) {
        super((byte)0, offset, 0, rules);
        this.width = width;
        assert (!this.isAccessible());
        assert (this.isInitialized());
    }

    Chunk(byte id, int offset, int length, ParserRuleSet rules, SyntaxStyle[] styles, byte defaultID) {
        super(id, offset, length, rules);
        this.style = styles[id];
        this.background = this.style.getBackgroundColor();
        if (this.background == null) {
            this.background = styles[defaultID].getBackgroundColor();
        }
        assert (this.isAccessible());
        assert (!this.isInitialized());
    }

    Chunk(byte id, int offset, int length, ParserRuleSet rules, SyntaxStyle style, Color background) {
        super(id, offset, length, rules);
        this.style = style;
        this.background = background;
        assert (this.isAccessible());
        assert (!this.isInitialized());
    }

    final boolean isAccessible() {
        return this.length > 0;
    }

    final boolean isInitialized() {
        return !this.isAccessible() || this.glyphs != null || this.width > 0.0f;
    }

    final boolean isTab(Segment lineText) {
        return this.length == 1 && lineText.array[lineText.offset + this.offset] == '\t';
    }

    final Chunk snippetBefore(int snipOffset) {
        assert (0 <= snipOffset && snipOffset < this.length);
        return new Chunk(this.id, this.offset, snipOffset, this.rules, this.style, this.background);
    }

    final Chunk snippetAfter(int snipOffset) {
        assert (0 <= snipOffset && snipOffset < this.length);
        return new Chunk(this.id, this.offset + snipOffset, this.length - snipOffset, this.rules, this.style, this.background);
    }

    final Chunk snippetBeforeLineOffset(int lineOffset) {
        return this.snippetBefore(lineOffset - this.offset);
    }

    final float offsetToX(int offset) {
        if (this.glyphs == null) {
            return 0.0f;
        }
        float x = 0.0f;
        for (GlyphVector gv : this.glyphs) {
            if (offset < gv.getNumGlyphs()) {
                return x += (float)gv.getGlyphPosition(offset).getX();
            }
            x += (float)gv.getLogicalBounds().getWidth();
            offset -= gv.getNumGlyphs();
        }
        assert (false) : "Shouldn't reach this.";
        return -1.0f;
    }

    final int xToOffset(float x, boolean round) {
        if (this.glyphs == null) {
            if (round && this.width - x < x) {
                return this.offset + this.length;
            }
            return this.offset;
        }
        int off = this.offset;
        float myx = 0.0f;
        for (GlyphVector gv : this.glyphs) {
            float gwidth = (float)gv.getLogicalBounds().getWidth();
            if (myx + gwidth >= x) {
                float[] pos = gv.getGlyphPositions(0, gv.getNumGlyphs(), null);
                for (int i = 0; i < gv.getNumGlyphs(); ++i) {
                    float nextX;
                    float glyphX = myx + pos[i << 1];
                    float f = nextX = i == gv.getNumGlyphs() - 1 ? this.width : myx + pos[(i << 1) + 2];
                    if (!(nextX > x)) continue;
                    if (!round || nextX - x > x - glyphX) {
                        return off + i;
                    }
                    return off + i + 1;
                }
            }
            myx += gwidth;
            off += gv.getNumGlyphs();
        }
        assert (false) : "Shouldn't reach this.";
        return -1;
    }

    void init(Segment lineText, TabExpander expander, float x, FontRenderContext fontRenderContext, int physicalLineOffset) {
        if (this.isAccessible()) {
            if (this.isTab(lineText)) {
                float newX = expander.nextTabStop(x, physicalLineOffset + this.offset);
                this.width = newX - x;
            } else {
                this.str = new String(lineText.array, lineText.offset + this.offset, this.length);
                GlyphKey cacheKey = new GlyphKey(this.str, this.style.getFont(), fontRenderContext);
                GlyphCache cache = Chunk.getGlyphCache();
                GlyphVector[] cachedGlyphs = (GlyphVector[])cache.get(cacheKey);
                if (cachedGlyphs != null) {
                    this.glyphs = cachedGlyphs;
                } else {
                    int textStart = lineText.offset + this.offset;
                    int textEnd = textStart + this.length;
                    this.glyphs = Chunk.layoutGlyphs(this.style.getFont(), fontRenderContext, lineText.array, textStart, textEnd);
                    cache.put(cacheKey, this.glyphs);
                }
                float w = 0.0f;
                for (GlyphVector gv : this.glyphs) {
                    w += (float)gv.getLogicalBounds().getWidth();
                }
                this.width = w;
            }
        }
        assert (this.isInitialized());
    }

    private static Font[] getFontSubstList() {
        if (fontSubstList == null) {
            if (fontSubstSystemFontsEnabled) {
                Font[] systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                fontSubstList = new Font[preferredFonts.length + systemFonts.length];
                System.arraycopy(preferredFonts, 0, fontSubstList, 0, preferredFonts.length);
                System.arraycopy(systemFonts, 0, fontSubstList, preferredFonts.length, systemFonts.length);
            } else {
                fontSubstList = new Font[preferredFonts.length];
                System.arraycopy(preferredFonts, 0, fontSubstList, 0, preferredFonts.length);
            }
        }
        return fontSubstList;
    }

    private static Font getSubstFont(int codepoint) {
        if (Character.isISOControl(codepoint)) {
            return null;
        }
        for (Font candidate : Chunk.getFontSubstList()) {
            if (!candidate.canDisplay(codepoint)) continue;
            return candidate;
        }
        return null;
    }

    private void drawGlyphs(Graphics2D gfx, float x, float y) {
        for (GlyphVector gv : this.glyphs) {
            gfx.drawGlyphVector(gv, x, y);
            x += (float)gv.getLogicalBounds().getWidth();
        }
    }

    private static GlyphVector layoutGlyphVector(Font font, FontRenderContext frc, char[] text, int start, int end) {
        int flags = 6;
        GlyphVector result = font.layoutGlyphVector(frc, text, start, end, flags);
        font.layoutGlyphVector(frc, EMPTY_TEXT, 0, 0, flags);
        return result;
    }

    private static GlyphVector[] layoutGlyphs(Font mainFont, FontRenderContext frc, char[] text, int start, int end) {
        int substStart;
        int n = substStart = !fontSubstEnabled ? -1 : mainFont.canDisplayUpTo(text, start, end);
        if (substStart == -1) {
            GlyphVector gv = Chunk.layoutGlyphVector(mainFont, frc, text, start, end);
            return new GlyphVector[]{gv};
        }
        FontSubstitution subst = new FontSubstitution(mainFont, frc, text, start);
        subst.addNonSubstRange(substStart - start);
        Chunk.doFontSubstitution(subst, mainFont, text, substStart, end);
        subst.finish();
        return subst.getGlyphs();
    }

    private static void doFontSubstitution(FontSubstitution subst, Font mainFont, char[] text, int start, int end) {
        while (true) {
            assert (start < end);
            int nextChar = Character.codePointAt(text, start);
            int charCount = Character.charCount(nextChar);
            assert (!mainFont.canDisplay(nextChar));
            Font substFont = Chunk.getSubstFont(nextChar);
            if (substFont != null) {
                subst.addRange(substFont, charCount);
            } else {
                subst.addNonSubstRange(charCount);
            }
            if ((start += charCount) >= end) break;
            int nextSubstStart = mainFont.canDisplayUpTo(text, start, end);
            if (nextSubstStart == -1) {
                subst.addNonSubstRange(end - start);
                break;
            }
            subst.addNonSubstRange(nextSubstStart - start);
            start = nextSubstStart;
        }
    }

    private static GlyphCache getGlyphCache() {
        GlyphCache cache;
        if (glyphCache != null && (cache = glyphCache.get()) != null) {
            return cache;
        }
        GlyphCache newOne = new GlyphCache(glyphCacheCapacity);
        glyphCache = new SoftReference<GlyphCache>(newOne);
        return newOne;
    }

    static {
        glyphCacheCapacity = 256;
    }

    private static class GlyphCache
    extends LinkedHashMap<GlyphKey, GlyphVector[]> {
        private final int capacity;

        public GlyphCache(int capacity) {
            super(capacity + 1, 1.0f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<GlyphKey, GlyphVector[]> eldest) {
            return this.size() > this.capacity;
        }
    }

    private static class GlyphKey {
        public final String token;
        public final Font font;
        public final FontRenderContext context;

        GlyphKey(String token, Font font, FontRenderContext context) {
            assert (token != null);
            assert (font != null);
            assert (context != null);
            this.token = token;
            this.font = font;
            this.context = context;
        }

        public final int hashCode() {
            return this.token.hashCode() + this.font.hashCode() + this.context.hashCode();
        }

        public final boolean equals(Object otherObject) {
            GlyphKey other = (GlyphKey)otherObject;
            return this.token.equals(other.token) && this.font.equals(other.font) && this.context.equals(other.context);
        }

        public final String toString() {
            return this.token;
        }
    }

    private static class FontSubstitution {
        private final Font mainFont;
        private final FontRenderContext frc;
        private final char[] text;
        private int rangeStart;
        private Font rangeFont;
        private int rangeLength;
        private final ArrayList<GlyphVector> glyphs;

        public FontSubstitution(Font mainFont, FontRenderContext frc, char[] text, int start) {
            this.mainFont = mainFont;
            this.frc = frc;
            this.text = text;
            this.rangeStart = start;
            this.rangeFont = null;
            this.rangeLength = 0;
            this.glyphs = new ArrayList();
        }

        public void addNonSubstRange(int length) {
            this.addRange(null, length);
        }

        private void addRange(Font font, int length) {
            assert (length >= 0);
            if (length == 0) {
                return;
            }
            if (font == this.rangeFont) {
                this.rangeLength += length;
            } else {
                this.addGlyphVectorOfLastRange();
                this.rangeFont = font;
                this.rangeStart += this.rangeLength;
                this.rangeLength = length;
            }
        }

        public void finish() {
            this.addGlyphVectorOfLastRange();
            this.rangeFont = null;
            this.rangeStart += this.rangeLength;
            this.rangeLength = 0;
        }

        public GlyphVector[] getGlyphs() {
            return this.glyphs.toArray(new GlyphVector[this.glyphs.size()]);
        }

        private void addGlyphVectorOfLastRange() {
            if (this.rangeLength == 0) {
                return;
            }
            Font font = this.rangeFont == null ? this.mainFont : this.rangeFont.deriveFont(this.mainFont.getStyle(), this.mainFont.getSize());
            GlyphVector gv = Chunk.layoutGlyphVector(font, this.frc, this.text, this.rangeStart, this.rangeStart + this.rangeLength);
            this.glyphs.add(gv);
        }
    }
}

