/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.keymap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.jedit.keymap.Keymap;
import org.jedit.keymap.KeymapFileFilter;
import org.jedit.keymap.KeymapImpl;
import org.jedit.keymap.KeymapManager;

public class KeymapManagerImpl
implements KeymapManager {
    private Keymap currentKeymap;
    private final IPropertyManager propertyManager;
    private static File userKeymapFolder;
    private final File systemKeymapFolder;

    public KeymapManagerImpl(IPropertyManager propertyManager, File systemKeymapFolder, File userKeymapFolder) {
        this.propertyManager = propertyManager;
        this.systemKeymapFolder = systemKeymapFolder;
        if (!systemKeymapFolder.isDirectory()) {
            Log.log(9, this, "System keymap folder do not exist, your installation is broken.Install keymaps in " + systemKeymapFolder.getAbsolutePath());
            JOptionPane.showMessageDialog(null, "System keymap folder do not exist, your installation is broken.Install keymaps in " + systemKeymapFolder.getAbsolutePath(), "Fatal Error", 0);
            System.exit(10);
        }
        KeymapManagerImpl.userKeymapFolder = userKeymapFolder;
    }

    @Override
    public Keymap getKeymap() {
        return this.currentKeymap;
    }

    @Override
    public Collection<String> getKeymapNames() {
        Collection<String> systemKeymapNames = KeymapManagerImpl.getKeymapsFromFolder(this.systemKeymapFolder);
        Collection<String> userKeymapNames = KeymapManagerImpl.getKeymapsFromFolder(userKeymapFolder);
        HashSet<String> keyMaps = new HashSet<String>();
        keyMaps.addAll(systemKeymapNames);
        keyMaps.addAll(userKeymapNames);
        return keyMaps;
    }

    @Override
    public Keymap getKeymap(String name) {
        File keymapFile = this.getKeymapFile(name);
        KeymapImpl keymap = null;
        if (keymapFile.isFile()) {
            keymap = new KeymapImpl(name, keymapFile);
        }
        return keymap;
    }

    @Override
    public KeymapManager.State getKeymapState(String name) {
        File systemKeymapFile = this.getSystemKeymapFile(name);
        File userKeymapFile = KeymapManagerImpl.getUserKeymapFile(name);
        if (userKeymapFile.isFile()) {
            if (systemKeymapFile.isFile()) {
                return KeymapManager.State.SystemModified;
            }
            return KeymapManager.State.User;
        }
        if (systemKeymapFile.isFile()) {
            return KeymapManager.State.System;
        }
        return KeymapManager.State.Unknown;
    }

    @Override
    public void resetKeymap(String name) {
        KeymapManager.State keymapState = this.getKeymapState(name);
        if (keymapState == KeymapManager.State.SystemModified) {
            File userFile = KeymapManagerImpl.getUserKeymapFile(name);
            userFile.delete();
        }
    }

    @Override
    public void deleteUserKeymap(String name) {
        KeymapManager.State keymapState = this.getKeymapState(name);
        if (keymapState == KeymapManager.State.User) {
            File userFile = KeymapManagerImpl.getUserKeymapFile(name);
            userFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean copyKeymap(String name, String newName) {
        boolean bl;
        Log.log(1, this, "copyKeymap(" + name + ',' + newName + ')');
        File keymapFile = KeymapManagerImpl.getUserKeymapFile(newName);
        if (keymapFile.exists()) {
            throw new IllegalArgumentException("Keymap " + newName + " already exists");
        }
        File originalKeymap = this.getKeymapFile(name);
        if (!originalKeymap.isFile()) {
            throw new IllegalArgumentException("Keymap " + name + " doesn't exist");
        }
        keymapFile.getParentFile().mkdirs();
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        Log.log(1, this, "Copying " + originalKeymap.getAbsolutePath() + " to " + keymapFile.getAbsolutePath());
        try {
            in = new BufferedInputStream(new FileInputStream(originalKeymap));
            out = new BufferedOutputStream(new FileOutputStream(keymapFile));
            IOUtilities.copyStream(null, in, out, false);
            bl = true;
        }
        catch (IOException e) {
            try {
                Log.log(9, this, e);
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(in);
                IOUtilities.closeQuietly(out);
                throw throwable;
            }
            IOUtilities.closeQuietly(in);
            IOUtilities.closeQuietly(out);
            return false;
        }
        IOUtilities.closeQuietly(in);
        IOUtilities.closeQuietly(out);
        return bl;
    }

    @Override
    public void reload() {
        String name = this.getCurrentKeymapName();
        this.currentKeymap = this.getKeymap(name);
        if (this.currentKeymap == null) {
            this.currentKeymap = this.getKeymap("jEdit");
        }
    }

    private File getKeymapFile(String name) {
        File file = KeymapManagerImpl.getUserKeymapFile(name);
        if (!file.isFile()) {
            file = this.getSystemKeymapFile(name);
        }
        return file;
    }

    static File getUserKeymapFile(String name) {
        return new File(userKeymapFolder, name + "_keys.props");
    }

    private File getSystemKeymapFile(String name) {
        return new File(this.systemKeymapFolder, name + "_keys.props");
    }

    private static Collection<String> getKeymapsFromFolder(File folder) {
        if (folder == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        File[] files = folder.listFiles(new KeymapFileFilter());
        if (files != null) {
            for (File file : files) {
                String filename = file.getName();
                String name = filename.substring(0, filename.length() - 11);
                names.add(name);
            }
        }
        return names;
    }

    private String getCurrentKeymapName() {
        return this.propertyManager.getProperty("keymap.current");
    }
}

