/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.ArrayList;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;

public class KeywordMap {
    private int mapLength;
    private Keyword[] map;
    private boolean ignoreCase;
    private StringBuilder noWordSep;

    public KeywordMap(boolean ignoreCase) {
        this(ignoreCase, 52);
        this.ignoreCase = ignoreCase;
        this.noWordSep = new StringBuilder();
    }

    public KeywordMap(boolean ignoreCase, int mapLength) {
        this.mapLength = mapLength;
        this.ignoreCase = ignoreCase;
        this.map = new Keyword[mapLength];
    }

    public byte lookup(Segment text, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        Keyword k = this.map[this.getSegmentMapKey(text, offset, length)];
        while (k != null) {
            if (length != k.keyword.length) {
                k = k.next;
                continue;
            }
            if (SyntaxUtilities.regionMatches(this.ignoreCase, text, offset, k.keyword)) {
                return k.id;
            }
            k = k.next;
        }
        return 0;
    }

    public void add(String keyword, byte id) {
        this.add(keyword.toCharArray(), id);
    }

    public void add(char[] keyword, byte id) {
        int key = this.getStringMapKey(keyword);
        block0: for (char ch : keyword) {
            if (Character.isLetterOrDigit(ch)) continue;
            for (int j = 0; j < this.noWordSep.length(); ++j) {
                if (this.noWordSep.charAt(j) == ch) continue block0;
            }
            this.noWordSep.append(ch);
        }
        this.map[key] = new Keyword(keyword, id, this.map[key]);
    }

    public String getNonAlphaNumericChars() {
        return this.noWordSep.toString();
    }

    public String[] getKeywords() {
        ArrayList<String> vector = new ArrayList<String>(100);
        Keyword[] arr$ = this.map;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Keyword kw;
            Keyword keyword = kw = arr$[i$];
            while (keyword != null) {
                vector.add(new String(keyword.keyword));
                keyword = keyword.next;
            }
        }
        String[] retVal = new String[vector.size()];
        vector.toArray(retVal);
        return retVal;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void add(KeywordMap map) {
        for (int i = 0; i < map.map.length; ++i) {
            Keyword k = map.map[i];
            while (k != null) {
                this.add(k.keyword, k.id);
                k = k.next;
            }
        }
    }

    private int getStringMapKey(char[] s) {
        return (Character.toUpperCase(s[0]) + Character.toUpperCase(s[s.length - 1])) % this.mapLength;
    }

    protected int getSegmentMapKey(Segment s, int off, int len) {
        return (Character.toUpperCase(s.array[off]) + Character.toUpperCase(s.array[off + len - 1])) % this.mapLength;
    }

    private static class Keyword {
        public char[] keyword;
        public byte id;
        public Keyword next;

        Keyword(char[] keyword, byte id, Keyword next) {
            this.keyword = keyword;
            this.id = id;
            this.next = next;
        }
    }
}

