/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.gjt.sp.jedit.io.EncodingDetector;
import org.gjt.sp.util.Log;

public class XMLEncodingDetector
implements EncodingDetector {
    @Override
    public String detectEncoding(InputStream sample) throws IOException {
        int count;
        int XML_PI_LENGTH = 50;
        byte[] _xmlPI = new byte[50];
        int offset = 0;
        while ((count = sample.read(_xmlPI, offset, 50 - offset)) != -1 && (offset += count) != 50) {
        }
        return XMLEncodingDetector.getXMLEncoding(new String(_xmlPI, 0, offset, "ASCII"));
    }

    private static String getXMLEncoding(String xmlPI) {
        if (!xmlPI.startsWith("<?xml")) {
            return null;
        }
        int index = xmlPI.indexOf("encoding=");
        if (index == -1 || index + 9 == xmlPI.length()) {
            return null;
        }
        char ch = xmlPI.charAt(index + 9);
        int endIndex = xmlPI.indexOf(ch, index + 10);
        if (endIndex == -1) {
            return null;
        }
        String encoding = xmlPI.substring(index + 10, endIndex);
        try {
            if (Charset.isSupported(encoding)) {
                return encoding;
            }
            Log.log(7, XMLEncodingDetector.class, "XML PI specifies unsupported encoding: " + encoding);
        }
        catch (IllegalCharsetNameException e) {
            Log.log(7, XMLEncodingDetector.class, "XML PI specifies illegal encoding: " + encoding, e);
        }
        return null;
    }
}

