/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class FontSelectorDialog
extends EnhancedDialog {
    private FontSelector fontSelector;
    private boolean isOK;
    private JTextField familyField;
    private JList familyList;
    private JTextField sizeField;
    private JList sizeList;
    private JTextField styleField;
    private JList styleList;
    private JLabel preview;
    private JButton ok;
    private JButton cancel;
    private static final String[] HIDEFONTS = new String[]{".bold", ".italic"};

    public FontSelectorDialog(Frame parent, Font font) {
        super(parent, jEdit.getProperty("font-selector.title"), true);
        this.init(font);
    }

    public FontSelectorDialog(Dialog parent, Font font) {
        super(parent, jEdit.getProperty("font-selector.title"), true);
        this.init(font);
    }

    FontSelectorDialog(Frame parent, Font font, FontSelector fontSelector) {
        super(parent, jEdit.getProperty("font-selector.title"), true);
        this.fontSelector = fontSelector;
        this.init(font);
    }

    FontSelectorDialog(Dialog parent, Font font, FontSelector fontSelector) {
        super(parent, jEdit.getProperty("font-selector.title"), true);
        this.fontSelector = fontSelector;
        this.init(font);
    }

    @Override
    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public Font getSelectedFont() {
        int size;
        if (!this.isOK) {
            return null;
        }
        try {
            size = Integer.parseInt(this.sizeField.getText());
        }
        catch (Exception e) {
            size = 12;
        }
        return new Font(this.familyField.getText(), this.styleList.getSelectedIndex(), size);
    }

    private void init(Font font) {
        String[] fonts;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel listPanel = new JPanel(new GridLayout(1, 3, 6, 6));
        try {
            fonts = FontSelectorDialog.getFontList();
        }
        catch (Exception e) {
            Log.log(9, this, "Broken Java implementation!");
            Log.log(9, this, e);
            fonts = new String[]{"Broken Java implementation!"};
        }
        this.familyField = new JTextField();
        this.familyList = new JList<String>(fonts);
        JPanel familyPanel = FontSelectorDialog.createTextFieldAndListPanel("font-selector.family", this.familyField, this.familyList);
        listPanel.add(familyPanel);
        String[] sizes = new String[]{"9", "10", "12", "14", "16", "18", "24"};
        this.sizeField = new JTextField();
        this.sizeList = new JList<String>(sizes);
        JPanel sizePanel = FontSelectorDialog.createTextFieldAndListPanel("font-selector.size", this.sizeField, this.sizeList);
        listPanel.add(sizePanel);
        String[] styles = new String[]{jEdit.getProperty("font-selector.plain"), jEdit.getProperty("font-selector.bold"), jEdit.getProperty("font-selector.italic"), jEdit.getProperty("font-selector.bolditalic")};
        this.styleField = new JTextField();
        this.styleList = new JList<String>(styles);
        JPanel stylePanel = FontSelectorDialog.createTextFieldAndListPanel("font-selector.style", this.styleField, this.styleList);
        this.styleField.setEditable(false);
        listPanel.add(stylePanel);
        if (font != null) {
            this.familyList.setSelectedValue(font.getFamily(), true);
            this.familyField.setText(font.getFamily());
            this.sizeList.setSelectedValue(String.valueOf(font.getSize()), true);
            this.sizeField.setText(String.valueOf(font.getSize()));
            this.styleList.setSelectedIndex(font.getStyle());
        } else {
            this.sizeList.setSelectedValue("12", true);
            this.styleList.setSelectedIndex(0);
        }
        this.styleField.setText((String)this.styleList.getSelectedValue());
        ListHandler listHandler = new ListHandler();
        this.familyList.addListSelectionListener(listHandler);
        this.sizeList.addListSelectionListener(listHandler);
        this.styleList.addListSelectionListener(listHandler);
        content.add("North", listPanel);
        this.preview = new JLabel(jEdit.getProperty("font-selector.long-text")){

            @Override
            public void paintComponent(Graphics g) {
                if (FontSelectorDialog.this.fontSelector != null) {
                    FontSelectorDialog.this.fontSelector.setAntiAliasEnabled(g);
                }
                super.paintComponent(g);
            }
        };
        this.preview.setBorder(new TitledBorder(jEdit.getProperty("font-selector.preview")));
        this.updatePreview();
        Dimension prefSize = this.preview.getPreferredSize();
        prefSize.height = 50;
        this.preview.setPreferredSize(prefSize);
        content.add("Center", this.preview);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private static String[] getFontList() {
        String[] nameArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        ArrayList<String> nameVector = new ArrayList<String>(nameArray.length);
        for (int i = 0; i < nameArray.length; ++i) {
            int j;
            for (j = 0; j < HIDEFONTS.length && !nameArray[i].contains(HIDEFONTS[j]); ++j) {
            }
            if (j != HIDEFONTS.length) continue;
            nameVector.add(nameArray[i]);
        }
        String[] _array = new String[nameVector.size()];
        return nameVector.toArray(_array);
    }

    private static JPanel createTextFieldAndListPanel(String label, JTextField textField, JList list) {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.fill = 1;
        cons.weightx = 1.0;
        JLabel _label = new JLabel(jEdit.getProperty(label));
        layout.setConstraints(_label, cons);
        panel.add(_label);
        cons.gridy = 1;
        Component vs = Box.createVerticalStrut(6);
        layout.setConstraints(vs, cons);
        panel.add(vs);
        cons.gridy = 2;
        layout.setConstraints(textField, cons);
        panel.add(textField);
        cons.gridy = 3;
        vs = Box.createVerticalStrut(6);
        layout.setConstraints(vs, cons);
        panel.add(vs);
        cons.gridy = 4;
        cons.gridheight = 0;
        cons.weighty = 1.0;
        JScrollPane scroller = new JScrollPane(list);
        layout.setConstraints(scroller, cons);
        panel.add(scroller);
        return panel;
    }

    private void updatePreview() {
        int size;
        String family = this.familyField.getText();
        try {
            size = Integer.parseInt(this.sizeField.getText());
        }
        catch (Exception e) {
            size = 12;
        }
        int style = this.styleList.getSelectedIndex();
        this.preview.setFont(new Font(family, style, size));
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            String style;
            Object source = evt.getSource();
            if (source == FontSelectorDialog.this.familyList) {
                String family = (String)FontSelectorDialog.this.familyList.getSelectedValue();
                if (family != null) {
                    FontSelectorDialog.this.familyField.setText(family);
                }
            } else if (source == FontSelectorDialog.this.sizeList) {
                String size = (String)FontSelectorDialog.this.sizeList.getSelectedValue();
                if (size != null) {
                    FontSelectorDialog.this.sizeField.setText(size);
                }
            } else if (source == FontSelectorDialog.this.styleList && (style = (String)FontSelectorDialog.this.styleList.getSelectedValue()) != null) {
                FontSelectorDialog.this.styleField.setText(style);
            }
            FontSelectorDialog.this.updatePreview();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == FontSelectorDialog.this.ok) {
                FontSelectorDialog.this.ok();
            } else if (evt.getSource() == FontSelectorDialog.this.cancel) {
                FontSelectorDialog.this.cancel();
            }
        }
    }
}

