/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.EnhancedTreeCellRenderer;

public class FilesChangedDialog
extends EnhancedDialog {
    private View view;
    private JTree bufferTree;
    private DefaultTreeModel bufferTreeModel;
    private DefaultMutableTreeNode root;
    private JButton selectAll;
    private boolean selectAllInProgress;
    private JButton reload;
    private JButton ignore;
    private JButton close;

    public FilesChangedDialog(View view, int[] states, boolean alreadyReloaded) {
        super(view, jEdit.getProperty("files-changed.title"), false);
        this.view = view;
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        Box iconBox = new Box(1);
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.warningIcon")));
        iconBox.add(Box.createGlue());
        content.add("West", iconBox);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(jEdit.getProperty("files-changed.caption"));
        label.setBorder(new EmptyBorder(0, 0, 6, 0));
        centerPanel.add("North", label);
        DefaultMutableTreeNode deleted = new DefaultMutableTreeNode(jEdit.getProperty("files-changed.deleted"), true);
        DefaultMutableTreeNode changed = new DefaultMutableTreeNode(jEdit.getProperty("files-changed.changed" + (alreadyReloaded ? "-auto" : "")), true);
        DefaultMutableTreeNode changedDirty = new DefaultMutableTreeNode(jEdit.getProperty("files-changed.changed-dirty" + (alreadyReloaded ? "-auto" : "")), true);
        Buffer[] buffers = jEdit.getBuffers();
        for (int i = 0; i < states.length; ++i) {
            DefaultMutableTreeNode addTo;
            Buffer buffer = buffers[i];
            switch (states[i]) {
                case 2: {
                    addTo = deleted;
                    break;
                }
                case 1: {
                    addTo = buffer.isDirty() ? changedDirty : changed;
                    break;
                }
                default: {
                    addTo = null;
                }
            }
            if (addTo == null) continue;
            addTo.add(new DefaultMutableTreeNode(buffer.getPath()));
        }
        this.root = new DefaultMutableTreeNode("", true);
        if (deleted.getChildCount() != 0) {
            this.root.add(deleted);
        }
        if (changed.getChildCount() != 0) {
            this.root.add(changed);
        }
        if (changedDirty.getChildCount() != 0) {
            this.root.add(changedDirty);
        }
        this.bufferTreeModel = new DefaultTreeModel(this.root);
        this.bufferTree = new JTree(this.bufferTreeModel);
        this.bufferTree.setRootVisible(false);
        this.bufferTree.setVisibleRowCount(10);
        this.bufferTree.setCellRenderer(new Renderer());
        this.bufferTree.getSelectionModel().addTreeSelectionListener(new TreeHandler());
        this.bufferTree.getSelectionModel().setSelectionMode(4);
        centerPanel.add("Center", new JScrollPane(this.bufferTree));
        content.add("Center", centerPanel);
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        if (!alreadyReloaded) {
            this.selectAll = new JButton(jEdit.getProperty("files-changed.select-all"));
            this.selectAll.setMnemonic(jEdit.getProperty("files-changed.select-all.mnemonic").charAt(0));
            buttons.add(this.selectAll);
            this.selectAll.addActionListener(new ActionHandler());
            buttons.add(Box.createHorizontalStrut(12));
            this.reload = new JButton(jEdit.getProperty("files-changed.reload"));
            this.reload.setMnemonic(jEdit.getProperty("files-changed.reload.mnemonic").charAt(0));
            buttons.add(this.reload);
            this.reload.addActionListener(new ActionHandler());
            buttons.add(Box.createHorizontalStrut(12));
            this.ignore = new JButton(jEdit.getProperty("files-changed.ignore"));
            this.ignore.setMnemonic(jEdit.getProperty("files-changed.ignore.mnemonic").charAt(0));
            buttons.add(this.ignore);
            this.ignore.addActionListener(new ActionHandler());
            buttons.add(Box.createHorizontalStrut(12));
        }
        this.close = new JButton(jEdit.getProperty("common.close"));
        this.getRootPane().setDefaultButton(this.close);
        buttons.add(this.close);
        this.close.addActionListener(new ActionHandler());
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.bufferTree.expandPath(new TreePath(new Object[]{this.root, deleted}));
        this.bufferTree.expandPath(new TreePath(new Object[]{this.root, changed}));
        this.bufferTree.expandPath(new TreePath(new Object[]{this.root, changedDirty}));
        GUIUtilities.requestFocus(this, this.bufferTree);
        this.updateEnabled();
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    private void updateEnabled() {
        TreePath[] paths = this.bufferTree.getSelectionPaths();
        boolean enabled = false;
        if (paths != null) {
            for (TreePath tp : paths) {
                Object[] path = tp.getPath();
                if (path.length != 3) continue;
                enabled = true;
            }
        }
        if (this.reload != null) {
            this.reload.setEnabled(enabled);
        }
        if (this.ignore != null) {
            this.ignore.setEnabled(enabled);
        }
    }

    private void selectAll() {
        this.selectAllInProgress = true;
        Object[] path = new TreeNode[3];
        path[0] = this.root;
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            path[1] = node;
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)node.getChildAt(j);
                path[2] = node2;
                this.bufferTree.getSelectionModel().addSelectionPath(new TreePath(path));
            }
        }
        this.selectAllInProgress = false;
        this.updateEnabled();
    }

    private void action(String action) {
        TreePath[] paths = this.bufferTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        int row = this.bufferTree.getRowForPath(paths[0]);
        for (TreePath path : paths) {
            if (path.getPathCount() == 2) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!(node.getUserObject() instanceof String)) {
                return;
            }
            Buffer buffer = jEdit.getBuffer((String)node.getUserObject());
            if (buffer == null) {
                return;
            }
            if ("RELOAD".equals(action)) {
                buffer.reload(this.view);
            } else {
                buffer.setAutoReload(false);
                buffer.setAutoReloadDialog(false);
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            parent.remove(node);
        }
        this.bufferTreeModel.reload(this.root);
        Object[] nodes = new TreeNode[]{this.root, null};
        for (int j = 0; j < this.root.getChildCount(); ++j) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(j);
            if (this.root.getChildAt(j).getChildCount() == 0) {
                this.root.remove(j);
                --j;
                continue;
            }
            nodes[1] = node;
            this.bufferTree.expandPath(new TreePath(nodes));
        }
        if (this.root.getChildCount() == 0) {
            this.dispose();
        } else {
            TreePath path;
            if (row >= this.bufferTree.getRowCount()) {
                row = this.bufferTree.getRowCount() - 1;
            }
            if ((path = this.bufferTree.getPathForRow(row)).getPathCount() == 2) {
                this.bufferTree.setSelectionRow(row + 1);
            } else {
                this.bufferTree.setSelectionPath(path);
            }
        }
    }

    static class Renderer
    extends EnhancedTreeCellRenderer {
        private Font entryFont = UIManager.getFont("Tree.font");
        private Font groupFont;

        Renderer() {
            if (this.entryFont == null) {
                this.entryFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.groupFont = this.entryFont.deriveFont(1);
        }

        @Override
        protected TreeCellRenderer newInstance() {
            return new Renderer();
        }

        @Override
        protected void configureTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getParent() == tree.getModel().getRoot()) {
                this.setFont(this.groupFont);
            } else {
                this.setFont(this.entryFont);
            }
            this.setIcon(null);
        }
    }

    class TreeHandler
    implements TreeSelectionListener {
        TreeHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            Buffer buffer;
            if (FilesChangedDialog.this.selectAllInProgress) {
                return;
            }
            FilesChangedDialog.this.updateEnabled();
            TreePath[] paths = FilesChangedDialog.this.bufferTree.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return;
            }
            TreePath path = paths[paths.length - 1];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof String && (buffer = jEdit.getBuffer((String)node.getUserObject())) != null) {
                FilesChangedDialog.this.view.showBuffer(buffer);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == FilesChangedDialog.this.selectAll) {
                FilesChangedDialog.this.selectAll();
            } else if (source == FilesChangedDialog.this.reload) {
                FilesChangedDialog.this.action("RELOAD");
            } else if (source == FilesChangedDialog.this.close) {
                FilesChangedDialog.this.dispose();
            } else if (source == FilesChangedDialog.this.ignore) {
                FilesChangedDialog.this.action("IGNORE");
            }
        }
    }
}

