/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputMethodRequests;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.JEditActionContext;
import org.gjt.sp.jedit.JEditActionSet;
import org.gjt.sp.jedit.JEditBeanShellAction;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.input.DefaultInputHandlerProvider;
import org.gjt.sp.jedit.input.InputHandlerProvider;
import org.gjt.sp.jedit.input.TextAreaInputHandler;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.ElasticTabstopsTabExpander;
import org.gjt.sp.jedit.textarea.FoldPainter;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.InputMethodSupport;
import org.gjt.sp.jedit.textarea.MouseActions;
import org.gjt.sp.jedit.textarea.ScrollLayout;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.SelectionManager;
import org.gjt.sp.jedit.textarea.StatusListener;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextAreaBorder;
import org.gjt.sp.jedit.textarea.TextAreaDropHandler;
import org.gjt.sp.jedit.textarea.TextAreaException;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.jedit.textarea.TriangleFoldPainter;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.ThreadUtilities;

public abstract class TextArea
extends JComponent {
    public static final int NO_SCROLL = 0;
    public static final int NORMAL_SCROLL = 1;
    public static final int ELECTRIC_SCROLL = 2;
    static TextArea focusedComponent;
    MouseInputAdapter mouseHandler;
    final ChunkCache chunkCache;
    DisplayManager displayManager;
    final SelectionManager selectionManager;
    private JEditActionContext<JEditBeanShellAction, JEditActionSet<JEditBeanShellAction>> actionContext;
    boolean bufferChanging;
    int maxHorizontalScrollWidth;
    String wrap;
    boolean hardWrap;
    boolean softWrap;
    boolean wrapToWidth;
    int maxLineLen;
    int wrapMargin;
    float tabSize;
    int charWidth;
    boolean scrollBarsInitialized;
    final Point offsetXY;
    boolean lastLinePartial;
    boolean blink;
    private static final Timer caretTimer;
    private static final Timer structureTimer;
    protected JPopupMenu popup;
    private boolean popupEnabled;
    private final Gutter gutter;
    protected final TextAreaPainter painter;
    private final EventListenerList listenerList;
    private final MutableCaretEvent caretEvent;
    private boolean caretBlinks;
    private final ElasticTabstopsTabExpander elasticTabstopsExpander = new ElasticTabstopsTabExpander(this);
    protected InputHandlerProvider inputHandlerProvider;
    private InputMethodSupport inputMethodSupport;
    private int physLastLine;
    private int screenLastLine;
    private int visibleLines;
    private int electricScroll;
    private int horizontalOffset;
    private boolean quickCopy;
    private final Box verticalBox;
    private final JScrollBar vertical;
    private final JScrollBar horizontal;
    protected JEditBuffer buffer;
    protected int caret;
    protected int caretLine;
    private int caretScreenLine;
    private final List<StructureMatcher> structureMatchers;
    private StructureMatcher.Match match;
    private int magicCaret;
    protected boolean multi;
    private boolean overwrite;
    private boolean rectangularSelectionMode;
    private boolean dndEnabled;
    private boolean queuedCaretUpdate;
    private int queuedScrollMode;
    private boolean queuedFireCaretEvent;
    private int oldCaretLine;
    private boolean joinNonWordChars;
    private boolean ctrlForRectangularSelection;

    protected TextArea(IPropertyManager propertyManager, InputHandlerProvider inputHandlerProvider) {
        this.inputHandlerProvider = inputHandlerProvider;
        this.enableEvents(12L);
        this.selectionManager = new SelectionManager(this);
        this.chunkCache = new ChunkCache(this);
        this.painter = new TextAreaPainter(this);
        this.gutter = new Gutter(this);
        this.gutter.setMouseActionsProvider(new MouseActions(propertyManager, "gutter"));
        this.listenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.blink = true;
        this.offsetXY = new Point();
        this.structureMatchers = new LinkedList<StructureMatcher>();
        this.structureMatchers.add(new StructureMatcher.BracketMatcher());
        this.setLayout(new ScrollLayout());
        this.add("center", this.painter);
        this.add("left", this.gutter);
        this.verticalBox = new Box(0);
        this.vertical = new JScrollBar(1);
        this.verticalBox.add(this.vertical);
        this.vertical.setRequestFocusEnabled(false);
        this.add("right", this.verticalBox);
        this.horizontal = new JScrollBar(0);
        this.add("bottom", this.horizontal);
        this.horizontal.setRequestFocusEnabled(false);
        this.horizontal.setValues(0, 0, 0, 0);
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            this.setBorder(new TextAreaBorder());
            this.vertical.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
            this.horizontal.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.addFocusListener(new FocusHandler());
        this.addMouseWheelListener(new MouseWheelHandler());
        focusedComponent = this;
    }

    public FoldPainter getFoldPainter() {
        return new TriangleFoldPainter();
    }

    public void initInputHandler() {
        this.actionContext = new JEditActionContext<JEditBeanShellAction, JEditActionSet<JEditBeanShellAction>>(){

            @Override
            public void invokeAction(EventObject evt, JEditBeanShellAction action) {
                action.invoke(TextArea.this);
            }
        };
        this.setMouseHandler(new TextAreaMouseHandler(this));
        this.inputHandlerProvider = new DefaultInputHandlerProvider(new TextAreaInputHandler(this){

            @Override
            protected JEditBeanShellAction getAction(String action) {
                return (JEditBeanShellAction)TextArea.this.actionContext.getAction(action);
            }
        });
    }

    public JEditActionContext<JEditBeanShellAction, JEditActionSet<JEditBeanShellAction>> getActionContext() {
        return this.actionContext;
    }

    public void setMouseHandler(MouseInputAdapter mouseInputAdapter) {
        this.mouseHandler = mouseInputAdapter;
        this.painter.addMouseListener(this.mouseHandler);
        this.painter.addMouseMotionListener(this.mouseHandler);
    }

    @Override
    public void setTransferHandler(TransferHandler newHandler) {
        super.setTransferHandler(newHandler);
        try {
            this.getDropTarget().addDropTargetListener(new TextAreaDropHandler(this));
        }
        catch (TooManyListenersException e) {
            Log.log(9, this, e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        String baseVersion = super.toString();
        int len = baseVersion.length() - 1;
        builder.append(baseVersion);
        builder.setLength(len);
        builder.append(",caret=").append(this.caret);
        builder.append(",caretLine=").append(this.caretLine);
        builder.append(",caretScreenLine=").append(this.caretScreenLine);
        builder.append(",electricScroll=").append(this.electricScroll);
        builder.append(",horizontalOffset=").append(this.horizontalOffset);
        builder.append(",magicCaret=").append(this.magicCaret);
        builder.append(",offsetXY=").append(this.offsetXY.toString());
        builder.append(",oldCaretLine=").append(this.oldCaretLine);
        builder.append(",screenLastLine=").append(this.screenLastLine);
        builder.append(",visibleLines=").append(this.visibleLines);
        builder.append(",firstPhysicalLine=").append(this.getFirstPhysicalLine());
        builder.append(",physLastLine=").append(this.physLastLine).append("]");
        return builder.toString();
    }

    public void dispose() {
        DisplayManager.textAreaDisposed(this);
        this.gutter.dispose();
    }

    public AbstractInputHandler getInputHandler() {
        return this.inputHandlerProvider.getInputHandler();
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final Gutter getGutter() {
        return this.gutter;
    }

    public DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean caretBlinks) {
        this.caretBlinks = caretBlinks;
        if (!caretBlinks) {
            this.blink = false;
        }
        if (this.buffer != null) {
            this.invalidateLine(this.caretLine);
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int electricScroll) {
        this.electricScroll = electricScroll;
    }

    public final boolean isQuickCopyEnabled() {
        return this.quickCopy;
    }

    public final void setQuickCopyEnabled(boolean quickCopy) {
        this.quickCopy = quickCopy;
    }

    public final JEditBuffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(JEditBuffer buffer) {
        if (this.buffer == buffer) {
            return;
        }
        try {
            this.bufferChanging = true;
            boolean inCompoundEdit = false;
            if (this.buffer != null) {
                if (!this.buffer.isLoading()) {
                    this.selectNone();
                }
                this.caretScreenLine = 0;
                this.caret = 0;
                this.caretLine = 0;
                this.match = null;
                inCompoundEdit = this.buffer.insideCompoundEdit();
                if (inCompoundEdit) {
                    this.buffer.endCompoundEdit();
                }
            }
            this.buffer = buffer;
            if (inCompoundEdit) {
                this.buffer.beginCompoundEdit();
            }
            this.chunkCache.setBuffer(buffer);
            this.gutter.setBuffer(buffer);
            this.propertiesChanged();
            if (this.displayManager != null) {
                this.displayManager.release();
            }
            this.displayManager = DisplayManager.getDisplayManager(buffer, this);
            this.displayManager.init();
            if (buffer.isLoading()) {
                this.updateScrollBar();
            }
            this.repaint();
            this.fireScrollEvent(true);
        }
        finally {
            this.bufferChanging = false;
        }
    }

    public final boolean isEditable() {
        return this.buffer.isEditable();
    }

    public boolean isDragEnabled() {
        return this.dndEnabled;
    }

    public void setDragEnabled(boolean dndEnabled) {
        this.dndEnabled = dndEnabled;
    }

    public boolean getJoinNonWordChars() {
        return this.joinNonWordChars;
    }

    public void setJoinNonWordChars(boolean joinNonWordChars) {
        this.joinNonWordChars = joinNonWordChars;
    }

    public boolean isCtrlForRectangularSelection() {
        return this.ctrlForRectangularSelection;
    }

    public void setCtrlForRectangularSelection(boolean ctrlForRectangularSelection) {
        this.ctrlForRectangularSelection = ctrlForRectangularSelection;
    }

    public final int getFirstLine() {
        return this.displayManager.firstLine.getScrollLine() + this.displayManager.firstLine.getSkew();
    }

    public void setFirstLine(int firstLine) {
        int max = this.displayManager.getScrollLineCount() - this.visibleLines + (this.lastLinePartial ? 1 : 0);
        if (firstLine > max) {
            firstLine = max;
        }
        if (firstLine < 0) {
            firstLine = 0;
        }
        int oldFirstLine = this.getFirstLine();
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "setFirstLine() from " + oldFirstLine + " to " + firstLine);
        }
        if (firstLine == oldFirstLine) {
            return;
        }
        this.displayManager.setFirstLine(oldFirstLine, firstLine);
        this.repaint();
        this.fireScrollEvent(true);
    }

    public final int getFirstPhysicalLine() {
        return this.displayManager.firstLine.getPhysicalLine();
    }

    public void setFirstPhysicalLine(int physFirstLine) {
        this.setFirstPhysicalLine(physFirstLine, 0);
    }

    public void setFirstPhysicalLine(int physFirstLine, int skew) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "setFirstPhysicalLine(" + physFirstLine + ',' + skew + ')');
        }
        int amount = physFirstLine - this.displayManager.firstLine.getPhysicalLine();
        this.displayManager.setFirstPhysicalLine(amount, skew);
        this.repaint();
        this.fireScrollEvent(true);
    }

    public final int getLastPhysicalLine() {
        return this.physLastLine;
    }

    public int getLastScreenLine() {
        return this.screenLastLine;
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        if (horizontalOffset > 0) {
            horizontalOffset = 0;
        }
        if (horizontalOffset == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = horizontalOffset;
        this.painter.repaint();
        this.fireScrollEvent(false);
    }

    public void scrollUpLine() {
        this.setFirstLine(this.getFirstLine() - 1);
    }

    public void scrollUpPage() {
        this.setFirstLine(this.getFirstLine() - this.getVisibleLines() + (this.lastLinePartial ? 1 : 0));
    }

    public void scrollDownLine() {
        this.setFirstLine(this.getFirstLine() + 1);
    }

    public void scrollDownPage() {
        this.setFirstLine(this.getFirstLine() + this.getVisibleLines() - (this.lastLinePartial ? 1 : 0));
    }

    public void scrollToCaret(boolean doElectricScroll) {
        this.scrollTo(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), doElectricScroll);
    }

    public void scrollTo(int offset, boolean doElectricScroll) {
        int line = this.buffer.getLineOfOffset(offset);
        this.scrollTo(line, offset - this.buffer.getLineStartOffset(line), doElectricScroll);
    }

    public void scrollTo(int line, int offset, boolean doElectricScroll) {
        int extraEndVirt;
        if (this.buffer.isLoading()) {
            return;
        }
        if (Debug.SCROLL_TO_DEBUG) {
            Log.log(1, this, "scrollTo(), lineCount=" + this.getLineCount());
        }
        if (this.visibleLines <= 1) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "visibleLines <= 0");
            }
            ChunkCache.LineInfo[] infos = this.chunkCache.getLineInfosForPhysicalLine(line);
            int subregion = ChunkCache.getSubregionOfOffset(offset, infos);
            this.setFirstPhysicalLine(line, subregion);
            return;
        }
        int lineLength = this.buffer.getLineLength(line);
        if (offset > lineLength) {
            extraEndVirt = this.charWidth * (offset - lineLength);
            offset = lineLength;
        } else {
            extraEndVirt = 0;
        }
        int _electricScroll = doElectricScroll && this.visibleLines - 1 > this.electricScroll << 1 ? this.electricScroll : 0;
        int screenLine = this.chunkCache.getScreenLineOfOffset(line, offset);
        int visibleLines = this.getVisibleLines();
        if (screenLine == -1) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "screenLine == -1");
            }
            ChunkCache.LineInfo[] infos = this.chunkCache.getLineInfosForPhysicalLine(line);
            int subregion = ChunkCache.getSubregionOfOffset(offset, infos);
            int prevLine = this.displayManager.getPrevVisibleLine(this.getFirstPhysicalLine());
            int nextLine = this.displayManager.getNextVisibleLine(this.getLastPhysicalLine());
            if (line == this.getFirstPhysicalLine()) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + this.getFirstPhysicalLine());
                }
                this.setFirstPhysicalLine(line, subregion - _electricScroll);
            } else if (line == prevLine) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + prevLine);
                }
                this.setFirstPhysicalLine(prevLine, subregion - _electricScroll);
            } else if (line == this.getLastPhysicalLine()) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + this.getLastPhysicalLine());
                }
                this.setFirstPhysicalLine(line, subregion + _electricScroll - visibleLines + (this.lastLinePartial ? 2 : 1));
            } else if (line == nextLine) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + nextLine);
                }
                this.setFirstPhysicalLine(nextLine, subregion + _electricScroll - visibleLines + (this.lastLinePartial ? 2 : 1));
            } else {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, "neither");
                    Log.log(1, this, "Last physical line is " + this.getLastPhysicalLine());
                }
                this.setFirstPhysicalLine(line, subregion - (visibleLines >> 1));
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, "Last physical line is " + this.getLastPhysicalLine());
                }
            }
        } else if (screenLine < _electricScroll) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "electric up");
            }
            this.setFirstLine(this.getFirstLine() - _electricScroll + screenLine);
        } else if (screenLine > visibleLines - _electricScroll - (this.lastLinePartial ? 2 : 1)) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "electric down");
            }
            this.setFirstLine(this.getFirstLine() + _electricScroll - visibleLines + screenLine + (this.lastLinePartial ? 2 : 1));
        }
        if (!this.displayManager.isLineVisible(line)) {
            return;
        }
        Point point = this.offsetToXY(line, offset, this.offsetXY);
        point.x += extraEndVirt;
        if (point.x < 0) {
            this.setHorizontalOffset(this.horizontalOffset - point.x + this.charWidth + 5);
        } else if (point.x >= this.painter.getWidth() - this.charWidth - 5) {
            this.setHorizontalOffset(this.horizontalOffset + (this.painter.getWidth() - point.x) - this.charWidth - 5);
        }
    }

    public final void addScrollListener(ScrollListener listener) {
        this.listenerList.add(ScrollListener.class, listener);
    }

    public final void removeScrollListener(ScrollListener listener) {
        this.listenerList.remove(ScrollListener.class, listener);
    }

    public int getPhysicalLineOfScreenLine(int screenLine) {
        return this.chunkCache.getLineInfo((int)screenLine).physicalLine;
    }

    public Chunk getChunksOfScreenLine(int screenLine) {
        return this.chunkCache.getLineInfo((int)screenLine).chunks;
    }

    public int getScreenLineOfOffset(int offset) {
        int line = this.buffer.getLineOfOffset(offset);
        return this.chunkCache.getScreenLineOfOffset(line, offset -= this.buffer.getLineStartOffset(line));
    }

    public int getScreenLineStartOffset(int line) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(line);
        if (lineInfo.physicalLine == -1) {
            return -1;
        }
        return this.buffer.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset;
    }

    public int getScreenLineEndOffset(int line) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(line);
        if (lineInfo.physicalLine == -1) {
            return -1;
        }
        return this.buffer.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset + lineInfo.length;
    }

    public int xyToOffset(int x, int y) {
        return this.xyToOffset(x, y, true);
    }

    public int xyToOffset(int x, int y, boolean round) {
        int height = this.painter.getLineHeight();
        int line = y / height;
        if (line < 0 || line >= this.visibleLines) {
            return -1;
        }
        return this.xToScreenLineOffset(line, x, round);
    }

    public int xToScreenLineOffset(int screenLine, int x, boolean round) {
        int lower;
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(screenLine);
        if (lineInfo.physicalLine == -1) {
            return this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        }
        float xInLine = x - this.horizontalOffset;
        int offsetInLine = Chunk.xToOffset(lineInfo.chunks, xInLine, false);
        int lineStartOffset = this.getLineStartOffset(lineInfo.physicalLine);
        if (offsetInLine == -1 || offsetInLine == lineInfo.offset + lineInfo.length) {
            return lineStartOffset + lineInfo.offset + lineInfo.length - 1;
        }
        int offset = lineStartOffset + offsetInLine;
        LineCharacterBreaker charBreaker = new LineCharacterBreaker(this, offset);
        int n = lower = charBreaker.offsetIsBoundary(offset) ? offset : charBreaker.previousOf(offset);
        if (round) {
            int upper;
            float upperX;
            float lowerX = Chunk.offsetToX(lineInfo.chunks, lower - lineStartOffset);
            return xInLine < (lowerX + (upperX = Chunk.offsetToX(lineInfo.chunks, (upper = charBreaker.nextOf(lower)) - lineStartOffset))) / 2.0f ? lower : upper;
        }
        return lower;
    }

    public Point offsetToXY(int offset) {
        int line = this.buffer.getLineOfOffset(offset);
        Point retVal = new Point();
        return this.offsetToXY(line, offset -= this.buffer.getLineStartOffset(line), retVal);
    }

    public Point offsetToXY(int line, int offset) {
        return this.offsetToXY(line, offset, new Point());
    }

    public Point offsetToXY(int line, int offset, Point retVal) {
        if (!this.displayManager.isLineVisible(line)) {
            return null;
        }
        int screenLine = this.chunkCache.getScreenLineOfOffset(line, offset);
        if (screenLine == -1) {
            return null;
        }
        retVal.y = screenLine * this.painter.getLineHeight();
        ChunkCache.LineInfo info = this.chunkCache.getLineInfo(screenLine);
        retVal.x = (int)((float)this.horizontalOffset + Chunk.offsetToX(info.chunks, offset));
        return retVal;
    }

    public void invalidateScreenLineRange(int start, int end) {
        if (this.buffer.isLoading()) {
            return;
        }
        if (start > end) {
            int tmp = end;
            end = start;
            start = tmp;
        }
        if (this.chunkCache.needFullRepaint()) {
            end = this.visibleLines;
        }
        int y = start * this.painter.getLineHeight();
        int height = (end - start + 1) * this.painter.getLineHeight();
        this.painter.repaint(0, y, this.painter.getWidth(), height);
        this.gutter.repaint(0, y, this.gutter.getWidth(), height);
    }

    public void invalidateLine(int line) {
        if (!this.isShowing() || this.buffer.isLoading() || line < this.getFirstPhysicalLine() || line > this.physLastLine || !this.displayManager.isLineVisible(line)) {
            return;
        }
        int startLine = -1;
        int endLine = -1;
        for (int i = 0; i < this.visibleLines; ++i) {
            ChunkCache.LineInfo info = this.chunkCache.getLineInfo(i);
            if ((info.physicalLine >= line || info.physicalLine == -1) && startLine == -1) {
                startLine = i;
            }
            if ((info.physicalLine < line || !info.lastSubregion) && info.physicalLine != -1) continue;
            endLine = i;
            break;
        }
        if (this.chunkCache.needFullRepaint() || endLine == -1) {
            endLine = this.visibleLines;
        }
        this.invalidateScreenLineRange(startLine, endLine);
    }

    public void invalidateLineRange(int start, int end) {
        if (!this.isShowing() || this.buffer.isLoading()) {
            return;
        }
        if (end < start) {
            int tmp = end;
            end = start;
            start = tmp;
        }
        if (end < this.getFirstPhysicalLine() || start > this.getLastPhysicalLine()) {
            return;
        }
        int startScreenLine = -1;
        int endScreenLine = -1;
        for (int i = 0; i < this.visibleLines; ++i) {
            ChunkCache.LineInfo info = this.chunkCache.getLineInfo(i);
            if ((info.physicalLine >= start || info.physicalLine == -1) && startScreenLine == -1) {
                startScreenLine = i;
            }
            if ((info.physicalLine < end || !info.lastSubregion) && info.physicalLine != -1) continue;
            endScreenLine = i;
            break;
        }
        if (startScreenLine == -1) {
            startScreenLine = 0;
        }
        if (this.chunkCache.needFullRepaint() || endScreenLine == -1) {
            endScreenLine = this.visibleLines;
        }
        this.invalidateScreenLineRange(startScreenLine, endScreenLine);
    }

    public final int getBufferLength() {
        return this.buffer.getLength();
    }

    public final int getLineCount() {
        return this.buffer.getLineCount();
    }

    public final int getLineOfOffset(int offset) {
        return this.buffer.getLineOfOffset(offset);
    }

    public int getLineStartOffset(int line) {
        return this.buffer.getLineStartOffset(line);
    }

    public int getLineEndOffset(int line) {
        return this.buffer.getLineEndOffset(line);
    }

    public int getLineLength(int line) {
        return this.buffer.getLineLength(line);
    }

    public final String getText(int start, int len) {
        return this.buffer.getText(start, len);
    }

    public final void getText(int start, int len, Segment segment) {
        this.buffer.getText(start, len, segment);
    }

    public String getText() {
        return this.buffer.getText(0, this.buffer.getLength());
    }

    public final String getLineText(int lineIndex) {
        return this.buffer.getLineText(lineIndex);
    }

    public final void getLineText(int lineIndex, Segment segment) {
        this.buffer.getLineText(lineIndex, segment);
    }

    public String getVisibleLineText(int screenLine) {
        int offset = -this.getHorizontalOffset();
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(screenLine);
        int lineStartOffset = this.getLineStartOffset(lineInfo.physicalLine);
        Point point = this.offsetToXY(lineStartOffset + lineInfo.offset);
        int begin = this.xyToOffset(offset + point.x, point.y);
        int end = this.xyToOffset(this.getPainter().getWidth(), point.y);
        return this.buffer.getText(begin, end - begin);
    }

    public void getVisibleLineText(int screenLine, Segment segment) {
        int offset = -this.getHorizontalOffset();
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(screenLine);
        int lineStartOffset = this.getLineStartOffset(lineInfo.physicalLine);
        Point point = this.offsetToXY(lineStartOffset + lineInfo.offset);
        int begin = this.xyToOffset(offset + point.x, point.y);
        int end = this.xyToOffset(this.getPainter().getWidth(), point.y);
        this.buffer.getText(begin, end - begin, segment);
    }

    public CharSequence getVisibleLineSegment(int screenLine) {
        int offset = -this.getHorizontalOffset();
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(screenLine);
        int lineStartOffset = this.getLineStartOffset(lineInfo.physicalLine);
        Point point = this.offsetToXY(lineStartOffset + lineInfo.offset);
        int begin = this.xyToOffset(offset + point.x, point.y);
        int end = this.xyToOffset(this.getPainter().getWidth(), point.y);
        return this.buffer.getSegment(begin, end - begin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.remove(0, this.buffer.getLength());
            this.buffer.insert(0, text);
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    public final void selectAll() {
        int firstLine = this.getFirstLine();
        int horizOffset = this.getHorizontalOffset();
        this.setSelection(new Selection.Range(0, this.buffer.getLength()));
        this.moveCaretPosition(this.buffer.getLength(), true);
        this.setFirstLine(firstLine);
        this.setHorizontalOffset(horizOffset);
    }

    public void selectLine() {
        int caretLine = this.getCaretLine();
        int start = this.getLineStartOffset(caretLine);
        int end = this.getLineEndOffset(caretLine) - 1;
        Selection.Range s = new Selection.Range(start, end);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(end);
    }

    public void selectParagraph() {
        int start;
        int caretLine = this.getCaretLine();
        if (this.getLineLength(caretLine) == 0) {
            this.getToolkit().beep();
            return;
        }
        int end = caretLine;
        for (start = caretLine; start >= 0 && this.getLineLength(start) != 0; --start) {
        }
        while (end < this.getLineCount() && this.getLineLength(end) != 0) {
            ++end;
        }
        int selectionStart = this.getLineStartOffset(start + 1);
        int selectionEnd = this.getLineEndOffset(end - 1) - 1;
        Selection.Range s = new Selection.Range(selectionStart, selectionEnd);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(selectionEnd);
    }

    public void selectWord() {
        int line = this.getCaretLine();
        int lineStart = this.getLineStartOffset(line);
        int offset = this.getCaretPosition() - lineStart;
        if (this.getLineLength(line) == 0) {
            return;
        }
        String lineText = this.getLineText(line);
        String noWordSep = this.buffer.getStringProperty("noWordSep");
        if (offset == this.getLineLength(line)) {
            --offset;
        }
        int wordStart = TextUtilities.findWordStart(lineText, offset, noWordSep, true, false, false);
        int wordEnd = TextUtilities.findWordEnd(lineText, offset + 1, noWordSep, true, false, false);
        Selection.Range s = new Selection.Range(lineStart + wordStart, lineStart + wordEnd);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(lineStart + wordEnd);
    }

    public Selection selectToMatchingBracket(int position, boolean quickCopy) {
        int bracket;
        int positionLine = this.buffer.getLineOfOffset(position);
        int lineOffset = position - this.buffer.getLineStartOffset(positionLine);
        if (this.getLineLength(positionLine) != 0 && (bracket = TextUtilities.findMatchingBracket(this.buffer, positionLine, Math.max(0, lineOffset - 1))) != -1) {
            Selection.Range s;
            if (bracket < position) {
                if (!quickCopy) {
                    this.moveCaretPosition(position, false);
                }
                s = new Selection.Range(bracket, position);
            } else {
                if (!quickCopy) {
                    this.moveCaretPosition(bracket + 1, false);
                }
                s = new Selection.Range(position - 1, bracket + 1);
            }
            if (!this.multi && !quickCopy) {
                this.selectNone();
            }
            this.addToSelection(s);
            return s;
        }
        return null;
    }

    public void selectToMatchingBracket() {
        this.selectToMatchingBracket(this.caret, false);
    }

    public void selectBlock() {
        char c;
        int start;
        int end;
        Selection s = this.getSelectionAtOffset(this.caret);
        if (s == null) {
            start = end = this.caret;
        } else {
            start = s.start;
            end = s.end;
        }
        String text = this.getText(0, this.buffer.getLength());
        if (start == 0) {
            this.getToolkit().beep();
            return;
        }
        String openBrackets = "([{\u00ab\u2039\u27e8\u2308\u230a\u2987\u27e6\u2983";
        String closeBrackets = ")]}\u00bb\u203a\u27e9\u2309\u230b\u2988\u27e7\u2984'";
        int count = 1;
        char openBracket = '\u0000';
        char closeBracket = '\u0000';
        while (--start >= 0) {
            c = text.charAt(start);
            int index = openBrackets.indexOf(c);
            if (index != -1) {
                if (--count != 0) continue;
                openBracket = c;
                closeBracket = closeBrackets.charAt(index);
                break;
            }
            if (closeBrackets.indexOf(c) == -1) continue;
            ++count;
        }
        count = 1;
        if (openBracket == '\u0000') {
            this.getToolkit().beep();
            return;
        }
        do {
            if ((c = text.charAt(end)) == closeBracket) {
                if (--count != 0) continue;
                ++end;
                break;
            }
            if (c != openBracket) continue;
            ++count;
        } while (++end < this.buffer.getLength());
        s = new Selection.Range(start, end);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(end);
    }

    public boolean lineInStructureScope(int line) {
        if (this.match == null) {
            return false;
        }
        if (this.match.startLine < this.caretLine) {
            return line >= this.match.startLine && line <= this.caretLine;
        }
        return line <= this.match.endLine && line >= this.caretLine;
    }

    public final void invertSelection() {
        this.selectionManager.invertSelection();
    }

    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    @Nonnull
    public Selection[] getSelection() {
        return this.selectionManager.getSelection();
    }

    public Selection getSelection(int index) {
        return this.selectionManager.selection.get(index);
    }

    public Iterator<Selection> getSelectionIterator() {
        return this.selectionManager.selection.iterator();
    }

    public void selectNone() {
        this.invalidateSelectedLines();
        this.setSelection((Selection)null);
    }

    public void setSelection(Selection[] selection) {
        this.invalidateSelectedLines();
        this.selectionManager.setSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void setSelection(Selection selection) {
        this.invalidateSelectedLines();
        this.selectionManager.setSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void addToSelection(Selection[] selection) {
        this.invalidateSelectedLines();
        this.selectionManager.addToSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void addToSelection(Selection selection) {
        this.invalidateSelectedLines();
        this.selectionManager.addToSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public Selection getSelectionAtOffset(int offset) {
        return this.selectionManager.getSelectionAtOffset(offset);
    }

    public void removeFromSelection(Selection sel) {
        this.invalidateSelectedLines();
        this.selectionManager.removeFromSelection(sel);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void removeFromSelection(int offset) {
        Selection sel = this.getSelectionAtOffset(offset);
        if (sel == null) {
            return;
        }
        this.invalidateSelectedLines();
        this.selectionManager.removeFromSelection(sel);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void resizeSelection(int offset, int end, int extraEndVirt, boolean rect) {
        Selection s = this.selectionManager.getSelectionAtOffset(offset);
        if (s != null) {
            this.invalidateLineRange(s.startLine, s.endLine);
            this.selectionManager.removeFromSelection(s);
        }
        this.selectionManager.resizeSelection(offset, end, extraEndVirt, rect);
        this.fireCaretEvent();
    }

    public void extendSelection(int offset, int end) {
        this.extendSelection(offset, end, 0, 0);
    }

    public void extendSelection(int offset, int end, int extraStartVirt, int extraEndVirt) {
        offset = this.getCharacterBoundaryAt(offset);
        end = this.getCharacterBoundaryAt(end);
        Selection s = this.getSelectionAtOffset(offset);
        if (s != null) {
            this.invalidateLineRange(s.startLine, s.endLine);
            this.selectionManager.removeFromSelection(s);
            if (offset == s.start) {
                offset = end;
                end = s.end;
            } else if (offset == s.end) {
                offset = s.start;
            }
        }
        if (end < offset) {
            int tmp = end;
            end = offset;
            offset = tmp;
        }
        if (this.rectangularSelectionMode) {
            s = new Selection.Rect(offset, end);
            ((Selection.Rect)s).extraStartVirt = extraStartVirt;
            ((Selection.Rect)s).extraEndVirt = extraEndVirt;
        } else {
            s = new Selection.Range(offset, end);
        }
        this.selectionManager.addToSelection(s);
        this.fireCaretEvent();
        if (this.rectangularSelectionMode && extraEndVirt != 0) {
            int line = this.getLineOfOffset(end);
            this.scrollTo(line, this.getLineLength(line) + extraEndVirt, false);
        }
    }

    public String getSelectedText(Selection s) {
        StringBuilder buf = new StringBuilder(s.end - s.start);
        s.getText(this.buffer, buf);
        return buf.toString();
    }

    public String getSelectedText(String separator) {
        Selection[] sel = this.selectionManager.getSelection();
        if (sel.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < sel.length; ++i) {
            if (i != 0) {
                buf.append(separator);
            }
            sel[i].getText(this.buffer, buf);
        }
        return buf.toString();
    }

    public String getSelectedText() {
        return this.getSelectedText("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedText(Selection s, String selectedText) {
        if (!this.isEditable()) {
            throw new InternalError("Text component read only");
        }
        try {
            this.buffer.beginCompoundEdit();
            this.moveCaretPosition(s.setText(this.buffer, selectedText));
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    public void setSelectedText(String selectedText) {
        int newCaret = this.replaceSelection(selectedText);
        if (newCaret != -1) {
            this.moveCaretPosition(newCaret);
        }
        this.selectNone();
    }

    public void setSelectedText(String selectedText, boolean moveCaret) {
        int newCaret = this.replaceSelection(selectedText);
        if (moveCaret && newCaret != -1) {
            this.moveCaretPosition(newCaret);
        }
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int replaceSelection(String selectedText) {
        if (!this.isEditable()) {
            throw new RuntimeException("Text component read only");
        }
        int newCaret = -1;
        if (this.getSelectionCount() == 0) {
            this.buffer.insert(this.caret, selectedText);
        } else {
            try {
                this.buffer.beginCompoundEdit();
                Selection[] selection = this.getSelection();
                for (int i = 0; i < selection.length; ++i) {
                    newCaret = selection[i].setText(this.buffer, selectedText);
                }
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
        return newCaret;
    }

    public int[] getSelectedLines() {
        if (this.selectionManager.getSelectionCount() == 0) {
            return new int[]{this.caretLine};
        }
        return this.selectionManager.getSelectedLines();
    }

    public boolean caretAutoScroll() {
        return focusedComponent == this;
    }

    public void addStructureMatcher(StructureMatcher matcher) {
        this.structureMatchers.add(matcher);
    }

    public void removeStructureMatcher(StructureMatcher matcher) {
        this.structureMatchers.remove(matcher);
    }

    public StructureMatcher.Match getStructureMatch() {
        return this.match;
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.invalidateLine(this.caretLine);
        } else {
            this.blink = true;
        }
    }

    public void centerCaret() {
        int offset = this.getScreenLineStartOffset(this.visibleLines >> 1);
        if (offset == -1) {
            this.getToolkit().beep();
        } else {
            this.setCaretPosition(offset);
        }
    }

    public void scrollAndCenterCaret() {
        if (!this.getDisplayManager().isLineVisible(this.getCaretLine())) {
            this.getDisplayManager().expandFold(this.getCaretLine(), true);
        }
        int physicalLine = this.getCaretLine();
        int midPhysicalLine = this.getPhysicalLineOfScreenLine(this.visibleLines >> 1);
        int diff = physicalLine - midPhysicalLine;
        this.setFirstLine(this.getFirstLine() + diff);
        this.requestFocus();
    }

    public void setCaretPosition(int newCaret) {
        this.selectNone();
        this.moveCaretPosition(newCaret, true);
    }

    public void setCaretPosition(int newCaret, boolean doElectricScroll) {
        this.selectNone();
        this.moveCaretPosition(newCaret, doElectricScroll);
    }

    public void moveCaretPosition(int newCaret) {
        this.moveCaretPosition(newCaret, true);
    }

    public void moveCaretPosition(int newCaret, boolean doElectricScroll) {
        this.moveCaretPosition(newCaret, doElectricScroll ? 2 : 1);
    }

    public void moveCaretPosition(int newCaret, int scrollMode) {
        if (newCaret < 0 || newCaret > this.buffer.getLength()) {
            throw new IllegalArgumentException("caret out of bounds: " + newCaret);
        }
        int oldCaretLine = this.caretLine;
        if (this.caret == newCaret) {
            this.finishCaretUpdate(oldCaretLine, scrollMode, false);
        } else {
            this.caret = this.getCharacterBoundaryAt(newCaret);
            this.caretLine = this.getLineOfOffset(this.caret);
            this.magicCaret = -1;
            this.finishCaretUpdate(oldCaretLine, scrollMode, true);
        }
    }

    public int getCaretPosition() {
        return this.caret;
    }

    public int getCaretLine() {
        return this.caretLine;
    }

    public int getMagicCaretPosition() {
        if (this.magicCaret == -1) {
            this.magicCaret = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        }
        return this.magicCaret;
    }

    public void setMagicCaretPosition(int magicCaret) {
        this.magicCaret = magicCaret;
    }

    public final void addCaretListener(CaretListener listener) {
        this.listenerList.add(CaretListener.class, listener);
    }

    public final void removeCaretListener(CaretListener listener) {
        this.listenerList.remove(CaretListener.class, listener);
    }

    public void goToNextBracket(boolean select) {
        int newCaret = -1;
        if (this.caret != this.buffer.getLength()) {
            String text = this.getText(this.caret, this.buffer.getLength() - this.caret - 1);
            block3: for (int i = 0; i < text.length(); ++i) {
                switch (text.charAt(i)) {
                    case ')': 
                    case ']': 
                    case '}': {
                        newCaret = this.caret + i + 1;
                        break block3;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
        }
        if (newCaret == -1) {
            this.getToolkit().beep();
        } else {
            if (select) {
                this.extendSelection(this.caret, newCaret);
            } else if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(newCaret);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void goToNextCharacter(boolean select) {
        int newCaret;
        int extraEndVirt;
        int extraStartVirt;
        block17: {
            block19: {
                Selection s;
                block18: {
                    s = this.getSelectionAtOffset(this.caret);
                    if (!select && s instanceof Selection.Range) {
                        if (!this.multi) {
                            this.setCaretPosition(s.end);
                            return;
                        }
                        if (this.caret != s.end) {
                            this.moveCaretPosition(s.end);
                            return;
                        }
                    }
                    if (s instanceof Selection.Rect) {
                        extraStartVirt = ((Selection.Rect)s).extraStartVirt;
                        extraEndVirt = ((Selection.Rect)s).extraEndVirt;
                    } else {
                        extraStartVirt = 0;
                        extraEndVirt = 0;
                    }
                    newCaret = this.caret;
                    if (this.caret != this.buffer.getLength()) break block18;
                    if (select && (this.rectangularSelectionMode || s instanceof Selection.Rect)) {
                        if (s != null && this.caret == s.start) {
                            ++extraStartVirt;
                            break block17;
                        } else {
                            ++extraEndVirt;
                        }
                        break block17;
                    } else {
                        this.getToolkit().beep();
                        return;
                    }
                }
                if (this.caret != this.getLineEndOffset(this.caretLine) - 1) break block19;
                if (select && (this.rectangularSelectionMode || s instanceof Selection.Rect)) {
                    if (s != null && this.caret == s.start) {
                        ++extraStartVirt;
                        break block17;
                    } else {
                        ++extraEndVirt;
                    }
                    break block17;
                } else {
                    int line = this.displayManager.getNextVisibleLine(this.caretLine);
                    if (line == -1) {
                        this.getToolkit().beep();
                        return;
                    }
                    newCaret = this.getLineStartOffset(line);
                }
                break block17;
            }
            newCaret = this.getNextCharacterOffset(this.caret);
        }
        if (select) {
            this.extendSelection(this.caret, newCaret, extraStartVirt, extraEndVirt);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToNextLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        boolean rectSelect = s == null ? this.rectangularSelectionMode : s instanceof Selection.Rect;
        int magic = this.getMagicCaretPosition();
        int newCaret = this.chunkCache.getBelowPosition(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), magic + 1, rectSelect && select);
        if (newCaret == -1) {
            int end = this.getLineEndOffset(this.caretLine) - 1;
            if (this.caret == end) {
                this.getToolkit().beep();
                return;
            }
            newCaret = end;
        }
        this._changeLine(select, newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToNextPage(boolean select) {
        int newCaret;
        this.scrollToCaret(false);
        int magic = this.getMagicCaretPosition();
        if (this.caretLine < this.displayManager.getFirstVisibleLine()) {
            this.caretLine = this.displayManager.getNextVisibleLine(this.caretLine);
        }
        if (this.getFirstLine() + this.getVisibleLines() >= this.displayManager.getScrollLineCount()) {
            int lastVisibleLine = this.displayManager.getLastVisibleLine();
            newCaret = this.getLineEndOffset(lastVisibleLine) - 1;
        } else {
            int caretScreenLine = this.getScreenLineOfOffset(this.caret);
            this.scrollDownPage();
            newCaret = this.xToScreenLineOffset(caretScreenLine, magic, true);
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret, false);
        this.setMagicCaretPosition(magic);
    }

    public void goToNextParagraph(boolean select) {
        int lineNo = this.getCaretLine();
        int newCaret = this.getBufferLength();
        boolean foundBlank = false;
        Segment lineSegment = new Segment();
        block3: for (int i = lineNo + 1; i < this.getLineCount(); ++i) {
            if (!this.displayManager.isLineVisible(i)) continue;
            this.getLineText(i, lineSegment);
            block4: for (int j = 0; j < lineSegment.count; ++j) {
                switch (lineSegment.array[lineSegment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        if (!foundBlank) continue block3;
                        newCaret = this.getLineStartOffset(i);
                        break block3;
                    }
                }
            }
            foundBlank = true;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToNextWord(boolean select) {
        this.goToNextWord(select, false);
    }

    public void goToNextWord(boolean select, boolean eatWhitespace) {
        String lineText;
        if (this.buffer.isLoading()) {
            return;
        }
        int lineStart = this.getLineStartOffset(this.caretLine);
        int newCaret = this.caret - lineStart;
        if (newCaret == (lineText = this.getLineText(this.caretLine)).length()) {
            int nextLine = this.displayManager.getNextVisibleLine(this.caretLine);
            if (nextLine == -1) {
                this.getToolkit().beep();
                return;
            }
            newCaret = this.getLineStartOffset(nextLine);
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            boolean camelCasedWords = this.buffer.getBooleanProperty("camelCasedWords");
            newCaret = TextUtilities.findWordEnd(lineText, newCaret + 1, noWordSep, true, camelCasedWords, eatWhitespace);
            newCaret += lineStart;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToPrevBracket(boolean select) {
        String text = this.getText(0, this.caret);
        int newCaret = -1;
        block3: for (int i = this.getCaretPosition() - 1; i >= 0; --i) {
            switch (text.charAt(i)) {
                case '(': 
                case '[': 
                case '{': {
                    newCaret = i;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (newCaret == -1) {
            this.getToolkit().beep();
        } else {
            if (select) {
                this.extendSelection(this.caret, newCaret);
            } else if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(newCaret);
        }
    }

    public void goToPrevCharacter(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        if (!select && s instanceof Selection.Range) {
            if (this.multi) {
                if (this.caret != s.start) {
                    this.moveCaretPosition(s.start);
                    return;
                }
            } else {
                this.setCaretPosition(s.start);
                return;
            }
        }
        if (this.caret == 0) {
            this.getToolkit().beep();
            return;
        }
        int extraStartVirt = 0;
        int extraEndVirt = 0;
        int newCaret = this.caret;
        if (select && this.caret == this.getLineEndOffset(this.caretLine) - 1) {
            if (s instanceof Selection.Rect) {
                extraStartVirt = ((Selection.Rect)s).extraStartVirt;
                extraEndVirt = ((Selection.Rect)s).extraEndVirt;
                if (this.caret == s.start) {
                    if (extraStartVirt == 0) {
                        newCaret = this.getPrevCharacterOffset(this.caret);
                    } else {
                        --extraStartVirt;
                    }
                } else if (extraEndVirt == 0) {
                    newCaret = this.getPrevCharacterOffset(this.caret);
                } else {
                    --extraEndVirt;
                }
            } else {
                newCaret = this.getPrevCharacterOffset(this.caret);
            }
        } else if (this.caret == this.getLineStartOffset(this.caretLine)) {
            int line = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (line == -1) {
                this.getToolkit().beep();
                return;
            }
            newCaret = this.getLineEndOffset(line) - 1;
        } else {
            newCaret = this.getPrevCharacterOffset(this.caret);
        }
        if (select) {
            this.extendSelection(this.caret, newCaret, extraStartVirt, extraEndVirt);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToPrevLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        boolean rectSelect = s == null ? this.rectangularSelectionMode : s instanceof Selection.Rect;
        int magic = this.getMagicCaretPosition();
        int newCaret = this.chunkCache.getAbovePosition(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), magic + 1, rectSelect && select);
        if (newCaret == -1) {
            int start = this.getLineStartOffset(this.caretLine);
            if (this.caret == start) {
                this.getToolkit().beep();
                return;
            }
            newCaret = start;
        }
        this._changeLine(select, newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToPrevPage(boolean select) {
        int newCaret;
        this.scrollToCaret(false);
        int magic = this.getMagicCaretPosition();
        if (this.caretLine < this.displayManager.getFirstVisibleLine()) {
            this.caretLine = this.displayManager.getNextVisibleLine(this.caretLine);
        }
        if (this.getFirstLine() == 0) {
            int firstVisibleLine = this.displayManager.getFirstVisibleLine();
            newCaret = this.getLineStartOffset(firstVisibleLine);
        } else {
            int caretScreenLine = this.getScreenLineOfOffset(this.caret);
            this.scrollUpPage();
            newCaret = this.xToScreenLineOffset(caretScreenLine, magic, true);
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret, false);
        this.setMagicCaretPosition(magic);
    }

    public void goToPrevParagraph(boolean select) {
        int lineNo = this.caretLine;
        int newCaret = 0;
        boolean foundBlank = false;
        Segment lineSegment = new Segment();
        block3: for (int i = lineNo - 1; i >= 0; --i) {
            if (!this.displayManager.isLineVisible(i)) continue;
            this.getLineText(i, lineSegment);
            block4: for (int j = 0; j < lineSegment.count; ++j) {
                switch (lineSegment.array[lineSegment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        if (!foundBlank) continue block3;
                        newCaret = this.getLineEndOffset(i) - 1;
                        break block3;
                    }
                }
            }
            foundBlank = true;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToPrevWord(boolean select) {
        this.goToPrevWord(select, false);
    }

    public void goToPrevWord(boolean select, boolean eatWhitespace) {
        this.goToPrevWord(select, eatWhitespace, false);
    }

    public void goToPrevWord(boolean select, boolean eatWhitespace, boolean eatOnlyAfterWord) {
        if (this.buffer.isLoading()) {
            return;
        }
        int lineStart = this.getLineStartOffset(this.caretLine);
        int newCaret = this.caret - lineStart;
        String lineText = this.getLineText(this.caretLine);
        if (newCaret == 0) {
            if (lineStart == 0) {
                this.getToolkit().beep();
                return;
            }
            int prevLine = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (prevLine == -1) {
                this.getToolkit().beep();
                return;
            }
            newCaret = this.getLineEndOffset(prevLine) - 1;
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            boolean camelCasedWords = this.buffer.getBooleanProperty("camelCasedWords");
            newCaret = TextUtilities.findWordStart(lineText, newCaret - 1, noWordSep, true, camelCasedWords, eatWhitespace, eatOnlyAfterWord);
            newCaret += lineStart;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void home(boolean select) {
        switch (this.getInputHandler().getLastActionCount() % 2) {
            case 1: {
                this.goToStartOfWhiteSpace(select);
                break;
            }
            default: {
                this.goToStartOfLine(select);
            }
        }
    }

    public void end(boolean select) {
        switch (this.getInputHandler().getLastActionCount() % 2) {
            case 1: {
                this.goToEndOfWhiteSpace(select);
                break;
            }
            default: {
                this.goToEndOfLine(select);
            }
        }
    }

    public void smartHome(boolean select) {
        switch (this.getInputHandler().getLastActionCount()) {
            case 1: {
                this.goToStartOfWhiteSpace(select);
                break;
            }
            case 2: {
                this.goToStartOfLine(select);
                break;
            }
            default: {
                this.goToFirstVisibleLine(select);
            }
        }
    }

    public void smartEnd(boolean select) {
        switch (this.getInputHandler().getLastActionCount()) {
            case 1: {
                int pos = this.getCaretPosition();
                this.goToEndOfCode(select);
                int npos = this.getCaretPosition();
                if (npos != pos) break;
                this.goToEndOfWhiteSpace(select);
                break;
            }
            case 2: {
                this.goToEndOfWhiteSpace(select);
                break;
            }
            case 3: {
                this.goToEndOfLine(select);
                break;
            }
            default: {
                this.goToLastVisibleLine(select);
            }
        }
    }

    public void goToStartOfLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        int line = select || s == null ? this.caretLine : s.startLine;
        int newCaret = this.getLineStartOffset(line);
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToEndOfLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        int line = select || s == null ? this.caretLine : s.endLine;
        int newCaret = this.getLineEndOffset(line) - 1;
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToEndOfCode(boolean select) {
        int line = this.getCaretLine();
        DefaultTokenHandler tokenHandler = new DefaultTokenHandler();
        this.buffer.markTokens(line, tokenHandler);
        Token token = tokenHandler.getTokens();
        char[] txt = this.getLineText(line).toCharArray();
        while (true) {
            if (token.id == 1 || token.id == 2 || token.id == 3 || token.id == 4) {
                for (int i = token.offset; i < token.offset + token.length; ++i) {
                    txt[i] = 32;
                }
            }
            if (token.next == null) break;
            token = token.next;
        }
        int newCaret = this.getLineLength(line) - StandardUtilities.getTrailingWhiteSpace(new String(txt));
        newCaret += this.getLineStartOffset(line);
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToStartOfWhiteSpace(boolean select) {
        int offset;
        int line;
        if (this.buffer.isLoading()) {
            return;
        }
        Selection s = this.getSelectionAtOffset(this.caret);
        if (select || s == null) {
            line = this.caretLine;
            offset = this.caret - this.buffer.getLineStartOffset(line);
        } else {
            line = s.startLine;
            offset = s.start - this.buffer.getLineStartOffset(line);
        }
        int firstIndent = this.chunkCache.getSubregionStartOffset(line, offset);
        if (firstIndent == this.getLineStartOffset(line)) {
            firstIndent = StandardUtilities.getLeadingWhiteSpace(this.getLineText(line));
            if (firstIndent == this.getLineLength(line)) {
                firstIndent = 0;
            }
            firstIndent += this.getLineStartOffset(line);
        }
        if (select) {
            this.extendSelection(this.caret, firstIndent);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(firstIndent);
    }

    public void goToEndOfWhiteSpace(boolean select) {
        int offset;
        int line;
        if (this.buffer.isLoading()) {
            return;
        }
        Selection s = this.getSelectionAtOffset(this.caret);
        if (select || s == null) {
            line = this.caretLine;
            offset = this.caret - this.getLineStartOffset(line);
        } else {
            line = s.endLine;
            offset = s.end - this.getLineStartOffset(line);
        }
        int lastIndent = this.chunkCache.getSubregionEndOffset(line, offset);
        if (lastIndent == this.getLineEndOffset(line)) {
            lastIndent = this.getLineLength(line) - StandardUtilities.getTrailingWhiteSpace(this.getLineText(line));
            if (lastIndent == 0) {
                lastIndent = this.getLineLength(line);
            }
            lastIndent += this.getLineStartOffset(line);
        } else {
            --lastIndent;
        }
        if (select) {
            this.extendSelection(this.caret, lastIndent);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(lastIndent);
    }

    public void goToFirstVisibleLine(boolean select) {
        int firstVisibleLine = this.getFirstLine() == 0 ? 0 : this.electricScroll;
        int firstVisible = this.getScreenLineStartOffset(firstVisibleLine);
        if (firstVisible == -1) {
            firstVisible = this.getLineStartOffset(this.displayManager.getFirstVisibleLine());
        }
        if (select) {
            this.extendSelection(this.caret, firstVisible);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(firstVisible);
    }

    public void goToLastVisibleLine(boolean select) {
        int lastVisible;
        if (this.getFirstLine() + this.visibleLines >= this.displayManager.getScrollLineCount()) {
            lastVisible = this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        } else {
            lastVisible = this.visibleLines - this.electricScroll - 1;
            if (this.lastLinePartial) {
                --lastVisible;
            }
            if (lastVisible < 0) {
                lastVisible = 0;
            }
            if ((lastVisible = this.getScreenLineEndOffset(lastVisible) - 1) == -1) {
                lastVisible = this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
            }
        }
        if (select) {
            this.extendSelection(this.caret, lastVisible);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(lastVisible);
    }

    public void goToBufferStart(boolean select) {
        int start = this.buffer.getLineStartOffset(this.displayManager.getFirstVisibleLine());
        if (select) {
            this.extendSelection(this.caret, start);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(start);
    }

    public void goToBufferEnd(boolean select) {
        int end = this.buffer.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        if (select) {
            this.extendSelection(this.caret, end);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(end);
    }

    public void goToMatchingBracket() {
        int dot;
        int bracket;
        if (this.getLineLength(this.caretLine) != 0 && (bracket = TextUtilities.findMatchingBracket(this.buffer, this.caretLine, Math.max(0, (dot = this.caret - this.getLineStartOffset(this.caretLine)) - 1))) != -1) {
            this.selectNone();
            this.moveCaretPosition(bracket + 1, false);
            return;
        }
        this.getToolkit().beep();
    }

    public void userInput(char ch) {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.getPainter().hideCursor();
        switch (ch) {
            case '\t': {
                this.userInputTab();
                break;
            }
            case '\b': {
                this.backspace();
                break;
            }
            case '\u007f': {
                this.delete();
                break;
            }
            default: {
                String str = String.valueOf(ch);
                if (this.getSelectionCount() == 0) {
                    if (this.doWordWrap(ch == ' ')) break;
                    boolean indent = this.buffer.isElectricKey(ch, this.caretLine) && "full".equals(this.buffer.getStringProperty("autoIndent")) && this.buffer.getCurrentIndentForLine(this.caretLine, null) == this.buffer.getIdealIndentForLine(this.caretLine);
                    this.insert(str, indent);
                    break;
                }
                this.replaceSelection(str);
            }
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean overwrite) {
        this.blink = true;
        caretTimer.restart();
        this.overwrite = overwrite;
        this.invalidateLine(this.caretLine);
        this.fireStatusChanged(0, overwrite);
    }

    public final void toggleOverwriteEnabled() {
        this.setOverwriteEnabled(!this.overwrite);
    }

    public void backspace() {
        this.delete(false);
    }

    public void backspaceWord() {
        this.backspaceWord(false);
    }

    public void backspaceWord(boolean eatWhitespace) {
        this.backspaceWord(eatWhitespace, false);
    }

    public void backspaceWord(boolean eatWhitespace, boolean eatOnlyAfterWord) {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.getSelectionCount() != 0) {
            this.setSelectedText("");
            return;
        }
        int lineStart = this.getLineStartOffset(this.caretLine);
        int _caret = this.caret - lineStart;
        String lineText = this.getLineText(this.caretLine);
        if (_caret == 0) {
            if (lineStart == 0) {
                this.getToolkit().beep();
                return;
            }
            --_caret;
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            boolean camelCasedWords = this.buffer.getBooleanProperty("camelCasedWords");
            _caret = TextUtilities.findWordStart(lineText, _caret - 1, noWordSep, true, camelCasedWords, eatWhitespace, eatOnlyAfterWord);
        }
        this.buffer.remove(_caret + lineStart, this.caret - (_caret + lineStart));
    }

    public void delete() {
        this.delete(true);
    }

    public void deleteToEndOfLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.remove(this.caret, this.getLineEndOffset(this.caretLine) - this.caret - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLine() {
        int offset;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        int x = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        int[] lines = this.getSelectedLines();
        try {
            this.buffer.beginCompoundEdit();
            for (int i = lines.length - 1; i >= 0; --i) {
                int start = this.getLineStartOffset(lines[i]);
                int end = this.getLineEndOffset(lines[i]);
                if (end > this.buffer.getLength()) {
                    if (start != 0) {
                        --start;
                    }
                    --end;
                }
                this.buffer.remove(start, end - start);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        int lastLine = this.displayManager.getLastVisibleLine();
        if (this.caretLine == lastLine) {
            offset = this.chunkCache.xToSubregionOffset(lastLine, 0, x, true);
            this.setCaretPosition(this.buffer.getLineStartOffset(lastLine) + offset);
        } else {
            offset = this.chunkCache.xToSubregionOffset(this.caretLine, 0, x, true);
            this.setCaretPosition(this.getLineStartOffset(this.caretLine) + offset);
        }
    }

    public void deleteParagraph() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        int start = 0;
        for (int i = this.caretLine - 1; i >= 0; --i) {
            if (!this.lineContainsSpaceAndTabs(i)) continue;
            start = this.getLineStartOffset(i);
            break;
        }
        int end = this.buffer.getLength();
        for (int i = this.caretLine + 1; i < this.getLineCount(); ++i) {
            if (!this.lineContainsSpaceAndTabs(i)) continue;
            end = this.getLineEndOffset(i) - 1;
            break;
        }
        this.buffer.remove(start, end - start);
    }

    public void deleteToStartOfLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.remove(this.getLineStartOffset(this.caretLine), this.caret - this.getLineStartOffset(this.caretLine));
    }

    public void deleteWord() {
        this.deleteWord(false);
    }

    public void deleteWord(boolean eatWhitespace) {
        String lineText;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.getSelectionCount() != 0) {
            this.setSelectedText("");
            return;
        }
        int lineStart = this.getLineStartOffset(this.caretLine);
        int _caret = this.caret - lineStart;
        if (_caret == (lineText = this.getLineText(this.caretLine)).length()) {
            if (lineStart + _caret == this.buffer.getLength()) {
                this.getToolkit().beep();
                return;
            }
            ++_caret;
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            boolean camelCasedWords = this.buffer.getBooleanProperty("camelCasedWords");
            _caret = TextUtilities.findWordEnd(lineText, _caret + 1, noWordSep, true, camelCasedWords, eatWhitespace);
        }
        this.buffer.remove(this.caret, _caret + lineStart - this.caret);
    }

    public final boolean isMultipleSelectionEnabled() {
        return this.multi;
    }

    public final void toggleMultipleSelectionEnabled() {
        this.setMultipleSelectionEnabled(!this.multi);
    }

    public final void setMultipleSelectionEnabled(boolean multi) {
        this.multi = multi;
        this.fireStatusChanged(1, multi);
        this.painter.repaint();
    }

    public final boolean isRectangularSelectionEnabled() {
        return this.rectangularSelectionMode;
    }

    public final void toggleRectangularSelectionEnabled() {
        this.setRectangularSelectionEnabled(!this.rectangularSelectionMode);
        if (this.getSelectionCount() == 1) {
            Selection s = this.getSelection(0);
            this.removeFromSelection(s);
            if (this.rectangularSelectionMode) {
                this.addToSelection(new Selection.Rect(s.getStart(), s.getEnd()));
            } else {
                this.addToSelection(new Selection.Range(s.getStart(), s.getEnd()));
            }
        }
    }

    public final void setRectangularSelectionEnabled(boolean rectangularSelectionMode) {
        this.rectangularSelectionMode = rectangularSelectionMode;
        this.fireStatusChanged(2, rectangularSelectionMode);
        this.painter.repaint();
    }

    public void goToParentFold() {
        int line = -1;
        int level = this.buffer.getFoldLevel(this.caretLine);
        for (int i = this.caretLine - 1; i >= 0; --i) {
            if (this.buffer.getFoldLevel(i) >= level) continue;
            line = i;
            break;
        }
        if (line == -1) {
            this.getToolkit().beep();
            return;
        }
        int magic = this.getMagicCaretPosition();
        int newCaret = this.buffer.getLineStartOffset(line) + this.chunkCache.xToSubregionOffset(line, 0, magic + 1, true);
        if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToNextFold(boolean select) {
        int nextFold = -1;
        for (int i = this.caretLine + 1; i < this.buffer.getLineCount(); ++i) {
            if (!this.buffer.isFoldStart(i) || !this.displayManager.isLineVisible(i)) continue;
            nextFold = i;
            break;
        }
        if (nextFold == -1) {
            this.getToolkit().beep();
            return;
        }
        int magic = this.getMagicCaretPosition();
        int newCaret = this.buffer.getLineStartOffset(nextFold) + this.chunkCache.xToSubregionOffset(nextFold, 0, magic + 1, true);
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToPrevFold(boolean select) {
        int prevFold = -1;
        for (int i = this.caretLine - 1; i >= 0; --i) {
            if (!this.buffer.isFoldStart(i) || !this.displayManager.isLineVisible(i)) continue;
            prevFold = i;
            break;
        }
        if (prevFold == -1) {
            this.getToolkit().beep();
            return;
        }
        int magic = this.getMagicCaretPosition();
        int newCaret = this.buffer.getLineStartOffset(prevFold) + this.chunkCache.xToSubregionOffset(prevFold, 0, magic + 1, true);
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void collapseFold() {
        this.collapseFold(this.caretLine);
    }

    public void collapseFold(int line) {
        this.displayManager.collapseFold(line);
    }

    public void expandFold(boolean fully) {
        int x = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        int line = this.displayManager.expandFold(this.caretLine, fully);
        if (!fully && line != -1) {
            if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(this.getLineStartOffset(line) + this.chunkCache.xToSubregionOffset(line, 0, x, true));
        }
    }

    public void selectFold() {
        this.selectFold(this.caretLine);
    }

    public void selectFold(int line) {
        int[] lines = this.buffer.getFoldAtLine(line);
        int newCaret = this.getLineEndOffset(lines[1]) - 1;
        Selection.Range s = new Selection.Range(this.getLineStartOffset(lines[0]), newCaret);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(newCaret);
    }

    public void narrowToFold() {
        int[] lines = this.buffer.getFoldAtLine(this.caretLine);
        if (lines[0] == 0 && lines[1] == this.buffer.getLineCount() - 1) {
            this.getToolkit().beep();
        } else {
            this.displayManager.narrow(lines[0], lines[1]);
        }
    }

    public void narrowToSelection() {
        if (this.getSelectionCount() != 1) {
            this.getToolkit().beep();
            return;
        }
        Selection sel = this.getSelection(0);
        this.displayManager.narrow(sel.getStartLine(), sel.getEndLine());
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitFold() throws TextAreaException {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (!"explicit".equals(this.buffer.getStringProperty("folding"))) {
            throw new TextAreaException("folding-not-explicit");
        }
        try {
            this.buffer.beginCompoundEdit();
            if (this.getSelectionCount() == 0) {
                int caretBack = this.addExplicitFold(this.caret, this.caret, this.caretLine, this.caretLine);
                this.setCaretPosition(this.caret - caretBack);
            } else {
                Selection[] selections = this.getSelection();
                Selection selection = null;
                int caretBack = 0;
                for (int i = 0; i < selections.length; ++i) {
                    selection = selections[i];
                    caretBack = this.addExplicitFold(selection.start, selection.end, selection.startLine, selection.endLine);
                }
                assert (selection != null);
                this.setCaretPosition(selection.start - caretBack, false);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineComment() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        String comment = this.buffer.getContextSensitiveProperty(this.caret, "lineComment");
        if (comment == null || comment.length() == 0) {
            this.rangeLineComment();
            return;
        }
        comment = comment + ' ';
        this.buffer.beginCompoundEdit();
        int[] lines = this.getSelectedLines();
        try {
            for (int i = 0; i < lines.length; ++i) {
                String text = this.getLineText(lines[i]);
                this.buffer.insert(this.getLineStartOffset(lines[i]) + StandardUtilities.getLeadingWhiteSpace(text), comment);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rangeComment() {
        String commentStart = this.buffer.getContextSensitiveProperty(this.caret, "commentStart");
        String commentEnd = this.buffer.getContextSensitiveProperty(this.caret, "commentEnd");
        if (!this.buffer.isEditable() || commentStart == null || commentEnd == null || commentStart.length() == 0 || commentEnd.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        commentStart = commentStart + ' ';
        commentEnd = ' ' + commentEnd;
        try {
            this.buffer.beginCompoundEdit();
            Selection[] selection = this.getSelection();
            if (selection.length == 0) {
                int oldCaret = this.caret;
                this.buffer.insert(this.caret, commentStart);
                this.buffer.insert(this.caret, commentEnd);
                this.setCaretPosition(oldCaret + commentStart.length());
            }
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                if (s instanceof Selection.Range) {
                    this.buffer.insert(s.start, commentStart);
                    this.buffer.insert(s.end, commentEnd);
                    continue;
                }
                if (!(s instanceof Selection.Rect)) continue;
                Selection.Rect rect = (Selection.Rect)s;
                int start = rect.getStartColumn(this.buffer);
                int end = rect.getEndColumn(this.buffer);
                for (int j = s.startLine; j <= s.endLine; ++j) {
                    this.buffer.insertAtColumn(j, end, commentEnd);
                    this.buffer.insertAtColumn(j, start, commentStart);
                }
            }
            this.selectNone();
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatParagraph() throws TextAreaException {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.maxLineLen <= 0) {
            throw new TextAreaException("format-maxlinelen");
        }
        Selection[] selection = this.getSelection();
        if (selection.length != 0) {
            this.buffer.beginCompoundEdit();
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                this.setSelectedText(s, TextUtilities.format(this.getSelectedText(s), this.maxLineLen, this.buffer.getTabSize()));
            }
            this.buffer.endCompoundEdit();
        } else {
            int i;
            int lineNo = this.getCaretLine();
            int start = 0;
            int end = this.buffer.getLength();
            for (i = lineNo - 1; i >= 0; --i) {
                if (!this.lineContainsSpaceAndTabs(i)) continue;
                start = this.getLineEndOffset(i);
                break;
            }
            for (i = lineNo + 1; i < this.getLineCount(); ++i) {
                if (!this.lineContainsSpaceAndTabs(i)) continue;
                end = this.getLineStartOffset(i) - 1;
                break;
            }
            try {
                this.buffer.beginCompoundEdit();
                String text = this.buffer.getText(start, end - start);
                int offset = this.getCaretPosition() - start;
                int noSpaceOffset = TextUtilities.indexIgnoringWhitespace(text, offset);
                this.buffer.remove(start, end - start);
                text = TextUtilities.format(text, this.maxLineLen, this.buffer.getTabSize());
                this.buffer.insert(start, text);
                int caretPos = start;
                if (text.length() != 0) {
                    caretPos += Math.min(text.length(), TextUtilities.ignoringWhitespaceIndex(text, noSpaceOffset));
                }
                this.moveCaretPosition(caretPos);
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
    }

    public void spacesToTabs() {
        Selection[] selection = this.getSelection();
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        if (selection.length == 0) {
            this.setText(TextUtilities.spacesToTabs(this.getText(), this.buffer.getTabSize()));
        } else {
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                this.setSelectedText(s, TextUtilities.spacesToTabs(this.getSelectedText(s), this.buffer.getTabSize()));
            }
        }
        this.buffer.endCompoundEdit();
    }

    public void tabsToSpaces() {
        Selection[] selection = this.getSelection();
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        if (selection.length == 0) {
            this.setText(TextUtilities.tabsToSpaces(this.getText(), this.buffer.getTabSize()));
        } else {
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                this.setSelectedText(s, TextUtilities.tabsToSpaces(this.getSelectedText(s), this.buffer.getTabSize()));
            }
        }
        this.buffer.endCompoundEdit();
    }

    public void toUpperCase() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        Selection[] selection = this.getSelection();
        int caret = -1;
        if (selection.length == 0) {
            caret = this.getCaretPosition();
            this.selectWord();
            selection = this.getSelection();
        }
        if (selection.length == 0) {
            if (caret != -1) {
                this.setCaretPosition(caret);
            }
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        for (int i = 0; i < selection.length; ++i) {
            Selection s = selection[i];
            this.setSelectedText(s, this.getSelectedText(s).toUpperCase());
        }
        this.buffer.endCompoundEdit();
        if (caret != -1) {
            this.setCaretPosition(caret);
        }
    }

    public void toLowerCase() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        Selection[] selection = this.getSelection();
        int caret = -1;
        if (selection.length == 0) {
            caret = this.getCaretPosition();
            this.selectWord();
            selection = this.getSelection();
        }
        if (selection.length == 0) {
            if (caret != -1) {
                this.setCaretPosition(caret);
            }
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        for (int i = 0; i < selection.length; ++i) {
            Selection s = selection[i];
            this.setSelectedText(s, this.getSelectedText(s).toLowerCase());
        }
        this.buffer.endCompoundEdit();
        if (caret != -1) {
            this.setCaretPosition(caret);
        }
    }

    public void removeTrailingWhiteSpace() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.removeTrailingWhiteSpace(this.getSelectedLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEnterAndIndent() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
        } else {
            String autoIndent = this.buffer.getStringProperty("autoIndent");
            if ("full".equals(autoIndent) && this.buffer.isElectricKey('\n', this.caretLine)) {
                this.buffer.indentLine(this.caretLine, true);
            }
            try {
                this.buffer.beginCompoundEdit();
                this.setSelectedText("\n");
                if ("full".equals(autoIndent)) {
                    this.buffer.indentLine(this.caretLine, true);
                } else if ("simple".equals(autoIndent)) {
                    this.buffer.simpleIndentLine(this.caretLine);
                }
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
    }

    public void insertTabAndIndent() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        boolean indent = "full".equals(this.buffer.getStringProperty("autoIndent"));
        if (indent && this.getSelectionCount() == 0) {
            int whiteSpace;
            CharSequence text = this.buffer.getLineSegment(this.caretLine);
            int start = this.buffer.getLineStartOffset(this.caretLine);
            if (this.caret - start <= (whiteSpace = StandardUtilities.getLeadingWhiteSpace(text)) && this.buffer.indentLine(this.caretLine, false)) {
                return;
            }
        }
        this.userInput('\t');
    }

    public void indentSelectedLines() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.indentLines(this.getSelectedLines());
            this.selectNone();
        }
    }

    public void turnOnElasticTabstops() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.indentUsingElasticTabstops();
            this.buffer.elasticTabstopsOn = true;
        }
    }

    public void shiftIndentLeft() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.shiftIndentLeft(this.getSelectedLines());
        }
    }

    public void shiftIndentRight() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.shiftIndentRight(this.getSelectedLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinLines() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        try {
            this.buffer.beginCompoundEdit();
            boolean doneForSelection = false;
            for (Selection selection : this.selectionManager.getSelection()) {
                while (selection.startLine < selection.endLine) {
                    this.joinLineAt(selection.endLine - 1);
                    doneForSelection = true;
                }
            }
            if (!doneForSelection) {
                int end = this.getLineEndOffset(this.caretLine);
                if (end > this.buffer.getLength()) {
                    this.getToolkit().beep();
                    return;
                }
                this.joinLineAt(this.caretLine);
                if (!this.multi) {
                    this.selectNone();
                }
                this.moveCaretPosition(end - 1);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    public void addLeftOfScrollBar(Component comp) {
        this.verticalBox.add(comp, 0);
    }

    public void removeLeftOfScrollBar(Component comp) {
        this.verticalBox.remove(comp);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this.painter);
        ToolTipManager.sharedInstance().registerComponent(this.gutter);
        this.recalculateVisibleLines();
        if (!this.buffer.isLoading()) {
            this.recalculateLastPhysicalLine();
        }
        this.propertiesChanged();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this.painter);
        ToolTipManager.sharedInstance().unregisterComponent(this.gutter);
        if (focusedComponent == this) {
            focusedComponent = null;
        }
        caretTimer.stop();
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean getFocusCycleRoot() {
        return true;
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        this.getInputHandler().processKeyEvent(evt, 1, false);
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public void addTopComponent(Component comp) {
        this.add("top", comp);
    }

    public void removeTopComponent(Component comp) {
        this.remove(comp);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.inputMethodSupport == null) {
            this.inputMethodSupport = new InputMethodSupport(this);
            Log.log(1, this, "InputMethodSupport is activated");
        }
        return this.inputMethodSupport;
    }

    public final void addStatusListener(StatusListener listener) {
        this.listenerList.add(StatusListener.class, listener);
    }

    public final void removeStatusListener(StatusListener listener) {
        this.listenerList.remove(StatusListener.class, listener);
    }

    public void propertiesChanged() {
        boolean wrapSettingsChanged;
        if (this.buffer == null) {
            return;
        }
        if (this.buffer.getBooleanProperty("elasticTabstops")) {
            if (!this.buffer.elasticTabstopsOn) {
                this.turnOnElasticTabstops();
            }
            if (this.buffer.getColumnBlock() != null) {
                this.buffer.getColumnBlock().setTabSizeDirtyStatus(true, true);
            }
        } else {
            this.buffer.elasticTabstopsOn = false;
        }
        int _tabSize = this.buffer.getTabSize();
        char[] foo = new char[_tabSize];
        for (int i = 0; i < foo.length; ++i) {
            foo[i] = 32;
        }
        this.tabSize = this.painter.getStringWidth(new String(foo));
        String charWidthSample = " 0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        this.charWidth = (int)Math.round(this.painter.getFont().getStringBounds(charWidthSample, this.painter.getFontRenderContext()).getWidth() / (double)charWidthSample.length());
        String oldWrap = this.wrap;
        this.wrap = this.buffer.getStringProperty("wrap");
        this.hardWrap = "hard".equals(this.wrap);
        String largeFileMode = this.buffer.getStringProperty("largefilemode");
        this.softWrap = "soft".equals(this.wrap) && !"limited".equals(largeFileMode) && !"nohighlight".equals(largeFileMode);
        boolean oldWrapToWidth = this.wrapToWidth;
        int oldWrapMargin = this.wrapMargin;
        this.setMaxLineLength(this.buffer.getIntegerProperty("maxLineLen", 0));
        boolean bl = wrapSettingsChanged = !this.wrap.equals(oldWrap) || oldWrapToWidth != this.wrapToWidth || oldWrapMargin != this.wrapMargin;
        if (this.displayManager != null && !this.bufferChanging && !this.buffer.isLoading() && wrapSettingsChanged) {
            this.displayManager.invalidateScreenLineCounts();
            this.displayManager.notifyScreenLineChanges();
        }
        this.chunkCache.reset();
        this.gutter.repaint();
        this.painter.repaint();
    }

    public void addActionSet(JEditActionSet<JEditBeanShellAction> actionSet) {
        this.actionContext.addActionSet(actionSet);
    }

    @Deprecated
    public final int getMarkPosition() {
        Selection s = this.getSelectionAtOffset(this.caret);
        if (s == null) {
            return this.caret;
        }
        if (s.start == this.caret) {
            return s.end;
        }
        if (s.end == this.caret) {
            return s.start;
        }
        return this.caret;
    }

    public final boolean isCaretVisible() {
        return this.blink && this.hasFocus();
    }

    final boolean isStructureHighlightVisible() {
        return this.match != null && this.hasFocus() && this.displayManager.isLineVisible(this.match.startLine) && this.displayManager.isLineVisible(this.match.endLine);
    }

    void updateMaxHorizontalScrollWidth() {
        int max = this.chunkCache.getMaxHorizontalScrollWidth();
        if (max != this.maxHorizontalScrollWidth) {
            this.maxHorizontalScrollWidth = max;
            this.horizontal.setValues(Math.max(0, Math.min(this.maxHorizontalScrollWidth + this.charWidth - this.painter.getWidth(), -this.horizontalOffset)), this.painter.getWidth(), 0, this.maxHorizontalScrollWidth + this.charWidth);
            this.horizontal.setUnitIncrement(10);
            this.horizontal.setBlockIncrement(this.painter.getWidth());
        } else if (this.horizontal.getValue() != -this.horizontalOffset) {
            this.horizontal.setValue(-this.horizontalOffset);
        }
    }

    void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int height = this.painter.getHeight();
        int lineHeight = this.painter.getLineHeight();
        if (lineHeight == 0) {
            this.visibleLines = 0;
        } else if (height <= 0) {
            this.visibleLines = 0;
            this.lastLinePartial = false;
        } else {
            this.visibleLines = height / lineHeight;
            boolean bl = this.lastLinePartial = height % lineHeight != 0;
            if (this.lastLinePartial) {
                ++this.visibleLines;
            }
        }
        this.chunkCache.recalculateVisibleLines();
        if (this.displayManager != null && this.buffer != null && !this.buffer.isLoading()) {
            this.setFirstLine(this.getFirstLine());
        }
        this.updateScrollBar();
    }

    void foldStructureChanged() {
        this.chunkCache.invalidateAll();
        this.recalculateLastPhysicalLine();
        if (!this.displayManager.isLineVisible(this.caretLine)) {
            int x = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
            int line = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (!this.multi) {
                this.invalidateSelectedLines();
                this.selectionManager.setSelection((Selection)null);
            }
            this.moveCaretPosition(this.buffer.getLineStartOffset(line) + this.chunkCache.xToSubregionOffset(line, 0, x, true));
        }
        this.repaint();
    }

    void updateScrollBar() {
        if (this.buffer == null) {
            return;
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "updateScrollBar(), slc=" + this.displayManager.getScrollLineCount());
        }
        if (this.vertical != null && this.visibleLines != 0) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "Vertical ok");
            }
            final int lineCount = this.displayManager.getScrollLineCount();
            final int firstLine = this.getFirstLine();
            final int visible = this.visibleLines - (this.lastLinePartial ? 1 : 0);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TextArea.this.vertical.setValues(firstLine, visible, 0, lineCount);
                    TextArea.this.vertical.setUnitIncrement(2);
                    TextArea.this.vertical.setBlockIncrement(visible);
                }
            };
            ThreadUtilities.runInDispatchThread(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _finishCaretUpdate() {
        if (!this.queuedCaretUpdate) {
            return;
        }
        try {
            if (this.match != null) {
                if (this.oldCaretLine < this.match.startLine) {
                    this.invalidateLineRange(this.oldCaretLine, this.match.endLine);
                } else {
                    this.invalidateLineRange(this.match.startLine, this.oldCaretLine);
                }
                this.match = null;
            }
            int newCaretScreenLine = this.chunkCache.getScreenLineOfOffset(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine));
            if (this.caretScreenLine == -1) {
                this.invalidateScreenLineRange(newCaretScreenLine, newCaretScreenLine);
            } else {
                this.invalidateScreenLineRange(this.caretScreenLine, newCaretScreenLine);
            }
            this.caretScreenLine = newCaretScreenLine;
            this.invalidateSelectedLines();
            this.blink = true;
            caretTimer.restart();
            if (!this.displayManager.isLineVisible(this.caretLine)) {
                if (this.displayManager.isOutsideNarrowing(this.caretLine)) {
                    int collapseFolds = this.buffer.getIntegerProperty("collapseFolds", 0);
                    if (collapseFolds != 0) {
                        this.displayManager.expandFolds(collapseFolds, false);
                        this.displayManager.expandFold(this.caretLine, false);
                        this.foldStructureChanged();
                    } else {
                        this.displayManager.expandAllFolds();
                    }
                } else {
                    this.displayManager.expandFold(this.caretLine, false);
                }
            }
            if (this.queuedScrollMode == 2) {
                this.scrollToCaret(true);
            } else if (this.queuedScrollMode == 1) {
                this.scrollToCaret(false);
            }
            TextArea.updateBracketHighlightWithDelay();
            if (this.queuedFireCaretEvent) {
                this.fireCaretEvent();
            }
        }
        finally {
            this.queuedFireCaretEvent = false;
            this.queuedCaretUpdate = false;
            this.queuedScrollMode = 0;
        }
    }

    void invalidateStructureMatch() {
        if (this.match != null) {
            this.invalidateLineRange(this.match.startLine, this.match.endLine);
        }
    }

    void startDragAndDrop(InputEvent evt, boolean copy) {
        TransferHandler transferHandler = this.getTransferHandler();
        if (transferHandler != null) {
            Log.log(1, this, "Drag and drop callback");
            transferHandler.exportAsDrag(this, evt, copy ? 1 : 2);
        }
    }

    void fireNarrowActive() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != StatusListener.class) continue;
            try {
                ((StatusListener)listeners[i + 1]).narrowActive(this);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void _setHorizontalOffset(int horizontalOffset) {
        if (horizontalOffset > 0) {
            horizontalOffset = 0;
        }
        if (horizontalOffset == this.horizontalOffset) {
            return;
        }
        int min = Math.min(-(this.maxHorizontalScrollWidth + this.charWidth - this.painter.getWidth()), 0);
        if (horizontalOffset < min) {
            horizontalOffset = min;
        }
        this.setHorizontalOffset(horizontalOffset);
    }

    private void invalidateSelectedLines() {
        this.invalidateLine(this.caretLine);
        for (Selection s : this.selectionManager.selection) {
            this.invalidateLineRange(s.startLine, s.endLine);
        }
    }

    private void finishCaretUpdate(int oldCaretLine, int scrollMode, boolean fireCaretEvent) {
        this.queuedFireCaretEvent |= fireCaretEvent;
        this.queuedScrollMode = Math.max(scrollMode, this.queuedScrollMode);
        if (this.queuedCaretUpdate) {
            return;
        }
        this.oldCaretLine = oldCaretLine;
        this.queuedCaretUpdate = true;
        if (!this.buffer.isTransactionInProgress()) {
            this._finishCaretUpdate();
        }
    }

    private void fireCaretEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != CaretListener.class) continue;
            try {
                ((CaretListener)listeners[i + 1]).caretUpdate(this.caretEvent);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void fireScrollEvent(boolean vertical) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != ScrollListener.class) continue;
            try {
                if (vertical) {
                    ((ScrollListener)listeners[i + 1]).scrolledVertically(this);
                    continue;
                }
                ((ScrollListener)listeners[i + 1]).scrolledHorizontally(this);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void fireStatusChanged(int flag, boolean value) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != StatusListener.class) continue;
            try {
                ((StatusListener)listeners[i + 1]).statusChanged(this, flag, value);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void fireBracketSelected(int line, String text) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != StatusListener.class) continue;
            try {
                ((StatusListener)listeners[i + 1]).bracketSelected(this, line, text);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void _changeLine(boolean select, int newCaret) {
        if (select) {
            int extraEndVirt;
            int extraStartVirt;
            RectParams params = this.getRectParams(this.caret, newCaret);
            if (params == null) {
                extraStartVirt = 0;
                extraEndVirt = 0;
            } else {
                extraStartVirt = params.extraStartVirt;
                extraEndVirt = params.extraEndVirt;
                newCaret = params.newCaret;
            }
            this.extendSelection(this.caret, newCaret, extraStartVirt, extraEndVirt);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    private boolean lineContainsSpaceAndTabs(int lineIndex) {
        Segment lineSegment = new Segment();
        this.getLineText(lineIndex, lineSegment);
        block3: for (int j = 0; j < lineSegment.count; ++j) {
            switch (lineSegment.array[lineSegment.offset + j]) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(String str, boolean indent) {
        try {
            int caretLineEnd;
            if (this.overwrite || indent) {
                this.buffer.beginCompoundEdit();
            }
            if (this.overwrite && (caretLineEnd = this.getLineEndOffset(this.caretLine)) - this.caret > 1) {
                this.deleteNextCharacter(this.caret);
            }
            this.buffer.insert(this.caret, str);
            if (indent) {
                this.buffer.indentLine(this.caretLine, true);
            }
        }
        finally {
            if (this.overwrite || indent) {
                this.buffer.endCompoundEdit();
            }
        }
    }

    private void insertTab() {
        int tabSize = this.buffer.getTabSize();
        if (this.buffer.getBooleanProperty("noTabs")) {
            int lineStart = this.getLineStartOffset(this.caretLine);
            String line = this.getText(lineStart, this.caret - lineStart);
            int pos = 0;
            block3: for (int i = 0; i < line.length(); ++i) {
                switch (line.charAt(pos)) {
                    case '\t': {
                        pos = 0;
                        continue block3;
                    }
                    default: {
                        if (++pos < tabSize) continue block3;
                        pos = 0;
                    }
                }
            }
            this.replaceSelection(StandardUtilities.createWhiteSpace(tabSize - pos, 0));
        } else {
            this.replaceSelection("\t");
        }
    }

    protected void userInputTab() {
        if (this.getSelectionCount() == 1) {
            Selection sel = this.getSelection(0);
            if (sel instanceof Selection.Rect || sel.startLine == sel.endLine && (sel.start != this.buffer.getLineStartOffset(sel.startLine) || sel.end != this.buffer.getLineEndOffset(sel.startLine) - 1)) {
                this.insertTab();
            } else {
                this.shiftIndentRight();
            }
        } else if (this.getSelectionCount() != 0) {
            this.shiftIndentRight();
        } else {
            this.insertTab();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doWordWrap(boolean spaceInserted) {
        boolean returnValue;
        int insertNewLineAt;
        int caretPos;
        if (!this.hardWrap || this.maxLineLen <= 0) {
            return false;
        }
        Segment lineSegment = new Segment();
        this.buffer.getLineText(this.caretLine, lineSegment);
        int start = this.getLineStartOffset(this.caretLine);
        int end = this.getLineEndOffset(this.caretLine);
        int len = end - start - 1;
        for (int i = caretPos = this.caret - start; i < len; ++i) {
            char ch = lineSegment.array[lineSegment.offset + i];
            if (ch == ' ' || ch == '\t') continue;
            return false;
        }
        int tabSize = this.buffer.getTabSize();
        String wordBreakChars = this.buffer.getStringProperty("wordBreakChars");
        int lastInLine = 0;
        int logicalLength = 0;
        int lastWordOffset = -1;
        boolean lastWasSpace = true;
        for (int i = 0; i < caretPos; ++i) {
            char ch = lineSegment.array[lineSegment.offset + i];
            if (ch == '\t') {
                logicalLength += tabSize - logicalLength % tabSize;
                if (lastWasSpace || logicalLength > this.maxLineLen) continue;
                lastInLine = i;
                lastWordOffset = i;
                lastWasSpace = true;
                continue;
            }
            if (ch == ' ') {
                if (lastWasSpace || ++logicalLength > this.maxLineLen + 1) continue;
                lastInLine = i;
                lastWordOffset = i;
                lastWasSpace = true;
                continue;
            }
            if (wordBreakChars != null && wordBreakChars.indexOf(ch) != -1) {
                if (lastWasSpace || ++logicalLength > this.maxLineLen) continue;
                lastInLine = i;
                lastWordOffset = i;
                lastWasSpace = true;
                continue;
            }
            lastInLine = i;
            ++logicalLength;
            lastWasSpace = false;
        }
        if (spaceInserted && logicalLength == this.maxLineLen && lastInLine == caretPos - 1) {
            insertNewLineAt = caretPos;
            returnValue = true;
        } else if (logicalLength >= this.maxLineLen && lastWordOffset != -1) {
            insertNewLineAt = lastWordOffset;
            returnValue = false;
        } else {
            return false;
        }
        String indent = this.buffer.getStringProperty("autoIndent");
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.insert(start + insertNewLineAt, "\n");
            if ("full".equals(indent)) {
                this.buffer.indentLine(this.caretLine, true);
            } else if ("simple".equals(indent)) {
                this.buffer.simpleIndentLine(this.caretLine);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        return returnValue;
    }

    private static void updateBracketHighlightWithDelay() {
        structureTimer.stop();
        structureTimer.start();
    }

    private void updateStructureHighlight() {
        if (!this.painter.isStructureHighlightEnabled() && !this.gutter.isStructureHighlightEnabled()) {
            return;
        }
        for (StructureMatcher matcher : this.structureMatchers) {
            this.match = matcher.getMatch(this);
            if (this.match == null) continue;
            break;
        }
        if (this.match != null) {
            if (this.caretLine < this.match.startLine) {
                this.invalidateLineRange(this.caretLine, this.match.endLine);
            } else {
                this.invalidateLineRange(this.match.startLine, this.caretLine);
            }
            if (!this.displayManager.isLineVisible(this.match.startLine) || this.chunkCache.getScreenLineOfOffset(this.match.startLine, this.match.start - this.getLineStartOffset(this.match.startLine)) == -1) {
                this.showStructureStatusMessage(this.match.startLine < this.caretLine);
            }
        }
    }

    private void showStructureStatusMessage(boolean backward) {
        String text = this.buffer.getLineText(this.match.startLine).trim();
        if (backward && this.match.startLine != 0 && text.length() == 1) {
            switch (text.charAt(0)) {
                case '(': 
                case ')': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    text = this.buffer.getLineText(this.match.startLine - 1).trim() + ' ' + text;
                }
            }
        }
        this.fireBracketSelected(this.match.startLine + 1, text.replace('\t', ' '));
    }

    void recalculateLastPhysicalLine() {
        int oldScreenLastLine = this.screenLastLine;
        for (int i = this.visibleLines - 1; i >= 0; --i) {
            ChunkCache.LineInfo info = this.chunkCache.getLineInfo(i);
            if (info.physicalLine == -1) continue;
            this.physLastLine = info.physicalLine;
            this.screenLastLine = i;
            break;
        }
        this.invalidateScreenLineRange(oldScreenLastLine, this.screenLastLine);
    }

    private RectParams getRectParams(int caret, int newCaret) {
        int virtualWidth;
        Selection s = this.getSelectionAtOffset(caret);
        if (s instanceof Selection.Rect) {
            virtualWidth = caret == s.end ? this.buffer.getVirtualWidth(s.endLine, s.end - this.getLineStartOffset(s.endLine)) + ((Selection.Rect)s).extraEndVirt : this.buffer.getVirtualWidth(s.startLine, s.start - this.getLineStartOffset(s.startLine)) + ((Selection.Rect)s).extraStartVirt;
        } else if (this.rectangularSelectionMode) {
            virtualWidth = this.buffer.getVirtualWidth(this.caretLine, caret - this.buffer.getLineStartOffset(this.caretLine));
        } else {
            return null;
        }
        int newLine = this.getLineOfOffset(newCaret);
        int[] totalVirtualWidth = new int[1];
        int newOffset = this.buffer.getOffsetOfVirtualColumn(newLine, virtualWidth, totalVirtualWidth);
        if (newOffset == -1) {
            int extraVirt = virtualWidth - totalVirtualWidth[0];
            newCaret = this.getLineEndOffset(newLine) - 1;
            boolean bias = s == null ? newCaret < caret : (s.start == caret ? newCaret <= s.end : (s.end == caret ? newCaret <= s.start : false));
            RectParams returnValue = bias ? new RectParams(extraVirt, 0, newCaret) : new RectParams(0, extraVirt, newCaret);
            return returnValue;
        }
        return new RectParams(0, 0, this.getLineStartOffset(newLine) + newOffset);
    }

    private void deleteNextCharacter(int offset) {
        assert (offset < this.buffer.getLength());
        int length = this.getNextCharacterOffset(offset) - offset;
        this.buffer.remove(offset, length);
    }

    private void deletePrevCodePoint(int offset) {
        assert (offset > 0);
        int length = 1;
        if (offset >= 2) {
            Segment prevText = new Segment();
            this.buffer.getText(offset - 1, 1, prevText);
            char prevCodeUnit = prevText.array[prevText.offset];
            if (Character.isLowSurrogate(prevCodeUnit)) {
                this.buffer.getText(offset - 2, 1, prevText);
                prevCodeUnit = prevText.array[prevText.offset];
                if (Character.isHighSurrogate(prevCodeUnit)) {
                    length = 2;
                }
            }
        }
        this.buffer.remove(offset - length, length);
    }

    private void delete(boolean forward) {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.getSelectionCount() != 0) {
            Selection[] selections;
            for (Selection s : selections = this.getSelection()) {
                if (s instanceof Selection.Rect) {
                    Selection.Rect r = (Selection.Rect)s;
                    int startColumn = r.getStartColumn(this.buffer);
                    if (startColumn == r.getEndColumn(this.buffer)) {
                        if (!forward && startColumn == 0) {
                            this.getToolkit().beep();
                            continue;
                        }
                        this.tallCaretDelete(r, forward);
                        continue;
                    }
                    this.setSelectedText(s, null);
                    continue;
                }
                this.setSelectedText(s, null);
            }
        } else if (forward) {
            if (this.caret == this.buffer.getLength()) {
                this.getToolkit().beep();
                return;
            }
            this.deleteNextCharacter(this.caret);
        } else {
            if (this.caret == 0) {
                this.getToolkit().beep();
                return;
            }
            this.deletePrevCodePoint(this.caret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tallCaretDelete(Selection.Rect s, boolean forward) {
        try {
            this.buffer.beginCompoundEdit();
            int[] width = new int[1];
            int startCol = s.getStartColumn(this.buffer);
            int startLine = s.startLine;
            int endLine = s.endLine;
            for (int i = startLine; i <= endLine; ++i) {
                int offset = this.buffer.getOffsetOfVirtualColumn(i, startCol, width);
                if (offset == -1) {
                    if (width[0] == startCol) {
                        offset = this.getLineLength(i);
                    } else {
                        if (i != startLine || forward) continue;
                        this.shiftTallCaretLeft(s);
                        continue;
                    }
                }
                offset += this.buffer.getLineStartOffset(i);
                if (forward) {
                    if (offset == this.buffer.getLineEndOffset(i) - 1) continue;
                    this.deleteNextCharacter(offset);
                    continue;
                }
                this.deletePrevCodePoint(offset);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    private void shiftTallCaretLeft(Selection.Rect s) {
        this.removeFromSelection(s);
        this.addToSelection(new Selection.Rect(this.buffer, s.getStartLine(), s.getStartColumn(this.buffer) - 1, s.getEndLine(), s.getEndColumn(this.buffer) - 1));
    }

    private void setMaxLineLength(int maxLineLen) {
        this.maxLineLen = maxLineLen;
        if (maxLineLen <= 0) {
            if (this.softWrap) {
                this.wrapToWidth = true;
                this.wrapMargin = this.painter.getWidth() - this.charWidth * 3;
            } else {
                this.wrapToWidth = false;
                this.wrapMargin = 0;
            }
        } else {
            int estimate = this.charWidth * maxLineLen;
            if (this.softWrap && this.painter.getWidth() < estimate) {
                this.wrapToWidth = true;
                this.wrapMargin = this.painter.getWidth() - this.charWidth * 3;
            } else {
                this.wrapToWidth = false;
                this.wrapMargin = estimate;
            }
        }
    }

    protected int addExplicitFold(int caretStart, int caretEnd, int lineStart, int lineEnd) {
        String start;
        int startCaret = caretStart < this.buffer.getLength() ? caretStart + 1 : caretStart;
        int endCaret = caretEnd > 0 ? caretEnd - 1 : caretEnd;
        String startLineComment = this.buffer.getContextSensitiveProperty(startCaret, "lineComment");
        String startCommentStart = this.buffer.getContextSensitiveProperty(startCaret, "commentStart");
        String startCommentEnd = this.buffer.getContextSensitiveProperty(startCaret, "commentEnd");
        String endLineComment = this.buffer.getContextSensitiveProperty(endCaret, "lineComment");
        String endCommentStart = this.buffer.getContextSensitiveProperty(endCaret, "commentStart");
        String endCommentEnd = this.buffer.getContextSensitiveProperty(endCaret, "commentEnd");
        int caretBack = 1;
        if (startLineComment != null) {
            start = startLineComment + "{{{ ";
        } else if (startCommentStart != null && startCommentEnd != null) {
            start = startCommentStart + "{{{  " + startCommentEnd;
            caretBack = 2 + startCommentEnd.length();
        } else {
            start = "{{{ ";
        }
        if (startLineComment != null) {
            if (this.buffer.getLineLength(lineStart) != caretStart) {
                start = start + '\n';
            }
        } else {
            start = start + "\n";
        }
        String end = endLineComment != null ? endLineComment + "}}}" : (endCommentStart != null && endCommentEnd != null ? endCommentStart + "}}}" + endCommentEnd : "}}}");
        String line = this.buffer.getLineText(lineStart);
        String whitespace = line.substring(0, StandardUtilities.getLeadingWhiteSpace(line));
        caretBack += whitespace.length();
        if (caretStart == caretEnd) {
            caretBack += end.length() + 1;
            int lineStartOffset = this.buffer.getLineStartOffset(lineStart);
            if (lineStartOffset + whitespace.length() != caretStart) {
                ++caretBack;
            }
        }
        if (endLineComment != null) {
            if (this.buffer.getLineLength(lineEnd) != caretEnd) {
                end = end + '\n';
            }
        } else {
            end = end + "\n";
        }
        if (caretEnd == this.buffer.getLineStartOffset(lineEnd)) {
            this.buffer.insert(caretEnd, end);
        } else {
            CharSequence lineText = this.buffer.getSegment(caretEnd - 1, 1);
            if (Character.isWhitespace(lineText.charAt(0))) {
                this.buffer.insert(caretEnd, end);
            } else {
                this.buffer.insert(caretEnd, ' ' + end);
            }
        }
        this.buffer.insert(caretStart, start + whitespace);
        return caretBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeLineComment() {
        String commentStart = this.buffer.getContextSensitiveProperty(this.caret, "commentStart");
        String commentEnd = this.buffer.getContextSensitiveProperty(this.caret, "commentEnd");
        if (!this.buffer.isEditable() || commentStart == null || commentEnd == null || commentStart.length() == 0 || commentEnd.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        commentStart = commentStart + ' ';
        commentEnd = ' ' + commentEnd;
        try {
            this.buffer.beginCompoundEdit();
            int[] lines = this.getSelectedLines();
            for (int i = 0; i < lines.length; ++i) {
                String text = this.getLineText(lines[i]);
                if (text.trim().length() == 0) continue;
                this.buffer.insert(this.getLineEndOffset(lines[i]) - 1, commentEnd);
                this.buffer.insert(this.getLineStartOffset(lines[i]) + StandardUtilities.getLeadingWhiteSpace(text), commentStart);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    private void joinLineAt(int line) {
        if (line >= this.buffer.getLineCount() - 1) {
            return;
        }
        int end = this.getLineEndOffset(line);
        CharSequence nextLineText = this.buffer.getLineSegment(line + 1);
        this.buffer.remove(end - 1, StandardUtilities.getLeadingWhiteSpace(nextLineText) + 1);
        if (nextLineText.length() != 0) {
            this.buffer.insert(end - 1, " ");
        }
    }

    public boolean isRightClickPopupEnabled() {
        return this.popupEnabled;
    }

    public void setRightClickPopupEnabled(boolean popupEnabled) {
        this.popupEnabled = popupEnabled;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public void handlePopupTrigger(MouseEvent evt) {
        this.createPopupMenu(evt);
        int x = evt.getX();
        int y = evt.getY();
        int dragStart = this.xyToOffset(x, y, !this.painter.isBlockCaretEnabled() && !this.isOverwriteEnabled());
        if (this.getSelectionCount() == 0 || this.multi) {
            this.moveCaretPosition(dragStart, false);
        }
        TextArea.showPopupMenu(this.popup, this, x, y, false);
    }

    public void createPopupMenu(MouseEvent evt) {
    }

    public void showPopupMenu() {
        Point caretPos;
        if (!this.popup.isVisible() && this.hasFocus() && (caretPos = this.offsetToXY(this.getCaretPosition())) != null) {
            int charHeight = this.getPainter().getLineHeight();
            TextArea.showPopupMenu(this.popup, this.painter, caretPos.x, caretPos.y + charHeight, true);
        }
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y, boolean point) {
        Component win;
        int offsetX = 0;
        int offsetY = 0;
        int extraOffset = point ? 1 : 0;
        for (win = comp; !(win instanceof Window) && win != null; win = win.getParent()) {
            offsetX += win.getX();
            offsetY += win.getY();
        }
        if (win != null) {
            Dimension size = popup.getPreferredSize();
            Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            x = x + offsetX + size.width + win.getX() > screenSize.width && x + offsetX + win.getX() >= size.width ? (point ? (x -= size.width + extraOffset) : win.getWidth() - size.width - offsetX + extraOffset) : (x += extraOffset);
            y = y + offsetY + size.height + win.getY() > screenSize.height && y + offsetY + win.getY() >= size.height ? (point ? win.getHeight() - size.height - offsetY + extraOffset : -size.height - 1) : (y += extraOffset);
            popup.show(comp, x, y);
        } else {
            popup.show(comp, x + extraOffset, y + extraOffset);
        }
    }

    private int getPrevCharacterOffset(int offset) {
        return new LineCharacterBreaker(this, offset).previousOf(offset);
    }

    private int getNextCharacterOffset(int offset) {
        return new LineCharacterBreaker(this, offset).nextOf(offset);
    }

    private int getCharacterBoundaryAt(int offset) {
        LineCharacterBreaker charBreaker = new LineCharacterBreaker(this, offset);
        return charBreaker.offsetIsBoundary(offset) ? offset : charBreaker.previousOf(offset);
    }

    public TabExpander getTabExpander() {
        if (this.buffer.getBooleanProperty("elasticTabstops")) {
            return this.elasticTabstopsExpander;
        }
        return this.painter;
    }

    static {
        caretTimer = new Timer(500, new CaretBlinker());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
        structureTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (focusedComponent != null) {
                    focusedComponent.updateStructureHighlight();
                }
            }
        });
        structureTimer.setInitialDelay(100);
        structureTimer.setRepeats(false);
    }

    private class MouseWheelHandler
    implements MouseWheelListener {
        private MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isAltDown()) {
                boolean select;
                boolean bl = select = e.isShiftDown() || e.isControlDown();
                if (e.getWheelRotation() < 0) {
                    TextArea.this.goToPrevLine(select);
                } else {
                    TextArea.this.goToNextLine(select);
                }
            } else if (e.getScrollType() == 1) {
                if (e.isShiftDown()) {
                    TextArea.this._setHorizontalOffset(TextArea.this.getHorizontalOffset() + (e.getWheelRotation() > 0 ? 1 : -1) * TextArea.this.painter.getWidth());
                } else if (e.getWheelRotation() > 0) {
                    TextArea.this.scrollDownPage();
                } else {
                    TextArea.this.scrollUpPage();
                }
            } else if (e.isControlDown() && e.isShiftDown()) {
                if (e.getWheelRotation() > 0) {
                    TextArea.this.scrollDownPage();
                } else {
                    TextArea.this.scrollUpPage();
                }
            } else if (e.isControlDown()) {
                TextArea.this.setFirstLine(TextArea.this.getFirstLine() + e.getWheelRotation());
            } else if (e.getScrollType() == 0) {
                if (e.isShiftDown()) {
                    TextArea.this._setHorizontalOffset(TextArea.this.getHorizontalOffset() + -TextArea.this.charWidth * e.getUnitsToScroll());
                } else {
                    TextArea.this.setFirstLine(TextArea.this.getFirstLine() + e.getUnitsToScroll());
                }
            } else if (e.isShiftDown()) {
                TextArea.this._setHorizontalOffset(TextArea.this.getHorizontalOffset() + -TextArea.this.charWidth * e.getWheelRotation());
            } else {
                TextArea.this.setFirstLine(TextArea.this.getFirstLine() + 3 * e.getWheelRotation());
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            if (TextArea.this.bufferChanging) {
                return;
            }
            if (TextArea.this.match != null) {
                if (TextArea.this.caretLine < ((TextArea)TextArea.this).match.startLine) {
                    TextArea.this.invalidateLineRange(TextArea.this.caretLine, ((TextArea)TextArea.this).match.endLine);
                } else {
                    TextArea.this.invalidateLineRange(((TextArea)TextArea.this).match.startLine, TextArea.this.caretLine);
                }
            } else {
                TextArea.this.invalidateLine(TextArea.this.caretLine);
            }
            focusedComponent = TextArea.this;
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (!TextArea.this.isShowing()) {
                return;
            }
            if (TextArea.this.match != null) {
                if (TextArea.this.caretLine < ((TextArea)TextArea.this).match.startLine) {
                    TextArea.this.invalidateLineRange(TextArea.this.caretLine, ((TextArea)TextArea.this).match.endLine);
                } else {
                    TextArea.this.invalidateLineRange(((TextArea)TextArea.this).match.startLine, TextArea.this.caretLine);
                }
            } else {
                TextArea.this.invalidateLine(TextArea.this.caretLine);
            }
        }
    }

    private class AdjustHandler
    implements AdjustmentListener {
        private AdjustHandler() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            if (!TextArea.this.scrollBarsInitialized) {
                return;
            }
            if (evt.getAdjustable() == TextArea.this.vertical) {
                TextArea.this.setFirstLine(TextArea.this.vertical.getValue());
            } else {
                TextArea.this.setHorizontalOffset(-TextArea.this.horizontal.getValue());
            }
        }
    }

    private class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(TextArea.this);
        }

        @Override
        public int getDot() {
            return TextArea.this.getCaretPosition();
        }

        @Override
        public int getMark() {
            return TextArea.this.getMarkPosition();
        }
    }

    private static class CaretBlinker
    implements ActionListener {
        private CaretBlinker() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (focusedComponent != null && focusedComponent.hasFocus()) {
                focusedComponent.blinkCaret();
            }
        }
    }

    private static class LineCharacterBreaker {
        private final BreakIterator charBreaker;
        private final int index0Offset;

        public LineCharacterBreaker(TextArea textArea, int offset) {
            int line = textArea.getLineOfOffset(offset);
            this.charBreaker = BreakIterator.getCharacterInstance();
            this.charBreaker.setText(new CharIterator(textArea.buffer.getLineSegment(line)));
            this.index0Offset = textArea.getLineStartOffset(line);
        }

        public boolean offsetIsBoundary(int offset) {
            return this.charBreaker.isBoundary(offset - this.index0Offset);
        }

        public int nextOf(int offset) {
            int following = this.charBreaker.following(offset - this.index0Offset);
            if (following == -1) {
                return offset + 1;
            }
            return following + this.index0Offset;
        }

        public int previousOf(int offset) {
            int preceding = this.charBreaker.preceding(offset - this.index0Offset);
            if (preceding == -1) {
                return offset - 1;
            }
            return preceding + this.index0Offset;
        }

        private static class CharIterator
        implements CharacterIterator {
            private final CharSequence sequence;
            private int index;

            public CharIterator(CharSequence sequence) {
                this.sequence = sequence;
                this.index = 0;
            }

            @Override
            public char first() {
                this.index = 0;
                return this.current();
            }

            @Override
            public char last() {
                int length = this.sequence.length();
                this.index = length > 0 ? length - 1 : length;
                return this.current();
            }

            @Override
            public char current() {
                return this.index < this.sequence.length() ? this.sequence.charAt(this.index) : (char)'\uffff';
            }

            @Override
            public char next() {
                int length = this.sequence.length();
                if (this.index < length) {
                    ++this.index;
                    return this.current();
                }
                return '\uffff';
            }

            @Override
            public char previous() {
                if (this.index > 0) {
                    --this.index;
                    return this.current();
                }
                return '\uffff';
            }

            @Override
            public char setIndex(int position) {
                if (0 <= position && position <= this.sequence.length()) {
                    this.index = position;
                    return this.current();
                }
                throw new IllegalArgumentException();
            }

            @Override
            public int getBeginIndex() {
                return 0;
            }

            @Override
            public int getEndIndex() {
                return this.sequence.length();
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Object clone() {
                CharIterator newOne = new CharIterator(this.sequence);
                newOne.index = this.index;
                return newOne;
            }
        }
    }

    private static class RectParams {
        final int extraStartVirt;
        final int extraEndVirt;
        final int newCaret;

        RectParams(int extraStartVirt, int extraEndVirt, int newCaret) {
            this.extraStartVirt = extraStartVirt;
            this.extraEndVirt = extraEndVirt;
            this.newCaret = newCaret;
        }
    }
}

