/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import javax.swing.SwingWorker;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.TaskManager;

public abstract class Task
implements Runnable,
ProgressObserver {
    private long value;
    private String status;
    private long maximum;
    private String label;
    private Thread thread;
    private SwingWorker.StateValue state = SwingWorker.StateValue.PENDING;
    private volatile boolean cancellable = true;

    protected Task() {
    }

    @Override
    public final void run() {
        this.state = SwingWorker.StateValue.STARTED;
        TaskManager.instance.fireRunning(this);
        try {
            this.thread = Thread.currentThread();
            this._run();
            this.thread = null;
        }
        catch (Throwable t) {
            Log.log(9, this, t);
        }
        this.state = SwingWorker.StateValue.DONE;
        TaskManager.instance.fireDone(this);
    }

    public abstract void _run();

    @Override
    public final void setValue(long value) {
        this.value = value;
        TaskManager.instance.fireValueUpdated(this);
    }

    @Override
    public final void setMaximum(long maximum) {
        this.maximum = maximum;
        TaskManager.instance.fireMaximumUpdated(this);
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
        TaskManager.instance.fireStatusUpdated(this);
    }

    public long getValue() {
        return this.value;
    }

    public String getStatus() {
        return this.status;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public SwingWorker.StateValue getState() {
        return this.state;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public void setCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    public void cancel() {
        if (this.cancellable && this.thread != null) {
            this.thread.interrupt();
        }
    }

    public String toString() {
        return "Task[" + (Object)((Object)this.state) + ',' + this.status + ',' + this.value + '/' + this.maximum + ']';
    }
}

