/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.io.CharsetEncoding;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class PluginJAR {
    private final String path;
    private String cachePath;
    private final File file;
    private final JARClassLoader classLoader;
    private ZipFile zipFile;
    private Properties properties;
    private Map<String, Properties> localizationProperties;
    private String[] classes;
    private String[] resources;
    private ActionSet actions;
    private ActionSet browserActions;
    private EditPlugin plugin;
    private URL dockablesURI;
    private URL servicesURI;
    private boolean activated;
    private final Set<String> theseRequireMe = new LinkedHashSet<String>();
    private final Set<String> theseUseMe = new LinkedHashSet<String>();
    private final Set<String> weRequireThese = new LinkedHashSet<String>();
    private final Set<String> weUseThese = new LinkedHashSet<String>();

    public static PluginJAR load(String path, boolean loadDependents) {
        String jars;
        PluginJAR jar = jEdit.getPluginJAR(path);
        if (jar != null && jar.getPlugin() != null) {
            return jar;
        }
        jEdit.addPluginJAR(path);
        jar = jEdit.getPluginJAR(path);
        if (jar == null) {
            return null;
        }
        EditPlugin plugin = jar.getPlugin();
        if (plugin == null) {
            return jar;
        }
        String className = plugin.getClassName();
        if (loadDependents) {
            Set<String> pluginLoadList = PluginJAR.getDependencySet(className);
            for (String jarName : pluginLoadList) {
                String jarPath = PluginJAR.findPlugin(jarName);
                if (jarPath == null) {
                    Log.log(7, PluginJAR.class, "Unable to load dependency " + jarName + " the plugin is not installed");
                    continue;
                }
                PluginJAR.load(jarPath, true);
            }
        }
        if ((jars = jEdit.getProperty("plugin." + className + ".jars")) != null) {
            String dir2 = MiscUtilities.getParentOfPath(path);
            StringTokenizer st = new StringTokenizer(jars);
            while (st.hasMoreTokens()) {
                String _jarPath = MiscUtilities.constructPath(dir2, st.nextToken());
                PluginJAR _jar = jEdit.getPluginJAR(_jarPath);
                if (_jar != null) continue;
                jEdit.addPluginJAR(_jarPath);
            }
        }
        jar.checkDependencies();
        jar.activatePluginIfNecessary();
        jEdit.propertiesChanged();
        return jar;
    }

    public String getPath() {
        return this.path;
    }

    public static String findPlugin(String className) {
        EditPlugin ep = jEdit.getPlugin(className);
        if (ep != null) {
            return ep.getPluginJAR().getPath();
        }
        for (String JARpath : jEdit.getNotLoadedPluginJARs()) {
            PluginJAR pjar = new PluginJAR(new File(JARpath));
            if (!pjar.containsClass(className)) continue;
            return JARpath;
        }
        return null;
    }

    boolean containsClass(String className) {
        try {
            this.getZipFile();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Enumeration<? extends ZipEntry> itr = this.zipFile.entries();
        while (itr.hasMoreElements()) {
            String name;
            String entry = itr.nextElement().toString();
            if (!entry.endsWith(".class") || !(name = entry.substring(0, entry.length() - 6).replace('/', '.')).equals(className)) continue;
            return true;
        }
        return false;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public static Set<String> getDependencySet(String className) {
        String dep;
        Set<String> retval = new LinkedHashSet<String>();
        int i = 0;
        while ((dep = jEdit.getProperty("plugin." + className + ".depend." + i++)) != null) {
            PluginDepends pluginDepends;
            try {
                pluginDepends = PluginJAR.getPluginDepends(dep);
            }
            catch (IllegalArgumentException e) {
                Log.log(9, PluginJAR.class, className + " has an invalid dependency: " + dep);
                continue;
            }
            if (!"plugin".equals(pluginDepends.what)) continue;
            int index2 = pluginDepends.arg.indexOf(32);
            if (index2 == -1) {
                Log.log(9, PluginJAR.class, className + " has an invalid dependency: " + dep + " (version is missing)");
                continue;
            }
            String pluginName = pluginDepends.arg.substring(0, index2);
            String needVersion = pluginDepends.arg.substring(index2 + 1);
            Set<String> loadTheseFirst = PluginJAR.getDependencySet(pluginName);
            loadTheseFirst.add(pluginName);
            loadTheseFirst.addAll(retval);
            retval = loadTheseFirst;
        }
        return retval;
    }

    public File getFile() {
        return this.file;
    }

    public JARClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized ZipFile getZipFile() throws IOException {
        if (this.zipFile == null) {
            Log.log(1, this, "Opening " + this.path);
            this.zipFile = new ZipFile(this.path);
        }
        return this.zipFile;
    }

    public ActionSet getActionSet() {
        return this.actions;
    }

    public ActionSet getBrowserActionSet() {
        return this.browserActions;
    }

    public boolean checkDependencies() {
        String dep;
        if (this.plugin == null) {
            return true;
        }
        int i = 0;
        boolean ok = true;
        String name = this.plugin.getClassName();
        while ((dep = jEdit.getProperty("plugin." + name + ".depend." + i++)) != null) {
            Object[] args;
            PluginDepends pluginDepends;
            try {
                pluginDepends = PluginJAR.getPluginDepends(dep);
            }
            catch (IllegalArgumentException e) {
                Log.log(9, this, name + " has an invalid" + " dependency: " + dep);
                ok = false;
                continue;
            }
            if ("jdk".equals(pluginDepends.what)) {
                if (pluginDepends.optional || StandardUtilities.compareStrings(System.getProperty("java.version"), pluginDepends.arg, false) >= 0) continue;
                Object[] args2 = new String[]{pluginDepends.arg, System.getProperty("java.version")};
                jEdit.pluginError(this.path, "plugin-error.dep-jdk", args2);
                ok = false;
                continue;
            }
            if ("jedit".equals(pluginDepends.what)) {
                if (pluginDepends.arg.length() != 11) {
                    Log.log(9, this, "Invalid jEdit version number: " + pluginDepends.arg);
                    ok = false;
                }
                if (pluginDepends.optional || StandardUtilities.compareStrings(jEdit.getBuild(), pluginDepends.arg, false) >= 0) continue;
                String needs = MiscUtilities.buildToVersion(pluginDepends.arg);
                args = new String[]{needs, jEdit.getVersion()};
                jEdit.pluginError(this.path, "plugin-error.dep-jedit", args);
                ok = false;
                continue;
            }
            if ("plugin".equals(pluginDepends.what)) {
                Object[] args3;
                int index2 = pluginDepends.arg.indexOf(32);
                if (index2 == -1) {
                    Log.log(9, this, name + " has an invalid dependency: " + dep + " (version is missing)");
                    ok = false;
                    continue;
                }
                String pluginName = pluginDepends.arg.substring(0, index2);
                String needVersion = pluginDepends.arg.substring(index2 + 1);
                String currVersion = jEdit.getProperty("plugin." + pluginName + ".version");
                EditPlugin editPlugin = jEdit.getPlugin(pluginName, false);
                if (editPlugin == null) {
                    if (pluginDepends.optional) continue;
                    args3 = new String[]{needVersion, pluginName};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin.no-version", args3);
                    ok = false;
                    continue;
                }
                if (StandardUtilities.compareStrings(currVersion, needVersion, false) < 0) {
                    if (pluginDepends.optional) continue;
                    args3 = new String[]{needVersion, pluginName, currVersion};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin", args3);
                    ok = false;
                    continue;
                }
                if (editPlugin instanceof EditPlugin.Broken) {
                    if (pluginDepends.optional) continue;
                    args3 = new String[]{pluginName};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin.broken", args3);
                    ok = false;
                    continue;
                }
                PluginJAR jar = editPlugin.getPluginJAR();
                if (pluginDepends.optional) {
                    jar.theseUseMe.add(this.path);
                    this.weUseThese.add(jar.getPath());
                    continue;
                }
                jar.theseRequireMe.add(this.path);
                this.weRequireThese.add(jar.getPath());
                continue;
            }
            if ("class".equals(pluginDepends.what)) {
                if (pluginDepends.optional) continue;
                try {
                    this.classLoader.loadClass(pluginDepends.arg, false);
                }
                catch (Exception e) {
                    args = new String[]{pluginDepends.arg};
                    jEdit.pluginError(this.path, "plugin-error.dep-class", args);
                    ok = false;
                }
                continue;
            }
            Log.log(9, this, name + " has unknown" + " dependency: " + dep);
            ok = false;
        }
        String jars = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".jars");
        if (jars != null) {
            String dir2 = MiscUtilities.getParentOfPath(this.path);
            StringTokenizer st = new StringTokenizer(jars);
            while (st.hasMoreTokens()) {
                String jarPath = MiscUtilities.constructPath(dir2, st.nextToken());
                PluginJAR jar = jEdit.getPluginJAR(jarPath);
                if (jar == null) {
                    Object[] args = new String[]{jarPath};
                    jEdit.pluginError(this.path, "plugin-error.missing-jar", args);
                    ok = false;
                    continue;
                }
                this.weRequireThese.add(jarPath);
                jar.theseRequireMe.add(this.path);
            }
        }
        if (!ok) {
            this.breakPlugin();
        }
        return ok;
    }

    public Set<String> getRequiredJars() {
        return this.weRequireThese;
    }

    private static PluginDepends getPluginDepends(String dep) throws IllegalArgumentException {
        boolean optional;
        if (dep.startsWith("optional ")) {
            optional = true;
            dep = dep.substring("optional ".length());
        } else {
            optional = false;
        }
        int index = dep.indexOf(32);
        if (index == -1) {
            throw new IllegalArgumentException("wrong dependency");
        }
        String what = dep.substring(0, index);
        String arg = dep.substring(index + 1);
        PluginDepends depends = new PluginDepends();
        depends.what = what;
        depends.arg = arg;
        depends.optional = optional;
        return depends;
    }

    public static void transitiveClosure(String[] dependents, List<String> listModel) {
        for (int i = 0; i < dependents.length; ++i) {
            String jarPath = dependents[i];
            if (listModel.contains(jarPath)) continue;
            listModel.add(jarPath);
            PluginJAR jar = jEdit.getPluginJAR(jarPath);
            if (jar == null) {
                Log.log(7, PluginJAR.class, "The jar file " + jarPath + " doesn't exist, the plugin may have been partially removed");
                continue;
            }
            PluginJAR.transitiveClosure(jar.getDependentPlugins(), listModel);
        }
    }

    public String[] getDependentPlugins() {
        return this.theseRequireMe.toArray(new String[this.theseRequireMe.size()]);
    }

    public EditPlugin getPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activatePlugin() {
        PluginJAR pluginJAR = this;
        synchronized (pluginJAR) {
            if (this.activated) {
                return;
            }
            this.activated = true;
        }
        if (!(this.plugin instanceof EditPlugin.Deferred)) {
            return;
        }
        String className = this.plugin.getClassName();
        try {
            Class clazz = this.classLoader.loadClass(className, false);
            int modifiers = clazz.getModifiers();
            if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers) || !EditPlugin.class.isAssignableFrom(clazz)) {
                Log.log(9, this, "Plugin has properties but does not extend EditPlugin: " + className);
                this.breakPlugin();
                return;
            }
            this.plugin = (EditPlugin)clazz.newInstance();
            this.plugin.jar = this;
        }
        catch (Throwable t) {
            this.breakPlugin();
            Log.log(9, this, "Error while starting plugin " + className);
            Log.log(9, this, t);
            Object[] args = new String[]{t.toString()};
            jEdit.pluginError(this.path, "plugin-error.start-error", args);
            return;
        }
        if (jEdit.isMainThread() || SwingUtilities.isEventDispatchThread()) {
            this.startPlugin();
        } else {
            this.startPluginLater();
        }
        EditBus.sendAsync(new PluginUpdate(this, PluginUpdate.ACTIVATED, false));
    }

    public void activatePluginIfNecessary() {
        String filename = MiscUtilities.getFileName(this.getPath());
        jEdit.unsetProperty("plugin-blacklist." + filename);
        if (!(this.plugin instanceof EditPlugin.Deferred) || this.plugin == null) {
            return;
        }
        String className = this.plugin.getClassName();
        String activate = jEdit.getProperty("plugin." + className + ".activate");
        if (activate == null) {
            if (!jEdit.isMainThread()) {
                this.breakPlugin();
                jEdit.pluginError(this.path, "plugin-error.not-42", null);
            } else {
                this.activatePlugin();
            }
        } else {
            boolean load = false;
            StringTokenizer st = new StringTokenizer(activate);
            while (st.hasMoreTokens()) {
                String prop = st.nextToken();
                boolean value = jEdit.getBooleanProperty(prop);
                if (!value) continue;
                Log.log(1, this, "Activating " + className + " because of " + prop);
                load = true;
                break;
            }
            if (load) {
                this.activatePlugin();
            }
        }
    }

    public void deactivatePlugin(boolean exit) {
        if (!this.activated) {
            return;
        }
        if (!exit) {
            for (Buffer buffer = jEdit.getFirstBuffer(); buffer != null; buffer = buffer.getNext()) {
                if (buffer.getFoldHandler() == null || buffer.getFoldHandler().getClass().getClassLoader() != this.classLoader) continue;
                buffer.setFoldHandler(new DummyFoldHandler());
            }
        }
        if (this.plugin != null && !(this.plugin instanceof EditPlugin.Broken)) {
            String activate;
            if (this.plugin instanceof EBPlugin || this.plugin.getClass().getAnnotation(EditBus.EBHandler.class) != null) {
                EditBus.removeFromBus(this.plugin);
            }
            try {
                this.plugin.stop();
            }
            catch (Throwable t) {
                Log.log(9, this, "Error while stopping plugin:");
                Log.log(9, this, t);
            }
            this.plugin = new EditPlugin.Deferred(this, this.plugin.getClassName());
            EditBus.send(new PluginUpdate(this, PluginUpdate.DEACTIVATED, exit));
            if (!exit && (activate = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".activate")) == null) {
                this.breakPlugin();
                jEdit.pluginError(this.path, "plugin-error.not-42", null);
            }
        }
        this.activated = false;
    }

    public URL getDockablesURI() {
        return this.dockablesURI;
    }

    public URL getServicesURI() {
        return this.servicesURI;
    }

    public String toString() {
        if (this.plugin == null) {
            return this.path;
        }
        return this.path + ",class=" + this.plugin.getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static PluginCacheEntry getPluginCache(PluginJAR plugin) {
        PluginCacheEntry pluginCacheEntry;
        String jarCachePath = plugin.getCachePath();
        if (jarCachePath == null) {
            return null;
        }
        DataInputStream din = null;
        try {
            PluginCacheEntry cache = new PluginCacheEntry();
            cache.plugin = plugin;
            cache.modTime = plugin.getFile().lastModified();
            din = new DataInputStream(new BufferedInputStream(new FileInputStream(jarCachePath)));
            if (cache.read(din)) {
                PluginCacheEntry pluginCacheEntry2 = cache;
                IOUtilities.closeQuietly(din);
                return pluginCacheEntry2;
            }
            pluginCacheEntry = null;
            IOUtilities.closeQuietly(din);
        }
        catch (FileNotFoundException fnf) {
            PluginCacheEntry pluginCacheEntry3 = null;
            return pluginCacheEntry3;
        }
        catch (IOException io) {
            Log.log(9, PluginJAR.class, io);
            PluginCacheEntry pluginCacheEntry4 = null;
            return pluginCacheEntry4;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtilities.closeQuietly(din);
        }
        return pluginCacheEntry;
    }

    static void setPluginCache(PluginJAR plugin, PluginCacheEntry cache) {
        String jarCachePath = plugin.getCachePath();
        if (jarCachePath == null) {
            return;
        }
        Log.log(1, PluginJAR.class, "Writing " + jarCachePath);
        DataOutputStream dout = null;
        try {
            dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(jarCachePath)));
            cache.write(dout);
            dout.close();
        }
        catch (IOException io) {
            Log.log(9, PluginJAR.class, io);
            IOUtilities.closeQuietly(dout);
            new File(jarCachePath).delete();
        }
    }

    public PluginJAR(File file) {
        this.path = file.getPath();
        String jarCacheDir = jEdit.getJARCacheDirectory();
        if (jarCacheDir != null) {
            this.cachePath = MiscUtilities.constructPath(jarCacheDir, file.getName() + ".summary");
        }
        this.file = file;
        this.classLoader = new JARClassLoader(this);
        this.actions = new ActionSet();
    }

    boolean init() {
        PluginCacheEntry cache = PluginJAR.getPluginCache(this);
        if (cache != null) {
            if (!this.loadCache(cache)) {
                return false;
            }
            this.classLoader.activate();
        } else {
            try {
                cache = this.generateCache();
                if (cache == null) {
                    return false;
                }
                PluginJAR.setPluginCache(this, cache);
                this.classLoader.activate();
            }
            catch (IOException io) {
                Log.log(9, this, "Cannot load plugin " + this.path);
                Log.log(9, this, io);
                Object[] args = new String[]{io.toString()};
                jEdit.pluginError(this.path, "plugin-error.load-error", args);
                this.uninit(false);
            }
        }
        return true;
    }

    void uninit(boolean exit) {
        this.deactivatePlugin(exit);
        if (!exit) {
            PluginJAR jar;
            for (String path : this.weRequireThese) {
                jar = jEdit.getPluginJAR(path);
                if (jar == null) continue;
                jar.theseRequireMe.remove(this.path);
            }
            for (String path : this.weUseThese) {
                jar = jEdit.getPluginJAR(path);
                if (jar == null) continue;
                jar.theseUseMe.remove(this.path);
            }
            this.classLoader.deactivate();
            BeanShell.resetClassManager();
            if (this.actions != null) {
                jEdit.removeActionSet(this.actions);
            }
            if (this.browserActions != null) {
                VFSBrowser.getActionContext().removeActionSet(this.browserActions);
            }
            DockableWindowFactory.getInstance().unloadDockableWindows(this);
            ServiceManager.unloadServices(this);
            jEdit.removePluginProps(this.properties);
            if (this.localizationProperties != null) {
                Collection<Properties> values = this.localizationProperties.values();
                for (Properties value : values) {
                    jEdit.removePluginProps(value);
                }
            }
            try {
                if (this.zipFile != null) {
                    this.zipFile.close();
                    this.zipFile = null;
                }
            }
            catch (IOException io) {
                Log.log(9, this, io);
            }
            this.removePluginCache();
        }
    }

    String[] getClasses() {
        return this.classes;
    }

    public String[] getResources() {
        return this.resources;
    }

    private void actionsPresentButNotCoreClass() {
        Log.log(7, this, this.getPath() + " has an actions.xml but no plugin core class");
        this.actions.setLabel("MISSING PLUGIN CORE CLASS");
    }

    private boolean loadCache(PluginCacheEntry cache) {
        if (cache.pluginClass != null) {
            if (!PluginJAR.continueLoading(cache.pluginClass, cache.cachedProperties)) {
                return false;
            }
            EditPlugin otherPlugin = jEdit.getPlugin(cache.pluginClass);
            if (otherPlugin != null) {
                jEdit.removePluginJAR(otherPlugin.getPluginJAR(), false);
            }
        }
        this.classes = cache.classes;
        this.resources = cache.resources;
        if (cache.localizationProperties != null) {
            this.localizationProperties = cache.localizationProperties;
            String currentLanguage = jEdit.getCurrentLanguage();
            Properties langProperties = this.localizationProperties.get(currentLanguage);
            if (langProperties != null) {
                jEdit.addPluginProps(langProperties);
            }
        }
        if (cache.cachedProperties != null) {
            this.properties = cache.cachedProperties;
            jEdit.addPluginProps(cache.cachedProperties);
        }
        if (cache.actionsURI != null && cache.cachedActionNames != null) {
            this.actions = new ActionSet(this, cache.cachedActionNames, cache.cachedActionToggleFlags, cache.actionsURI);
        }
        if (cache.browserActionsURI != null && cache.cachedBrowserActionNames != null) {
            this.browserActions = new ActionSet(this, cache.cachedBrowserActionNames, cache.cachedBrowserActionToggleFlags, cache.browserActionsURI);
            String label = jEdit.getProperty("plugin." + cache.pluginClass + ".name");
            this.browserActions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{label}));
            VFSBrowser.getActionContext().addActionSet(this.browserActions);
        }
        if (cache.dockablesURI != null && cache.cachedDockableNames != null && cache.cachedDockableActionFlags != null && cache.cachedDockableMovableFlags != null) {
            this.dockablesURI = cache.dockablesURI;
            DockableWindowFactory.getInstance().cacheDockableWindows(this, cache.cachedDockableNames, cache.cachedDockableActionFlags, cache.cachedDockableMovableFlags);
        }
        if (this.actions.size() != 0) {
            jEdit.addActionSet(this.actions);
        }
        if (cache.servicesURI != null && cache.cachedServices != null) {
            this.servicesURI = cache.servicesURI;
            for (int i = 0; i < cache.cachedServices.length; ++i) {
                ServiceManager.Descriptor d = cache.cachedServices[i];
                ServiceManager.registerService(d);
            }
        }
        if (cache.pluginClass != null) {
            String label = jEdit.getProperty("plugin." + cache.pluginClass + ".name");
            this.actions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{label}));
            this.plugin = new EditPlugin.Deferred(this, cache.pluginClass);
        } else if (this.actions.size() != 0) {
            this.actionsPresentButNotCoreClass();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginCacheEntry generateCache() throws IOException {
        this.properties = new Properties();
        this.localizationProperties = new HashMap<String, Properties>();
        LinkedList<String> classes = new LinkedList<String>();
        LinkedList<String> resources = new LinkedList<String>();
        ZipFile zipFile = this.getZipFile();
        LinkedList<String> plugins = new LinkedList<String>();
        PluginCacheEntry cache = new PluginCacheEntry();
        cache.modTime = this.file.lastModified();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        Pattern languageFilePattern = Pattern.compile("lang_(\\w+).properties");
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            String lname = name.toLowerCase();
            if ("actions.xml".equals(lname)) {
                cache.actionsURI = this.classLoader.getResource(name);
                continue;
            }
            if ("browser.actions.xml".equals(lname)) {
                cache.browserActionsURI = this.classLoader.getResource(name);
                continue;
            }
            if ("dockables.xml".equals(lname)) {
                cache.dockablesURI = this.dockablesURI = this.classLoader.getResource(name);
                continue;
            }
            if ("services.xml".equals(lname)) {
                cache.servicesURI = this.servicesURI = this.classLoader.getResource(name);
                continue;
            }
            if (lname.endsWith(".props")) {
                InputStream in = null;
                try {
                    in = this.classLoader.getResourceAsStream(name);
                    this.properties.load(in);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(in);
                    throw throwable;
                }
                IOUtilities.closeQuietly(in);
                continue;
            }
            if (name.endsWith(".class")) {
                String className = MiscUtilities.fileToClass(name);
                if (className.endsWith("Plugin")) {
                    plugins.add(className);
                }
                classes.add(className);
                continue;
            }
            Matcher matcher = languageFilePattern.matcher(lname);
            if (matcher.matches()) {
                String languageName = matcher.group(1);
                Properties props = new Properties();
                InputStream in = null;
                try {
                    in = this.classLoader.getResourceAsStream(name);
                    CharsetEncoding utf8 = new CharsetEncoding("UTF-8");
                    Reader utf8in = utf8.getTextReader(in);
                    props.load(utf8in);
                    this.localizationProperties.put(languageName, props);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(in);
                    throw throwable;
                }
                IOUtilities.closeQuietly(in);
                continue;
            }
            resources.add(name);
        }
        cache.cachedProperties = this.properties;
        cache.localizationProperties = this.localizationProperties;
        if (cache.localizationProperties != null) {
            this.localizationProperties = cache.localizationProperties;
            String currentLanguage = jEdit.getCurrentLanguage();
            Properties langProperties = this.localizationProperties.get(currentLanguage);
            if (langProperties != null) {
                jEdit.addPluginProps(langProperties);
            }
        }
        jEdit.addPluginProps(this.properties);
        cache.classes = classes.toArray(new String[classes.size()]);
        this.classes = cache.classes;
        cache.resources = resources.toArray(new String[resources.size()]);
        this.resources = cache.resources;
        String label = null;
        for (String className : plugins) {
            String _label = jEdit.getProperty("plugin." + className + ".name");
            String version = jEdit.getProperty("plugin." + className + ".version");
            if (_label == null || version == null) {
                Log.log(7, this, "Ignoring: " + className);
                continue;
            }
            cache.pluginClass = className;
            if (!PluginJAR.continueLoading(className, cache.cachedProperties)) {
                return null;
            }
            EditPlugin otherPlugin = jEdit.getPlugin(className);
            if (otherPlugin != null) {
                jEdit.removePluginJAR(otherPlugin.getPluginJAR(), false);
            }
            this.plugin = new EditPlugin.Deferred(this, className);
            label = _label;
            break;
        }
        if (cache.actionsURI != null) {
            this.actions = new ActionSet(this, null, null, cache.actionsURI);
            this.actions.load();
            cache.cachedActionNames = this.actions.getCacheableActionNames();
            cache.cachedActionToggleFlags = new boolean[cache.cachedActionNames.length];
            for (int i = 0; i < cache.cachedActionNames.length; ++i) {
                cache.cachedActionToggleFlags[i] = jEdit.getBooleanProperty(cache.cachedActionNames[i] + ".toggle");
            }
        }
        if (cache.browserActionsURI != null) {
            this.browserActions = new ActionSet(this, null, null, cache.browserActionsURI);
            this.browserActions.load();
            VFSBrowser.getActionContext().addActionSet(this.browserActions);
            cache.cachedBrowserActionNames = this.browserActions.getCacheableActionNames();
            cache.cachedBrowserActionToggleFlags = new boolean[cache.cachedBrowserActionNames.length];
            for (int i = 0; i < cache.cachedBrowserActionNames.length; ++i) {
                cache.cachedBrowserActionToggleFlags[i] = jEdit.getBooleanProperty(cache.cachedBrowserActionNames[i] + ".toggle");
            }
        }
        if (this.dockablesURI != null) {
            DockableWindowFactory.getInstance().loadDockableWindows(this, this.dockablesURI, cache);
        }
        if (this.actions.size() != 0) {
            if (label != null) {
                this.actions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{label}));
            } else {
                this.actionsPresentButNotCoreClass();
            }
            jEdit.addActionSet(this.actions);
        }
        if (this.servicesURI != null) {
            ServiceManager.loadServices(this, this.servicesURI, cache);
        }
        return cache;
    }

    private static boolean continueLoading(String clazz, Properties cachedProperties) {
        String thisVersion;
        String otherVersion;
        return jEdit.getPlugin(clazz) == null || (otherVersion = jEdit.getProperty("plugin." + clazz + ".version")).compareTo(thisVersion = cachedProperties.getProperty("plugin." + clazz + ".version")) <= 0;
    }

    private void startPlugin() {
        try {
            this.plugin.start();
        }
        catch (Throwable t) {
            this.breakPlugin();
            Log.log(9, this, "Error while starting plugin " + this.plugin.getClassName());
            Log.log(9, this, t);
            Object[] args = new String[]{t.toString()};
            jEdit.pluginError(this.path, "plugin-error.start-error", args);
        }
        if (this.plugin instanceof EBPlugin || this.plugin.getClass().getAnnotation(EditBus.EBHandler.class) != null) {
            if (jEdit.getProperty("plugin." + this.plugin.getClassName() + ".activate") == null) {
                ((EBComponent)((Object)this.plugin)).handleMessage(new PropertiesChanged(null));
            }
            EditBus.addToBus(this.plugin);
        }
        for (Buffer buffer = jEdit.getFirstBuffer(); buffer != null; buffer = buffer.getNext()) {
            FoldHandler handler = FoldHandler.getFoldHandler(buffer.getStringProperty("folding"));
            if (buffer.getFoldHandler() == null || handler == null || handler == buffer.getFoldHandler()) continue;
            buffer.setFoldHandler(handler);
        }
    }

    private void startPluginLater() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!PluginJAR.this.activated) {
                    return;
                }
                PluginJAR.this.startPlugin();
            }
        });
    }

    private void breakPlugin() {
        this.plugin = new EditPlugin.Broken(this, this.plugin.getClassName());
        this.uninit(false);
        jEdit.addPluginProps(this.properties);
    }

    private void removePluginCache() {
        if (this.cachePath != null) {
            new File(this.cachePath).delete();
        }
    }

    public static class PluginCacheEntry {
        public static final int MAGIC = -1214061532;
        public PluginJAR plugin;
        public long modTime;
        public String[] classes;
        public String[] resources;
        public URL actionsURI;
        public String[] cachedActionNames;
        public boolean[] cachedActionToggleFlags;
        public URL browserActionsURI;
        public String[] cachedBrowserActionNames;
        public boolean[] cachedBrowserActionToggleFlags;
        public URL dockablesURI;
        public String[] cachedDockableNames;
        public boolean[] cachedDockableActionFlags;
        public boolean[] cachedDockableMovableFlags;
        public URL servicesURI;
        ServiceManager.Descriptor[] cachedServices;
        public Properties cachedProperties;
        public Map<String, Properties> localizationProperties;
        public String pluginClass;

        public boolean read(DataInputStream din) throws IOException {
            int cacheMagic = din.readInt();
            if (cacheMagic != -1214061532) {
                return false;
            }
            String cacheBuild = PluginCacheEntry.readString(din);
            if (!cacheBuild.equals(jEdit.getBuild())) {
                return false;
            }
            long cacheModTime = din.readLong();
            if (cacheModTime != this.modTime) {
                return false;
            }
            this.actionsURI = PluginCacheEntry.readURI(din);
            this.cachedActionNames = PluginCacheEntry.readStringArray(din);
            this.cachedActionToggleFlags = PluginCacheEntry.readBooleanArray(din);
            this.browserActionsURI = PluginCacheEntry.readURI(din);
            this.cachedBrowserActionNames = PluginCacheEntry.readStringArray(din);
            this.cachedBrowserActionToggleFlags = PluginCacheEntry.readBooleanArray(din);
            this.dockablesURI = PluginCacheEntry.readURI(din);
            this.cachedDockableNames = PluginCacheEntry.readStringArray(din);
            this.cachedDockableActionFlags = PluginCacheEntry.readBooleanArray(din);
            this.cachedDockableMovableFlags = PluginCacheEntry.readBooleanArray(din);
            this.servicesURI = PluginCacheEntry.readURI(din);
            int len = din.readInt();
            if (len == 0) {
                this.cachedServices = null;
            } else {
                this.cachedServices = new ServiceManager.Descriptor[len];
                for (int i = 0; i < len; ++i) {
                    ServiceManager.Descriptor d;
                    this.cachedServices[i] = d = new ServiceManager.Descriptor(PluginCacheEntry.readString(din), PluginCacheEntry.readString(din), null, this.plugin);
                }
            }
            this.classes = PluginCacheEntry.readStringArray(din);
            this.resources = PluginCacheEntry.readStringArray(din);
            this.cachedProperties = PluginCacheEntry.readMap(din);
            this.localizationProperties = PluginCacheEntry.readLanguagesMap(din);
            this.pluginClass = PluginCacheEntry.readString(din);
            return true;
        }

        public void write(DataOutputStream dout) throws IOException {
            dout.writeInt(-1214061532);
            PluginCacheEntry.writeString(dout, jEdit.getBuild());
            dout.writeLong(this.modTime);
            PluginCacheEntry.writeString(dout, this.actionsURI);
            PluginCacheEntry.writeStringArray(dout, this.cachedActionNames);
            PluginCacheEntry.writeBooleanArray(dout, this.cachedActionToggleFlags);
            PluginCacheEntry.writeString(dout, this.browserActionsURI);
            PluginCacheEntry.writeStringArray(dout, this.cachedBrowserActionNames);
            PluginCacheEntry.writeBooleanArray(dout, this.cachedBrowserActionToggleFlags);
            PluginCacheEntry.writeString(dout, this.dockablesURI);
            PluginCacheEntry.writeStringArray(dout, this.cachedDockableNames);
            PluginCacheEntry.writeBooleanArray(dout, this.cachedDockableActionFlags);
            PluginCacheEntry.writeBooleanArray(dout, this.cachedDockableMovableFlags);
            PluginCacheEntry.writeString(dout, this.servicesURI);
            if (this.cachedServices == null) {
                dout.writeInt(0);
            } else {
                dout.writeInt(this.cachedServices.length);
                for (int i = 0; i < this.cachedServices.length; ++i) {
                    PluginCacheEntry.writeString(dout, this.cachedServices[i].clazz);
                    PluginCacheEntry.writeString(dout, this.cachedServices[i].name);
                }
            }
            PluginCacheEntry.writeStringArray(dout, this.classes);
            PluginCacheEntry.writeStringArray(dout, this.resources);
            PluginCacheEntry.writeMap(dout, this.cachedProperties);
            PluginCacheEntry.writeLanguages(dout, this.localizationProperties);
            PluginCacheEntry.writeString(dout, this.pluginClass);
        }

        private static String readString(DataInputStream din) throws IOException {
            int len = din.readInt();
            if (len == 0) {
                return null;
            }
            char[] str = new char[len];
            for (int i = 0; i < len; ++i) {
                str[i] = din.readChar();
            }
            return new String(str);
        }

        private static URL readURI(DataInputStream din) throws IOException {
            String str = PluginCacheEntry.readString(din);
            if (str == null) {
                return null;
            }
            return new URL(str);
        }

        private static String[] readStringArray(DataInputStream din) throws IOException {
            int len = din.readInt();
            if (len == 0) {
                return null;
            }
            String[] str = new String[len];
            for (int i = 0; i < len; ++i) {
                str[i] = PluginCacheEntry.readString(din);
            }
            return str;
        }

        private static boolean[] readBooleanArray(DataInputStream din) throws IOException {
            int len = din.readInt();
            if (len == 0) {
                return null;
            }
            boolean[] bools = new boolean[len];
            for (int i = 0; i < len; ++i) {
                bools[i] = din.readBoolean();
            }
            return bools;
        }

        private static Properties readMap(DataInputStream din) throws IOException {
            Properties returnValue = new Properties();
            int count = din.readInt();
            for (int i = 0; i < count; ++i) {
                String key = PluginCacheEntry.readString(din);
                String value = PluginCacheEntry.readString(din);
                if (value == null) {
                    value = "";
                }
                returnValue.setProperty(key, value);
            }
            return returnValue;
        }

        private static Map<String, Properties> readLanguagesMap(DataInputStream din) throws IOException {
            int languagesCount = din.readInt();
            if (languagesCount == 0) {
                return Collections.emptyMap();
            }
            HashMap<String, Properties> languages = new HashMap<String, Properties>(languagesCount);
            for (int i = 0; i < languagesCount; ++i) {
                String lang = PluginCacheEntry.readString(din);
                Properties props = PluginCacheEntry.readMap(din);
                languages.put(lang, props);
            }
            return languages;
        }

        private static void writeString(DataOutputStream dout, Object obj) throws IOException {
            if (obj == null) {
                dout.writeInt(0);
            } else {
                String str = obj.toString();
                dout.writeInt(str.length());
                dout.writeChars(str);
            }
        }

        private static void writeStringArray(DataOutputStream dout, String[] str) throws IOException {
            if (str == null) {
                dout.writeInt(0);
            } else {
                dout.writeInt(str.length);
                for (int i = 0; i < str.length; ++i) {
                    PluginCacheEntry.writeString(dout, str[i]);
                }
            }
        }

        private static void writeBooleanArray(DataOutputStream dout, boolean[] bools) throws IOException {
            if (bools == null) {
                dout.writeInt(0);
            } else {
                dout.writeInt(bools.length);
                for (int i = 0; i < bools.length; ++i) {
                    dout.writeBoolean(bools[i]);
                }
            }
        }

        private static void writeMap(DataOutputStream dout, Properties properties) throws IOException {
            dout.writeInt(properties.size());
            Set<Map.Entry<Object, Object>> set = properties.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                PluginCacheEntry.writeString(dout, entry.getKey());
                PluginCacheEntry.writeString(dout, entry.getValue());
            }
        }

        private static void writeLanguages(DataOutputStream dout, Map<String, Properties> languages) throws IOException {
            dout.writeInt(languages.size());
            for (Map.Entry<String, Properties> entry : languages.entrySet()) {
                PluginCacheEntry.writeString(dout, entry.getKey());
                PluginCacheEntry.writeMap(dout, entry.getValue());
            }
        }
    }

    private static class PluginDepends {
        String what;
        String arg;
        boolean optional;

        private PluginDepends() {
        }
    }
}

