/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight.color;

import gatchan.highlight.color.ColorToken;
import gatchan.highlight.color.FlexColorScanner;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.IOException;
import java.io.StringReader;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.Log;

public class FlexColorPainter
extends TextAreaExtension {
    public static final int MAX_LINE_LENGTH = 10000;
    private final TextArea textArea;
    private final Point point = new Point();

    public FlexColorPainter(TextArea textArea) {
        this.textArea = textArea;
    }

    public void paintScreenLineRange(Graphics2D gfx, int firstLine, int lastLine, int[] physicalLines, int[] start, int[] end, int y, int lineHeight) {
        if (jEdit.getBooleanProperty((String)"gatchan.highlight.colorsenabled")) {
            super.paintScreenLineRange(gfx, firstLine, lastLine, physicalLines, start, end, y, lineHeight);
        }
    }

    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        String lineContent;
        int endOffset;
        int startOffset;
        int screenToPhysicalOffset;
        JEditBuffer buffer = this.textArea.getBuffer();
        int lineStart = buffer.getLineStartOffset(physicalLine);
        int length = buffer.getLineLength(physicalLine);
        int l = length - (screenToPhysicalOffset = start - (startOffset = this.textArea.getLineStartOffset(physicalLine))) - (endOffset = this.textArea.getLineEndOffset(physicalLine)) + end;
        if (l > 10000) {
            l = 10000;
        }
        if ((lineContent = buffer.getText(lineStart + screenToPhysicalOffset, l)).isEmpty()) {
            return;
        }
        FlexColorScanner flexColor = new FlexColorScanner(new StringReader(lineContent));
        try {
            ColorToken token = flexColor.yylex();
            while (token != null) {
                this.paint(token, gfx, physicalLine, start, y);
                try {
                    token = flexColor.yylex();
                }
                catch (IOException e) {
                    Log.log((int)9, (Object)((Object)this), (Object)e);
                }
            }
        }
        catch (IOException e) {
            Log.log((int)9, (Object)((Object)this), (Object)e);
        }
    }

    private void paint(ColorToken token, Graphics2D gfx, int physicalLine, int start, int y) {
        int phycialLineStartOffset = this.textArea.getLineStartOffset(physicalLine);
        int screenStartOffset = start + token.getStart();
        int screenEndOffset = start + token.getEnd();
        Point p = this.textArea.offsetToXY(physicalLine, screenStartOffset - phycialLineStartOffset, this.point);
        if (p == null) {
            return;
        }
        int startX = p.x;
        p = this.textArea.offsetToXY(physicalLine, screenEndOffset - phycialLineStartOffset, this.point);
        if (p == null) {
            return;
        }
        int endX = p.x;
        Color oldColor = gfx.getColor();
        Composite oldComposite = gfx.getComposite();
        gfx.setColor(token.getColor());
        FontMetrics fm = this.textArea.getPainter().getFontMetrics();
        int y2 = y + fm.getHeight() - 2;
        int y3 = y + fm.getHeight() - 1;
        gfx.drawLine(startX, y2, endX, y2);
        gfx.drawLine(startX, y3, endX, y3);
        gfx.setColor(oldColor);
        gfx.setComposite(oldComposite);
    }
}

