/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightDialog;
import gatchan.highlight.HighlightHypersearchResults;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.HighlightOverview;
import gatchan.highlight.Highlighter;
import gatchan.highlight.color.FlexColorPainter;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.jedit.visitors.JEditVisitor;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class HighlightPlugin
extends EditPlugin {
    private static HighlightManager highlightManager;
    public static final String LAYER_PROPERTY = "plugin.highlight";
    public static final String NAME = "highlight";
    public static final String PROPERTY_PREFIX = "plugin.Highlight.";
    public static final String MENU = "highlight.menu";
    public static final String OPTION_PREFIX = "options.highlight.";
    private int layer;
    private float alpha;
    private boolean highlightOverview;
    private boolean highlightOverviewSameColor;
    private Color highlightOverviewColor;

    public void start() {
        this.layer = jEdit.getIntegerProperty((String)"gatchan.highlight.layer", (int)Integer.MAX_VALUE);
        this.highlightOverview = jEdit.getBooleanProperty((String)"gatchan.highlight.overview");
        File highlightFile = this.dataMigration();
        highlightManager = HighlightManagerTableModel.createInstance(highlightFile);
        highlightManager.propertiesChanged();
        jEdit.visit((JEditVisitor)new TextAreaInitializer());
        jEdit.visit((JEditVisitor)new ViewInitializer());
        EditBus.addToBus((Object)((Object)this));
    }

    public void stop() {
        EditBus.removeFromBus((Object)((Object)this));
        jEdit.resetProperty((String)"plugin.gatchan.highlight.HighlightPlugin.activate");
        Buffer[] buffers = jEdit.getBuffers();
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i].unsetProperty("highlights");
        }
        jEdit.visit((JEditVisitor)new TextAreaUninitializer());
        jEdit.visit((JEditVisitor)new ViewUninitializer());
        highlightManager.dispose();
        highlightManager = null;
    }

    private static void uninitTextArea(JEditTextArea textArea) {
        FlexColorPainter flexColorPainter;
        TextAreaPainter painter = textArea.getPainter();
        Highlighter highlighter = (Highlighter)textArea.getClientProperty(Highlighter.class);
        if (highlighter != null) {
            painter.removeExtension((TextAreaExtension)highlighter);
            textArea.putClientProperty(Highlighter.class, null);
            highlightManager.removeHighlightChangeListener(highlighter);
        }
        if ((flexColorPainter = (FlexColorPainter)((Object)textArea.getClientProperty(FlexColorPainter.class))) != null) {
            painter.removeExtension((TextAreaExtension)flexColorPainter);
            textArea.putClientProperty(FlexColorPainter.class, null);
        }
        HighlightPlugin.removeHighlightOverview(textArea);
        textArea.removeCaretListener((CaretListener)highlightManager);
    }

    private void initTextArea(JEditTextArea textArea) {
        Highlighter highlighter = new Highlighter(textArea);
        highlightManager.addHighlightChangeListener(highlighter);
        TextAreaPainter painter = textArea.getPainter();
        painter.addExtension(this.layer, (TextAreaExtension)highlighter);
        textArea.putClientProperty(Highlighter.class, (Object)highlighter);
        textArea.addCaretListener((CaretListener)highlightManager);
        FlexColorPainter flexColorPainter = new FlexColorPainter((TextArea)textArea);
        textArea.putClientProperty(FlexColorPainter.class, (Object)flexColorPainter);
        painter.addExtension(this.layer - 1, (TextAreaExtension)flexColorPainter);
        if (this.highlightOverview) {
            this.addHighlightOverview(textArea);
        }
        textArea.revalidate();
    }

    private void addHighlightOverview(JEditTextArea textArea) {
        HighlightOverview currentOverview = (HighlightOverview)textArea.getClientProperty(HighlightOverview.class);
        if (currentOverview == null) {
            currentOverview = new HighlightOverview(textArea);
            highlightManager.addHighlightChangeListener(currentOverview);
            textArea.addLeftOfScrollBar((Component)currentOverview);
            textArea.putClientProperty(HighlightOverview.class, (Object)currentOverview);
        }
        if (!jEdit.getBooleanProperty((String)"gatchan.highlight.overview.samecolor")) {
            currentOverview.setOverviewColor(jEdit.getColorProperty((String)"gatchan.highlight.overview.color"));
        } else {
            currentOverview.setOverviewColor(null);
        }
    }

    private static void removeHighlightOverview(JEditTextArea textArea) {
        HighlightOverview overview = (HighlightOverview)textArea.getClientProperty(HighlightOverview.class);
        if (overview != null) {
            textArea.removeLeftOfScrollBar((Component)overview);
            textArea.putClientProperty(HighlightOverview.class, null);
            highlightManager.removeHighlightChangeListener(overview);
            textArea.revalidate();
        }
    }

    private HighlightHypersearchResults initView(View view) {
        HighlightHypersearchResults highlighter = new HighlightHypersearchResults(view);
        highlighter.start();
        view.getDockableWindowManager().putClientProperty(HighlightHypersearchResults.class, (Object)highlighter);
        return highlighter;
    }

    private static void uninitView(View view) {
        HighlightHypersearchResults highlighter = (HighlightHypersearchResults)view.getDockableWindowManager().getClientProperty(HighlightHypersearchResults.class);
        if (highlighter == null) {
            return;
        }
        highlighter.stop();
        view.getDockableWindowManager().putClientProperty(HighlightHypersearchResults.class, null);
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        boolean newOverview = jEdit.getBooleanProperty((String)"gatchan.highlight.overview");
        boolean newOverviewSameColor = jEdit.getBooleanProperty((String)"gatchan.highlight.overview.samecolor");
        Color newOverviewColor = jEdit.getColorProperty((String)"gatchan.highlight.overview.color");
        int layer = jEdit.getIntegerProperty((String)"gatchan.highlight.layer", (int)Integer.MAX_VALUE);
        float alpha = (float)jEdit.getIntegerProperty((String)"gatchan.highlight.alpha", (int)50) / 100.0f;
        if (this.layer != layer || this.alpha != alpha || newOverview != this.highlightOverview || newOverviewSameColor != this.highlightOverviewSameColor || this.highlightOverviewColor != null && !this.highlightOverviewColor.equals(newOverviewColor)) {
            this.highlightOverview = newOverview;
            this.highlightOverviewSameColor = newOverviewSameColor;
            this.highlightOverviewColor = newOverviewColor;
            this.layer = layer;
            this.alpha = alpha;
            jEdit.visit((JEditVisitor)new JEditVisitorAdapter(){

                public void visit(JEditTextArea textArea) {
                    TextAreaPainter painter = textArea.getPainter();
                    Highlighter highlighter = (Highlighter)textArea.getClientProperty(Highlighter.class);
                    highlighter.setAlphaComposite(HighlightPlugin.this.alpha);
                    painter.removeExtension((TextAreaExtension)highlighter);
                    painter.addExtension(HighlightPlugin.this.layer, (TextAreaExtension)highlighter);
                    if (HighlightPlugin.this.highlightOverview) {
                        HighlightPlugin.this.addHighlightOverview(textArea);
                    } else {
                        HighlightPlugin.removeHighlightOverview(textArea);
                    }
                }
            });
        }
        highlightManager.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate vu) {
        View view = vu.getView();
        Object what = vu.getWhat();
        if (what == ViewUpdate.CREATED) {
            this.initView(view);
        } else if (what == ViewUpdate.CLOSED) {
            HighlightPlugin.uninitView(view);
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        JEditTextArea textArea = editPaneUpdate.getEditPane().getTextArea();
        Object what = editPaneUpdate.getWhat();
        if (what == EditPaneUpdate.CREATED) {
            this.initTextArea(textArea);
        } else if (what == EditPaneUpdate.DESTROYED) {
            HighlightPlugin.uninitTextArea(textArea);
        }
    }

    @EditBus.EBHandler
    public void handleBufferPaneUpdate(BufferUpdate bufferUpdate) {
        if (bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
            highlightManager.bufferClosed(bufferUpdate.getBuffer());
        }
    }

    @EditBus.EBHandler
    public void handleDockableWindowUpdate(DockableWindowUpdate dockableUpdate) {
        if (dockableUpdate.getWhat() == DockableWindowUpdate.ACTIVATED && "hypersearch-results".equals(dockableUpdate.getDockable())) {
            View view = ((DockableWindowManager)dockableUpdate.getSource()).getView();
            HighlightHypersearchResults highlighter = (HighlightHypersearchResults)view.getDockableWindowManager().getClientProperty(HighlightHypersearchResults.class);
            if (highlighter == null) {
                this.initView(view);
            } else {
                highlighter.start();
            }
        }
    }

    public static void highlightThis(JEditTextArea textArea) {
        HighlightPlugin.highlightThis(textArea, 0);
    }

    public static void highlightThis(JEditTextArea textArea, int scope) {
        String text = HighlightPlugin.getCurrentWord((TextArea)textArea);
        if (text == null) {
            return;
        }
        Highlight highlight = new Highlight(text);
        highlight.setScope(scope);
        if (scope == 2) {
            highlight.setBuffer(textArea.getBuffer());
        }
        highlightManager.addElement(highlight);
    }

    private static String getCurrentWord(TextArea textArea) {
        String text = textArea.getSelectedText();
        if (text == null) {
            textArea.selectWord();
            text = textArea.getSelectedText();
        }
        return text;
    }

    public static void highlightEntireWord(JEditTextArea textArea) {
        HighlightPlugin.highlightEntireWord(textArea, 0);
    }

    public static void highlightEntireWord(JEditTextArea textArea, int scope) {
        String text = HighlightPlugin.getCurrentWord((TextArea)textArea);
        if (text == null) {
            return;
        }
        Highlight highlight = new Highlight("\\b" + text + "\\b", true, false);
        highlight.setScope(scope);
        if (scope == 2) {
            highlight.setBuffer(textArea.getBuffer());
        }
        highlightManager.addElement(highlight);
    }

    public static void highlightCurrentSearch() {
        HighlightPlugin.highlightCurrentSearch(0);
    }

    public static void highlightCurrentSearch(int scope) {
        Highlight h = new Highlight();
        h.setScope(scope);
        if (scope == 2) {
            h.setBuffer((JEditBuffer)jEdit.getActiveView().getBuffer());
        }
        h.init(SearchAndReplace.getSearchString(), SearchAndReplace.getRegexp(), SearchAndReplace.getIgnoreCase(), Highlight.getNextColor());
        HighlightPlugin.addHighlight(h);
    }

    public static void highlightDialog(View view, TextArea textArea) {
        String currentWord = HighlightPlugin.getCurrentWord(textArea);
        HighlightDialog d = new HighlightDialog(view);
        if (currentWord != null && currentWord.length() != 0) {
            d.setString(currentWord);
        }
        d.setVisible(true);
    }

    public static void addHighlight(Highlight highlight) {
        highlightManager.addElement(highlight);
    }

    public static void removeAllHighlights() {
        highlightManager.removeAll();
    }

    public static void enableHighlights() {
        highlightManager.setHighlightEnable(true);
    }

    public static void disableHighlights() {
        highlightManager.setHighlightEnable(false);
    }

    public static void toggleHighlights() {
        highlightManager.setHighlightEnable(!highlightManager.isHighlightEnable());
    }

    public static void highlightHyperSearchResult(View view) {
        HighlightHypersearchResults h = (HighlightHypersearchResults)view.getDockableWindowManager().getClientProperty(HighlightHypersearchResults.class);
        if (h == null) {
            return;
        }
        h.start();
    }

    public static boolean isHighlightEnable() {
        return highlightManager.isHighlightEnable();
    }

    public File dataMigration() {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            return null;
        }
        File file = new File(settingsDirectory, "plugins");
        String home = new File(file, ((Object)((Object)this)).getClass().getName()).getPath();
        if (home == null) {
            return null;
        }
        String PROJECT_DIRECTORY = jEdit.getSettingsDirectory() + File.separator + "HighlightPlugin" + File.separator;
        File projectDirectory = new File(PROJECT_DIRECTORY);
        File highlights = new File(projectDirectory, "highlights.ser");
        File homeFolder = new File(home);
        if (!homeFolder.exists()) {
            Log.log((int)1, (Object)((Object)this), (Object)("Home doesn't exist, trying to create it " + home));
            if (!homeFolder.mkdirs()) {
                Log.log((int)9, (Object)((Object)this), (Object)"Unable to create home directory, running Highlight plugin with no Home");
                return null;
            }
        }
        if (!homeFolder.isDirectory() || !homeFolder.canWrite()) {
            Log.log((int)9, (Object)((Object)this), (Object)"Unable to write in home folder");
            return null;
        }
        File newFile = new File(homeFolder, "highlights.ser");
        if (highlights.isFile()) {
            Log.log((int)1, (Object)((Object)this), (Object)"Moving data to new home");
            IOUtilities.moveFile((File)highlights, (File)newFile);
            highlights.delete();
            projectDirectory.delete();
            return newFile;
        }
        return newFile;
    }

    private class ViewUninitializer
    extends JEditVisitorAdapter {
        private ViewUninitializer() {
        }

        public void visit(View view) {
            HighlightPlugin.uninitView(view);
        }
    }

    private class ViewInitializer
    extends JEditVisitorAdapter {
        private ViewInitializer() {
        }

        public void visit(View view) {
            HighlightPlugin.this.initView(view);
        }
    }

    private class TextAreaUninitializer
    extends JEditVisitorAdapter {
        private TextAreaUninitializer() {
        }

        public void visit(JEditTextArea textArea) {
            HighlightPlugin.uninitTextArea(textArea);
        }
    }

    private class TextAreaInitializer
    extends JEditVisitorAdapter {
        private TextAreaInitializer() {
        }

        public void visit(JEditTextArea textArea) {
            HighlightPlugin.this.initTextArea(textArea);
        }
    }
}

