/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.lobobrowser.util.FilteredCollection;
import org.lobobrowser.util.ObjectFilter;
import org.lobobrowser.util.Objects;

public class WeakValueHashMap
implements Map {
    private final Map map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object object) {
        WeakReference weakReference = (WeakReference)this.map.get(object);
        return weakReference != null && weakReference.get() != null;
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public Object get(Object object) {
        this.checkQueue();
        WeakReference weakReference = (WeakReference)this.map.get(object);
        return weakReference == null ? null : weakReference.get();
    }

    public Object put(Object object, Object object2) {
        this.checkQueue();
        return this.putImpl(object, object2);
    }

    private final Object putImpl(Object object, Object object2) {
        if (object2 == null) {
            throw new IllegalArgumentException("null values not accepted");
        }
        LocalWeakReference localWeakReference = new LocalWeakReference(object, object2, this.queue);
        WeakReference weakReference = this.map.put(object, localWeakReference);
        return weakReference == null ? null : weakReference.get();
    }

    public Object remove(Object object) {
        this.checkQueue();
        WeakReference weakReference = (WeakReference)this.map.remove(object);
        return weakReference == null ? null : weakReference.get();
    }

    public void putAll(Map map) {
        this.checkQueue();
        for (Map.Entry entry : map.entrySet()) {
            this.putImpl(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.checkQueue();
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    private final void checkQueue() {
        LocalWeakReference localWeakReference;
        ReferenceQueue referenceQueue = this.queue;
        while ((localWeakReference = (LocalWeakReference)referenceQueue.poll()) != null) {
            this.map.remove(localWeakReference.getKey());
        }
    }

    public Collection values() {
        return new FilteredCollection(this.map.values(), new LocalFilter());
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class LocalWeakReference
    extends WeakReference {
        private final Object key;

        public LocalWeakReference(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }

        public Object getKey() {
            return this.key;
        }

        public boolean equals(Object object) {
            Object t = this.get();
            Object var3_3 = object instanceof LocalWeakReference ? ((LocalWeakReference)object).get() : null;
            return Objects.equals(t, var3_3);
        }

        public int hashCode() {
            Object t = this.get();
            return t == null ? 0 : t.hashCode();
        }
    }

    private class LocalFilter
    implements ObjectFilter {
        private LocalFilter() {
        }

        public Object decode(Object object) {
            WeakReference weakReference = (WeakReference)object;
            return weakReference == null ? null : weakReference.get();
        }

        public Object encode(Object object) {
            throw new UnsupportedOperationException("Read-only collection.");
        }
    }
}

