/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.lobobrowser.util.Domains;
import org.lobobrowser.util.NameValuePair;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.Strings;

public class Urls {
    private static final Logger logger = Logger.getLogger(Urls.class.getName());
    public static final DateFormat PATTERN_RFC1123;

    private Urls() {
    }

    public static boolean isLocal(URL uRL) {
        if (Urls.isLocalFile(uRL)) {
            return true;
        }
        String string = uRL.getProtocol();
        if ("jar".equalsIgnoreCase(string)) {
            String string2 = uRL.getPath();
            int n = string2.lastIndexOf(33);
            String string3 = n == -1 ? string2 : string2.substring(0, n);
            try {
                URL uRL2 = new URL(string3);
                return Urls.isLocal(uRL2);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return false;
    }

    public static boolean isLocalFile(URL uRL) {
        String string = uRL.getProtocol();
        return "file".equalsIgnoreCase(string) && !Urls.hasHost(uRL);
    }

    public static boolean hasHost(URL uRL) {
        String string = uRL.getHost();
        return string != null && !"".equals(string);
    }

    public static URL createURL(URL uRL, String string) throws MalformedURLException {
        return new URL(uRL, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getExpiration(URLConnection uRLConnection, long l) {
        int n;
        Object object;
        Object object2;
        String string = uRLConnection.getHeaderField("Cache-Control");
        if (string != null) {
            object2 = new StringTokenizer(string, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken().trim().toLowerCase();
                if ("must-revalidate".equals(object)) {
                    return new Long(0L);
                }
                if (!((String)object).startsWith("max-age") || (n = ((String)object).indexOf(61)) == -1) continue;
                String string2 = ((String)object).substring(n + 1).trim();
                try {
                    int n2 = Integer.parseInt(string2);
                    return new Long(l + (long)(n2 * 1000));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warning("getExpiration(): Bad Cache-Control max-age value: " + string2);
                }
            }
        }
        if ((object2 = uRLConnection.getHeaderField("Expires")) != null) {
            try {
                object = PATTERN_RFC1123;
                synchronized (object) {
                    Date date = PATTERN_RFC1123.parse((String)object2);
                    return new Long(date.getTime());
                }
            }
            catch (ParseException parseException) {
                try {
                    n = Integer.parseInt((String)object2);
                    return new Long(l + (long)(n * 1000));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warning("getExpiration(): Bad Expires header value: " + (String)object2);
                }
            }
        }
        return null;
    }

    public static List getHeaders(URLConnection uRLConnection) {
        String string;
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        int n = 0;
        while ((string = uRLConnection.getHeaderField(n)) != null) {
            String string2 = uRLConnection.getHeaderFieldKey(n);
            if (string2 != null) {
                arrayList.add(new NameValuePair(string2, string));
            }
            ++n;
        }
        return arrayList;
    }

    public static URL guessURL(URL uRL, String string) throws MalformedURLException {
        URL uRL2;
        try {
            if (uRL != null) {
                String string2;
                int n = string.indexOf(58);
                String string3 = string2 = n == -1 ? null : string.substring(0, n);
                if (string2 != null && !string2.equalsIgnoreCase(uRL.getProtocol())) {
                    uRL = null;
                }
            }
            uRL2 = Urls.createURL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            string = string.trim();
            int n = string.indexOf(58);
            if (n == -1) {
                String string4;
                int n2 = string.indexOf(47);
                uRL2 = n2 == 0 ? new URL("file:" + string) : (n2 == -1 ? new URL(uRL, "http://" + string) : (Domains.isLikelyHostName(string4 = string.substring(0, n2).toLowerCase()) ? new URL(uRL, "http://" + string) : new URL(uRL, "file:" + string)));
            }
            if (n == 1) {
                uRL2 = new URL(uRL, "file:" + string);
            }
            throw malformedURLException;
        }
        if (!"".equals(uRL2.getHost()) && uRL2.toExternalForm().indexOf(32) != -1) {
            throw new MalformedURLException("There are blanks in the URL: " + uRL2.toExternalForm());
        }
        return uRL2;
    }

    public static URL guessURL(String string) throws MalformedURLException {
        return Urls.guessURL(null, string);
    }

    public static String getCharset(URLConnection uRLConnection) {
        String string = uRLConnection.getContentType();
        if (string == null) {
            return Urls.getDefaultCharset(uRLConnection);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken().trim();
                int n = string3.indexOf(61);
                if (n == -1 || !"charset".equalsIgnoreCase(string2 = string3.substring(0, n).trim())) continue;
                String string4 = string3.substring(n + 1);
                return Strings.unquote(string4.trim());
            }
        }
        return Urls.getDefaultCharset(uRLConnection);
    }

    private static String getDefaultCharset(URLConnection uRLConnection) {
        URL uRL = uRLConnection.getURL();
        if (Urls.isLocalFile(uRL)) {
            String string = System.getProperty("file.encoding");
            return string == null ? "ISO-8859-1" : string;
        }
        return "ISO-8859-1";
    }

    public static String getNoRefForm(URL uRL) {
        String string = uRL.getHost();
        int n = uRL.getPort();
        String string2 = n == -1 ? "" : ":" + n;
        String string3 = uRL.getUserInfo();
        String string4 = string3 == null || string3.length() == 0 ? "" : string3 + "@";
        String string5 = string == null || string.length() == 0 ? "" : "//" + string4 + string + string2;
        return uRL.getProtocol() + ":" + string5 + uRL.getFile();
    }

    public static boolean sameNoRefURL(URL uRL, URL uRL2) {
        return Objects.equals(uRL.getHost(), uRL2.getHost()) && Objects.equals(uRL.getProtocol(), uRL2.getProtocol()) && uRL.getPort() == uRL2.getPort() && Objects.equals(uRL.getFile(), uRL2.getFile()) && Objects.equals(uRL.getUserInfo(), uRL2.getUserInfo());
    }

    static {
        DateFormat dateFormat = PATTERN_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

