/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.lobobrowser.util.ObjectFilter;

public class FilteredCollection
implements Collection {
    private final ObjectFilter filter;
    private final Collection sourceCollection;

    public FilteredCollection(Collection collection, ObjectFilter objectFilter) {
        this.filter = objectFilter;
        this.sourceCollection = collection;
    }

    public int size() {
        int n = 0;
        Iterator iterator = this.sourceCollection.iterator();
        while (iterator.hasNext()) {
            if (this.filter.decode(iterator.next()) == null) continue;
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        Iterator iterator = this.sourceCollection.iterator();
        while (iterator.hasNext()) {
            if (this.filter.decode(iterator.next()) == null) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object object) {
        return this.sourceCollection.contains(this.filter.encode(object));
    }

    public Iterator iterator() {
        final Iterator iterator = this.sourceCollection.iterator();
        return new Iterator(){
            private Boolean hasNext;
            private Object next;

            private void scanNext() {
                while (iterator.hasNext()) {
                    Object object = FilteredCollection.this.filter.decode(iterator.next());
                    if (object == null) continue;
                    this.hasNext = Boolean.TRUE;
                    this.next = object;
                }
                this.hasNext = Boolean.FALSE;
            }

            public boolean hasNext() {
                if (this.hasNext == null) {
                    this.scanNext();
                }
                return this.hasNext;
            }

            public Object next() {
                if (this.hasNext == null) {
                    this.scanNext();
                }
                if (Boolean.FALSE.equals(this.hasNext)) {
                    throw new NoSuchElementException();
                }
                Object object = this.next;
                this.hasNext = null;
                return object;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public Object[] toArray(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.sourceCollection.iterator();
        while (iterator.hasNext()) {
            Object object = this.filter.decode(iterator.next());
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(objectArray);
    }

    public boolean add(Object object) {
        return this.sourceCollection.add(this.filter.encode(object));
    }

    public boolean remove(Object object) {
        return this.sourceCollection.remove(this.filter.encode(object));
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Object[] objectArray = this.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (collection.contains(objectArray[i]) || !this.remove(objectArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    public void clear() {
        Object[] objectArray = this.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.sourceCollection.remove(this.filter.encode(objectArray[i]));
        }
    }
}

