/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.EventObject;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.GenericEventListener;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.io.IORoutines;
import org.w3c.dom.Document;

public class SimpleHttpRequest
implements HttpRequest {
    private static final Logger logger = Logger.getLogger(SimpleHttpRequest.class.getName());
    private int readyState;
    private int status;
    private String statusText;
    private byte[] responseBytes;
    private final UserAgentContext context;
    private final Proxy proxy;
    private boolean isAsync;
    private URL requestURL;
    protected String requestMethod;
    protected String requestUserName;
    protected String requestPassword;
    protected URLConnection connection;
    protected Map responseHeadersMap;
    protected String responseHeaders;
    private final EventDispatch readyEvent = new EventDispatch();

    public SimpleHttpRequest(UserAgentContext userAgentContext, Proxy proxy) {
        this.context = userAgentContext;
        this.proxy = proxy;
    }

    public synchronized int getReadyState() {
        return this.readyState;
    }

    public synchronized String getResponseText() {
        String string;
        byte[] byArray = this.responseBytes;
        URLConnection uRLConnection = this.connection;
        String string2 = string = uRLConnection == null ? "ISO-8859-1" : Urls.getCharset(uRLConnection);
        if (string == null) {
            string = "ISO-8859-1";
        }
        try {
            return byArray == null ? null : new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.log(Level.WARNING, "getResponseText(): Charset '" + string + "' did not work. Retrying with ISO-8859-1.", unsupportedEncodingException);
            try {
                return new String(byArray, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                return null;
            }
        }
    }

    public synchronized Document getResponseXML() {
        byte[] byArray = this.responseBytes;
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(byteArrayInputStream);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Unable to parse response as XML.", exception);
            return null;
        }
    }

    public synchronized byte[] getResponseBytes() {
        return this.responseBytes;
    }

    public synchronized Image getResponseImage() {
        byte[] byArray = this.responseBytes;
        if (byArray == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(byArray);
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized String getStatusText() {
        return this.statusText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        URLConnection uRLConnection;
        SimpleHttpRequest simpleHttpRequest = this;
        synchronized (simpleHttpRequest) {
            uRLConnection = this.connection;
        }
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        } else if (uRLConnection != null) {
            try {
                uRLConnection.getInputStream().close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public synchronized String getAllResponseHeaders() {
        return this.responseHeaders;
    }

    public synchronized String getResponseHeader(String string) {
        Map map = this.responseHeadersMap;
        return map == null ? null : (String)map.get(string);
    }

    public void open(String string, String string2) throws IOException {
        this.open(string, string2, true);
    }

    public void open(String string, URL uRL) throws IOException {
        this.open(string, uRL, true, null, null);
    }

    public void open(String string, URL uRL, boolean bl) throws IOException {
        this.open(string, uRL, bl, null, null);
    }

    public void open(String string, String string2, boolean bl) throws IOException {
        URL uRL = Urls.createURL(null, string2);
        this.open(string, uRL, bl, null);
    }

    public void open(String string, URL uRL, boolean bl, String string2) throws IOException {
        this.open(string, uRL, bl, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String string, URL uRL, boolean bl, String string2, String string3) throws IOException {
        this.abort();
        Proxy proxy = this.proxy;
        URLConnection uRLConnection = proxy == null || proxy == Proxy.NO_PROXY ? uRL.openConnection() : uRL.openConnection(proxy);
        SimpleHttpRequest simpleHttpRequest = this;
        synchronized (simpleHttpRequest) {
            this.connection = uRLConnection;
            this.isAsync = bl;
            this.requestMethod = string;
            this.requestURL = uRL;
            this.requestUserName = string2;
            this.requestPassword = string3;
        }
        this.changeState(1, 0, null, null);
    }

    public void send(final String string) throws IOException {
        final URL uRL = this.requestURL;
        if (uRL == null) {
            throw new IOException("No URL has been provided.");
        }
        if (this.isAsync) {
            new Thread("SimpleHttpRequest-" + uRL.getHost()){

                public void run() {
                    try {
                        SimpleHttpRequest.this.sendSync(string);
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.WARNING, "send(): Error in asynchronous request on " + uRL, throwable);
                    }
                }
            }.start();
        } else {
            this.sendSync(string);
        }
    }

    protected String getPostCharset() {
        return "UTF-8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSync(String string) throws IOException {
        Object object;
        try {
            InputStream inputStream;
            String string2;
            int n;
            byte[] byArray;
            Object object2;
            this.changeState(1, 0, null, null);
            SimpleHttpRequest simpleHttpRequest = this;
            synchronized (simpleHttpRequest) {
                object = this.connection;
            }
            ((URLConnection)object).setRequestProperty("User-Agent", this.context.getUserAgent());
            if (object instanceof HttpURLConnection) {
                object2 = (HttpURLConnection)object;
                String string3 = this.requestMethod;
                if (string3 == null) {
                    throw new IOException("Null method.");
                }
                string3 = string3.toUpperCase();
                ((HttpURLConnection)object2).setRequestMethod(string3);
                if ("POST".equals(string3) && string != null) {
                    ((URLConnection)object2).setDoOutput(true);
                    byArray = string.getBytes(this.getPostCharset());
                    ((HttpURLConnection)object2).setFixedLengthStreamingMode(byArray.length);
                    OutputStream outputStream = ((URLConnection)object2).getOutputStream();
                    try {
                        outputStream.write(byArray);
                    }
                    finally {
                        outputStream.flush();
                    }
                }
                n = ((HttpURLConnection)object2).getResponseCode();
                string2 = ((HttpURLConnection)object2).getResponseMessage();
                inputStream = ((HttpURLConnection)object2).getErrorStream();
            } else {
                n = 0;
                string2 = "";
                inputStream = null;
            }
            object2 = this;
            synchronized (object2) {
                this.responseHeaders = this.getAllResponseHeaders((URLConnection)object);
                this.responseHeadersMap = ((URLConnection)object).getHeaderFields();
            }
            this.changeState(2, n, string2, null);
            object2 = inputStream == null ? ((URLConnection)object).getInputStream() : inputStream;
            int n2 = ((URLConnection)object).getContentLength();
            this.changeState(3, n, string2, null);
            byArray = IORoutines.load((InputStream)object2, n2 == -1 ? 4096 : n2);
            this.changeState(4, n, string2, byArray);
        }
        finally {
            object = this;
            synchronized (object) {
                this.connection = null;
            }
        }
    }

    public void addReadyStateChangeListener(final ReadyStateChangeListener readyStateChangeListener) {
        this.readyEvent.addListener(new GenericEventListener(){

            public void processEvent(EventObject eventObject) {
                readyStateChangeListener.readyStateChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(int n, int n2, String string, byte[] byArray) {
        SimpleHttpRequest simpleHttpRequest = this;
        synchronized (simpleHttpRequest) {
            this.readyState = n;
            this.status = n2;
            this.statusText = string;
            this.responseBytes = byArray;
        }
        this.readyEvent.fireEvent(null);
    }

    private String getAllResponseHeaders(URLConnection uRLConnection) {
        String string;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = uRLConnection.getHeaderField(n)) != null) {
            String string2 = uRLConnection.getHeaderFieldKey(n);
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }
}

