/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.FloatingInfo;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.util.CollectionUtilities;

public class RRelative
extends BaseRCollection {
    private final RElement child;
    private final int xoffset;
    private final int yoffset;

    public RRelative(RenderableContainer renderableContainer, ModelNode modelNode, RElement rElement, int n, int n2) {
        super(renderableContainer, modelNode);
        rElement.setOriginalParent(this);
        rElement.setParent(this);
        rElement.setOrigin(n, n2);
        this.child = rElement;
        this.xoffset = n;
        this.yoffset = n2;
    }

    public void assignDimension() {
        RElement rElement = this.child;
        this.width = rElement.getWidth();
        this.height = rElement.getHeight();
    }

    public FloatingInfo getExportableFloatingInfo() {
        RElement rElement = this.child;
        if (rElement instanceof RBlock) {
            return ((RBlock)rElement).getExportableFloatingInfo();
        }
        return null;
    }

    public RElement getElement() {
        return this.child;
    }

    public int getXOffset() {
        return this.xoffset;
    }

    public int getYOffset() {
        return this.yoffset;
    }

    public Iterator getRenderables() {
        return CollectionUtilities.singletonIterator(this.child);
    }

    protected void invalidateLayoutLocal() {
    }

    public RenderableSpot getLowestRenderableSpot(int n, int n2) {
        return this.child.getLowestRenderableSpot(n - this.xoffset, n2 - this.yoffset);
    }

    public boolean isContainedByNode() {
        return true;
    }

    public boolean onDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        return this.child.onDoubleClick(mouseEvent, n - this.xoffset, n2 - this.yoffset);
    }

    public boolean onMouseClick(MouseEvent mouseEvent, int n, int n2) {
        return this.child.onMouseClick(mouseEvent, n - this.xoffset, n2 - this.yoffset);
    }

    public boolean onMouseDisarmed(MouseEvent mouseEvent) {
        return this.child.onMouseDisarmed(mouseEvent);
    }

    public boolean onMousePressed(MouseEvent mouseEvent, int n, int n2) {
        return this.child.onMousePressed(mouseEvent, n - this.xoffset, n2 - this.yoffset);
    }

    public boolean onMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        return this.child.onMouseReleased(mouseEvent, n - this.xoffset, n2 - this.yoffset);
    }

    public void paint(Graphics graphics) {
        this.child.paintTranslated(graphics);
    }
}

