/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLIFrameElementImpl;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.BrowserFrameUIControl;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.ExportableFloat;
import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.html.renderer.FloatingBoundsSource;
import org.lobobrowser.html.renderer.FloatingInfo;
import org.lobobrowser.html.renderer.FloatingViewportBounds;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.HrControl;
import org.lobobrowser.html.renderer.ImgControl;
import org.lobobrowser.html.renderer.InputButtonControl;
import org.lobobrowser.html.renderer.InputCheckboxControl;
import org.lobobrowser.html.renderer.InputFileControl;
import org.lobobrowser.html.renderer.InputImageControl;
import org.lobobrowser.html.renderer.InputPasswordControl;
import org.lobobrowser.html.renderer.InputRadioControl;
import org.lobobrowser.html.renderer.InputSelectControl;
import org.lobobrowser.html.renderer.InputTextAreaControl;
import org.lobobrowser.html.renderer.InputTextControl;
import org.lobobrowser.html.renderer.LineBreak;
import org.lobobrowser.html.renderer.MarkupLayout;
import org.lobobrowser.html.renderer.MarkupUtilities;
import org.lobobrowser.html.renderer.OverflowException;
import org.lobobrowser.html.renderer.ParentFloatingBoundsSource;
import org.lobobrowser.html.renderer.PositionedRenderable;
import org.lobobrowser.html.renderer.RBlank;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RFloatInfo;
import org.lobobrowser.html.renderer.RImgControl;
import org.lobobrowser.html.renderer.RLine;
import org.lobobrowser.html.renderer.RList;
import org.lobobrowser.html.renderer.RListItem;
import org.lobobrowser.html.renderer.RRelative;
import org.lobobrowser.html.renderer.RSpacing;
import org.lobobrowser.html.renderer.RStyleChanger;
import org.lobobrowser.html.renderer.RTable;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RWord;
import org.lobobrowser.html.renderer.Range;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.SizeExceededException;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.renderer.UIControlWrapper;
import org.lobobrowser.html.renderer.ZIndexComparator;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.ArrayUtilities;

public class RBlockViewport
extends BaseRCollection {
    public static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final Logger logger = Logger.getLogger(RBlockViewport.class.getName());
    private final RenderableContainer container;
    private final int listNesting;
    private final UserAgentContext userAgentContext;
    private final HtmlRendererContext rendererContext;
    private final FrameContext frameContext;
    private SortedSet positionedRenderables;
    private ArrayList seqRenderables = null;
    private ArrayList exportableFloats = null;
    private RLine currentLine;
    private int maxX;
    private int maxY;
    private int desiredWidth;
    private int desiredHeight;
    private int availContentHeight;
    private int availContentWidth;
    private int yLimit;
    private int positionedOrdinal;
    private int currentCollapsibleMargin;
    private Insets paddingInsets;
    private boolean overrideNoWrap;
    private FloatingBounds floatBounds = null;
    private boolean sizeOnly;
    private BoundableRenderable lastSeqBlock;
    private static final Map elementLayout = new HashMap(70);
    private static final MarkupLayout miscLayout = new MiscLayout();
    private static final SizeExceededException SEE;
    private BoundableRenderable armedRenderable;
    private Collection pendingFloats = null;
    private Boolean isFloatLimit = null;

    public RBlockViewport(ModelNode modelNode, RenderableContainer renderableContainer, int n, UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext, FrameContext frameContext, RCollection rCollection) {
        super(renderableContainer, modelNode);
        this.parent = rCollection;
        this.userAgentContext = userAgentContext;
        this.rendererContext = htmlRendererContext;
        this.frameContext = frameContext;
        this.container = renderableContainer;
        this.listNesting = n;
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public void invalidateLayoutLocal() {
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public int getAvailContentWidth() {
        return this.availContentWidth;
    }

    private int initCollapsibleMargin() {
        RCollection rCollection = this.parent;
        if (!(rCollection instanceof RBlock)) {
            return 0;
        }
        RBlock rBlock = (RBlock)rCollection;
        return rBlock.getCollapsibleMarginTop();
    }

    public void layout(int n, int n2, Insets insets, int n3, FloatingBounds floatingBounds, boolean bl) {
        SortedSet sortedSet;
        int n4;
        int n5;
        int n6;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("layout(): Invoked outside GUI dispatch thread.");
        }
        RenderableContainer renderableContainer = this.container;
        this.paddingInsets = insets;
        this.yLimit = n3;
        this.desiredHeight = n2;
        this.desiredWidth = n;
        this.floatBounds = floatingBounds;
        this.isFloatLimit = null;
        this.pendingFloats = null;
        this.sizeOnly = bl;
        this.lastSeqBlock = null;
        this.currentCollapsibleMargin = this.initCollapsibleMargin();
        this.maxX = insets.left;
        this.maxY = insets.top;
        int n7 = n - insets.left - insets.right;
        if (n7 < 0) {
            n7 = 0;
        }
        if ((n6 = n2 - insets.top - insets.bottom) == 0) {
            n6 = 0;
        }
        this.availContentHeight = n6;
        this.availContentWidth = n7;
        this.layoutPass((NodeImpl)this.modelNode);
        Collection collection = renderableContainer.getDelayedPairs();
        if (collection != null && collection.size() > 0) {
            for (DelayedPair delayedPair : collection) {
                if (delayedPair.targetParent != renderableContainer) continue;
                this.importDelayedPair(delayedPair);
            }
        }
        int n8 = n5 = this.maxY;
        BoundableRenderable boundableRenderable = this.lastSeqBlock;
        if (boundableRenderable != null) {
            int n9 = this.getEffectiveBlockHeight(boundableRenderable);
            if (boundableRenderable.getY() + n9 > n5) {
                this.maxY = n5 = boundableRenderable.getY() + n9;
                n8 = boundableRenderable.getY() + boundableRenderable.getHeight();
            }
        }
        RLine rLine = this.currentLine;
        Rectangle rectangle = rLine.getBounds();
        if (rectangle.height > 0 || rectangle.y > n8) {
            int n10 = rectangle.x + rectangle.width;
            if (n10 > this.maxX) {
                this.maxX = n10;
            }
            if ((n4 = rectangle.y + rectangle.height) > n5) {
                this.maxY = n5 = n4;
            }
        }
        if ((sortedSet = this.positionedRenderables) != null) {
            n4 = this.isFloatLimit();
            for (PositionedRenderable positionedRenderable : sortedSet) {
                BoundableRenderable boundableRenderable2 = positionedRenderable.renderable;
                if (boundableRenderable2.getX() + boundableRenderable2.getWidth() > this.maxX) {
                    this.maxX = boundableRenderable2.getX() + boundableRenderable2.getWidth();
                }
                if (n4 == 0 && positionedRenderable.isFloat || boundableRenderable2.getY() + boundableRenderable2.getHeight() <= n5) continue;
                this.maxY = n5 = boundableRenderable2.getY() + boundableRenderable2.getHeight();
            }
        }
        this.width = insets.right + this.maxX;
        this.height = insets.bottom + n5;
    }

    private void layoutPass(NodeImpl nodeImpl) {
        RenderableContainer renderableContainer = this.container;
        renderableContainer.clearDelayedPairs();
        this.positionedOrdinal = 0;
        this.seqRenderables = null;
        this.positionedRenderables = null;
        this.exportableFloats = null;
        this.currentLine = this.addLine(nodeImpl, null, this.paddingInsets.top);
        this.layoutChildren(nodeImpl);
        this.lineDone(this.currentLine);
    }

    public void alignX(int n, int n2, Insets insets) {
        ArrayList arrayList;
        int n3 = this.maxY;
        if (n > 0 && (arrayList = this.seqRenderables) != null) {
            Insets insets2 = this.paddingInsets;
            FloatingBounds floatingBounds = this.floatBounds;
            int n4 = arrayList.size();
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                int n6;
                boolean bl;
                int n7;
                int n8;
                int n9;
                int n10;
                Object e = arrayList.get(i);
                if (!(e instanceof BoundableRenderable)) continue;
                BoundableRenderable boundableRenderable = (BoundableRenderable)e;
                int n11 = boundableRenderable.getY();
                if (n5 > 0) {
                    n10 = n11 + n5;
                    boundableRenderable.setY(n10);
                    if (n10 + boundableRenderable.getHeight() > this.maxY) {
                        this.maxY = n10 + boundableRenderable.getHeight();
                    }
                } else {
                    n10 = n11;
                }
                if ((n9 = (n8 = n2 - (n7 = (bl = boundableRenderable instanceof RBlock && ((RBlock)boundableRenderable).isOverflowVisibleX()) ? insets2.left : this.fetchLeftOffset(n11)) - (n6 = bl ? insets2.right : this.fetchRightOffset(n11))) - boundableRenderable.getWidth()) <= 0) continue;
                int n12 = n9 * n / 100;
                if (bl) continue;
                int n13 = n7 + n12;
                boundableRenderable.setX(n13);
            }
        }
        if (n3 != this.maxY) {
            this.height += this.maxY - n3;
        }
    }

    public void alignY(int n, int n2, Insets insets) {
        int n3;
        int n4;
        int n5;
        int n6 = this.maxY;
        if (n > 0 && (n5 = (n4 = n2 - insets.top - insets.bottom) - (n3 = this.maxY - insets.top)) > 0) {
            Object object;
            Iterator iterator;
            Object object2;
            int n7 = n5 * n / 100;
            ArrayList arrayList = this.seqRenderables;
            if (arrayList != null) {
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    iterator = object2.next();
                    if (!(iterator instanceof BoundableRenderable)) continue;
                    object = (BoundableRenderable)((Object)iterator);
                    int n8 = object.getY() + n7;
                    object.setY(n8);
                    if (n8 + object.getHeight() <= this.maxY) continue;
                    this.maxY = n8 + object.getHeight();
                }
            }
            if ((object2 = this.positionedRenderables) != null) {
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (PositionedRenderable)iterator.next();
                    if (!((PositionedRenderable)object).verticalAlignable) continue;
                    BoundableRenderable boundableRenderable = ((PositionedRenderable)object).renderable;
                    int n9 = boundableRenderable.getY() + n7;
                    boundableRenderable.setY(n9);
                    if (n9 + boundableRenderable.getHeight() <= this.maxY) continue;
                    this.maxY = n9 + boundableRenderable.getHeight();
                }
            }
        }
        if (n6 != this.maxY) {
            this.height += this.maxY - n6;
        }
    }

    private RLine addLine(ModelNode modelNode, RLine rLine, int n) {
        boolean bl;
        Object object;
        int n2;
        this.lineDone(rLine);
        this.checkY(n);
        int n3 = n2 = this.fetchLeftOffset(n);
        int n4 = this.desiredWidth - this.fetchRightOffset(n) - n2;
        if (rLine == null) {
            int n5;
            object = this.modelNode.getRenderState();
            bl = object == null ? false : object.getWhiteSpace() == 2;
            int n6 = n5 = object == null ? 0 : object.getTextIndent(this.availContentWidth);
            if (n5 != 0) {
                n4 += n2 - (n3 += n5);
            }
        } else {
            int n7 = rLine.getHeight();
            if (n7 > 0) {
                this.currentCollapsibleMargin = 0;
            }
            bl = rLine.isAllowOverflow();
            if (rLine.x + rLine.width > this.maxX) {
                this.maxX = rLine.x + rLine.width;
            }
        }
        RLine rLine2 = new RLine(modelNode, this.container, n3, n, n4, 0, bl);
        rLine2.setParent(this);
        object = this.seqRenderables;
        if (object == null) {
            this.seqRenderables = object = new ArrayList<RLine>(1);
        }
        ((ArrayList)object).add(rLine2);
        this.currentLine = rLine2;
        return rLine2;
    }

    private void layoutMarkup(NodeImpl nodeImpl) {
        RLine rLine;
        RenderState renderState = nodeImpl.getRenderState();
        Insets insets = null;
        Insets insets2 = null;
        if (renderState != null) {
            HtmlInsets htmlInsets = renderState.getMarginInsets();
            insets = htmlInsets == null ? null : htmlInsets.getSimpleAWTInsets(this.availContentWidth, this.availContentHeight);
            HtmlInsets htmlInsets2 = renderState.getPaddingInsets();
            insets2 = htmlInsets2 == null ? null : htmlInsets2.getSimpleAWTInsets(this.availContentWidth, this.availContentHeight);
        }
        int n = 0;
        int n2 = 0;
        if (insets != null) {
            n += insets.left;
            n2 += insets.right;
        }
        if (insets2 != null) {
            n += insets2.left;
            n2 += insets2.right;
        }
        if (n > 0) {
            rLine = this.currentLine;
            rLine.addSpacing(new RSpacing(nodeImpl, this.container, n, rLine.height));
        }
        this.layoutChildren(nodeImpl);
        if (n2 > 0) {
            rLine = this.currentLine;
            rLine.addSpacing(new RSpacing(nodeImpl, this.container, n2, rLine.height));
        }
    }

    private void layoutChildren(NodeImpl nodeImpl) {
        NodeImpl[] nodeImplArray = nodeImpl.getChildrenArray();
        if (nodeImplArray != null) {
            for (NodeImpl nodeImpl2 : nodeImplArray) {
                short s = nodeImpl2.getNodeType();
                if (s == 3) {
                    this.layoutText(nodeImpl2);
                    continue;
                }
                if (s == 1) {
                    this.currentLine.addStyleChanger(new RStyleChanger(nodeImpl2));
                    String string = nodeImpl2.getNodeName().toUpperCase();
                    MarkupLayout markupLayout = (MarkupLayout)elementLayout.get(string);
                    if (markupLayout == null) {
                        markupLayout = miscLayout;
                    }
                    markupLayout.layoutMarkup(this, (HTMLElementImpl)nodeImpl2);
                    this.currentLine.addStyleChanger(new RStyleChanger(nodeImpl));
                    continue;
                }
                if (s == 8 || s == 7) continue;
                throw new IllegalStateException("Unknown node: " + nodeImpl2);
            }
        }
    }

    private final void positionRBlock(HTMLElementImpl hTMLElementImpl, RBlock rBlock) {
        if (!this.addElsewhereIfPositioned(rBlock, hTMLElementImpl, false, true, false)) {
            int n;
            int n2 = this.availContentHeight;
            RLine rLine = this.currentLine;
            this.lineDone(rLine);
            Insets insets = this.paddingInsets;
            int n3 = rLine == null ? insets.top : rLine.y + rLine.height;
            int n4 = n = this.availContentWidth;
            int n5 = insets.right;
            int n6 = insets.left;
            int n7 = n3;
            FloatingBounds floatingBounds = this.floatBounds;
            ParentFloatingBoundsSource parentFloatingBoundsSource = floatingBounds == null ? null : new ParentFloatingBoundsSource(n5, n4, n6, n7, floatingBounds);
            rBlock.layout(n, n2, true, false, parentFloatingBoundsSource, this.sizeOnly);
            this.addAsSeqBlock(rBlock, false, false, false, false);
            FloatingInfo floatingInfo = rBlock.getExportableFloatingInfo();
            if (floatingInfo != null) {
                this.importFloatingInfo(floatingInfo, rBlock);
            }
            this.addLineAfterBlock(rBlock, false);
        }
    }

    private final void positionRElement(HTMLElementImpl hTMLElementImpl, RElement rElement, boolean bl, boolean bl2, boolean bl3) {
        if (!this.addElsewhereIfPositioned(rElement, hTMLElementImpl, bl, true, true)) {
            int n;
            int n2 = this.availContentWidth;
            int n3 = this.availContentHeight;
            RLine rLine = this.currentLine;
            this.lineDone(rLine);
            if (bl2) {
                n = rLine == null ? this.paddingInsets.top : rLine.y + rLine.height;
                int n4 = this.fetchLeftOffset(n);
                int n5 = this.fetchRightOffset(n);
                n2 = this.desiredWidth - n4 - n5;
            }
            rElement.layout(n2, n3, this.sizeOnly);
            n = 0;
            if (bl3) {
                String string = hTMLElementImpl.getAttribute("align");
                n = string != null && string.equalsIgnoreCase("center") ? 1 : 0;
            }
            this.addAsSeqBlock(rElement, bl2, false, true, n != 0);
        }
    }

    private final void layoutRBlock(HTMLElementImpl hTMLElementImpl) {
        RBlock rBlock = (RBlock)hTMLElementImpl.getUINode();
        if (rBlock == null) {
            rBlock = new RBlock(hTMLElementImpl, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container);
            hTMLElementImpl.setUINode(rBlock);
        }
        rBlock.setOriginalParent(this);
        this.positionRBlock(hTMLElementImpl, rBlock);
    }

    private final void layoutRTable(HTMLElementImpl hTMLElementImpl) {
        RElement rElement = (RElement)hTMLElementImpl.getUINode();
        if (rElement == null) {
            rElement = new RTable(hTMLElementImpl, this.userAgentContext, this.rendererContext, this.frameContext, this.container);
            hTMLElementImpl.setUINode(rElement);
        }
        rElement.setOriginalParent(this);
        this.positionRElement(hTMLElementImpl, rElement, hTMLElementImpl instanceof HTMLTableElementImpl, true, true);
    }

    private final void layoutListItem(HTMLElementImpl hTMLElementImpl) {
        RListItem rListItem = (RListItem)hTMLElementImpl.getUINode();
        if (rListItem == null) {
            rListItem = new RListItem(hTMLElementImpl, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container, null);
            hTMLElementImpl.setUINode(rListItem);
        }
        rListItem.setOriginalParent(this);
        this.positionRBlock(hTMLElementImpl, rListItem);
    }

    private final void layoutList(HTMLElementImpl hTMLElementImpl) {
        RList rList = (RList)hTMLElementImpl.getUINode();
        if (rList == null) {
            rList = new RList(hTMLElementImpl, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container, null);
            hTMLElementImpl.setUINode(rList);
        }
        rList.setOriginalParent(this);
        this.positionRBlock(hTMLElementImpl, rList);
    }

    private void addLineBreak(ModelNode modelNode, int n) {
        int n2;
        Object object;
        RLine rLine = this.currentLine;
        if (rLine == null) {
            object = this.paddingInsets;
            this.addLine(modelNode, null, ((Insets)object).top);
            rLine = this.currentLine;
        }
        if (rLine.getHeight() == 0) {
            object = modelNode.getRenderState();
            int n3 = object.getFontMetrics().getHeight();
            rLine.setHeight(n3);
        }
        rLine.setLineBreak(new LineBreak(n, modelNode));
        FloatingBounds floatingBounds = this.floatBounds;
        if (n == 0 || floatingBounds == null) {
            n2 = rLine == null ? this.paddingInsets.top : rLine.y + rLine.height;
        } else {
            int n4 = rLine == null ? this.paddingInsets.top : rLine.y + rLine.height;
            switch (n) {
                case 1: {
                    n2 = floatingBounds.getLeftClearY(n4);
                    break;
                }
                case 2: {
                    n2 = floatingBounds.getRightClearY(n4);
                    break;
                }
                default: {
                    n2 = floatingBounds.getClearY(n4);
                }
            }
        }
        this.currentLine = this.addLine(modelNode, rLine, n2);
    }

    private boolean addElsewhereIfFloat(BoundableRenderable boundableRenderable, HTMLElementImpl hTMLElementImpl, boolean bl, AbstractCSS2Properties abstractCSS2Properties, boolean bl2) {
        String string = null;
        if (abstractCSS2Properties != null && (string = abstractCSS2Properties.getFloat()) != null && string.length() == 0) {
            string = null;
        }
        if (string == null && bl) {
            string = hTMLElementImpl.getAttribute("align");
        }
        if (string != null) {
            if ("left".equalsIgnoreCase(string)) {
                this.layoutFloat(boundableRenderable, bl2, true);
                return true;
            }
            if ("right".equalsIgnoreCase(string)) {
                this.layoutFloat(boundableRenderable, bl2, false);
                return true;
            }
        }
        return false;
    }

    final RBlockViewport getParentViewport() {
        RCollection rCollection;
        for (rCollection = this.getOriginalOrCurrentParent(); rCollection != null && !(rCollection instanceof RBlockViewport); rCollection = rCollection.getOriginalOrCurrentParent()) {
        }
        return (RBlockViewport)rCollection;
    }

    private static int getPosition(HTMLElementImpl hTMLElementImpl) {
        RenderState renderState = hTMLElementImpl.getRenderState();
        return renderState == null ? 0 : renderState.getPosition();
    }

    private boolean addElsewhereIfPositioned(RElement rElement, HTMLElementImpl hTMLElementImpl, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        AbstractCSS2Properties abstractCSS2Properties = hTMLElementImpl.getCurrentStyle();
        int n = RBlockViewport.getPosition(hTMLElementImpl);
        boolean bl5 = n == 1;
        boolean bl6 = bl4 = n == 2;
        if (bl5 || bl4) {
            int n2;
            int n3;
            int n4;
            int n5;
            Object object;
            Object object2;
            Object object3;
            if (bl2) {
                if (rElement instanceof RBlock) {
                    object3 = (RBlock)rElement;
                    object2 = null;
                    if (bl4) {
                        object = this.paddingInsets;
                        RLine rLine = this.currentLine;
                        this.lineDone(rLine);
                        n5 = rLine == null ? ((Insets)object).top : rLine.y + rLine.height;
                        n4 = this.availContentWidth;
                        n3 = ((Insets)object).right;
                        int n6 = ((Insets)object).left;
                        FloatingBounds floatingBounds = this.floatBounds;
                        object2 = floatingBounds == null ? null : new ParentFloatingBoundsSource(n3, n4, n6, n5, floatingBounds);
                    }
                    ((RBlock)object3).layout(this.availContentWidth, this.availContentHeight, false, false, (FloatingBoundsSource)object2, this.sizeOnly);
                } else {
                    rElement.layout(this.availContentWidth, this.availContentHeight, this.sizeOnly);
                }
            }
            object3 = hTMLElementImpl.getRenderState();
            object2 = abstractCSS2Properties.getLeft();
            object = this.currentLine;
            int n7 = n2 = object == null ? 0 : ((BaseBoundableRenderable)object).getY() + ((BaseBoundableRenderable)object).getHeight();
            if (object2 != null) {
                n5 = HtmlValues.getPixelSize((String)object2, (RenderState)object3, 0, this.availContentWidth);
            } else {
                String string = abstractCSS2Properties.getRight();
                if (string != null) {
                    n3 = HtmlValues.getPixelSize(string, (RenderState)object3, 0, this.availContentWidth);
                    n5 = this.desiredWidth - n3 - rElement.getWidth();
                } else {
                    n5 = 0;
                }
            }
            n4 = bl4 ? 0 : n2;
            String string = abstractCSS2Properties.getTop();
            if (string != null) {
                n4 = HtmlValues.getPixelSize(string, (RenderState)object3, n4, this.availContentHeight);
            } else {
                String string2 = abstractCSS2Properties.getBottom();
                if (string2 != null) {
                    int n8 = HtmlValues.getPixelSize(string2, (RenderState)object3, 0, this.availContentHeight);
                    n4 = this.desiredHeight - n8 - rElement.getHeight();
                    if (!bl4 && n4 < 0) {
                        n4 = 0;
                    }
                }
            }
            if (bl4) {
                RRelative rRelative = new RRelative(this.container, hTMLElementImpl, rElement, n5, n4);
                rRelative.assignDimension();
                if (!this.addElsewhereIfFloat(rRelative, hTMLElementImpl, bl, abstractCSS2Properties, true)) {
                    Object object4;
                    boolean bl7 = false;
                    if (rElement instanceof RTable) {
                        object4 = hTMLElementImpl.getAttribute("align");
                        bl7 = object4 != null && ((String)object4).equalsIgnoreCase("center");
                    }
                    this.addAsSeqBlock(rRelative, bl3, true, true, bl7);
                    object4 = rRelative.getExportableFloatingInfo();
                    if (object4 != null) {
                        this.importFloatingInfo((FloatingInfo)object4, rRelative);
                    }
                } else {
                    rRelative.assignDimension();
                }
            } else {
                this.scheduleAbsDelayedPair(rElement, n5, n4);
                return true;
            }
            int n9 = rElement.getY() + rElement.getHeight();
            this.checkY(n9);
            if (n9 > this.maxY) {
                this.maxY = n9;
            }
            return true;
        }
        return this.addElsewhereIfFloat(rElement, hTMLElementImpl, bl, abstractCSS2Properties, bl2);
    }

    private void addRenderableToLineCheckStyle(RElement rElement, HTMLElementImpl hTMLElementImpl, boolean bl) {
        if (this.addElsewhereIfPositioned(rElement, hTMLElementImpl, bl, true, true)) {
            return;
        }
        rElement.layout(this.availContentWidth, this.availContentHeight, this.sizeOnly);
        this.addRenderableToLine(rElement);
    }

    private void addRenderableToLine(Renderable renderable) {
        block4: {
            RenderState renderState = renderable.getModelNode().getRenderState();
            RLine rLine = this.currentLine;
            int n = rLine.y;
            boolean bl = rLine.isEmpty();
            FloatingBounds floatingBounds = this.floatBounds;
            int n2 = floatingBounds != null ? floatingBounds.getFirstClearY(n) : n + rLine.height;
            try {
                rLine.add(renderable);
                if (floatingBounds == null || n2 <= n) break block4;
                int n3 = this.fetchRightOffset(n);
                int n4 = this.desiredWidth - n3;
                if (rLine.getX() + rLine.getWidth() <= n4) break block4;
                rLine.setY(n2);
            }
            catch (OverflowException overflowException) {
                int n5 = bl ? n2 : n + rLine.height;
                this.addLine(renderable.getModelNode(), rLine, n5);
                Collection collection = overflowException.getRenderables();
                for (Renderable renderable2 : collection) {
                    this.addRenderableToLine(renderable2);
                }
            }
        }
        if (renderable instanceof RUIControl) {
            this.container.addComponent(((RUIControl)renderable).widget.getComponent());
        }
    }

    private void addWordToLine(RWord rWord) {
        block3: {
            RLine rLine = this.currentLine;
            int n = rLine.y;
            boolean bl = rLine.isEmpty();
            FloatingBounds floatingBounds = this.floatBounds;
            int n2 = floatingBounds != null ? floatingBounds.getFirstClearY(n) : n + rLine.height;
            try {
                rLine.addWord(rWord);
                if (floatingBounds == null || n2 <= n) break block3;
                int n3 = this.fetchRightOffset(n);
                int n4 = this.desiredWidth - n3;
                if (rLine.getX() + rLine.getWidth() <= n4) break block3;
                rLine.setY(n2);
            }
            catch (OverflowException overflowException) {
                int n5 = bl ? n2 : n + rLine.height;
                this.addLine(rWord.getModelNode(), rLine, n5);
                Collection collection = overflowException.getRenderables();
                for (Renderable renderable : collection) {
                    this.addRenderableToLine(renderable);
                }
            }
        }
    }

    private void addAsSeqBlockCheckStyle(RElement rElement, HTMLElementImpl hTMLElementImpl, boolean bl) {
        if (this.addElsewhereIfPositioned(rElement, hTMLElementImpl, bl, false, true)) {
            return;
        }
        this.addAsSeqBlock(rElement);
    }

    private void addAsSeqBlock(RElement rElement) {
        this.addAsSeqBlock(rElement, true, true, true, false);
    }

    private int getNewBlockY(BoundableRenderable boundableRenderable, int n) {
        if (!(boundableRenderable instanceof RElement)) {
            return n;
        }
        RElement rElement = (RElement)boundableRenderable;
        int n2 = this.currentCollapsibleMargin;
        int n3 = rElement.getMarginTop();
        if (n3 == 0 && n2 == 0) {
            return n;
        }
        return n - Math.min(n3, n2);
    }

    private int getEffectiveBlockHeight(BoundableRenderable boundableRenderable) {
        if (!(boundableRenderable instanceof RElement)) {
            return boundableRenderable.getHeight();
        }
        RCollection rCollection = this.getParent();
        if (!(rCollection instanceof RElement)) {
            return boundableRenderable.getHeight();
        }
        int n = ((RElement)boundableRenderable).getMarginBottom();
        int n2 = ((RElement)rCollection).getCollapsibleMarginBottom();
        return boundableRenderable.getHeight() - Math.min(n, n2);
    }

    private void addAsSeqBlock(BoundableRenderable boundableRenderable, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        int n2;
        int n3;
        boolean bl5;
        RLine rLine;
        Insets insets = this.paddingInsets;
        int n4 = insets.left;
        ArrayList<BoundableRenderable> arrayList = this.seqRenderables;
        if (arrayList == null) {
            this.seqRenderables = arrayList = new ArrayList<BoundableRenderable>(1);
        }
        if ((rLine = this.currentLine) != null) {
            bl5 = rLine.isAllowOverflow();
            if (bl2) {
                this.lineDone(rLine);
            }
            if (rLine.x + rLine.width > this.maxX) {
                this.maxX = rLine.x + rLine.width;
            }
        } else {
            bl5 = false;
        }
        int n5 = rLine == null ? 0 : rLine.height;
        int n6 = rLine == null ? insets.top : rLine.y + n5;
        int n7 = n5 == 0 ? this.getNewBlockY(boundableRenderable, n6) : n6;
        int n8 = boundableRenderable.getWidth();
        if (bl) {
            FloatingBounds floatingBounds = this.floatBounds;
            if (floatingBounds != null) {
                n2 = n3 = this.fetchLeftOffset(n6);
                int n9 = this.fetchRightOffset(n6);
                n = this.desiredWidth - n9 - n3;
                if (n8 > n) {
                    n7 = floatingBounds.getClearY(n6);
                }
            } else {
                n = this.availContentWidth;
                n2 = n4;
            }
            if (bl4 && (n3 = n - n8) > 0) {
                n2 += n3 / 2;
            }
        } else {
            n2 = n4;
        }
        boundableRenderable.setOrigin(n2, n7);
        arrayList.add(boundableRenderable);
        boundableRenderable.setParent(this);
        if (n2 + n8 > this.maxX) {
            this.maxX = n2 + n8;
        }
        this.lastSeqBlock = boundableRenderable;
        int n10 = this.currentCollapsibleMargin = boundableRenderable instanceof RElement ? ((RElement)boundableRenderable).getMarginBottom() : 0;
        if (bl3) {
            int n11;
            n6 = n7 + boundableRenderable.getHeight();
            this.checkY(n6);
            n = n11 = this.fetchLeftOffset(n6);
            n3 = this.desiredWidth - this.fetchRightOffset(n6) - n11;
            ModelNode modelNode = boundableRenderable.getModelNode().getParentModelNode();
            RLine rLine2 = new RLine(modelNode, this.container, n, n6, n3, 0, bl5);
            rLine2.setParent(this);
            arrayList.add(rLine2);
            this.currentLine = rLine2;
        }
    }

    private void addLineAfterBlock(RBlock rBlock, boolean bl) {
        int n;
        boolean bl2;
        RLine rLine;
        ArrayList<RLine> arrayList = this.seqRenderables;
        if (arrayList == null) {
            this.seqRenderables = arrayList = new ArrayList<RLine>(1);
        }
        if ((rLine = this.currentLine) != null) {
            bl2 = rLine.isAllowOverflow();
            if (bl) {
                this.lineDone(rLine);
            }
            if (rLine.x + rLine.width > this.maxX) {
                this.maxX = rLine.x + rLine.width;
            }
        } else {
            bl2 = false;
        }
        ModelNode modelNode = rBlock.getModelNode().getParentModelNode();
        int n2 = rBlock.getY() + rBlock.getHeight();
        this.checkY(n2);
        int n3 = n = this.fetchLeftOffset(n2);
        int n4 = this.desiredWidth - this.fetchRightOffset(n2) - n;
        RLine rLine2 = new RLine(modelNode, this.container, n3, n2, n4, 0, bl2);
        rLine2.setParent(this);
        arrayList.add(rLine2);
        this.currentLine = rLine2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void layoutText(NodeImpl nodeImpl) {
        RenderState renderState = nodeImpl.getRenderState();
        if (renderState == null) {
            throw new IllegalStateException("RenderState is null for node " + nodeImpl + " with parent " + nodeImpl.getParentNode());
        }
        FontMetrics fontMetrics = renderState.getFontMetrics();
        int n = fontMetrics.getDescent();
        int n2 = fontMetrics.getAscent() + fontMetrics.getLeading();
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.charWidth(' ');
        int n5 = this.overrideNoWrap ? 2 : renderState.getWhiteSpace();
        int n6 = renderState.getTextTransform();
        String string = nodeImpl.getNodeValue();
        if (n5 != 1) {
            boolean bl = this.currentLine.isAllowOverflow();
            boolean bl2 = n5 == 2;
            this.currentLine.setAllowOverflow(bl2);
            try {
                int n7 = string.length();
                boolean bl3 = true;
                StringBuffer stringBuffer = new StringBuffer(12);
                block7: for (int i = 0; i < n7; ++i) {
                    char c = string.charAt(i);
                    if (Character.isWhitespace(c)) {
                        BaseBoundableRenderable baseBoundableRenderable;
                        int n8;
                        if (bl3) {
                            bl3 = false;
                        }
                        if ((n8 = stringBuffer.length()) > 0) {
                            baseBoundableRenderable = new RWord(nodeImpl, stringBuffer.toString(), this.container, fontMetrics, n, n2, n3, n6);
                            this.addWordToLine((RWord)baseBoundableRenderable);
                            stringBuffer.delete(0, n8);
                        }
                        baseBoundableRenderable = this.currentLine;
                        if (((RLine)baseBoundableRenderable).width > 0) {
                            RBlank rBlank = new RBlank(nodeImpl, fontMetrics, this.container, n2, n4, n3);
                            ((RLine)baseBoundableRenderable).addBlank(rBlank);
                        }
                        ++i;
                        while (i < n7) {
                            c = string.charAt(i);
                            if (!Character.isWhitespace(c)) {
                                stringBuffer.append(c);
                                continue block7;
                            }
                            ++i;
                        }
                        continue;
                    }
                    stringBuffer.append(c);
                }
                if (stringBuffer.length() <= 0) return;
                RWord rWord = new RWord(nodeImpl, stringBuffer.toString(), this.container, fontMetrics, n, n2, n3, n6);
                this.addWordToLine(rWord);
                return;
            }
            finally {
                this.currentLine.setAllowOverflow(bl);
            }
        }
        int n9 = string.length();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        block9: for (int i = 0; i < n9; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    bl = true;
                    continue block9;
                }
                case '\n': {
                    int n10 = stringBuffer.length();
                    if (n10 > 0) {
                        RWord rWord = new RWord(nodeImpl, stringBuffer.toString(), this.container, fontMetrics, n, n2, n3, n6);
                        this.addWordToLine(rWord);
                        stringBuffer.delete(0, stringBuffer.length());
                    }
                    RLine rLine = this.currentLine;
                    rLine.setLineBreak(new LineBreak(0, nodeImpl));
                    this.addLine(nodeImpl, rLine, rLine.y + rLine.height);
                    continue block9;
                }
                default: {
                    if (bl) {
                        stringBuffer.append('\r');
                        bl = false;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer.length() <= 0) return;
        RWord rWord = new RWord(nodeImpl, stringBuffer.toString(), this.container, fontMetrics, n, n2, n3, n6);
        this.addWordToLine(rWord);
    }

    private void populateZIndexGroups(Collection collection, Collection collection2, ArrayList arrayList) {
        this.populateZIndexGroups(collection, collection2 == null ? null : collection2.iterator(), arrayList);
    }

    private void populateZIndexGroups(Collection collection, Iterator iterator, ArrayList arrayList) {
        Object object;
        Object object2;
        Iterator iterator2 = collection.iterator();
        BoundableRenderable boundableRenderable = null;
        while (iterator2.hasNext()) {
            object2 = (PositionedRenderable)iterator2.next();
            object = ((PositionedRenderable)object2).renderable;
            if (object.getZIndex() >= 0) {
                boundableRenderable = object;
                break;
            }
            arrayList.add(object);
        }
        if ((object2 = iterator) != null) {
            while (object2.hasNext()) {
                arrayList.add(object2.next());
            }
        }
        if (boundableRenderable != null) {
            arrayList.add(boundableRenderable);
            while (iterator2.hasNext()) {
                object = (PositionedRenderable)iterator2.next();
                BoundableRenderable boundableRenderable2 = ((PositionedRenderable)object).renderable;
                arrayList.add(boundableRenderable2);
            }
        }
    }

    public Renderable[] getRenderablesArray() {
        int n;
        SortedSet sortedSet = this.positionedRenderables;
        int n2 = n = sortedSet == null ? 0 : sortedSet.size();
        if (n == 0) {
            ArrayList arrayList = this.seqRenderables;
            return arrayList == null ? Renderable.EMPTY_ARRAY : arrayList.toArray(Renderable.EMPTY_ARRAY);
        }
        ArrayList arrayList = new ArrayList();
        this.populateZIndexGroups((Collection)sortedSet, this.seqRenderables, arrayList);
        return arrayList.toArray(Renderable.EMPTY_ARRAY);
    }

    public Iterator getRenderables() {
        SortedSet sortedSet = this.positionedRenderables;
        if (sortedSet == null || sortedSet.size() == 0) {
            ArrayList arrayList = this.seqRenderables;
            return arrayList == null ? null : arrayList.iterator();
        }
        ArrayList arrayList = new ArrayList();
        this.populateZIndexGroups((Collection)sortedSet, this.seqRenderables, arrayList);
        return arrayList.iterator();
    }

    public Iterator getRenderables(Rectangle rectangle) {
        Object object3;
        Object object2;
        Object[] objectArray;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("getRenderables(): Invoked outside GUI dispatch thread.");
        }
        ArrayList arrayList = this.seqRenderables;
        Iterator iterator = null;
        if (arrayList != null) {
            objectArray = arrayList.toArray(Renderable.EMPTY_ARRAY);
            object2 = MarkupUtilities.findRenderables((Renderable[])objectArray, rectangle, true);
            iterator = ArrayUtilities.iterator(objectArray, ((Range)object2).offset, ((Range)object2).length);
        }
        if ((objectArray = this.positionedRenderables) == null || objectArray.size() == 0) {
            return iterator;
        }
        object2 = new ArrayList();
        for (Object object3 : objectArray) {
            BoundableRenderable boundableRenderable;
            Rectangle rectangle2;
            BoundableRenderable boundableRenderable2 = ((PositionedRenderable)object3).renderable;
            if (!(boundableRenderable2 instanceof BoundableRenderable) || !rectangle.intersects(rectangle2 = (boundableRenderable = boundableRenderable2).getBounds())) continue;
            ((ArrayList)object2).add(object3);
        }
        if (((ArrayList)object2).size() == 0) {
            return iterator;
        }
        object3 = new ArrayList();
        this.populateZIndexGroups((Collection)object2, iterator, (ArrayList)object3);
        return ((ArrayList)object3).iterator();
    }

    public BoundableRenderable getRenderable(int n, int n2) {
        Iterator iterator = this.getRenderables(n, n2);
        return iterator == null ? null : (iterator.hasNext() ? (BoundableRenderable)iterator.next() : null);
    }

    public BoundableRenderable getRenderable(Point point) {
        return this.getRenderable(point.x, point.y);
    }

    public Iterator getRenderables(Point point) {
        return this.getRenderables(point.x, point.y);
    }

    public Iterator getRenderables(int n, int n2) {
        Renderable[] renderableArray;
        ArrayList arrayList;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n3;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("getRenderable(): Invoked outside GUI dispatch thread.");
        }
        LinkedList<Object> linkedList = null;
        SortedSet sortedSet = this.positionedRenderables;
        int n4 = sortedSet == null ? 0 : sortedSet.size();
        PositionedRenderable[] positionedRenderableArray = n4 == 0 ? null : sortedSet.toArray(PositionedRenderable.EMPTY_ARRAY);
        int n5 = 0;
        if (n4 != 0) {
            int n6 = n;
            n3 = n2;
            n5 = n4;
            while (--n5 >= 0) {
                object4 = positionedRenderableArray[n5];
                object3 = ((PositionedRenderable)object4).renderable;
                if (object3.getZIndex() < 0) break;
                if (!(object3 instanceof BoundableRenderable) || !((Rectangle)(object2 = (object = object3).getBounds())).contains(n6, n3)) continue;
                if (linkedList == null) {
                    linkedList = new LinkedList();
                }
                linkedList.add(object);
            }
        }
        if ((arrayList = this.seqRenderables) != null && (object4 = MarkupUtilities.findRenderable(renderableArray = arrayList.toArray(Renderable.EMPTY_ARRAY), n, n2, true)) != null) {
            if (linkedList == null) {
                linkedList = new LinkedList<Object>();
            }
            linkedList.add(object4);
        }
        if (n4 != 0) {
            n3 = n;
            int n7 = n2;
            while (n5 >= 0) {
                Rectangle rectangle;
                object3 = positionedRenderableArray[n5];
                object = ((PositionedRenderable)object3).renderable;
                if (object instanceof BoundableRenderable && (rectangle = (object2 = (BoundableRenderable)object).getBounds()).contains(n3, n7)) {
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                    }
                    linkedList.add(object2);
                }
                --n5;
            }
        }
        return linkedList == null ? null : linkedList.iterator();
    }

    private RElement setupNewUIControl(RenderableContainer renderableContainer, HTMLElementImpl hTMLElementImpl, UIControl uIControl) {
        RUIControl rUIControl = new RUIControl(hTMLElementImpl, uIControl, renderableContainer, this.frameContext, this.userAgentContext);
        hTMLElementImpl.setUINode(rUIControl);
        return rUIControl;
    }

    private final void addAlignableAsBlock(HTMLElementImpl hTMLElementImpl, RElement rElement) {
        boolean bl = false;
        String string = hTMLElementImpl.getAttribute("align");
        if (string != null) {
            if ("left".equalsIgnoreCase(string)) {
                this.layoutFloat(rElement, false, true);
            } else if ("right".equalsIgnoreCase(string)) {
                this.layoutFloat(rElement, false, false);
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.addAsSeqBlock(rElement);
        }
    }

    private final void layoutHr(HTMLElementImpl hTMLElementImpl) {
        RElement rElement = (RElement)hTMLElementImpl.getUINode();
        if (rElement == null) {
            rElement = this.setupNewUIControl(this.container, hTMLElementImpl, new HrControl(hTMLElementImpl));
        }
        rElement.layout(this.availContentWidth, this.availContentHeight, this.sizeOnly);
        this.addAlignableAsBlock(hTMLElementImpl, rElement);
    }

    private final BaseInputControl createInputControl(HTMLBaseInputElement hTMLBaseInputElement) {
        String string = hTMLBaseInputElement.getAttribute("type");
        if (string == null) {
            return new InputTextControl(hTMLBaseInputElement);
        }
        if ("text".equals(string = string.toLowerCase()) || string.length() == 0) {
            return new InputTextControl(hTMLBaseInputElement);
        }
        if ("hidden".equals(string)) {
            return null;
        }
        if ("submit".equals(string)) {
            return new InputButtonControl(hTMLBaseInputElement);
        }
        if ("password".equals(string)) {
            return new InputPasswordControl(hTMLBaseInputElement);
        }
        if ("radio".equals(string)) {
            return new InputRadioControl(hTMLBaseInputElement);
        }
        if ("checkbox".equals(string)) {
            return new InputCheckboxControl(hTMLBaseInputElement);
        }
        if ("image".equals(string)) {
            return new InputImageControl(hTMLBaseInputElement);
        }
        if ("reset".equals(string)) {
            return new InputButtonControl(hTMLBaseInputElement);
        }
        if ("button".equals(string)) {
            return new InputButtonControl(hTMLBaseInputElement);
        }
        if ("file".equals(string)) {
            return new InputFileControl(hTMLBaseInputElement);
        }
        return null;
    }

    private final int fetchLeftOffset(int n) {
        Insets insets = this.paddingInsets;
        FloatingBounds floatingBounds = this.floatBounds;
        if (floatingBounds == null) {
            return insets.left;
        }
        int n2 = floatingBounds.getLeft(n);
        if (n2 < insets.left) {
            return insets.left;
        }
        return n2;
    }

    private final int fetchRightOffset(int n) {
        Insets insets = this.paddingInsets;
        FloatingBounds floatingBounds = this.floatBounds;
        if (floatingBounds == null) {
            return insets.right;
        }
        int n2 = floatingBounds.getRight(n);
        if (n2 < insets.right) {
            return insets.right;
        }
        return n2;
    }

    private final void checkY(int n) {
        if (this.yLimit != -1 && n > this.yLimit) {
            throw SEE;
        }
    }

    private final void layoutFloat(BoundableRenderable boundableRenderable, boolean bl, boolean bl2) {
        boundableRenderable.setOriginalParent(this);
        if (bl) {
            int n = this.availContentWidth;
            int n2 = this.availContentHeight;
            if (boundableRenderable instanceof RBlock) {
                RBlock rBlock = (RBlock)boundableRenderable;
                rBlock.layout(n, n2, false, false, null, this.sizeOnly);
            } else if (boundableRenderable instanceof RElement) {
                RElement rElement = (RElement)boundableRenderable;
                rElement.layout(n, n2, this.sizeOnly);
            }
        }
        RFloatInfo rFloatInfo = new RFloatInfo(boundableRenderable.getModelNode(), boundableRenderable, bl2);
        this.currentLine.simplyAdd(rFloatInfo);
        this.scheduleFloat(rFloatInfo);
    }

    private void scheduleAbsDelayedPair(BoundableRenderable boundableRenderable, int n, int n2) {
        RenderableContainer renderableContainer;
        HTMLElementImpl hTMLElementImpl;
        int n3;
        Object object;
        RenderableContainer renderableContainer2 = this.container;
        while (renderableContainer2 instanceof Renderable && (object = ((Renderable)((Object)renderableContainer2)).getModelNode()) instanceof HTMLElementImpl && (n3 = RBlockViewport.getPosition(hTMLElementImpl = (HTMLElementImpl)object)) == 0 && (renderableContainer = renderableContainer2.getParentContainer()) != null) {
            renderableContainer2 = renderableContainer;
        }
        object = new DelayedPair(renderableContainer2, boundableRenderable, n, n2);
        this.container.addDelayedPair((DelayedPair)object);
    }

    void importDelayedPair(DelayedPair delayedPair) {
        BoundableRenderable boundableRenderable = delayedPair.child;
        boundableRenderable.setOrigin(delayedPair.x, delayedPair.y);
        this.addPositionedRenderable(boundableRenderable, false, false);
    }

    private final void addPositionedRenderable(BoundableRenderable boundableRenderable, boolean bl, boolean bl2) {
        TreeSet<PositionedRenderable> treeSet = this.positionedRenderables;
        if (treeSet == null) {
            this.positionedRenderables = treeSet = new TreeSet<PositionedRenderable>(new ZIndexComparator());
        }
        treeSet.add(new PositionedRenderable(boundableRenderable, bl, this.positionedOrdinal++, bl2));
        boundableRenderable.setParent(this);
        if (boundableRenderable instanceof RUIControl) {
            this.container.addComponent(((RUIControl)boundableRenderable).widget.getComponent());
        }
    }

    public int getFirstLineHeight() {
        ArrayList arrayList = this.seqRenderables;
        if (arrayList != null) {
            int n = arrayList.size();
            if (n == 0) {
                return 0;
            }
            for (int i = 0; i < n; ++i) {
                BoundableRenderable boundableRenderable = (BoundableRenderable)arrayList.get(0);
                int n2 = boundableRenderable.getHeight();
                if (n2 == 0) continue;
                return n2;
            }
        }
        return 1;
    }

    public int getFirstBaselineOffset() {
        ArrayList arrayList = this.seqRenderables;
        if (arrayList != null) {
            for (Object e : arrayList) {
                RBlock rBlock;
                if (e instanceof RLine) {
                    int n = ((RLine)e).getBaselineOffset();
                    if (n == 0) continue;
                    return n;
                }
                if (!(e instanceof RBlock) || (rBlock = (RBlock)e).getHeight() <= 0) continue;
                Insets insets = rBlock.getInsets(false, false);
                Insets insets2 = this.paddingInsets;
                return rBlock.getFirstBaselineOffset() + insets.top + (insets2 == null ? 0 : insets2.top);
            }
        }
        return 0;
    }

    public RenderableSpot getLowestRenderableSpot(int n, int n2) {
        BoundableRenderable boundableRenderable = this.getRenderable(new Point(n, n2));
        if (boundableRenderable != null) {
            return boundableRenderable.getLowestRenderableSpot(n - boundableRenderable.getX(), n2 - boundableRenderable.getY());
        }
        return new RenderableSpot(this, n, n2);
    }

    public boolean onMouseClick(MouseEvent mouseEvent, int n, int n2) {
        Iterator iterator = this.getRenderables(new Point(n, n2));
        if (iterator != null) {
            while (iterator.hasNext()) {
                BoundableRenderable boundableRenderable = (BoundableRenderable)iterator.next();
                if (boundableRenderable == null) continue;
                Rectangle rectangle = boundableRenderable.getBounds();
                if (boundableRenderable.onMouseClick(mouseEvent, n - rectangle.x, n2 - rectangle.y)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        Iterator iterator = this.getRenderables(new Point(n, n2));
        if (iterator != null) {
            while (iterator.hasNext()) {
                BoundableRenderable boundableRenderable = (BoundableRenderable)iterator.next();
                if (boundableRenderable == null) continue;
                Rectangle rectangle = boundableRenderable.getBounds();
                if (boundableRenderable.onDoubleClick(mouseEvent, n - rectangle.x, n2 - rectangle.y)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMouseDisarmed(MouseEvent mouseEvent) {
        BoundableRenderable boundableRenderable = this.armedRenderable;
        if (boundableRenderable != null) {
            try {
                boolean bl = boundableRenderable.onMouseDisarmed(mouseEvent);
                return bl;
            }
            finally {
                this.armedRenderable = null;
            }
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent, int n, int n2) {
        Iterator iterator = this.getRenderables(new Point(n, n2));
        if (iterator != null) {
            while (iterator.hasNext()) {
                BoundableRenderable boundableRenderable = (BoundableRenderable)iterator.next();
                if (boundableRenderable == null) continue;
                Rectangle rectangle = boundableRenderable.getBounds();
                if (boundableRenderable.onMousePressed(mouseEvent, n - rectangle.x, n2 - rectangle.y)) continue;
                this.armedRenderable = boundableRenderable;
                return false;
            }
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        BoundableRenderable boundableRenderable;
        Iterator iterator = this.getRenderables(new Point(n, n2));
        if (iterator != null) {
            while (iterator.hasNext()) {
                boundableRenderable = (BoundableRenderable)iterator.next();
                if (boundableRenderable == null) continue;
                Rectangle rectangle = boundableRenderable.getBounds();
                if (boundableRenderable.onMouseReleased(mouseEvent, n - rectangle.x, n2 - rectangle.y)) continue;
                BoundableRenderable boundableRenderable2 = this.armedRenderable;
                if (boundableRenderable2 != null && boundableRenderable != boundableRenderable2) {
                    boundableRenderable2.onMouseDisarmed(mouseEvent);
                    this.armedRenderable = null;
                }
                return false;
            }
        }
        if ((boundableRenderable = this.armedRenderable) != null) {
            boundableRenderable.onMouseDisarmed(mouseEvent);
            this.armedRenderable = null;
        }
        return true;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Iterator iterator = this.getRenderables(rectangle);
        if (iterator != null) {
            int n = 0;
            while (iterator.hasNext()) {
                ++n;
                Object e = iterator.next();
                if (e instanceof BoundableRenderable) {
                    BoundableRenderable boundableRenderable = (BoundableRenderable)e;
                    boundableRenderable.paintTranslated(graphics);
                    continue;
                }
                ((Renderable)e).paint(graphics);
            }
        }
    }

    public boolean isContainedByNode() {
        return false;
    }

    public String toString() {
        return "RBlockViewport[node=" + this.modelNode + "]";
    }

    private void scheduleFloat(RFloatInfo rFloatInfo) {
        RLine rLine = this.currentLine;
        if (rLine == null) {
            int n = rLine == null ? this.paddingInsets.top : rLine.getY();
            this.placeFloat(rFloatInfo.getRenderable(), n, rFloatInfo.isLeftFloat());
        } else if (rLine.getWidth() == 0) {
            int n = rLine.getY();
            this.placeFloat(rFloatInfo.getRenderable(), n, rFloatInfo.isLeftFloat());
            int n2 = this.fetchLeftOffset(n);
            int n3 = this.fetchRightOffset(n);
            rLine.changeLimits(n2, this.desiredWidth - n2 - n3);
        } else {
            LinkedList<RFloatInfo> linkedList = this.pendingFloats;
            if (linkedList == null) {
                this.pendingFloats = linkedList = new LinkedList<RFloatInfo>();
            }
            linkedList.add(rFloatInfo);
        }
    }

    private void lineDone(RLine rLine) {
        int n = rLine == null ? this.paddingInsets.top : rLine.y + rLine.height;
        Collection collection = this.pendingFloats;
        if (collection != null) {
            this.pendingFloats = null;
            for (RFloatInfo rFloatInfo : collection) {
                this.placeFloat(rFloatInfo.getRenderable(), n, rFloatInfo.isLeftFloat());
            }
        }
    }

    private void addExportableFloat(BoundableRenderable boundableRenderable, boolean bl, int n, int n2) {
        ArrayList<ExportableFloat> arrayList = this.exportableFloats;
        if (arrayList == null) {
            this.exportableFloats = arrayList = new ArrayList<ExportableFloat>(1);
        }
        arrayList.add(new ExportableFloat(boundableRenderable, bl, n, n2));
    }

    private void placeFloat(BoundableRenderable boundableRenderable, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        Insets insets = this.paddingInsets;
        int n5 = n;
        int n6 = boundableRenderable.getWidth();
        int n7 = boundableRenderable.getHeight();
        int n8 = this.desiredWidth;
        while (true) {
            int n9;
            Object object;
            n4 = this.fetchLeftOffset(n5);
            n3 = this.fetchRightOffset(n5);
            int n10 = n2 = bl ? n4 : n8 - n3 - n6;
            if (n4 == insets.left && n3 == insets.right) {
                if (bl || n2 >= n4) break;
                n2 = n4;
                break;
            }
            if (n6 <= n8 - n3 - n4) break;
            if (boundableRenderable instanceof RBlock && !((BaseElementRenderable)(object = (RBlock)boundableRenderable)).hasDeclaredWidth()) {
                n9 = n8 - n3 - n4;
                ((BaseElementRenderable)object).layout(n9, this.availContentHeight, this.sizeOnly);
                if (((RBlock)object).getWidth() < n6) {
                    if (((RBlock)object).getWidth() > n8 - n3 - n4) {
                        ((BaseElementRenderable)object).layout(this.availContentWidth, this.availContentHeight, this.sizeOnly);
                    } else {
                        n6 = ((RBlock)object).getWidth();
                        n7 = ((RBlock)object).getHeight();
                        continue;
                    }
                }
            }
            int n11 = n9 = (object = this.floatBounds) == null ? n5 + n7 : object.getFirstClearY(n5);
            if (n9 == n5) break;
            n5 = n9;
        }
        boundableRenderable.setOrigin(n2, n5);
        n4 = bl ? n2 + n6 : n8 - n2;
        this.floatBounds = new FloatingViewportBounds(this.floatBounds, bl, n5, n4, n7);
        n3 = this.isFloatLimit() ? 1 : 0;
        if (n3 != 0) {
            this.addPositionedRenderable(boundableRenderable, true, true);
        } else {
            this.addExportableFloat(boundableRenderable, bl, n2, n5);
        }
        if (n2 + n6 > this.maxX) {
            this.maxX = n2 + n6;
        }
        if (this.isFloatLimit() && n5 + n7 > this.maxY) {
            this.maxY = n5 + n7;
        }
    }

    private boolean isFloatLimit() {
        Boolean bl = this.isFloatLimit;
        if (bl == null) {
            this.isFloatLimit = bl = this.isFloatLimitImpl();
        }
        return bl;
    }

    private Boolean isFloatLimitImpl() {
        int n;
        int n2;
        RCollection rCollection = this.getOriginalOrCurrentParent();
        if (!(rCollection instanceof RBlock)) {
            return Boolean.TRUE;
        }
        RBlock rBlock = (RBlock)rCollection;
        RCollection rCollection2 = rBlock.getOriginalOrCurrentParent();
        if (!(rCollection2 instanceof RBlockViewport)) {
            return Boolean.TRUE;
        }
        ModelNode modelNode = this.modelNode;
        if (!(modelNode instanceof HTMLElementImpl)) {
            return Boolean.TRUE;
        }
        HTMLElementImpl hTMLElementImpl = (HTMLElementImpl)modelNode;
        int n3 = RBlockViewport.getPosition(hTMLElementImpl);
        if (n3 == 1 || n3 == 3) {
            return Boolean.TRUE;
        }
        AbstractCSS2Properties abstractCSS2Properties = hTMLElementImpl.getCurrentStyle();
        RenderState renderState = hTMLElementImpl.getRenderState();
        int n4 = n2 = renderState == null ? 0 : renderState.getFloat();
        if (n2 != 0) {
            return Boolean.TRUE;
        }
        int n5 = renderState == null ? 0 : renderState.getOverflowX();
        int n6 = n = renderState == null ? 0 : renderState.getOverflowY();
        if (n5 == 2 || n5 == 1 || n == 2 || n == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public FloatingInfo getExportableFloatingInfo() {
        ArrayList arrayList = this.exportableFloats;
        if (arrayList == null) {
            return null;
        }
        ExportableFloat[] exportableFloatArray = arrayList.toArray(ExportableFloat.EMPTY_ARRAY);
        return new FloatingInfo(0, 0, exportableFloatArray);
    }

    private void importFloatingInfo(FloatingInfo floatingInfo, BoundableRenderable boundableRenderable) {
        int n = floatingInfo.shiftX + boundableRenderable.getX();
        int n2 = floatingInfo.shiftY + boundableRenderable.getY();
        for (ExportableFloat exportableFloat : floatingInfo.floats) {
            this.importFloat(exportableFloat, n, n2);
        }
    }

    private void importFloat(ExportableFloat exportableFloat, int n, int n2) {
        BoundableRenderable boundableRenderable = exportableFloat.element;
        int n3 = exportableFloat.origX + n;
        int n4 = exportableFloat.origY + n2;
        boundableRenderable.setOrigin(n3, n4);
        FloatingBounds floatingBounds = this.floatBounds;
        boolean bl = exportableFloat.leftFloat;
        int n5 = bl ? n3 + boundableRenderable.getWidth() : this.desiredWidth - n3;
        this.floatBounds = new FloatingViewportBounds(floatingBounds, bl, n4, n5, boundableRenderable.getHeight());
        if (this.isFloatLimit()) {
            this.addPositionedRenderable(boundableRenderable, true, true);
        } else {
            this.addExportableFloat(boundableRenderable, bl, n3, n4);
        }
    }

    static {
        Map map = elementLayout;
        EmLayout emLayout = new EmLayout();
        map.put("I", emLayout);
        map.put("EM", emLayout);
        map.put("CITE", emLayout);
        map.put("H1", new HLayout(24));
        map.put("H2", new HLayout(18));
        map.put("H3", new HLayout(15));
        map.put("H4", new HLayout(12));
        map.put("H5", new HLayout(10));
        map.put("H6", new HLayout(8));
        StrongLayout strongLayout = new StrongLayout();
        map.put("B", strongLayout);
        map.put("STRONG", strongLayout);
        map.put("TH", strongLayout);
        map.put("U", new ULayout());
        map.put("STRIKE", new StrikeLayout());
        map.put("BR", new BrLayout());
        map.put("P", new PLayout());
        map.put("NOSCRIPT", new NoScriptLayout());
        NopLayout nopLayout = new NopLayout();
        map.put("SCRIPT", nopLayout);
        map.put("HEAD", nopLayout);
        map.put("TITLE", nopLayout);
        map.put("META", nopLayout);
        map.put("STYLE", nopLayout);
        map.put("LINK", nopLayout);
        map.put("IMG", new ImgLayout());
        map.put("TABLE", new TableLayout());
        ChildrenLayout childrenLayout = new ChildrenLayout();
        map.put("HTML", childrenLayout);
        AnchorLayout anchorLayout = new AnchorLayout();
        map.put("A", anchorLayout);
        map.put("ANCHOR", anchorLayout);
        map.put("INPUT", new InputLayout2());
        map.put("TEXTAREA", new TextAreaLayout2());
        map.put("SELECT", new SelectLayout());
        ListItemLayout listItemLayout = new ListItemLayout();
        map.put("UL", listItemLayout);
        map.put("OL", listItemLayout);
        map.put("LI", listItemLayout);
        CommonBlockLayout commonBlockLayout = new CommonBlockLayout();
        map.put("PRE", commonBlockLayout);
        map.put("CENTER", commonBlockLayout);
        map.put("CAPTION", commonBlockLayout);
        DivLayout divLayout = new DivLayout();
        map.put("DIV", divLayout);
        map.put("BODY", divLayout);
        map.put("DL", divLayout);
        map.put("DT", divLayout);
        BlockQuoteLayout blockQuoteLayout = new BlockQuoteLayout();
        map.put("BLOCKQUOTE", blockQuoteLayout);
        map.put("DD", blockQuoteLayout);
        map.put("HR", new HrLayout());
        map.put("SPAN", new SpanLayout());
        ObjectLayout objectLayout = new ObjectLayout(false, true);
        map.put("OBJECT", new ObjectLayout(true, true));
        map.put("APPLET", objectLayout);
        map.put("EMBED", objectLayout);
        map.put("IFRAME", new IFrameLayout());
        SEE = new SizeExceededException();
    }

    private static abstract class CommonLayout
    implements MarkupLayout {
        protected static final int DISPLAY_NONE = 0;
        protected static final int DISPLAY_INLINE = 1;
        protected static final int DISPLAY_BLOCK = 2;
        protected static final int DISPLAY_LIST_ITEM = 3;
        protected static final int DISPLAY_TABLE_ROW = 4;
        protected static final int DISPLAY_TABLE_CELL = 5;
        protected static final int DISPLAY_TABLE = 6;
        private final int display;

        public CommonLayout(int n) {
            this.display = n;
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            int n;
            RenderState renderState = hTMLElementImpl.getRenderState();
            int n2 = n = renderState == null ? this.display : renderState.getDisplay();
            if (n == 1) {
                int n3;
                int n4 = n3 = renderState == null ? 0 : renderState.getPosition();
                if (n3 == 1 || n3 == 3) {
                    n = 2;
                } else {
                    int n5;
                    int n6 = n5 = renderState == null ? 0 : renderState.getFloat();
                    if (n5 != 0) {
                        n = 2;
                    }
                }
            }
            switch (n) {
                case 0: {
                    UINode uINode = hTMLElementImpl.getUINode();
                    if (!(uINode instanceof BaseBoundableRenderable)) break;
                    ((BaseBoundableRenderable)((Object)uINode)).markLayoutValid();
                    break;
                }
                case 2: {
                    rBlockViewport.layoutRBlock(hTMLElementImpl);
                    break;
                }
                case 3: {
                    String string = hTMLElementImpl.getTagName();
                    if ("UL".equalsIgnoreCase(string) || "OL".equalsIgnoreCase(string)) {
                        rBlockViewport.layoutList(hTMLElementImpl);
                        break;
                    }
                    rBlockViewport.layoutListItem(hTMLElementImpl);
                    break;
                }
                case 6: {
                    rBlockViewport.layoutRTable(hTMLElementImpl);
                    break;
                }
                default: {
                    rBlockViewport.layoutMarkup(hTMLElementImpl);
                }
            }
        }
    }

    private static abstract class CommonWidgetLayout
    implements MarkupLayout {
        protected static final int ADD_INLINE = 0;
        protected static final int ADD_AS_BLOCK = 1;
        private final int method;
        private final boolean useAlignAttribute;

        public CommonWidgetLayout(int n, boolean bl) {
            this.method = n;
            this.useAlignAttribute = bl;
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            Object object;
            AbstractCSS2Properties abstractCSS2Properties = hTMLElementImpl.getCurrentStyle();
            if (abstractCSS2Properties != null && (object = abstractCSS2Properties.getDisplay()) != null && "none".equalsIgnoreCase((String)object)) {
                return;
            }
            object = hTMLElementImpl.getUINode();
            RElement rElement = null;
            if (object == null) {
                rElement = this.createRenderable(rBlockViewport, hTMLElementImpl);
                if (rElement == null) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("layoutMarkup(): Don't know how to render " + hTMLElementImpl + ".");
                    }
                    return;
                }
                hTMLElementImpl.setUINode(rElement);
            } else {
                rElement = (RElement)object;
            }
            rElement.setOriginalParent(rBlockViewport);
            switch (this.method) {
                case 0: {
                    rBlockViewport.addRenderableToLineCheckStyle(rElement, hTMLElementImpl, this.useAlignAttribute);
                    break;
                }
                case 1: {
                    rBlockViewport.positionRElement(hTMLElementImpl, rElement, this.useAlignAttribute, true, false);
                }
            }
        }

        protected abstract RElement createRenderable(RBlockViewport var1, HTMLElementImpl var2);
    }

    private static class IFrameLayout
    extends CommonWidgetLayout {
        public IFrameLayout() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            BrowserFrame browserFrame = rBlockViewport.rendererContext.createBrowserFrame();
            ((HTMLIFrameElementImpl)hTMLElementImpl).setBrowserFrame(browserFrame);
            BrowserFrameUIControl browserFrameUIControl = new BrowserFrameUIControl(hTMLElementImpl, browserFrame);
            return new RUIControl(hTMLElementImpl, browserFrameUIControl, rBlockViewport.container, rBlockViewport.frameContext, rBlockViewport.userAgentContext);
        }
    }

    private static class TextAreaLayout2
    extends CommonWidgetLayout {
        public TextAreaLayout2() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            HTMLBaseInputElement hTMLBaseInputElement = (HTMLBaseInputElement)hTMLElementImpl;
            InputTextAreaControl inputTextAreaControl = new InputTextAreaControl(hTMLBaseInputElement);
            hTMLBaseInputElement.setInputContext(inputTextAreaControl);
            return new RUIControl(hTMLElementImpl, inputTextAreaControl, rBlockViewport.container, rBlockViewport.frameContext, rBlockViewport.userAgentContext);
        }
    }

    private static class SelectLayout
    extends CommonWidgetLayout {
        public SelectLayout() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            HTMLBaseInputElement hTMLBaseInputElement = (HTMLBaseInputElement)hTMLElementImpl;
            InputSelectControl inputSelectControl = new InputSelectControl(hTMLBaseInputElement);
            hTMLBaseInputElement.setInputContext(inputSelectControl);
            return new RUIControl(hTMLElementImpl, inputSelectControl, rBlockViewport.container, rBlockViewport.frameContext, rBlockViewport.userAgentContext);
        }
    }

    private static class InputLayout2
    extends CommonWidgetLayout {
        public InputLayout2() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            HTMLBaseInputElement hTMLBaseInputElement = (HTMLBaseInputElement)hTMLElementImpl;
            BaseInputControl baseInputControl = rBlockViewport.createInputControl(hTMLBaseInputElement);
            if (baseInputControl == null) {
                return null;
            }
            hTMLBaseInputElement.setInputContext(baseInputControl);
            return new RUIControl(hTMLElementImpl, baseInputControl, rBlockViewport.container, rBlockViewport.frameContext, rBlockViewport.userAgentContext);
        }
    }

    private static class ImgLayout
    extends CommonWidgetLayout {
        public ImgLayout() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            ImgControl imgControl = new ImgControl((HTMLImageElementImpl)hTMLElementImpl);
            return new RImgControl(hTMLElementImpl, imgControl, rBlockViewport.container, rBlockViewport.frameContext, rBlockViewport.userAgentContext);
        }
    }

    private static class ObjectLayout
    extends CommonWidgetLayout {
        private boolean tryToRenderContent;
        private final ThreadLocal htmlObject = new ThreadLocal();

        public ObjectLayout(boolean bl, boolean bl2) {
            super(0, bl2);
            this.tryToRenderContent = bl;
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            HtmlObject htmlObject = rBlockViewport.rendererContext.getHtmlObject(hTMLElementImpl);
            if (htmlObject == null && this.tryToRenderContent) {
                rBlockViewport.layoutMarkup(hTMLElementImpl);
            } else if (htmlObject != null) {
                this.htmlObject.set(htmlObject);
                super.layoutMarkup(rBlockViewport, hTMLElementImpl);
            }
        }

        protected RElement createRenderable(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            HtmlObject htmlObject = (HtmlObject)this.htmlObject.get();
            UIControlWrapper uIControlWrapper = new UIControlWrapper(htmlObject);
            RUIControl rUIControl = new RUIControl(hTMLElementImpl, uIControlWrapper, rBlockViewport.container, rBlockViewport.frameContext, rBlockViewport.userAgentContext);
            return rUIControl;
        }
    }

    private static class AnchorLayout
    extends CommonLayout {
        public AnchorLayout() {
            super(1);
        }
    }

    private static class StrongLayout
    extends CommonLayout {
        public StrongLayout() {
            super(1);
        }
    }

    private static class StrikeLayout
    extends CommonLayout {
        public StrikeLayout() {
            super(1);
        }
    }

    private static class ULayout
    extends CommonLayout {
        public ULayout() {
            super(1);
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            super.layoutMarkup(rBlockViewport, hTMLElementImpl);
        }
    }

    private static class EmLayout
    extends CommonLayout {
        public EmLayout() {
            super(1);
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            super.layoutMarkup(rBlockViewport, hTMLElementImpl);
        }
    }

    private static class SpanLayout
    extends CommonLayout {
        public SpanLayout() {
            super(1);
        }
    }

    private static class BlockQuoteLayout
    extends CommonLayout {
        public BlockQuoteLayout() {
            super(2);
        }
    }

    private static class DivLayout
    extends CommonLayout {
        public DivLayout() {
            super(2);
        }
    }

    private static class CommonBlockLayout
    extends CommonLayout {
        public CommonBlockLayout() {
            super(2);
        }
    }

    private static class TableLayout
    extends CommonLayout {
        public TableLayout() {
            super(6);
        }
    }

    private static class HrLayout
    implements MarkupLayout {
        private HrLayout() {
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            rBlockViewport.layoutHr(hTMLElementImpl);
        }
    }

    private static class BrLayout
    implements MarkupLayout {
        private BrLayout() {
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            String string = hTMLElementImpl.getAttribute("clear");
            rBlockViewport.addLineBreak(hTMLElementImpl, LineBreak.getBreakType(string));
        }
    }

    private static class ListItemLayout
    extends CommonLayout {
        public ListItemLayout() {
            super(3);
        }
    }

    private static class PLayout
    extends CommonLayout {
        public PLayout() {
            super(2);
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            super.layoutMarkup(rBlockViewport, hTMLElementImpl);
        }
    }

    private static class HLayout
    extends CommonLayout {
        public HLayout(int n) {
            super(2);
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            super.layoutMarkup(rBlockViewport, hTMLElementImpl);
        }
    }

    private static class MiscLayout
    extends CommonLayout {
        public MiscLayout() {
            super(1);
        }
    }

    private static class ChildrenLayout
    implements MarkupLayout {
        private ChildrenLayout() {
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            rBlockViewport.layoutChildren(hTMLElementImpl);
        }
    }

    private static class NoScriptLayout
    implements MarkupLayout {
        private NoScriptLayout() {
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
            UserAgentContext userAgentContext = rBlockViewport.userAgentContext;
            if (!userAgentContext.isScriptingEnabled()) {
                rBlockViewport.layoutMarkup(hTMLElementImpl);
            }
        }
    }

    private static class NopLayout
    implements MarkupLayout {
        private NopLayout() {
        }

        public void layoutMarkup(RBlockViewport rBlockViewport, HTMLElementImpl hTMLElementImpl) {
        }
    }
}

