/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.CommandOutputParser;
import console.Console;
import console.ConsoleProcess;
import console.Output;
import errorlist.DefaultErrorSource;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jcfunc.CF;
import jcfunc.Description;
import jcfunc.escMatcher;
import jcfunc.parameters.paramSGR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StringList;

class StreamThread
extends Thread {
    private ConsoleProcess process;
    private boolean aborted;
    private InputStream in;
    CommandOutputParser copt = null;
    private final int DEFAULT = -1;
    private final int WARNING = 1;
    private final int ERROR = 0;
    private StringBuilder lineBuffer;
    private int shiftUCW;
    private int ANSI_BEHAVIOUR;
    private Pattern eolPattern;
    private Pattern eolReplacingPattern;
    private escMatcher ansi_Matcher;
    private SimpleAttributeSet commonAttrs;
    private Color defaultColor;
    private SimpleAttributeSet defaultAttrs;
    private SimpleAttributeSet warningAttrs;
    private SimpleAttributeSet errorAttrs;

    StreamThread(ConsoleProcess process, InputStream in, Color defaultColor) {
        int i;
        this.process = process;
        this.in = in;
        String currentDirectory = process.getCurrentDirectory();
        Console console = process.getConsole();
        DefaultErrorSource es = console.getErrorSource();
        this.copt = new CommandOutputParser(console.getView(), es, defaultColor);
        this.copt.setDirectory(currentDirectory);
        this.lineBuffer = new StringBuilder(100);
        this.shiftUCW = 0;
        this.eolPattern = Pattern.compile("\n");
        if (!System.getProperty("line.separator").equals("\n")) {
            this.eolReplacingPattern = Pattern.compile(System.getProperty("line.separator"));
        }
        this.defaultColor = defaultColor;
        this.commonAttrs = new SimpleAttributeSet();
        StyleConstants.setBackground(this.commonAttrs, console.getConsolePane().getBackground());
        StyleConstants.setForeground(this.commonAttrs, defaultColor);
        this.defaultAttrs = this.setDefaultAttrs(null);
        int ansi_mode = 0;
        if (jEdit.getProperty((String)"options.ansi-escape.mode").contentEquals("8bit")) {
            ansi_mode = 1;
        }
        this.ansi_Matcher = new escMatcher(ansi_mode, 32);
        this.ANSI_BEHAVIOUR = -1;
        String str = jEdit.getProperty((String)"options.ansi-escape.behaviour");
        if (str.contentEquals("remove")) {
            this.ANSI_BEHAVIOUR = 0;
        } else if (str.contentEquals("parse")) {
            this.ANSI_BEHAVIOUR = 1;
        }
        StringList funcs = StringList.split((String)jEdit.getProperty((String)"options.ansi-escape.func-list").toLowerCase(), (Object)"\\s+");
        String avaible_funcs = jEdit.getProperty((String)"options.ansi-escape.func-list-values");
        for (i = 0; i < funcs.size(); ++i) {
            if (avaible_funcs.contains((CharSequence)funcs.get(i))) continue;
            str = (String)funcs.remove(i);
            str = null;
            --i;
        }
        CF[] func_arr = new CF[funcs.size()];
        for (i = 0; i < funcs.size(); ++i) {
            func_arr[i] = CF.valueOf(CF.class, ((String)funcs.get(i)).toUpperCase());
        }
        this.ansi_Matcher.setPatterns(func_arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(this.in, jEdit.getProperty((String)"console.encoding"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        Output output = this.process.getOutput();
        try {
            char[] input = new char[1024];
            while (!this.aborted) {
                int read = isr.read(input, 0, input.length);
                if (this.aborted) {
                    break;
                }
                if (read == -1) {
                    if (this.lineBuffer.length() > 0) {
                        this.printString(output, this.lineBuffer.toString(), false);
                    }
                    break;
                }
                String line = this.lineBuffer.append(input, 0, read).toString();
                if (this.eolReplacingPattern != null) {
                    this.lineBuffer.setLength(0);
                    line = this.lineBuffer.append(this.eolReplacingPattern.matcher(line).replaceAll("\n")).toString();
                }
                if (this.ANSI_BEHAVIOUR == 0 && this.ansi_Matcher.matches(line)) {
                    this.lineBuffer.setLength(0);
                    line = this.lineBuffer.append(this.ansi_Matcher.removeAll(line)).toString();
                }
                Matcher matcher = this.eolPattern.matcher(line);
                int bPosition = 0;
                while (matcher.find()) {
                    this.printString(output, line.substring(bPosition, matcher.end()), false);
                    bPosition = matcher.end();
                }
                if (bPosition > 0) {
                    this.lineBuffer.delete(0, bPosition);
                }
                if (this.lineBuffer.length() <= 0 || isr.ready()) continue;
                StreamThread.sleep(50L);
                if (isr.ready()) continue;
                this.printString(output, this.lineBuffer.toString(), true);
                this.lineBuffer.setLength(0);
            }
        }
        catch (Exception e) {
            if (!this.aborted) {
                Log.log((int)9, (Object)e, (Object)e);
                Console console = this.process.getConsole();
                Output error = this.process.getErrorOutput();
                if (console != null) {
                    Object[] args = new String[]{e.toString()};
                    error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.error", (Object[])args));
                }
            }
        }
        finally {
            this.copt.finishErrorParsing();
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
            this.process.threadDone();
        }
    }

    void abort() {
        this.aborted = true;
        this.interrupt();
    }

    private void printString(Output output, String str, boolean isUnterminated) {
        ArrayList<Description> seqs = null;
        SimpleAttributeSet currentAttrs = null;
        if (this.ANSI_BEHAVIOUR == 1 && this.ansi_Matcher.matches(str)) {
            seqs = this.ansi_Matcher.parse(str, true);
            str = this.ansi_Matcher.removeAll(str);
        }
        int errorStatus = this.copt.processLine(str);
        if (isUnterminated) {
            this.shiftUCW += str.length();
        } else {
            currentAttrs = this.updateCurrentAttrs(errorStatus, this.copt.getColor());
            if (this.shiftUCW > 0) {
                output.setAttrs(this.shiftUCW, currentAttrs);
                this.shiftUCW = 0;
            }
        }
        try {
            if (seqs == null) {
                output.writeAttrs(currentAttrs, str);
            } else {
                boolean firstFlushed = false;
                block5: for (Description descr : seqs) {
                    if (!firstFlushed) {
                        if (descr.bPosition > 0) {
                            this.flushSubstring(output, str, currentAttrs, 0, descr.bPosition);
                        }
                        firstFlushed = true;
                    }
                    switch (descr.function) {
                        case SGR: {
                            this.defaultAttrs = this.setDefaultAttrs(this.processSGRparameters(descr.parameters, this.defaultAttrs));
                            currentAttrs = this.updateCurrentAttrs(errorStatus, this.copt.getColor());
                            this.flushSubstring(output, str, currentAttrs, descr.bPosition, descr.ePosition);
                            continue block5;
                        }
                    }
                    this.flushSubstring(output, str, currentAttrs, descr.bPosition, descr.ePosition);
                }
            }
        }
        catch (Exception err) {
            Log.log((int)9, (Object)this, (Object)"Can't Flush:", (Throwable)err);
        }
    }

    private SimpleAttributeSet processSGRparameters(int[] parameters, SimpleAttributeSet baseAttrs) {
        SimpleAttributeSet funcAttrs = new SimpleAttributeSet(baseAttrs);
        int intensity = 0;
        Color clr = null;
        block22: for (int value : parameters) {
            paramSGR valSGR = paramSGR.getEnumValue(value);
            switch (valSGR) {
                case Reset: {
                    return null;
                }
                case Bright: {
                    intensity = 1;
                    continue block22;
                }
                case Faint: {
                    intensity = -1;
                    continue block22;
                }
                case Italic: {
                    StyleConstants.setItalic(funcAttrs, true);
                    continue block22;
                }
                case Underline_Single: 
                case Underline_Doubly: {
                    StyleConstants.setUnderline(funcAttrs, true);
                    continue block22;
                }
                case CrossedOut: {
                    StyleConstants.setStrikeThrough(funcAttrs, true);
                    continue block22;
                }
                case Normal_Int: {
                    intensity = 0;
                    continue block22;
                }
                case Normal_Style: {
                    StyleConstants.setItalic(funcAttrs, false);
                    continue block22;
                }
                case Underline_NGT: {
                    StyleConstants.setUnderline(funcAttrs, false);
                    continue block22;
                }
                case CrossedOut_NGT: {
                    StyleConstants.setStrikeThrough(funcAttrs, false);
                    continue block22;
                }
                case Color_Text_Black: 
                case Color_Text_Red: 
                case Color_Text_Green: 
                case Color_Text_Yellow: 
                case Color_Text_Blue: 
                case Color_Text_Magenta: 
                case Color_Text_Cyan: 
                case Color_Text_White: 
                case Color_Text_Reserved: {
                    clr = paramSGR.getColor(valSGR);
                    switch (intensity) {
                        case 1: {
                            clr = clr.darker();
                            break;
                        }
                        case -1: {
                            clr = clr.brighter();
                        }
                    }
                    StyleConstants.setForeground(funcAttrs, clr == null ? this.defaultColor : clr);
                    continue block22;
                }
                case Color_Bkgr_Black: 
                case Color_Bkgr_Red: 
                case Color_Bkgr_Green: 
                case Color_Bkgr_Yellow: 
                case Color_Bkgr_Blue: 
                case Color_Bkgr_Magenta: 
                case Color_Bkgr_Cyan: 
                case Color_Bkgr_White: 
                case Color_Bkgr_Reserved: {
                    clr = paramSGR.getColor(valSGR);
                    switch (intensity) {
                        case 1: {
                            clr = clr.darker();
                            break;
                        }
                        case -1: {
                            clr = clr.brighter();
                        }
                    }
                    StyleConstants.setBackground(funcAttrs, clr == null ? this.defaultColor : clr);
                    continue block22;
                }
            }
        }
        return funcAttrs;
    }

    private void flushSubstring(Output output, String str, SimpleAttributeSet localAttrs, int bpos, int epos) {
        if (epos - bpos > 0) {
            output.writeAttrs(localAttrs, str.substring(bpos, epos));
        }
    }

    private SimpleAttributeSet setDefaultAttrs(SimpleAttributeSet newAttrs) {
        return newAttrs == null ? this.commonAttrs : newAttrs;
    }

    private SimpleAttributeSet setNondefaultAttrs(SimpleAttributeSet nondefAttrs, Color color) {
        if (nondefAttrs == null) {
            nondefAttrs = new SimpleAttributeSet(this.commonAttrs);
            StyleConstants.setForeground(nondefAttrs, color);
        }
        return nondefAttrs;
    }

    private SimpleAttributeSet updateCurrentAttrs(int errorStatus, Color errorColor) {
        switch (errorStatus) {
            case -1: {
                return this.defaultAttrs;
            }
            case 1: {
                this.warningAttrs = this.setNondefaultAttrs(this.warningAttrs, errorColor);
                return this.warningAttrs;
            }
            case 0: {
                this.errorAttrs = this.setNondefaultAttrs(this.errorAttrs, errorColor);
                return this.errorAttrs;
            }
        }
        return this.defaultAttrs;
    }
}

