/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorGutterIcon;
import errorlist.ErrorHighlight;
import errorlist.ErrorList;
import errorlist.ErrorOverview;
import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.awt.Color;
import java.awt.Component;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.StandardUtilities;

public class ErrorListPlugin
extends EditPlugin {
    static final String FILENAME_FILTER = "error-list.filenameFilter";
    static final String IS_INCLUSION_FILTER = "error-list.isInclusionFilter";
    static final String SHOW_UNDERLINES = "error-list.showUnderlines";
    static final String SHOW_ICONS_IN_GUTTER = "error-list.showIconsInGutter";
    private static boolean showOnError;
    private static boolean showErrorOverview;
    private static Color warningColor;
    private static Color errorColor;
    private static Pattern filter;
    private static boolean isInclusionFilter;

    public void start() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.initEditPane(panes[i]);
                this.addErrorOverviewIfErrors(panes[i]);
            }
        }
        this.propertiesChanged();
        EditBus.addToBus((Object)((Object)this));
    }

    public void stop() {
        EditBus.removeFromBus((Object)((Object)this));
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.uninitEditPane(panes[i]);
                ErrorListPlugin.removeErrorOverview(panes[i]);
            }
            ErrorList errorList = (ErrorList)view.getDockableWindowManager().getDockable("error-list");
            if (errorList == null) continue;
            errorList.unload();
        }
    }

    @EditBus.EBHandler
    public void handleErrorSourceMessage(ErrorSourceUpdate message) {
        Object what = message.getWhat();
        if (what == ErrorSourceUpdate.ERROR_ADDED) {
            ErrorSource.Error error = message.getError();
            Buffer buffer = error.getBuffer();
            if (buffer != null) {
                this.invalidateLineInAllViews(buffer, error.getLineNumber());
            }
            if (showOnError && jEdit.getActiveView() != null && !this.isErrorFiltered(error)) {
                this.showErrorList(jEdit.getActiveView());
            }
        } else if (what == ErrorSourceUpdate.ERROR_REMOVED) {
            ErrorSource.Error error = message.getError();
            Buffer buffer = error.getBuffer();
            if (buffer != null) {
                this.invalidateLineInAllViews(buffer, error.getLineNumber());
            }
        } else if (what == ErrorSourceUpdate.ERRORS_CLEARED || what == ErrorSourceUpdate.ERROR_SOURCE_ADDED || what == ErrorSourceUpdate.ERROR_SOURCE_REMOVED) {
            for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
                EditPane[] editPanes = view.getEditPanes();
                for (int i = 0; i < editPanes.length; ++i) {
                    EditPane pane = editPanes[i];
                    pane.getTextArea().getPainter().repaint();
                    this.addErrorOverviewIfErrors(pane);
                }
            }
            if (what == ErrorSourceUpdate.ERROR_SOURCE_ADDED && showOnError && jEdit.getActiveView() != null && this.doErrorsExist()) {
                this.showErrorList(jEdit.getActiveView());
            }
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneMessage(EditPaneUpdate message) {
        EditPane editPane = message.getEditPane();
        Object what = message.getWhat();
        if (what == EditPaneUpdate.CREATED) {
            this.initEditPane(editPane);
            this.addErrorOverviewIfErrors(editPane);
        } else if (what == EditPaneUpdate.DESTROYED) {
            this.uninitEditPane(editPane);
            ErrorListPlugin.removeErrorOverview(editPane);
        } else if (what == EditPaneUpdate.BUFFER_CHANGED) {
            this.addErrorOverviewIfErrors(editPane);
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(EBMessage message) {
        this.propertiesChanged();
    }

    public void showErrorOverviewIfNecessary() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.addErrorOverviewIfErrors(panes[i]);
            }
        }
    }

    public static void addErrorOverview(EditPane editPane) {
        ErrorOverview overview = ErrorListPlugin.getErrorOverview(editPane);
        if (overview != null) {
            overview.repaint();
        } else {
            overview = new ErrorOverview(editPane);
            JEditTextArea textArea = editPane.getTextArea();
            textArea.addLeftOfScrollBar((Component)overview);
            textArea.putClientProperty(ErrorOverview.class, (Object)overview);
            textArea.revalidate();
        }
    }

    public static void removeErrorOverview(EditPane editPane) {
        ErrorOverview overview = ErrorListPlugin.getErrorOverview(editPane);
        if (overview != null) {
            JEditTextArea textArea = editPane.getTextArea();
            textArea.removeLeftOfScrollBar((Component)overview);
            textArea.revalidate();
            textArea.putClientProperty(ErrorOverview.class, null);
        }
    }

    public static ErrorOverview getErrorOverview(EditPane editPane) {
        return (ErrorOverview)editPane.getTextArea().getClientProperty(ErrorOverview.class);
    }

    static Color getErrorColor(int type) {
        return type == 1 ? warningColor : errorColor;
    }

    static Pattern getFilenameFilter() {
        return filter;
    }

    static boolean isInclusionFilter() {
        return isInclusionFilter;
    }

    static boolean showUnderlines() {
        return jEdit.getBooleanProperty((String)SHOW_UNDERLINES, (boolean)true);
    }

    static boolean showIconsInGutter() {
        return jEdit.getBooleanProperty((String)SHOW_ICONS_IN_GUTTER, (boolean)false);
    }

    private boolean isErrorFiltered(ErrorSource.Error error) {
        String path;
        boolean match;
        if (jEdit.getBooleanProperty((String)("error-list-filtered-types." + error.getErrorType()), (boolean)false)) {
            return true;
        }
        Pattern filter = ErrorListPlugin.getFilenameFilter();
        return filter != null && (match = filter.matcher(path = error.getFilePath()).matches()) != ErrorListPlugin.isInclusionFilter();
    }

    private void propertiesChanged() {
        showOnError = jEdit.getBooleanProperty((String)"error-list.showOnError");
        showErrorOverview = jEdit.getBooleanProperty((String)"error-list.showErrorOverview");
        warningColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"error-list.warningColor"));
        errorColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"error-list.errorColor"));
        String globFilter = jEdit.getProperty((String)FILENAME_FILTER);
        filter = globFilter != null && globFilter.length() > 0 ? Pattern.compile(StandardUtilities.globToRE((String)globFilter)) : null;
        isInclusionFilter = jEdit.getBooleanProperty((String)IS_INCLUSION_FILTER, (boolean)false);
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.uninitEditPane(panes[i]);
                this.initEditPane(panes[i]);
                this.addErrorOverviewIfErrors(panes[i]);
            }
        }
    }

    private void initEditPane(EditPane editPane) {
        TextAreaExtension ext;
        JEditTextArea textArea = editPane.getTextArea();
        if (ErrorListPlugin.showIconsInGutter()) {
            ext = new ErrorGutterIcon(editPane);
            Gutter gutter = textArea.getGutter();
            gutter.addExtension(ext);
            gutter.putClientProperty((Object)"ErrorHighlight", (Object)ext);
        }
        if (ErrorListPlugin.showUnderlines()) {
            ext = new ErrorHighlight(editPane);
            textArea.getPainter().addExtension(ext);
            textArea.putClientProperty((Object)"ErrorHighlight", (Object)ext);
        }
    }

    private void uninitEditPane(EditPane editPane) {
        Gutter gutter;
        JEditTextArea textArea = editPane.getTextArea();
        TextAreaExtension ext = (TextAreaExtension)textArea.getClientProperty((Object)"ErrorHighlight");
        if (ext != null) {
            textArea.getPainter().removeExtension(ext);
            textArea.putClientProperty((Object)"ErrorHighlight", null);
        }
        if ((ext = (TextAreaExtension)(gutter = textArea.getGutter()).getClientProperty((Object)"ErrorHighlight")) != null) {
            gutter.removeExtension(ext);
            gutter.putClientProperty((Object)"ErrorHighlight", null);
        }
    }

    private void showErrorList(View view) {
        DockableWindowManager dwm = view.getDockableWindowManager();
        dwm.addDockableWindow("error-list");
    }

    private void invalidateLineInAllViews(Buffer buffer, int line) {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPanes = view.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                EditPane pane = editPanes[i];
                if (pane.getBuffer() != buffer) continue;
                pane.getTextArea().invalidateLine(line);
                this.addErrorOverviewIfErrors(pane);
            }
        }
    }

    private void addErrorOverviewIfErrors(EditPane editPane) {
        Buffer buffer = editPane.getBuffer();
        if (showErrorOverview) {
            ErrorSource[] errorSources = ErrorSource.getErrorSources();
            for (int i = 0; i < errorSources.length; ++i) {
                ErrorSource source = errorSources[i];
                if (source.getFileErrors(buffer.getSymlinkPath()) == null) continue;
                ErrorListPlugin.addErrorOverview(editPane);
                return;
            }
        }
        ErrorListPlugin.removeErrorOverview(editPane);
    }

    private boolean doErrorsExist() {
        for (ErrorSource errorSource : ErrorSource.getErrorSources()) {
            ErrorSource.Error[] errors = errorSource.getAllErrors();
            if (errors == null) continue;
            for (ErrorSource.Error error : errors) {
                if (this.isErrorFiltered(error)) continue;
                return true;
            }
        }
        return false;
    }
}

