/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsolePane;
import console.Output;
import java.awt.Color;
import javax.swing.text.AttributeSet;
import org.gjt.sp.util.Log;

public class ErrorOutput
implements Output {
    private Output m_output;
    private Color m_color;
    AttributeSet m_set;
    private boolean writeToOutput;

    public ErrorOutput(Console c) {
        boolean bl = this.writeToOutput = c != null;
        if (this.writeToOutput) {
            this.bindToOutput(c.getOutput(), c.getErrorColor());
        }
    }

    public ErrorOutput(Output output, Color errorColor) {
        boolean bl = this.writeToOutput = output != null;
        if (this.writeToOutput) {
            this.bindToOutput(output, errorColor);
        }
    }

    private void bindToOutput(Output output, Color errorColor) {
        this.m_output = output;
        this.m_color = errorColor;
        this.m_set = ConsolePane.colorAttributes(this.m_color);
    }

    @Override
    public void print(Color color, String msg) {
        if (this.writeToOutput) {
            this.m_output.print(this.m_color, msg);
        } else {
            Log.log((int)9, null, (Object)msg);
        }
    }

    @Override
    public void writeAttrs(AttributeSet attrs, String msg) {
        if (this.writeToOutput) {
            this.m_output.writeAttrs(this.m_set, msg);
        } else {
            Log.log((int)9, null, (Object)msg);
        }
    }

    @Override
    public void setAttrs(int length, AttributeSet attrs) {
    }

    @Override
    public void commandDone() {
    }
}

