/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ErrorOutput;
import console.ErrorThread;
import console.InputThread;
import console.Output;
import console.OutputThread;
import console.ProcessRunner;
import console.StreamThread;
import console.SystemShell;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.StringList;

class ConsoleProcess {
    Process process;
    private SystemShell.ConsoleState consoleState;
    private String currentDirectory;
    private Console console;
    private Output output;
    private Output error;
    private String[] args;
    private InputThread stdin;
    private OutputThread stdout;
    private OutputThread stderr;
    private int threadDoneCount = 0;
    private int exitCode = 834;
    private boolean stopped;
    private boolean foreground;
    private PipedInputStream pipeIn;
    private PipedOutputStream pipeOut;

    ConsoleProcess(Console console, Output output, String[] args, Map<String, String> env2, SystemShell.ConsoleState consoleState, boolean foreground) {
        this.args = args;
        this.currentDirectory = consoleState.currentDirectory;
        this.console = console;
        this.foreground = foreground;
        if (foreground) {
            this.output = output;
            this.error = new ErrorOutput(console);
            this.consoleState = consoleState;
        } else {
            this.error = new ErrorOutput(null);
        }
        try {
            boolean merge = jEdit.getBooleanProperty((String)"console.processrunner.mergeError", (boolean)true);
            this.process = ProcessRunner.getProcessRunner().exec(args, env2, this.currentDirectory, merge && foreground);
            if (this.process == null) {
                String str = StringList.join((Object[])args, (String)" ");
                throw new RuntimeException("Unrecognized command: " + str);
            }
            if (foreground) {
                this.pipeIn = new PipedInputStream();
                this.pipeOut = new PipedOutputStream(this.pipeIn);
                console.startAnimation();
                this.threadDoneCount = merge ? 2 : 3;
            } else {
                this.threadDoneCount = 1;
            }
            new Thread(){

                @Override
                public void run() {
                    try {
                        ConsoleProcess.this.exitCode = ConsoleProcess.this.process.waitFor();
                        ConsoleProcess.this.showExit();
                        ConsoleProcess.this.threadDone();
                    }
                    catch (InterruptedException e) {
                        ConsoleProcess.this.exitCode = 1;
                        Log.log((int)9, (Object)this, (Object)e);
                    }
                }
            }.start();
            if (foreground) {
                this.stdout = new StreamThread(this, this.process.getInputStream(), console.getPlainColor());
                this.stdout.start();
                if (merge) {
                    this.stderr = null;
                } else {
                    this.stderr = new StreamThread(this, this.process.getErrorStream(), console.getErrorColor());
                    this.stderr.start();
                }
                this.stdin = new InputThread(this, this.process.getOutputStream());
                this.stdin.start();
            } else {
                this.stderr = new ErrorThread(this, this.process.getErrorStream(), console.getErrorColor());
                this.stderr.start();
            }
        }
        catch (Exception ioe) {
            Log.log((int)9, (Object)ioe, (Object)"ConsoleProcess()");
        }
    }

    synchronized void showExit() {
        if (this.error == null) {
            this.error = this.console.getOutput();
        }
        boolean showExitStatus = jEdit.getBooleanProperty((String)"console.processrunner.showExitStatus", (boolean)true);
        if (!this.foreground || showExitStatus) {
            Object[] pp = new Object[]{this.args[0], this.exitCode};
            String msg = jEdit.getProperty((String)"console.shell.exited", (Object[])pp);
            if (this.exitCode == 0) {
                this.error.print(this.console.getInfoColor(), msg);
            } else {
                this.error.print(this.console.getErrorColor(), msg);
            }
        }
    }

    void detach() {
        if (this.console != null) {
            Object[] pp = new Object[]{this.args[0]};
            this.output.commandDone();
            if (this.error != null) {
                this.error.print(this.console.getErrorColor(), jEdit.getProperty((String)"console.shell.detached", (Object[])pp));
                this.error.commandDone();
            }
        }
        this.consoleState.setProcess(null);
        this.consoleState = null;
        this.console = null;
    }

    synchronized void stop() {
        if (this.process != null) {
            if (this.stdin != null) {
                this.stdin.abort();
            }
            if (this.stdout != null) {
                this.stdout.abort();
            }
            if (this.stderr != null) {
                this.stderr.abort();
            }
            this.stopped = true;
            try {
                if (this.pipeOut != null) {
                    this.pipeOut.close();
                }
            }
            catch (IOException e) {
                Log.log((int)7, (Object)this, (Object)e.getMessage());
            }
            try {
                this.process.destroy();
                if (this.output != null) {
                    this.output.commandDone();
                }
            }
            catch (Exception e) {
                Log.log((int)7, (Object)this, (Object)e.getMessage());
            }
            this.process = null;
            if (this.console != null) {
                // empty if block
            }
        }
        if (this.consoleState != null) {
            this.consoleState.setProcess(null);
        }
        this.notifyAll();
    }

    boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException itse) {
            return true;
        }
        return false;
    }

    int getExitStatus() {
        return this.exitCode;
    }

    Console getConsole() {
        return this.console;
    }

    Output getOutput() {
        return this.output;
    }

    Output getErrorOutput() {
        return this.error;
    }

    String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public PipedInputStream getPipeInput() {
        return this.pipeIn;
    }

    String[] getArgs() {
        return this.args;
    }

    public PipedOutputStream getPipeOutput() {
        return this.process != null ? this.pipeOut : null;
    }

    public synchronized int waitFor() throws InterruptedException {
        if (this.process != null) {
            this.exitCode = this.process.waitFor();
        }
        while (!this.stopped) {
            this.wait(100L);
        }
        return this.exitCode;
    }

    synchronized void threadDone() {
        --this.threadDoneCount;
        if (this.threadDoneCount > 0) {
            return;
        }
        if (!this.stopped && this.process != null) {
            this.stop();
        }
        boolean doCheck = false;
        final int check = jEdit.getIntegerProperty((String)"checkFileStatus");
        if (StandardUtilities.compareStrings((String)jEdit.getBuild(), (String)"05.01.00.01", (boolean)false) >= 0) {
            if (check > 0) {
                doCheck = true;
            }
        } else {
            doCheck = true;
        }
        if (doCheck) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jEdit.checkBufferStatus((View)ConsoleProcess.this.console.getView(), (check != 0 ? 1 : 0) != 0);
                }
            });
        }
    }

    public boolean isForeground() {
        return this.foreground;
    }
}

