/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;

public class ButtonCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private final JButton remove = new JButton(GUIUtilities.loadIcon((String)"Clear.png"));
    private final JButton search = new JButton(GUIUtilities.loadIcon((String)"Find.png"));
    private final HighlightManager highlightManager;
    private int row;
    private Highlight highlight;

    public ButtonCellEditor(HighlightManager highlightManager) {
        this.highlightManager = highlightManager;
        this.remove.addActionListener(this);
        this.search.addActionListener(this);
    }

    @Override
    public Object getCellEditorValue() {
        return this.highlight;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.highlight = (Highlight)value;
        if (column == 2) {
            return this.remove;
        }
        return this.search;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
        if (e.getSource() == this.remove) {
            this.highlightManager.removeRow(this.row);
        } else if (e.getSource() == this.search) {
            String text = this.highlight.getStringToHighlight();
            SearchAndReplace.setRegexp((boolean)this.highlight.isRegexp());
            HistoryModel.getModel((String)"find").addItem(text);
            SearchAndReplace.setSearchString((String)text);
            SearchAndReplace.setSearchFileSet((SearchFileSet)new CurrentBufferSet());
            SearchAndReplace.hyperSearch((View)jEdit.getActiveView());
        }
    }
}

