/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.SwingWorker;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import sidekick.SideKick;
import sidekick.SideKickActions;
import sidekick.SideKickBindings;
import sidekick.SideKickMenuProvider;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickToolBar;
import sidekick.SideKickTree;

public class SideKickPlugin
extends EditPlugin {
    private static final String MARKER_SETS_PLUGIN = "marker.MarkerSetsPlugin";
    private static final String SHOW_TOOL_BAR = "sidekick.showToolBar";
    public static final String NAME = "sidekick-tree";
    public static final String PARSER_MODE_PROPERTY = "sidekick.parser-mode";
    public static final String PARSER_PROPERTY = "sidekick.parser";
    public static final String PARSED_DATA_PROPERTY = "sidekick.parsed-data";
    public static final String PARSE_COUNT = "sidekick.parse-count";
    public static final String NONE = "None";
    public static final String DEFAULT = "default parser";
    private static final String MACRO_PATH = "/macros";
    private static Map<View, SideKick> sidekicks;
    private static Map<String, SideKickParser> parsers;
    private static Executor executor;
    private static Set<Buffer> parsedBufferSet;
    private static Map<View, SideKickToolBar> toolBars;
    private static boolean toolBarsEnabled;
    private static Map<View, SwingWorker<SideKickParsedData, Object>> workers;
    private static EditPlugin markerSetsPlugin;

    public void start() {
        BeanShell.getNameSpace().addCommandPath(MACRO_PATH, ((Object)((Object)this)).getClass());
        markerSetsPlugin = jEdit.getPlugin((String)MARKER_SETS_PLUGIN, (boolean)false);
        sidekicks = new HashMap<View, SideKick>();
        parsers = new HashMap<String, SideKickParser>();
        workers = new HashMap<View, SwingWorker<SideKickParsedData, Object>>();
        parsedBufferSet = new HashSet<Buffer>();
        toolBars = new HashMap<View, SideKickToolBar>();
        toolBarsEnabled = jEdit.getBooleanProperty((String)SHOW_TOOL_BAR);
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            SideKickPlugin.initView(view);
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                SideKickPlugin.initTextArea(panes[i].getTextArea());
            }
        }
        jEdit.addActionSet((ActionSet)SideKickMenuProvider.getParserSwitchers());
        SideKickActions.propertiesChanged();
        EditBus.addToBus((Object)((Object)this));
    }

    public void stop() {
        EditBus.removeFromBus((Object)((Object)this));
        jEdit.removeActionSet((ActionSet)SideKickMenuProvider.getParserSwitchers());
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            SideKickPlugin.uninitView(view);
            SideKickParsedData.setParsedData(view, null);
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                SideKickPlugin.uninitTextArea(panes[i].getTextArea());
            }
        }
        for (Buffer buffer = jEdit.getFirstBuffer(); buffer != null; buffer = buffer.getNext()) {
            buffer.setProperty(PARSED_DATA_PROPERTY, null);
        }
        sidekicks = null;
        parsers = null;
        parsedBufferSet = null;
        toolBars = null;
        workers = null;
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate vu) {
        View view = vu.getView();
        if (vu.getWhat() == ViewUpdate.CREATED) {
            SideKickPlugin.initView(view);
        } else if (vu.getWhat() == ViewUpdate.CLOSED) {
            SideKickPlugin.uninitView(view);
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate epu) {
        EditPane editPane = epu.getEditPane();
        if (epu.getWhat() == EditPaneUpdate.CREATED) {
            SideKickPlugin.initTextArea(editPane.getTextArea());
        } else if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
            SideKickPlugin.uninitTextArea(editPane.getTextArea());
        }
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bu) {
        if (bu.getWhat() == BufferUpdate.CLOSED) {
            SideKickPlugin.finishParsingBuffer(bu.getBuffer());
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        SideKickActions.propertiesChanged();
        boolean showToolBar = jEdit.getBooleanProperty((String)SHOW_TOOL_BAR);
        if (showToolBar != toolBarsEnabled) {
            toolBarsEnabled = showToolBar;
            for (View v : jEdit.getViews()) {
                if (toolBarsEnabled) {
                    SideKickPlugin.attachToolBar(v);
                    continue;
                }
                SideKickPlugin.detachToolBar(v);
            }
        }
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate msg) {
        EditPlugin plugin = msg.getPluginJAR().getPlugin();
        if (plugin == null) {
            return;
        }
        if (plugin.getClassName().equals(MARKER_SETS_PLUGIN)) {
            if (msg.getWhat() == PluginUpdate.ACTIVATED) {
                markerSetsPlugin = plugin;
            } else if (msg.getWhat() == PluginUpdate.DEACTIVATED) {
                markerSetsPlugin = null;
            }
        }
    }

    public static EditPlugin getMarkerSetsPlugin() {
        return markerSetsPlugin;
    }

    public static SideKickParser getParserForMode(Mode m) {
        String modeStr = m.getName();
        String propName = "mode." + modeStr + '.' + PARSER_PROPERTY;
        String parserName = jEdit.getProperty((String)propName);
        if (parserName == null) {
            return null;
        }
        SideKickParser parser = (SideKickParser)ServiceManager.getService((String)"sidekick.SideKickParser", (String)parserName);
        return parser;
    }

    public static SideKickParser getParser(String name) {
        SideKickParser parser = (SideKickParser)ServiceManager.getService((String)"sidekick.SideKickParser", (String)name);
        if (parser != null) {
            return parser;
        }
        return parsers.get(name);
    }

    public static SideKickParser getParserForView(View view) {
        SideKick sidekick = sidekicks.get(view);
        if (sidekick == null) {
            return null;
        }
        return sidekick.getParser();
    }

    public static void setParserForBuffer(Buffer buffer, String parserName) {
        if (parserName.equals(NONE)) {
            buffer.setStringProperty(PARSER_PROPERTY, parserName);
            return;
        }
        if (parserName.equals(DEFAULT)) {
            buffer.unsetProperty(PARSER_PROPERTY);
            return;
        }
        SideKickParser newParser = SideKickPlugin.getParser(parserName);
        if (newParser == null) {
            throw new RuntimeException("Unknown parser: " + parserName);
        }
        buffer.setStringProperty(PARSER_PROPERTY, parserName);
    }

    public static SideKickParser getParserForBuffer(Buffer buffer) {
        String parserName = buffer.getStringProperty(PARSER_PROPERTY);
        Mode mode = buffer.getMode();
        String modeName = mode != null ? mode.getName() : "";
        buffer.setStringProperty(PARSER_MODE_PROPERTY, modeName);
        if (parserName == null || parserName.equals(DEFAULT) || parserName.length() == 0) {
            if (mode != null) {
                return SideKickPlugin.getParserForMode(mode);
            }
            return null;
        }
        if (parserName.equals(NONE)) {
            return null;
        }
        return SideKickPlugin.getParser(parserName);
    }

    public static void parse(View view, boolean showParsingMessage) {
        SideKick sidekick = sidekicks.get(view);
        if (sidekick == null) {
            return;
        }
        sidekick.setParser(view.getBuffer());
        sidekick.parse(showParsingMessage);
    }

    public static void execute(Runnable runnable) {
        if (executor == null) {
            executor = Executors.newSingleThreadExecutor();
        }
        executor.execute(runnable);
    }

    public static void execute(View view, SwingWorker<SideKickParsedData, Object> worker) {
        workers.put(view, worker);
        worker.execute();
    }

    public static void cleanup(View view) {
        workers.remove(view);
    }

    public static boolean isParsingBuffer(Buffer buffer) {
        return parsedBufferSet.contains(buffer);
    }

    static void startParsingBuffer(Buffer buffer) {
        parsedBufferSet.add(buffer);
    }

    static void finishParsingBuffer(Buffer buffer) {
        parsedBufferSet.remove(buffer);
    }

    private static void attachToolBar(View view) {
        SideKickToolBar toolBar = new SideKickToolBar(view);
        view.addToolBar((Component)toolBar);
        toolBars.put(view, toolBar);
    }

    private static void detachToolBar(View view) {
        SideKickToolBar toolBar = toolBars.remove(view);
        if (toolBar != null) {
            view.removeToolBar((Component)toolBar);
            toolBar.dispose();
        }
    }

    private static void initView(View view) {
        SideKick sideKick = new SideKick(view);
        sidekicks.put(view, sideKick);
        sideKick.parse(true);
        if (toolBarsEnabled) {
            SideKickPlugin.attachToolBar(view);
        }
    }

    static SideKick getSideKick(View v) {
        return sidekicks.get(v);
    }

    private static void uninitView(View view) {
        SideKick sidekick = sidekicks.get(view);
        sidekick.dispose();
        sidekicks.remove(view);
        SideKickPlugin.stop(view);
        workers.remove(view);
        SideKickPlugin.detachToolBar(view);
    }

    private static void initTextArea(JEditTextArea textArea) {
        SideKickBindings b = new SideKickBindings();
        textArea.putClientProperty(SideKickBindings.class, (Object)b);
        textArea.addKeyListener((KeyListener)b);
    }

    private static void uninitTextArea(JEditTextArea textArea) {
        SideKickBindings b = (SideKickBindings)textArea.getClientProperty(SideKickBindings.class);
        textArea.putClientProperty(SideKickBindings.class, null);
        textArea.removeKeyListener((KeyListener)b);
        SideKickTree.CaretHandler caretHandler = (SideKickTree.CaretHandler)textArea.getClientProperty(SideKickTree.CaretHandler.class);
        if (caretHandler != null) {
            textArea.putClientProperty(SideKickTree.CaretHandler.class, null);
            textArea.removeCaretListener((CaretListener)caretHandler);
        }
    }

    public static void stop(View view) {
        SwingWorker<SideKickParsedData, Object> worker = workers.get(view);
        if (worker != null && !worker.isCancelled() && !worker.isDone()) {
            worker.cancel(true);
        }
    }
}

