/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsoleProcess;
import console.Output;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class InputThread
extends Thread {
    InputStream inputPipe;
    OutputStream out;
    Output error;
    ConsoleProcess cProcess;
    boolean aborted;

    InputThread(ConsoleProcess process, OutputStream out) {
        this.cProcess = process;
        this.error = process.getErrorOutput();
        this.inputPipe = process.getPipeInput();
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader inr = new BufferedReader(new InputStreamReader(this.inputPipe));
        try {
            String _line;
            while ((_line = inr.readLine()) != null) {
                if (this.aborted) {
                    break;
                }
                _line = _line + '\n';
                _line = new String(_line.getBytes(), jEdit.getProperty((String)"console.encoding"));
                this.out.write(_line.getBytes());
                try {
                    this.out.flush();
                }
                catch (IOException flushe) {}
            }
        }
        catch (IOException e) {
            if (!this.aborted) {
                Log.log((int)9, (Object)this, (Object)e);
                Console console = this.cProcess.getConsole();
                if (console != null) {
                    Object[] args = new String[]{e.toString()};
                    this.error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.error", (Object[])args));
                }
            }
        }
        finally {
            try {
                this.out.close();
            }
            catch (Exception exception) {}
            this.cProcess.threadDone();
        }
    }

    void abort() {
        this.aborted = true;
        this.interrupt();
    }
}

