/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Path;
import isabelle.Path$;
import isabelle.UTF8$;
import isabelle.package$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class File$ {
    public static final File$ MODULE$;

    static {
        new File$();
    }

    public List<String> read_dir(Path dir) {
        Object object = dir.is_dir() ? BoxedUnit.UNIT : package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Bad directory: ").append((Object)dir.toString()).toString());
        File[] files = dir.file().listFiles();
        return files == null ? Nil$.MODULE$ : (List)Predef$.MODULE$.refArrayOps((Object[])files).toList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return x$1.getName();
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public Stream<Path> find_files(Path dir) {
        return ((Stream)this.read_dir(dir).toStream().map((Function1)new Serializable(dir){
            public static final long serialVersionUID = 0L;
            private final Path dir$1;

            public final Stream<Path> apply(String name2) {
                Path path2 = this.dir$1.$plus(Path$.MODULE$.basic(name2));
                return Stream$.MODULE$.consWrapper((Function0)new Serializable(this, path2){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final Stream<Path> apply() {
                        return this.path$1.is_dir() ? File$.MODULE$.find_files(this.path$1) : scala.package$.MODULE$.Stream().empty();
                    }
                    {
                        this.path$1 = path$1;
                    }
                }).$hash$colon$colon((Object)path2);
            }
            {
                this.dir$1 = dir$1;
            }
        }, Stream$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms());
    }

    /*
     * WARNING - void declaration
     */
    public byte[] read_bytes(File file) {
        int i = 0;
        int n = (int)file.length();
        byte[] buf = new byte[n];
        FileInputStream stream = new FileInputStream(file);
        try {
            int m;
            do {
                if ((m = stream.read(buf, i, n - i)) == -1) continue;
                i += m;
            } while (m != -1 && n > i);
        }
        catch (Throwable throwable) {
            void var6_5;
            var6_5.close();
            throw throwable;
        }
        stream.close();
        return buf;
    }

    public String read(File file) {
        return new String(this.read_bytes(file), UTF8$.MODULE$.charset());
    }

    public String read(Path path2) {
        return this.read(path2.file());
    }

    public String read_stream(BufferedReader reader) {
        int c;
        StringBuilder output = new StringBuilder(100);
        while ((c = reader.read()) != -1) {
            output.$plus$eq((char)c);
        }
        reader.close();
        return output.toString();
    }

    public String read_stream(InputStream stream) {
        return this.read_stream(new BufferedReader(new InputStreamReader(stream, UTF8$.MODULE$.charset())));
    }

    public String read_gzip(File file) {
        return this.read_stream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));
    }

    public String read_gzip(Path path2) {
        return this.read_gzip(path2.file());
    }

    public List<String> read_lines(BufferedReader reader, Function1<String, BoxedUnit> progress) {
        String line;
        ListBuffer result2 = new ListBuffer();
        while ((line = this.liftedTree1$1(reader)) != null) {
            progress.apply((Object)line);
            result2.$plus$eq((Object)line);
        }
        reader.close();
        return result2.toList();
    }

    public String try_read(Seq<Path> paths2) {
        StringBuilder buf = new StringBuilder();
        paths2.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path path2) {
                return path2.is_file();
            }
        }).foreach((Function1)new Serializable(buf){
            public static final long serialVersionUID = 0L;
            private final StringBuilder buf$1;

            public final StringBuilder apply(Path path2) {
                this.buf$1.append(File$.MODULE$.read(path2));
                return this.buf$1.append('\n');
            }
            {
                this.buf$1 = buf$1;
            }
        });
        return buf.toString();
    }

    public void write_file(File file, Iterable<CharSequence> text2, Function1<OutputStream, OutputStream> make_stream) {
        OutputStream stream = (OutputStream)make_stream.apply((Object)new FileOutputStream(file));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, UTF8$.MODULE$.charset()));
        try {
            text2.iterator().foreach((Function1)new Serializable(writer){
                public static final long serialVersionUID = 0L;
                private final BufferedWriter writer$1;

                public final Writer apply(CharSequence x$3) {
                    return this.writer$1.append(x$3);
                }
                {
                    this.writer$1 = writer$1;
                }
            });
            return;
        }
        finally {
            writer.close();
        }
    }

    public void write(File file, Iterable<CharSequence> text2) {
        this.write_file(file, text2, (Function1<OutputStream, OutputStream>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OutputStream apply(OutputStream s) {
                return s;
            }
        });
    }

    public void write(File file, CharSequence text2) {
        this.write(file, (Iterable<CharSequence>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CharSequence[]{text2})));
    }

    public void write(Path path2, Iterable<CharSequence> text2) {
        this.write(path2.file(), text2);
    }

    public void write(Path path2, CharSequence text2) {
        this.write(path2.file(), text2);
    }

    public void write_gzip(File file, Iterable<CharSequence> text2) {
        this.write_file(file, text2, (Function1<OutputStream, OutputStream>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GZIPOutputStream apply(OutputStream s) {
                return new GZIPOutputStream(new BufferedOutputStream(s));
            }
        });
    }

    public void write_gzip(File file, CharSequence text2) {
        this.write_gzip(file, (Iterable<CharSequence>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CharSequence[]{text2})));
    }

    public void write_gzip(Path path2, Iterable<CharSequence> text2) {
        this.write_gzip(path2.file(), text2);
    }

    public void write_gzip(Path path2, CharSequence text2) {
        this.write_gzip(path2.file(), text2);
    }

    public void write_backup(Path path2, CharSequence text2) {
        path2.file().renameTo(path2.backup().file());
        this.write(path2, text2);
    }

    public boolean eq(File file1, File file2) {
        boolean bl;
        try {
            bl = Files.isSameFile(file1.toPath(), file2.toPath());
        }
        catch (Throwable throwable) {
            Option<String> option2 = package$.MODULE$.ERROR().unapply(throwable);
            if (option2.isEmpty()) {
                throw throwable;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    public void copy(File src, File dst) {
        Throwable throwable222;
        block8: {
            FileOutputStream out;
            FileInputStream in;
            if (!this.eq(src, dst)) {
                int m;
                in = new FileInputStream(src);
                out = new FileOutputStream(dst);
                byte[] buf = new byte[65536];
                do {
                    if ((m = in.read(buf, 0, buf.length)) == -1) continue;
                    out.write(buf, 0, m);
                } while (m != -1);
                out.close();
            }
            return;
            {
                catch (Throwable throwable222) {
                    out.close();
                    break block8;
                }
            }
            finally {
                in.close();
            }
        }
        throw throwable222;
    }

    public void copy(Path path1, Path path2) {
        this.copy(path1.file(), path2.file());
    }

    /*
     * WARNING - void declaration
     */
    public File tmp_file(String prefix) {
        void var2_2;
        File file = File.createTempFile(prefix, null);
        file.deleteOnExit();
        return var2_2;
    }

    public <A> A with_tmp_file(String prefix, Function1<File, A> body) {
        File file = this.tmp_file(prefix);
        try {
            return (A)body.apply((Object)file);
        }
        finally {
            file.delete();
        }
    }

    private final String liftedTree1$1(BufferedReader reader$1) {
        String string2;
        try {
            string2 = reader$1.readLine();
        }
        catch (IOException iOException) {
            string2 = null;
        }
        return string2;
    }

    private File$() {
        MODULE$ = this;
    }
}

