/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.DefaultErrorSource;
import errorlist.ErrorSourceUpdate;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;

public abstract class ErrorSource {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    protected boolean registered;
    private static Vector errorSources = new Vector();
    private static ErrorSource[] cachedErrorSources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerErrorSource(ErrorSource errorSource) {
        ErrorSource errorSource2 = errorSource;
        synchronized (errorSource2) {
            if (errorSource.registered) {
                return;
            }
            Vector vector = errorSources;
            synchronized (vector) {
                errorSources.addElement(errorSource);
                errorSource.registered = true;
                cachedErrorSources = null;
            }
            EditBus.sendAsync((EBMessage)new ErrorSourceUpdate(errorSource, ErrorSourceUpdate.ERROR_SOURCE_ADDED, errorSource.getAllErrors()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterErrorSource(ErrorSource errorSource) {
        if (!errorSource.registered) {
            return;
        }
        EditBus.removeFromBus((Object)errorSource);
        Vector vector = errorSources;
        synchronized (vector) {
            errorSources.removeElement(errorSource);
            errorSource.registered = false;
            cachedErrorSources = null;
        }
        EditBus.sendAsync((EBMessage)new ErrorSourceUpdate(errorSource, ErrorSourceUpdate.ERROR_SOURCE_REMOVED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorSource[] getErrorSources() {
        Vector vector = errorSources;
        synchronized (vector) {
            if (cachedErrorSources == null) {
                cachedErrorSources = new ErrorSource[errorSources.size()];
                errorSources.copyInto(cachedErrorSources);
            }
            return cachedErrorSources;
        }
    }

    public void addError(DefaultErrorSource.DefaultError error) {
    }

    public View getView() {
        return null;
    }

    public abstract String getName();

    public abstract int getErrorCount();

    public abstract Error[] getAllErrors();

    public abstract int getFileErrorCount(String var1);

    public abstract Error[] getFileErrors(String var1);

    public abstract Error[] getLineErrors(String var1, int var2, int var3);

    public static interface Error {
        public int getErrorType();

        public ErrorSource getErrorSource();

        public Buffer getBuffer();

        public String getFilePath();

        public String getFileName();

        public int getLineNumber();

        public int getStartOffset();

        public int getEndOffset();

        public String getErrorMessage();

        public String[] getExtraMessages();
    }
}

