/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorListPlugin;
import errorlist.ErrorSource;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class ErrorOverview
extends JPanel {
    private static final int WIDTH = 10;
    private static final int HILITE_HEIGHT = 2;
    private EditPane editPane;

    public ErrorOverview(final EditPane editPane) {
        super(new BorderLayout());
        this.editPane = editPane;
        this.setRequestFocusEnabled(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                int line = ErrorOverview.this.yToLine(evt.getY());
                JEditTextArea textArea = editPane.getTextArea();
                if (line >= 0 && line < textArea.getLineCount()) {
                    textArea.setCaretPosition(textArea.getLineStartOffset(line));
                }
            }
        });
    }

    public void invalidateLine(int line) {
        this.repaint(0, this.lineToY(line), this.getWidth(), 2);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        Buffer buffer = this.editPane.getBuffer();
        int lineCount = buffer.getLineCount();
        int line = this.yToLine(evt.getY());
        JEditTextArea textArea = this.editPane.getTextArea();
        if (line >= 0 && line < textArea.getLineCount()) {
            ErrorSource[] errorSources = ErrorSource.getErrorSources();
            for (int i = 0; i < errorSources.length; ++i) {
                ErrorSource.Error[] errors = errorSources[i].getLineErrors(buffer.getSymlinkPath(), line, line);
                if (errors == null && line != 0) {
                    errors = errorSources[i].getLineErrors(buffer.getPath(), line - 1, line - 1);
                }
                if (errors == null && line != lineCount - 1) {
                    errors = errorSources[i].getLineErrors(buffer.getPath(), line + 1, line + 1);
                }
                if (errors == null) continue;
                return errors[0].getErrorMessage();
            }
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics gfx) {
        super.paintComponent(gfx);
        ErrorSource[] errorSources = ErrorSource.getErrorSources();
        if (errorSources == null) {
            return;
        }
        Buffer buffer = this.editPane.getBuffer();
        Rectangle clip = gfx.getClipBounds();
        int lineCount = buffer.getLineCount();
        int line1 = this.yToLine(clip.y);
        int line2 = this.yToLine(clip.y + clip.height);
        if (line1 < 0) {
            line1 = 0;
        }
        if (line2 >= lineCount) {
            line2 = lineCount - 1;
        }
        for (int i = 0; i < errorSources.length; ++i) {
            ErrorSource.Error[] errors = errorSources[i].getLineErrors(buffer.getSymlinkPath(), line1, line2);
            if (errors == null) continue;
            for (int j = 0; j < errors.length; ++j) {
                ErrorSource.Error error = errors[j];
                int line = error.getLineNumber();
                if (line < line1 || line > line2) {
                    System.err.println("WTF: " + line);
                }
                int y = this.lineToY(line);
                gfx.setColor(ErrorListPlugin.getErrorColor(errors[j].getErrorType()));
                gfx.fillRect(0, y, this.getWidth(), 2);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(10, 0);
    }

    private int lineToY(int line) {
        return line * this.getHeight() / this.editPane.getBuffer().getLineCount();
    }

    private int yToLine(int y) {
        return y * this.editPane.getBuffer().getLineCount() / this.getHeight();
    }
}

